/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    static final int DELAY = 100;
    static final int TIMER_ID = 100;
    static final int MINIMUM_WIDTH = 100;
    static final int ProgressBarProc;
    static final TCHAR ProgressBarClass;

    static {
        ProgressBarClass = new TCHAR(0, "msctls_progress32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ProgressBarClass, wNDCLASS);
        ProgressBarProc = wNDCLASS.lpfnWndProc;
        int n2 = OS.GetModuleHandle(null);
        int n3 = OS.GetProcessHeap();
        wNDCLASS.hInstance = n2;
        wNDCLASS.style &= 0xFFFFBFFF;
        wNDCLASS.style |= 8;
        int n4 = ProgressBarClass.length() * TCHAR.sizeof;
        int n5 = OS.HeapAlloc(n3, 8, n4);
        OS.MoveMemory(n5, ProgressBarClass, n4);
        wNDCLASS.lpszClassName = n5;
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n3, 0, n5);
    }

    public ProgressBar(Composite composite, int n2) {
        super(composite, ProgressBar.checkStyle(n2));
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ProgressBarProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        return ProgressBar.checkBits(n2 |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = this.getBorderWidth();
        int n5 = n4 * 2;
        int n6 = n4 * 2;
        if ((this.style & 0x100) != 0) {
            n5 += OS.GetSystemMetrics(21) * 10;
            n6 += OS.GetSystemMetrics(3);
        } else {
            n5 += OS.GetSystemMetrics(2);
            n6 += OS.GetSystemMetrics(20) * 10;
        }
        if (n2 != -1) {
            n5 = n2 + n4 * 2;
        }
        if (n3 != -1) {
            n6 = n3 + n4 * 2;
        }
        return new Point(n5, n6);
    }

    void createHandle() {
        super.createHandle();
        this.startTimer();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_HIGHLIGHT);
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1031, 0, 0);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1031, 1, 0);
    }

    public int getSelection() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1032, 0, 0);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.stopTimer();
    }

    void startTimer() {
        if ((this.style & 2) != 0) {
            int n2 = OS.GetWindowLong(this.handle, -16);
            if (OS.COMCTL32_MAJOR < 6 || (n2 & 8) == 0) {
                OS.SetTimer(this.handle, 100, 100, 0);
            } else {
                OS.SendMessage(this.handle, 1034, 1, 100);
            }
        }
    }

    void stopTimer() {
        if ((this.style & 2) != 0) {
            int n2 = OS.GetWindowLong(this.handle, -16);
            if (OS.COMCTL32_MAJOR < 6 || (n2 & 8) == 0) {
                OS.KillTimer(this.handle, 100);
            } else {
                OS.SendMessage(this.handle, 1034, 0, 0);
            }
        }
    }

    void setBackgroundPixel(int n2) {
        if (n2 == -1) {
            n2 = -16777216;
        }
        OS.SendMessage(this.handle, 8193, 0, n2);
    }

    void setForegroundPixel(int n2) {
        if (n2 == -1) {
            n2 = -16777216;
        }
        OS.SendMessage(this.handle, 1033, 0, n2);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 1031, 1, 0);
        if (n3 >= 0 && n3 < n2) {
            OS.SendMessage(this.handle, 1030, n3, n2);
        }
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 1031, 0, 0);
        if (n2 >= 0 && n2 < n3) {
            OS.SendMessage(this.handle, 1030, n2, n3);
        }
    }

    public void setSelection(int n2) {
        this.checkWidget();
        OS.SendMessage(this.handle, 1026, n2, 0);
    }

    int widgetStyle() {
        int n2 = super.widgetStyle();
        if ((this.style & 0x10000) != 0) {
            n2 |= 1;
        }
        if ((this.style & 0x200) != 0) {
            n2 |= 4;
        }
        if ((this.style & 2) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    TCHAR windowClass() {
        return ProgressBarClass;
    }

    int windowProc() {
        return ProgressBarProc;
    }

    LRESULT WM_GETDLGCODE(int n2, int n3) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(256);
    }

    LRESULT WM_SIZE(int n2, int n3) {
        LRESULT lRESULT = super.WM_SIZE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 2) != 0 && OS.COMCTL32_MAJOR >= 6) {
            int n4;
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            int n5 = n4 = OS.GetWindowLong(this.handle, -16);
            n5 = rECT.right - rECT.left < 100 ? (n5 &= 0xFFFFFFF7) : (n5 |= 8);
            if (n5 != n4) {
                this.stopTimer();
                OS.SetWindowLong(this.handle, -16, n5);
                this.startTimer();
            }
        }
        return lRESULT;
    }

    LRESULT WM_TIMER(int n2, int n3) {
        LRESULT lRESULT = super.WM_TIMER(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if ((this.style & 2) != 0) {
            int n4 = OS.GetWindowLong(this.handle, -16);
            if ((OS.COMCTL32_MAJOR < 6 || (n4 & 8) == 0) && n2 == 100) {
                OS.SendMessage(this.handle, 1029, 0, 0);
            }
        }
        return lRESULT;
    }
}

