/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.encoding.DataHandlerDataSource;
import com.sun.xml.internal.ws.encoding.StringDataContentHandler;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.server.sei.EndpointValueSetter;
import com.sun.xml.internal.ws.spi.db.DatabindingException;
import com.sun.xml.internal.ws.spi.db.PropertyAccessor;
import com.sun.xml.internal.ws.spi.db.RepeatedElementBridge;
import com.sun.xml.internal.ws.spi.db.WrapperComposite;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.imageio.ImageIO;
import javax.jws.WebParam;
import javax.xml.bind.JAXBException;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

public abstract class EndpointArgumentsBuilder {
    public static final EndpointArgumentsBuilder NONE = new None();
    private static final Map<Class, Object> primitiveUninitializedValues;
    protected QName wrapperName;
    protected Map<QName, WrappedPartBuilder> wrappedParts = null;

    public abstract void readRequest(Message var1, Object[] var2) throws JAXBException, XMLStreamException;

    public static Object getVMUninitializedValue(Type type) {
        return primitiveUninitializedValues.get(type);
    }

    protected void readWrappedRequest(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
        if (!message.hasPayload()) {
            throw new WebServiceException("No payload. Expecting payload with " + this.wrapperName + " element");
        }
        XMLStreamReader xMLStreamReader = message.readPayload();
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.wrapperName);
        xMLStreamReader.nextTag();
        while (xMLStreamReader.getEventType() == 1) {
            QName qName = xMLStreamReader.getName();
            WrappedPartBuilder wrappedPartBuilder = this.wrappedParts.get(qName);
            if (wrappedPartBuilder == null) {
                XMLStreamReaderUtil.skipElement(xMLStreamReader);
                xMLStreamReader.nextTag();
            } else {
                wrappedPartBuilder.readRequest(objectArray, xMLStreamReader, message.getAttachments());
            }
            XMLStreamReaderUtil.toNextTag(xMLStreamReader, qName);
        }
        xMLStreamReader.close();
        XMLStreamReaderFactory.recycle(xMLStreamReader);
    }

    public static final String getWSDLPartName(Attachment attachment) {
        String string = attachment.getContentId();
        int n = string.lastIndexOf(64, string.length());
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        if ((n = string2.lastIndexOf(61, string2.length())) == -1) {
            return null;
        }
        try {
            return URLDecoder.decode(string2.substring(0, n), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WebServiceException(unsupportedEncodingException);
        }
    }

    private static boolean isXMLMimeType(String string) {
        return string.equals("text/xml") || string.equals("application/xml");
    }

    static {
        Map<Class, Object> map = primitiveUninitializedValues = new HashMap<Class, Object>();
        map.put(Integer.TYPE, 0);
        map.put(Character.TYPE, Character.valueOf('\u0000'));
        map.put(Byte.TYPE, (byte)0);
        map.put(Short.TYPE, (short)0);
        map.put(Long.TYPE, 0L);
        map.put(Float.TYPE, Float.valueOf(0.0f));
        map.put(Double.TYPE, 0.0);
    }

    public static abstract class AttachmentBuilder
    extends EndpointArgumentsBuilder {
        protected final EndpointValueSetter setter;
        protected final ParameterImpl param;
        protected final String pname;
        protected final String pname1;

        AttachmentBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            this.setter = endpointValueSetter;
            this.param = parameterImpl;
            this.pname = parameterImpl.getPartName();
            this.pname1 = "<" + this.pname;
        }

        public static EndpointArgumentsBuilder createAttachmentBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            Class clazz = (Class)parameterImpl.getTypeInfo().type;
            if (DataHandler.class.isAssignableFrom(clazz)) {
                return new DataHandlerBuilder(parameterImpl, endpointValueSetter);
            }
            if (byte[].class == clazz) {
                return new ByteArrayBuilder(parameterImpl, endpointValueSetter);
            }
            if (Source.class.isAssignableFrom(clazz)) {
                return new SourceBuilder(parameterImpl, endpointValueSetter);
            }
            if (Image.class.isAssignableFrom(clazz)) {
                return new ImageBuilder(parameterImpl, endpointValueSetter);
            }
            if (InputStream.class == clazz) {
                return new InputStreamBuilder(parameterImpl, endpointValueSetter);
            }
            if (EndpointArgumentsBuilder.isXMLMimeType(parameterImpl.getBinding().getMimeType())) {
                return new JAXBBuilder(parameterImpl, endpointValueSetter);
            }
            if (String.class.isAssignableFrom(clazz)) {
                return new StringBuilder(parameterImpl, endpointValueSetter);
            }
            throw new UnsupportedOperationException("Unknown Type=" + clazz + " Attachment is not mapped.");
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            boolean bl = false;
            for (Attachment attachment : message.getAttachments()) {
                String string = AttachmentBuilder.getWSDLPartName(attachment);
                if (string == null || !string.equals(this.pname) && !string.equals(this.pname1)) continue;
                bl = true;
                this.mapAttachment(attachment, objectArray);
                break;
            }
            if (!bl) {
                throw new WebServiceException("Missing Attachment for " + this.pname);
            }
        }

        abstract void mapAttachment(Attachment var1, Object[] var2) throws JAXBException;
    }

    public static final class Body
    extends EndpointArgumentsBuilder {
        private final XMLBridge<?> bridge;
        private final EndpointValueSetter setter;

        public Body(XMLBridge<?> xMLBridge, EndpointValueSetter endpointValueSetter) {
            this.bridge = xMLBridge;
            this.setter = endpointValueSetter;
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) throws JAXBException {
            this.setter.put(message.readPayloadAsJAXB(this.bridge), objectArray);
        }
    }

    private static final class ByteArrayBuilder
    extends AttachmentBuilder {
        ByteArrayBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            super(parameterImpl, endpointValueSetter);
        }

        @Override
        void mapAttachment(Attachment attachment, Object[] objectArray) {
            this.setter.put(attachment.asByteArray(), objectArray);
        }
    }

    public static final class Composite
    extends EndpointArgumentsBuilder {
        private final EndpointArgumentsBuilder[] builders;

        public Composite(EndpointArgumentsBuilder ... endpointArgumentsBuilderArray) {
            this.builders = endpointArgumentsBuilderArray;
        }

        public Composite(Collection<? extends EndpointArgumentsBuilder> collection) {
            this(collection.toArray(new EndpointArgumentsBuilder[collection.size()]));
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            for (EndpointArgumentsBuilder endpointArgumentsBuilder : this.builders) {
                endpointArgumentsBuilder.readRequest(message, objectArray);
            }
        }
    }

    private static final class DataHandlerBuilder
    extends AttachmentBuilder {
        DataHandlerBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            super(parameterImpl, endpointValueSetter);
        }

        @Override
        void mapAttachment(Attachment attachment, Object[] objectArray) {
            this.setter.put(attachment.asDataHandler(), objectArray);
        }
    }

    public static final class DocLit
    extends EndpointArgumentsBuilder {
        private final PartBuilder[] parts;
        private final XMLBridge wrapper;
        private boolean dynamicWrapper;

        public DocLit(WrapperParameter wrapperParameter, WebParam.Mode mode) {
            this.wrapperName = wrapperParameter.getName();
            this.wrapper = wrapperParameter.getXMLBridge();
            Class clazz = (Class)this.wrapper.getTypeInfo().type;
            this.dynamicWrapper = WrapperComposite.class.equals((Object)clazz);
            ArrayList<PartBuilder> arrayList = new ArrayList<PartBuilder>();
            List<ParameterImpl> list = wrapperParameter.getWrapperChildren();
            for (ParameterImpl parameterImpl : list) {
                if (parameterImpl.getMode() == mode) continue;
                QName qName = parameterImpl.getName();
                try {
                    if (this.dynamicWrapper) {
                        XMLBridge xMLBridge;
                        if (this.wrappedParts == null) {
                            this.wrappedParts = new HashMap();
                        }
                        if ((xMLBridge = parameterImpl.getInlinedRepeatedElementBridge()) == null) {
                            xMLBridge = parameterImpl.getXMLBridge();
                        }
                        this.wrappedParts.put(parameterImpl.getName(), new WrappedPartBuilder(xMLBridge, EndpointValueSetter.get(parameterImpl)));
                        continue;
                    }
                    arrayList.add(new PartBuilder(wrapperParameter.getOwner().getBindingContext().getElementPropertyAccessor(clazz, qName.getNamespaceURI(), parameterImpl.getName().getLocalPart()), EndpointValueSetter.get(parameterImpl)));
                    assert (parameterImpl.getBinding() == ParameterBinding.BODY);
                }
                catch (JAXBException jAXBException) {
                    throw new WebServiceException(clazz + " do not have a property of the name " + qName, jAXBException);
                }
            }
            this.parts = arrayList.toArray(new PartBuilder[arrayList.size()]);
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            if (this.dynamicWrapper) {
                this.readWrappedRequest(message, objectArray);
            } else if (this.parts.length > 0) {
                if (!message.hasPayload()) {
                    throw new WebServiceException("No payload. Expecting payload with " + this.wrapperName + " element");
                }
                XMLStreamReader xMLStreamReader = message.readPayload();
                XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.wrapperName);
                Object t = this.wrapper.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)(message.getAttachments() != null ? new AttachmentUnmarshallerImpl(message.getAttachments()) : null));
                try {
                    for (PartBuilder partBuilder : this.parts) {
                        partBuilder.readRequest(objectArray, t);
                    }
                }
                catch (DatabindingException databindingException) {
                    throw new WebServiceException(databindingException);
                }
                xMLStreamReader.close();
                XMLStreamReaderFactory.recycle(xMLStreamReader);
            } else {
                message.consume();
            }
        }

        static final class PartBuilder {
            private final PropertyAccessor accessor;
            private final EndpointValueSetter setter;

            public PartBuilder(PropertyAccessor propertyAccessor, EndpointValueSetter endpointValueSetter) {
                this.accessor = propertyAccessor;
                this.setter = endpointValueSetter;
                assert (propertyAccessor != null && endpointValueSetter != null);
            }

            final void readRequest(Object[] objectArray, Object object) {
                Object v = this.accessor.get(object);
                this.setter.put(v, objectArray);
            }
        }
    }

    public static final class Header
    extends EndpointArgumentsBuilder {
        private final XMLBridge<?> bridge;
        private final EndpointValueSetter setter;
        private final QName headerName;
        private final SOAPVersion soapVersion;

        public Header(SOAPVersion sOAPVersion, QName qName, XMLBridge<?> xMLBridge, EndpointValueSetter endpointValueSetter) {
            this.soapVersion = sOAPVersion;
            this.headerName = qName;
            this.bridge = xMLBridge;
            this.setter = endpointValueSetter;
        }

        public Header(SOAPVersion sOAPVersion, ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            this(sOAPVersion, parameterImpl.getTypeInfo().tagName, parameterImpl.getXMLBridge(), endpointValueSetter);
            assert (parameterImpl.getOutBinding() == ParameterBinding.HEADER);
        }

        private SOAPFaultException createDuplicateHeaderException() {
            try {
                SOAPFault sOAPFault = this.soapVersion.getSOAPFactory().createFault();
                sOAPFault.setFaultCode(this.soapVersion.faultCodeClient);
                sOAPFault.setFaultString(ServerMessages.DUPLICATE_PORT_KNOWN_HEADER(this.headerName));
                return new SOAPFaultException(sOAPFault);
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) throws JAXBException {
            com.sun.xml.internal.ws.api.message.Header header = null;
            Iterator<com.sun.xml.internal.ws.api.message.Header> iterator = message.getHeaders().getHeaders(this.headerName, true);
            if (iterator.hasNext()) {
                header = iterator.next();
                if (iterator.hasNext()) {
                    throw this.createDuplicateHeaderException();
                }
            }
            if (header != null) {
                this.setter.put(header.readAsJAXB(this.bridge), objectArray);
            }
        }
    }

    private static final class ImageBuilder
    extends AttachmentBuilder {
        ImageBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            super(parameterImpl, endpointValueSetter);
        }

        @Override
        void mapAttachment(Attachment attachment, Object[] objectArray) {
            BufferedImage bufferedImage;
            InputStream inputStream = null;
            try {
                inputStream = attachment.asInputStream();
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (IOException iOException) {
                throw new WebServiceException(iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new WebServiceException(iOException);
                    }
                }
            }
            this.setter.put(bufferedImage, objectArray);
        }
    }

    private static final class InputStreamBuilder
    extends AttachmentBuilder {
        InputStreamBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            super(parameterImpl, endpointValueSetter);
        }

        @Override
        void mapAttachment(Attachment attachment, Object[] objectArray) {
            this.setter.put(attachment.asInputStream(), objectArray);
        }
    }

    private static final class JAXBBuilder
    extends AttachmentBuilder {
        JAXBBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            super(parameterImpl, endpointValueSetter);
        }

        @Override
        void mapAttachment(Attachment attachment, Object[] objectArray) throws JAXBException {
            Object t = this.param.getXMLBridge().unmarshal(attachment.asInputStream());
            this.setter.put(t, objectArray);
        }
    }

    static final class None
    extends EndpointArgumentsBuilder {
        private None() {
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) {
            message.consume();
        }
    }

    public static final class NullSetter
    extends EndpointArgumentsBuilder {
        private final EndpointValueSetter setter;
        private final Object nullValue;

        public NullSetter(EndpointValueSetter endpointValueSetter, Object object) {
            assert (endpointValueSetter != null);
            this.nullValue = object;
            this.setter = endpointValueSetter;
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) {
            this.setter.put(this.nullValue, objectArray);
        }
    }

    public static final class RpcLit
    extends EndpointArgumentsBuilder {
        public RpcLit(WrapperParameter wrapperParameter) {
            assert (wrapperParameter.getTypeInfo().type == WrapperComposite.class);
            this.wrapperName = wrapperParameter.getName();
            this.wrappedParts = new HashMap();
            List<ParameterImpl> list = wrapperParameter.getWrapperChildren();
            for (ParameterImpl parameterImpl : list) {
                this.wrappedParts.put(parameterImpl.getName(), new WrappedPartBuilder(parameterImpl.getXMLBridge(), EndpointValueSetter.get(parameterImpl)));
                assert (parameterImpl.getBinding() == ParameterBinding.BODY);
            }
        }

        @Override
        public void readRequest(Message message, Object[] objectArray) throws JAXBException, XMLStreamException {
            this.readWrappedRequest(message, objectArray);
        }
    }

    private static final class SourceBuilder
    extends AttachmentBuilder {
        SourceBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            super(parameterImpl, endpointValueSetter);
        }

        @Override
        void mapAttachment(Attachment attachment, Object[] objectArray) {
            this.setter.put(attachment.asSource(), objectArray);
        }
    }

    private static final class StringBuilder
    extends AttachmentBuilder {
        StringBuilder(ParameterImpl parameterImpl, EndpointValueSetter endpointValueSetter) {
            super(parameterImpl, endpointValueSetter);
        }

        @Override
        void mapAttachment(Attachment attachment, Object[] objectArray) {
            attachment.getContentType();
            StringDataContentHandler stringDataContentHandler = new StringDataContentHandler();
            try {
                String string = (String)stringDataContentHandler.getContent(new DataHandlerDataSource(attachment.asDataHandler()));
                this.setter.put(string, objectArray);
            }
            catch (Exception exception) {
                throw new WebServiceException(exception);
            }
        }
    }

    static final class WrappedPartBuilder {
        private final XMLBridge bridge;
        private final EndpointValueSetter setter;

        public WrappedPartBuilder(XMLBridge xMLBridge, EndpointValueSetter endpointValueSetter) {
            this.bridge = xMLBridge;
            this.setter = endpointValueSetter;
        }

        void readRequest(Object[] objectArray, XMLStreamReader xMLStreamReader, AttachmentSet attachmentSet) throws JAXBException {
            AttachmentUnmarshallerImpl attachmentUnmarshallerImpl;
            Object object = null;
            AttachmentUnmarshallerImpl attachmentUnmarshallerImpl2 = attachmentUnmarshallerImpl = attachmentSet != null ? new AttachmentUnmarshallerImpl(attachmentSet) : null;
            if (this.bridge instanceof RepeatedElementBridge) {
                RepeatedElementBridge repeatedElementBridge = (RepeatedElementBridge)this.bridge;
                ArrayList arrayList = new ArrayList();
                QName qName = xMLStreamReader.getName();
                while (xMLStreamReader.getEventType() == 1 && qName.equals(xMLStreamReader.getName())) {
                    arrayList.add(repeatedElementBridge.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)attachmentUnmarshallerImpl));
                    XMLStreamReaderUtil.toNextTag(xMLStreamReader, qName);
                }
                object = repeatedElementBridge.collectionHandler().convert(arrayList);
            } else {
                object = this.bridge.unmarshal(xMLStreamReader, (AttachmentUnmarshaller)attachmentUnmarshallerImpl);
            }
            this.setter.put(object, objectArray);
        }
    }
}

