/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthDragGestureRecognizer;
import com.sun.java.swing.plaf.gtk.SynthDropTargetListener;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthTransferable;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

abstract class SynthTextUI
extends TextUI
implements SynthUI,
ViewFactory {
    private SynthStyle style;
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();
    private static final TransferHandler defaultTransferHandler = new TextTransferHandler();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TextDragGestureRecognizer defaultDragRecognizer = new TextDragGestureRecognizer();
    private static final Position.Bias[] discardBias = new Position.Bias[1];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$io$InputStream;

    protected void installDefaults() {
        DropTarget dropTarget;
        Highlighter highlighter;
        this.editor.addMouseListener(defaultDragRecognizer);
        this.editor.addMouseMotionListener(defaultDragRecognizer);
        String string = this.getPropertyPrefix();
        Caret caret = this.editor.getCaret();
        if (caret == null || caret instanceof UIResource) {
            this.editor.setCaret(this.createCaret());
        }
        if ((highlighter = this.editor.getHighlighter()) == null || highlighter instanceof UIResource) {
            this.editor.setHighlighter(this.createHighlighter());
        }
        this.fetchStyle(this.editor);
        TransferHandler transferHandler = this.editor.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.editor.setTransferHandler(this.getTransferHandler());
        }
        if ((dropTarget = this.editor.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TextDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        this.editor.setKeymap(JTextComponent.getKeymap("default"));
        InputMap inputMap = this.getInputMap();
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, actionMap);
        }
        this.updateFocusAcceleratorBinding(false);
    }

    protected void installListeners() {
    }

    protected void modelChanged() {
        ViewFactory viewFactory = this.rootView.getViewFactory();
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        this.setView(viewFactory.create(element));
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.editor, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        this.editor.removeMouseListener(defaultDragRecognizer);
        this.editor.removeMouseMotionListener(defaultDragRecognizer);
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getMargin() instanceof UIResource) {
            this.editor.setMargin(null);
        }
        if (this.editor.getCaret() instanceof UIResource) {
            this.editor.setCaret(null);
        }
        if (this.editor.getHighlighter() instanceof UIResource) {
            this.editor.setHighlighter(null);
        }
        if (this.editor.getTransferHandler() instanceof UIResource) {
            this.editor.setTransferHandler(null);
        }
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
        SwingUtilities.replaceUIInputMap(this.editor, 2, null);
        SwingUtilities.replaceUIActionMap(this.editor, null);
    }

    protected void uninstallListeners() {
    }

    void updateFocusTraversalKeys() {
        EditorKit editorKit = this.getEditorKit(this.editor);
        if (editorKit != null && editorKit instanceof DefaultEditorKit) {
            Set set = this.editor.getFocusTraversalKeys(0);
            Set set2 = this.editor.getFocusTraversalKeys(1);
            HashSet hashSet = new HashSet(set);
            HashSet hashSet2 = new HashSet(set2);
            if (this.editor.isEditable()) {
                hashSet.remove(KeyStroke.getKeyStroke(9, 0));
                hashSet2.remove(KeyStroke.getKeyStroke(9, 1));
            } else {
                hashSet.add(KeyStroke.getKeyStroke(9, 0));
                hashSet2.add(KeyStroke.getKeyStroke(9, 1));
            }
            this.editor.setFocusTraversalKeys(0, hashSet);
            this.editor.setFocusTraversalKeys(1, hashSet2);
        }
    }

    void updateFocusAcceleratorBinding(boolean bl2) {
        char c2 = this.editor.getFocusAccelerator();
        if (bl2 || c2 != '\u0000') {
            InputMap inputMap = SwingUtilities.getUIInputMap(this.editor, 2);
            if (inputMap == null && c2 != '\u0000') {
                inputMap = new ComponentInputMapUIResource(this.editor);
                SwingUtilities.replaceUIInputMap(this.editor, 2, inputMap);
                ActionMap actionMap = this.getActionMap();
                SwingUtilities.replaceUIActionMap(this.editor, actionMap);
            }
            if (inputMap != null) {
                inputMap.clear();
                if (c2 != '\u0000') {
                    inputMap.put(KeyStroke.getKeyStroke((int)c2, 8), "requestFocus");
                }
            }
        }
    }

    protected void paintSafely(Graphics graphics) {
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (highlighter != null) {
            highlighter.paint(graphics);
        }
        Rectangle rectangle = this.getVisibleEditorRect();
        this.rootView.paint(graphics, rectangle);
        if (caret != null) {
            caret.paint(graphics);
        }
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = this.editor.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.editor.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected abstract String getPropertyPrefix();

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        Action[] actionArray = this.editor.getActions();
        int n2 = actionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Action action = actionArray[i2];
            actionMapUIResource.put(action.getValue("Name"), action);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        Action action;
        String string = this.getPropertyPrefix() + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction());
        if (this.getEditorKit(this.editor) instanceof DefaultEditorKit && actionMap != null && (action = actionMap.get("insert-break")) != null && action instanceof DefaultEditorKit.InsertBreakAction) {
            TextActionWrapper textActionWrapper = new TextActionWrapper((TextAction)action);
            actionMapUIResource.put(textActionWrapper.getValue("Name"), textActionWrapper);
        }
        if (actionMap != null) {
            actionMapUIResource.setParent(actionMap);
        }
        return actionMapUIResource;
    }

    InputMap getInputMap() {
        SynthContext synthContext = this.getContext(this.editor, 1);
        SynthStyle synthStyle = synthContext.getStyle();
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)synthStyle.get(synthContext, this.getPropertyPrefix() + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        synthContext.dispose();
        return inputMapUIResource;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            this.installDefaults();
            this.editor.setAutoscrolls(true);
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document document = this.editor.getDocument();
            if (document == null) {
                this.editor.setDocument(this.getEditorKit(this.editor).createDefaultDocument());
            } else {
                document.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
            this.installListeners();
            this.installKeyboardActions();
            LayoutManager layoutManager = this.editor.getLayout();
            if (layoutManager == null || layoutManager instanceof UIResource) {
                this.editor.setLayout(this.updateHandler);
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults();
        this.rootView.setView(null);
        jComponent.removeAll();
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager instanceof UIResource) {
            jComponent.setLayout(null);
        }
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.editor = null;
    }

    TransferHandler getTransferHandler() {
        return defaultTransferHandler;
    }

    protected Caret createCaret() {
        return new SynthCaret();
    }

    protected Highlighter createHighlighter() {
        return new SynthHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    private void fetchStyle(JTextComponent jTextComponent) {
        SynthContext synthContext = this.getContext(jTextComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Object object;
            Caret caret;
            Insets insets;
            Color color;
            Color color2;
            String string = this.getPropertyPrefix();
            Color color3 = this.editor.getCaretColor();
            if (color3 == null || color3 instanceof UIResource) {
                this.editor.setCaretColor((Color)this.style.get(synthContext, string + ".caretForeground"));
            }
            if ((color2 = this.editor.getForeground()) == null || color2 instanceof UIResource) {
                this.editor.setSelectionColor(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            synthContext.setComponentState(768);
            Color color4 = this.editor.getSelectionColor();
            if (color4 == null || color4 instanceof UIResource) {
                this.editor.setSelectionColor(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.editor.getSelectedTextColor()) == null || color instanceof UIResource) {
                this.editor.setSelectedTextColor(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            synthContext.setComponentState(8);
            Color color5 = this.editor.getDisabledTextColor();
            if (color5 == null || color5 instanceof UIResource) {
                this.editor.setDisabledTextColor((Color)this.style.get(synthContext, ColorType.FOREGROUND));
            }
            if ((insets = this.editor.getMargin()) == null || insets instanceof UIResource) {
                insets = (Insets)this.style.get(synthContext, string + ".margin");
                if (insets == null) {
                    insets = SynthLookAndFeel.EMPTY_UIRESOURCE_INSETS;
                }
                this.editor.setMargin(insets);
            }
            if ((caret = this.editor.getCaret()) instanceof UIResource && (object = this.style.get(synthContext, string + ".caretBlinkRate")) != null && object instanceof Integer) {
                Integer n2 = (Integer)object;
                caret.setBlinkRate(n2);
            }
        }
        synthContext.dispose();
    }

    void forceFetchStyle(JTextComponent jTextComponent) {
        this.style = null;
        this.fetchStyle(jTextComponent);
    }

    public void damageRange(JTextComponent jTextComponent, int n2, int n3) {
        this.damageRange(jTextComponent, n2, n3, Position.Bias.Forward, Position.Bias.Backward);
    }

    protected final void setView(View view) {
        this.editor.removeAll();
        this.rootView.setView(view);
        this.painted = false;
        this.editor.revalidate();
        this.editor.repaint();
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)this.rootView.getMinimumSpan(0) + insets.left + insets.right;
            dimension.height = (int)this.rootView.getMinimumSpan(1) + insets.top + insets.bottom;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            } else if (dimension.width == 0 && dimension.height == 0) {
                this.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            dimension.width = (int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(SynthContext synthContext, Graphics graphics) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            Document document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.paintSafely(graphics);
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, discardBias);
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n2) throws BadLocationException {
        return this.modelToView(jTextComponent, n2, Position.Bias.Forward);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n2, int n3) {
        return null;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle modelToView(JTextComponent jTextComponent, int n2, Position.Bias bias) throws BadLocationException {
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n2, rectangle, bias);
                if (shape != null) {
                    Rectangle rectangle2 = shape.getBounds();
                    return rectangle2;
                }
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(JTextComponent jTextComponent, Point point) {
        if (!this.painted) {
            return null;
        }
        Document document = this.editor.getDocument();
        String string = null;
        Rectangle rectangle = this.getVisibleEditorRect();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            string = this.rootView.getToolTipText(point.x, point.y, rectangle);
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        int n2 = -1;
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                n2 = this.rootView.viewToModel(point.x, point.y, rectangle, biasArray);
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damageRange(JTextComponent jTextComponent, int n2, int n3, Position.Bias bias, Position.Bias bias2) {
        if (this.painted) {
            Rectangle rectangle = this.getVisibleEditorRect();
            Document document = jTextComponent.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n2, bias, n3, bias2, rectangle);
                Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.editor.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n2, Position.Bias bias, int n3, Position.Bias[] biasArray) throws BadLocationException {
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (this.painted) {
                Rectangle rectangle = this.getVisibleEditorRect();
                this.rootView.setSize(rectangle.width, rectangle.height);
                int n4 = this.rootView.getNextVisualPositionFrom(n2, bias, rectangle, n3, biasArray);
                return n4;
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return -1;
    }

    class FocusAction
    extends AbstractAction {
        public boolean isEnabled() {
            return SynthTextUI.this.editor.isEditable();
        }

        FocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SynthTextUI.this.editor.requestFocus();
        }
    }

    class RootView
    extends View {
        private View view;

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getViewCount() {
            return 1;
        }

        public void setSize(float f2, float f3) {
            if (this.view != null) {
                this.view.setSize(f2, f3);
            }
        }

        public float getAlignment(int n2) {
            if (this.view != null) {
                return this.view.getAlignment(n2);
            }
            return 0.0f;
        }

        public float getMaximumSpan(int n2) {
            return 2.1474836E9f;
        }

        public float getMinimumSpan(int n2) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n2);
            }
            return 10.0f;
        }

        public float getPreferredSpan(int n2) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n2);
            }
            return 10.0f;
        }

        public int getResizeWeight(int n2) {
            if (this.view != null) {
                return this.view.getResizeWeight(n2);
            }
            return 0;
        }

        RootView() {
            super(null);
        }

        public Container getContainer() {
            return SynthTextUI.this.editor;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public Document getDocument() {
            return SynthTextUI.this.editor.getDocument();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return SynthTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public int getViewIndex(int n2, Position.Bias bias) {
            return 0;
        }

        public View getView(int n2) {
            return this.view;
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            this.view = view;
            if (this.view != null) {
                this.view.setParent(this);
            }
        }

        public void preferenceChanged(View view, boolean bl2, boolean bl3) {
            SynthTextUI.this.editor.revalidate();
        }

        public ViewFactory getViewFactory() {
            EditorKit editorKit = SynthTextUI.this.getEditorKit(SynthTextUI.this.editor);
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return SynthTextUI.this;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public Shape getChildAllocation(int n2, Shape shape) {
            return shape;
        }

        public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n2 = this.view.viewToModel(f2, f3, shape, biasArray);
                return n2;
            }
            return -1;
        }

        public View breakView(int n2, float f2, Shape shape) {
            throw new Error("Can't break root view");
        }

        public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n2, shape, bias);
            }
            return null;
        }

        public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n4 = this.view.getNextVisualPositionFrom(n2, bias, shape, n3, biasArray);
                if (n4 != -1) {
                    n2 = n4;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n2;
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Shape modelToView(int n2, Position.Bias bias, int n3, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n2, bias, n3, bias2, shape);
            }
            return null;
        }
    }

    public static class SynthCaret
    extends DefaultCaret
    implements UIResource {
    }

    public static class SynthHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    class TextActionWrapper
    extends TextAction {
        TextAction action;

        public boolean isEnabled() {
            return SynthTextUI.this.editor == null || SynthTextUI.this.editor.isEditable() ? this.action.isEnabled() : false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }

        public TextActionWrapper(TextAction textAction) {
            super((String)textAction.getValue("Name"));
            this.action = null;
            this.action = textAction;
        }
    }

    static class TextDragGestureRecognizer
    extends SynthDragGestureRecognizer {
        TextDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            int n2;
            Caret caret;
            int n3;
            JTextComponent jTextComponent;
            if (super.isDragPossible(mouseEvent) && (jTextComponent = (JTextComponent)this.getComponent(mouseEvent)).getDragEnabled() && (n3 = (caret = jTextComponent.getCaret()).getDot()) != (n2 = caret.getMark())) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n4 = jTextComponent.viewToModel(point);
                int n5 = Math.min(n3, n2);
                int n6 = Math.max(n3, n2);
                if (n4 >= n5 && n4 < n6) {
                    return true;
                }
            }
            return false;
        }
    }

    static class TextDropTargetListener
    extends SynthDropTargetListener {
        int dot;
        int mark;
        boolean visible;

        TextDropTargetListener() {
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            caret.setDot(this.mark);
            caret.moveDot(this.dot);
            caret.setVisible(this.visible);
        }

        protected void restoreComponentStateForDrop(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            caret.setVisible(this.visible);
        }

        protected void saveComponentState(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            this.dot = caret.getDot();
            this.mark = caret.getMark();
            this.visible = caret.isVisible();
            caret.setVisible(true);
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setCaretPosition(jTextComponent.viewToModel(point));
        }
    }

    static class TextTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;

        TextTransferHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            int n2 = 0;
            if (!(jComponent instanceof JPasswordField)) {
                n2 = ((JTextComponent)jComponent).isEditable() ? 3 : 1;
            }
            return n2;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.exportComp = (JTextComponent)jComponent;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean bl2 = false;
            DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
            if (dataFlavor != null) {
                try {
                    Object object;
                    boolean bl3 = false;
                    if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                        bl3 = true;
                    }
                    object = dataFlavor.getReaderForText(transferable);
                    this.handleReaderImport((Reader)object, jTextComponent, bl3);
                    bl2 = true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bl2;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n2) {
            if (this.shouldRemove && n2 == 2) {
                TextTransferable textTransferable = (TextTransferable)transferable;
                textTransferable.removeText();
            }
            this.exportComp = null;
        }

        protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl2) throws BadLocationException, IOException {
            if (bl2) {
                int n2 = jTextComponent.getSelectionStart();
                int n3 = jTextComponent.getSelectionEnd();
                int n4 = n3 - n2;
                EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
                Document document = jTextComponent.getDocument();
                if (n4 > 0) {
                    document.remove(n2, n4);
                }
                editorKit.read(reader, document, n2);
            } else {
                int n5;
                char[] cArray = new char[1024];
                boolean bl3 = false;
                StringBuffer stringBuffer = null;
                while ((n5 = reader.read(cArray, 0, cArray.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n5);
                    }
                    int n6 = 0;
                    block5: for (int i2 = 0; i2 < n5; ++i2) {
                        switch (cArray[i2]) {
                            case '\r': {
                                if (bl3) {
                                    if (i2 == 0) {
                                        stringBuffer.append('\n');
                                        continue block5;
                                    }
                                    cArray[i2 - 1] = 10;
                                    continue block5;
                                }
                                bl3 = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!bl3) continue block5;
                                if (i2 > n6 + 1) {
                                    stringBuffer.append(cArray, n6, i2 - n6 - 1);
                                }
                                bl3 = false;
                                n6 = i2;
                                continue block5;
                            }
                            default: {
                                if (!bl3) continue block5;
                                if (i2 == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[i2 - 1] = 10;
                                }
                                bl3 = false;
                            }
                        }
                    }
                    if (n6 >= n5) continue;
                    if (bl3) {
                        if (n6 >= n5 - 1) continue;
                        stringBuffer.append(cArray, n6, n5 - n6 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n6, n5 - n6);
                }
                if (bl3) {
                    stringBuffer.append('\n');
                }
                jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
            }
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            DataFlavor dataFlavor3 = null;
            if (jTextComponent instanceof JEditorPane) {
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    String string = dataFlavorArray[i2].getMimeType();
                    if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) {
                        return dataFlavorArray[i2];
                    }
                    if (dataFlavor == null && string.startsWith("text/plain")) {
                        dataFlavor = dataFlavorArray[i2];
                        continue;
                    }
                    if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i2].getRepresentationClass() == (class$java$lang$String == null ? SynthTextUI.class$("java.lang.String") : class$java$lang$String)) {
                        dataFlavor2 = dataFlavorArray[i2];
                        continue;
                    }
                    if (dataFlavor3 != null || !dataFlavorArray[i2].equals(DataFlavor.stringFlavor)) continue;
                    dataFlavor3 = dataFlavorArray[i2];
                }
                if (dataFlavor != null) {
                    return dataFlavor;
                }
                if (dataFlavor2 != null) {
                    return dataFlavor2;
                }
                if (dataFlavor3 != null) {
                    return dataFlavor3;
                }
                return null;
            }
            for (int i3 = 0; i3 < dataFlavorArray.length; ++i3) {
                String string = dataFlavorArray[i3].getMimeType();
                if (string.startsWith("text/plain")) {
                    return dataFlavorArray[i3];
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i3].getRepresentationClass() == (class$java$lang$String == null ? SynthTextUI.class$("java.lang.String") : class$java$lang$String)) {
                    dataFlavor2 = dataFlavorArray[i3];
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavorArray[i3].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavorArray[i3];
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }

        static class TextTransferable
        extends SynthTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document document = this.c.getDocument();
                        document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return dataFlavorArray;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            TextTransferable(JTextComponent jTextComponent, int n2, int n3) {
                super(null, null);
                this.c = jTextComponent;
                Document document = jTextComponent.getDocument();
                try {
                    this.p0 = document.createPosition(n2);
                    this.p1 = document.createPosition(n3);
                    this.plainData = jTextComponent.getSelectedText();
                    if (jTextComponent instanceof JEditorPane) {
                        JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                        this.mimeType = jEditorPane.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter stringWriter = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        jEditorPane.getEditorKit().write(stringWriter, document, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith("text/html")) {
                            this.htmlData = stringWriter.toString();
                        } else {
                            this.richText = stringWriter.toString();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if ((class$java$lang$String == null ? (class$java$lang$String = SynthTextUI.class$("java.lang.String")) : class$java$lang$String).equals(dataFlavor.getRepresentationClass())) {
                    return this.richText;
                }
                if ((class$java$io$Reader == null ? (class$java$io$Reader = SynthTextUI.class$("java.io.Reader")) : class$java$io$Reader).equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if ((class$java$io$InputStream == null ? (class$java$io$InputStream = SynthTextUI.class$("java.io.InputStream")) : class$java$io$InputStream).equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(this.richText);
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    UIResource {
        private Hashtable constraints;
        private boolean i18nView = false;

        UpdateHandler() {
        }

        public void removeLayoutComponent(Component component) {
            if (this.constraints != null) {
                this.constraints.remove(component);
            }
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Rectangle rectangle;
            if (this.constraints != null && !this.constraints.isEmpty() && (rectangle = SynthTextUI.this.getVisibleEditorRect()) != null) {
                Document document = SynthTextUI.this.editor.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                try {
                    SynthTextUI.this.rootView.setSize(rectangle.width, rectangle.height);
                    Enumeration enumeration = this.constraints.keys();
                    while (enumeration.hasMoreElements()) {
                        Component component = (Component)enumeration.nextElement();
                        View view = (View)this.constraints.get(component);
                        Shape shape = this.calculateViewPosition(rectangle, view);
                        if (shape == null) continue;
                        Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                        component.setBounds(rectangle2);
                    }
                }
                finally {
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                }
            }
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DropTarget dropTarget;
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthTextUI.this.fetchStyle((JTextComponent)propertyChangeEvent.getSource());
            }
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof Document || object2 instanceof Document) {
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                    if ("document".equals(string)) {
                        SynthTextUI.this.propertyChange(propertyChangeEvent);
                        SynthTextUI.this.modelChanged();
                        return;
                    }
                }
                SynthTextUI.this.modelChanged();
            }
            if ("focusAcceleratorKey".equals(string)) {
                SynthTextUI.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation".equals(string)) {
                SynthTextUI.this.modelChanged();
            } else if ("font".equals(string)) {
                SynthTextUI.this.modelChanged();
            } else if ("transferHandler".equals(string) && (dropTarget = SynthTextUI.this.editor.getDropTarget()) instanceof UIResource) {
                if (defaultDropTargetListener == null) {
                    defaultDropTargetListener = new TextDropTargetListener();
                }
                try {
                    dropTarget.addDropTargetListener(defaultDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
            SynthTextUI.this.propertyChange(propertyChangeEvent);
        }

        public final void changedUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = SynthTextUI.this.painted ? SynthTextUI.this.getVisibleEditorRect() : null;
            SynthTextUI.this.rootView.changedUpdate(documentEvent, rectangle, SynthTextUI.this.rootView.getViewFactory());
        }

        public final void insertUpdate(DocumentEvent documentEvent) {
            Boolean bl2;
            Document document = documentEvent.getDocument();
            Object object = document.getProperty("i18n");
            if (object instanceof Boolean && (bl2 = (Boolean)object) != this.i18nView) {
                this.i18nView = bl2;
                SynthTextUI.this.modelChanged();
                return;
            }
            bl2 = SynthTextUI.this.painted ? SynthTextUI.this.getVisibleEditorRect() : null;
            SynthTextUI.this.rootView.insertUpdate(documentEvent, (Shape)((Object)bl2), SynthTextUI.this.rootView.getViewFactory());
        }

        public final void removeUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = SynthTextUI.this.painted ? SynthTextUI.this.getVisibleEditorRect() : null;
            SynthTextUI.this.rootView.removeUpdate(documentEvent, rectangle, SynthTextUI.this.rootView.getViewFactory());
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object instanceof View) {
                if (this.constraints == null) {
                    this.constraints = new Hashtable(7);
                }
                this.constraints.put(component, object);
            }
        }

        Shape calculateViewPosition(Shape shape, View view) {
            int n2 = view.getStartOffset();
            View view2 = null;
            View view3 = SynthTextUI.this.rootView;
            while (view3 != null && view3 != view) {
                int n3 = ((View)view3).getViewIndex(n2, Position.Bias.Forward);
                shape = ((View)view3).getChildAllocation(n3, shape);
                view2 = ((View)view3).getView(n3);
                view3 = view2;
            }
            return view2 != null ? shape : null;
        }
    }
}

