/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WindowsSliderUI
extends BasicSliderUI {
    public void paintThumb(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl2 = this.slider.getOrientation() == 1;
            boolean bl3 = this.slider.getComponentOrientation().isLeftToRight();
            String string = !this.slider.getPaintTicks() ? (bl2 ? "trackbar.thumbvert" : "trackbar.thumb") : (bl2 ? (bl3 ? "trackbar.thumbright" : "trackbar.thumbleft") : "trackbar.thumbbottom");
            int n2 = 0;
            if (!this.slider.isEnabled()) {
                n2 = 4;
            }
            xPStyle.getSkin(string).paintSkin(graphics, this.thumbRect.x, this.thumbRect.y, n2);
        } else {
            super.paintThumb(graphics);
        }
    }

    public void paintTrack(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl2 = this.slider.getOrientation() == 1;
            String string = bl2 ? "trackbar.trackvert" : "trackbar.track";
            XPStyle.Skin skin = xPStyle.getSkin(string);
            if (bl2) {
                int n2 = (this.trackRect.width - skin.getWidth()) / 2;
                skin.paintSkin(graphics, this.trackRect.x + n2, this.trackRect.y, skin.getWidth(), this.trackRect.height, 0);
            } else {
                int n3 = (this.trackRect.height - skin.getHeight()) / 2;
                skin.paintSkin(graphics, this.trackRect.x, this.trackRect.y + n3, this.trackRect.width, skin.getHeight(), 0);
            }
        } else {
            super.paintTrack(graphics);
        }
    }

    public WindowsSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor("trackbar.tics.color", Color.black));
        }
        super.paintMajorTickForHorizSlider(graphics, rectangle, n2);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor("trackbar.ticsvert.color", Color.black));
        }
        super.paintMajorTickForVertSlider(graphics, rectangle, n2);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor("trackbar.tics.color", Color.black));
        }
        super.paintMinorTickForHorizSlider(graphics, rectangle, n2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor("trackbar.ticsvert.color", Color.black));
        }
        super.paintMinorTickForVertSlider(graphics, rectangle, n2);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsSliderUI((JSlider)jComponent);
    }
}

