/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.SequencedEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import sun.awt.AppContext;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;

public abstract class KeyboardFocusManager
implements KeyEventDispatcher,
KeyEventPostProcessor {
    private static final DebugHelper dbg;
    public static final int FORWARD_TRAVERSAL_KEYS = 0;
    public static final int BACKWARD_TRAVERSAL_KEYS = 1;
    public static final int UP_CYCLE_TRAVERSAL_KEYS = 2;
    public static final int DOWN_CYCLE_TRAVERSAL_KEYS = 3;
    static final int TRAVERSAL_KEY_LENGTH = 4;
    private static Component focusOwner;
    private static Component permanentFocusOwner;
    private static Window focusedWindow;
    private static Window activeWindow;
    private FocusTraversalPolicy defaultPolicy = new DefaultFocusTraversalPolicy();
    private static final String[] defaultFocusTraversalKeyPropertyNames;
    private static final String[] defaultFocusTraversalKeyStrings;
    private Set[] defaultFocusTraversalKeys = new Set[4];
    private static Container currentFocusCycleRoot;
    private VetoableChangeSupport vetoableSupport;
    private PropertyChangeSupport changeSupport;
    private LinkedList keyEventDispatchers;
    private LinkedList keyEventPostProcessors;
    private static Map mostRecentFocusOwners;
    private static final String notPrivileged = "this KeyboardFocusManager is not installed in the current thread's context";
    private static AWTPermission replaceKeyboardFocusManagerPermission;
    transient SequencedEvent currentSequencedEvent = null;
    private static LinkedList heavyweightRequests;
    private static LinkedList currentLightweightRequests;
    private static boolean clearingCurrentLightweightRequests;
    private static boolean allowSyncFocusRequests;
    private static Component newFocusOwner;
    static final int SNFH_FAILURE = 0;
    static final int SNFH_SUCCESS_HANDLED = 1;
    static final int SNFH_SUCCESS_PROCEED = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    int requestCount() {
        return heavyweightRequests.size();
    }

    static {
        $assertionsDisabled = !KeyboardFocusManager.class.desiredAssertionStatus();
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            KeyboardFocusManager.initIDs();
        }
        dbg = DebugHelper.create(KeyboardFocusManager.class);
        defaultFocusTraversalKeyPropertyNames = new String[]{"forwardDefaultFocusTraversalKeys", "backwardDefaultFocusTraversalKeys", "upCycleDefaultFocusTraversalKeys", "downCycleDefaultFocusTraversalKeys"};
        defaultFocusTraversalKeyStrings = new String[]{"TAB,ctrl TAB", "shift TAB,ctrl shift TAB", "", ""};
        mostRecentFocusOwners = new WeakHashMap();
        heavyweightRequests = new LinkedList();
        allowSyncFocusRequests = true;
        newFocusOwner = null;
    }

    public KeyboardFocusManager() {
        for (int i2 = 0; i2 < 4; ++i2) {
            this.defaultFocusTraversalKeys[i2] = KeyboardFocusManager.initFocusTraversalKeysSet(defaultFocusTraversalKeyStrings[i2], new HashSet());
        }
    }

    private native void _clearGlobalFocusOwner();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearFocusRequestList() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            Iterator iterator = heavyweightRequests.iterator();
            while (iterator.hasNext()) {
                HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)iterator.next();
                if (heavyweightFocusRequest.lightweightRequests == null) continue;
                Iterator iterator2 = heavyweightFocusRequest.lightweightRequests.iterator();
                while (iterator2.hasNext()) {
                    keyboardFocusManager.dequeueKeyEvents(-1L, ((LightweightFocusRequest)iterator2.next()).component);
                }
            }
            heavyweightRequests.clear();
        }
    }

    public void clearGlobalFocusOwner() {
        if (!GraphicsEnvironment.isHeadless()) {
            Toolkit.getDefaultToolkit();
            this._clearGlobalFocusOwner();
        }
    }

    public final void downFocusCycle() {
        Component component = this.getFocusOwner();
        if (component instanceof Container) {
            this.downFocusCycle((Container)component);
        }
    }

    public final void focusNextComponent() {
        Component component = this.getFocusOwner();
        if (component != null) {
            this.focusNextComponent(component);
        }
    }

    public final void focusPreviousComponent() {
        Component component = this.getFocusOwner();
        if (component != null) {
            this.focusPreviousComponent(component);
        }
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processCurrentLightweightRequests() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        LinkedList linkedList = null;
        Component component = keyboardFocusManager.getGlobalFocusOwner();
        if (component != null && component.appContext != AppContext.getAppContext()) {
            return;
        }
        Object object = heavyweightRequests;
        synchronized (object) {
            if (currentLightweightRequests == null) {
                return;
            }
            clearingCurrentLightweightRequests = true;
            linkedList = currentLightweightRequests;
            allowSyncFocusRequests = linkedList.size() < 2;
            currentLightweightRequests = null;
        }
        try {
            if (linkedList != null) {
                Component component2;
                object = linkedList.iterator();
                while (object.hasNext() && (component2 = keyboardFocusManager.getGlobalFocusOwner()) != null) {
                    LightweightFocusRequest lightweightFocusRequest = (LightweightFocusRequest)object.next();
                    FocusEvent focusEvent = new FocusEvent(component2, 1005, lightweightFocusRequest.temporary, lightweightFocusRequest.component);
                    FocusEvent focusEvent2 = new FocusEvent(lightweightFocusRequest.component, 1004, lightweightFocusRequest.temporary, component2);
                    component2.dispatchEvent(focusEvent);
                    lightweightFocusRequest.component.dispatchEvent(focusEvent2);
                }
            }
            Object var9_9 = null;
            clearingCurrentLightweightRequests = false;
            linkedList = null;
            allowSyncFocusRequests = true;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            clearingCurrentLightweightRequests = false;
            linkedList = null;
            allowSyncFocusRequests = true;
            throw throwable;
        }
    }

    public final void upFocusCycle() {
        Component component = this.getFocusOwner();
        if (component != null) {
            this.upFocusCycle(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeFirstRequest() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getFirst() : null);
            if (heavyweightFocusRequest != null) {
                heavyweightRequests.removeFirst();
                if (heavyweightFocusRequest.lightweightRequests != null) {
                    Iterator iterator = heavyweightFocusRequest.lightweightRequests.iterator();
                    while (iterator.hasNext()) {
                        keyboardFocusManager.dequeueKeyEvents(-1L, ((LightweightFocusRequest)iterator.next()).component);
                    }
                }
            }
            return heavyweightRequests.size() > 0;
        }
    }

    public abstract boolean dispatchEvent(AWTEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getFocusOwner() {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (focusOwner == null) {
                return null;
            }
            return KeyboardFocusManager.focusOwner.appContext == AppContext.getAppContext() ? focusOwner : null;
        }
    }

    protected Component getGlobalFocusOwner() throws SecurityException {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (this == KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
                return focusOwner;
            }
            throw new SecurityException(notPrivileged);
        }
    }

    protected Component getGlobalPermanentFocusOwner() throws SecurityException {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (this == KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
                return permanentFocusOwner;
            }
            throw new SecurityException(notPrivileged);
        }
    }

    static native Component getNativeFocusOwner();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getPermanentFocusOwner() {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (permanentFocusOwner == null) {
                return null;
            }
            return KeyboardFocusManager.permanentFocusOwner.appContext == AppContext.getAppContext() ? permanentFocusOwner : null;
        }
    }

    protected abstract void dequeueKeyEvents(long var1, Component var3);

    protected abstract void enqueueKeyEvents(long var1, Component var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearMostRecentFocusOwner(Component component) {
        Container container;
        if (component == null) {
            return;
        }
        Object object = component.getTreeLock();
        synchronized (object) {
            for (container = component.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
        }
        object = KeyboardFocusManager.class;
        synchronized (object) {
            Window window;
            if (container != null && KeyboardFocusManager.getMostRecentFocusOwner((Window)container) == component) {
                KeyboardFocusManager.setMostRecentFocusOwner((Window)container, null);
            }
            if (container != null && (window = (Window)container).getTemporaryLostComponent() == component) {
                window.setTemporaryLostComponent(null);
            }
        }
    }

    protected abstract void discardKeyEvents(Component var1);

    public abstract void focusNextComponent(Component var1);

    public abstract void focusPreviousComponent(Component var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFocusRequest(Component component) {
        Component component2;
        Component component3 = component2 = component.peer instanceof LightweightPeer ? component.getNativeContainer() : component;
        if (component2 == null) {
            return;
        }
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            Object object;
            Object object2;
            Object object3;
            if (currentLightweightRequests != null && currentLightweightRequests.size() > 0) {
                object3 = (LightweightFocusRequest)currentLightweightRequests.getFirst();
                object2 = ((LightweightFocusRequest)object3).component;
                Object object4 = object = ((Component)object2).peer instanceof LightweightPeer ? ((Component)object2).getNativeContainer() : object2;
                if (object == component) {
                    currentLightweightRequests = null;
                } else {
                    Iterator iterator = currentLightweightRequests.iterator();
                    while (iterator.hasNext()) {
                        if (((LightweightFocusRequest)iterator.next()).component != component) continue;
                        iterator.remove();
                    }
                    if (currentLightweightRequests.size() == 0) {
                        currentLightweightRequests = null;
                    }
                }
            }
            object3 = heavyweightRequests.iterator();
            while (object3.hasNext()) {
                object2 = (HeavyweightFocusRequest)object3.next();
                if (((HeavyweightFocusRequest)object2).heavyweight != component2) continue;
                if (component2 == component) {
                    object3.remove();
                    continue;
                }
                object = ((HeavyweightFocusRequest)object2).lightweightRequests.iterator();
                while (object.hasNext()) {
                    if (((LightweightFocusRequest)object.next()).component != component) continue;
                    object.remove();
                }
                if (((HeavyweightFocusRequest)object2).lightweightRequests.size() != 0) continue;
                object3.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeLastFocusRequest(Component component) {
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getLast() : null);
            if (heavyweightFocusRequest != null && heavyweightFocusRequest.heavyweight == component) {
                heavyweightRequests.removeLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalFocusOwner(Component component) {
        Component component2 = null;
        boolean bl2 = false;
        if (component == null || component.isFocusable()) {
            Class clazz = KeyboardFocusManager.class;
            synchronized (clazz) {
                component2 = this.getFocusOwner();
                try {
                    this.fireVetoableChange("focusOwner", component2, component);
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
                focusOwner = component;
                if (!(component == null || this.getCurrentFocusCycleRoot() != null && component.isFocusCycleRoot(this.getCurrentFocusCycleRoot()))) {
                    Container container = component.getFocusCycleRootAncestor();
                    if (container == null && component instanceof Window) {
                        container = (Container)component;
                    }
                    if (container != null) {
                        this.setGlobalCurrentFocusCycleRoot(container);
                    }
                }
                bl2 = true;
            }
        }
        if (bl2) {
            this.firePropertyChange("focusOwner", component2, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalPermanentFocusOwner(Component component) {
        Component component2 = null;
        boolean bl2 = false;
        if (component == null || component.isFocusable()) {
            Class clazz = KeyboardFocusManager.class;
            synchronized (clazz) {
                component2 = this.getPermanentFocusOwner();
                try {
                    this.fireVetoableChange("permanentFocusOwner", component2, component);
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
                permanentFocusOwner = component;
                KeyboardFocusManager.setMostRecentFocusOwner(component);
                bl2 = true;
            }
        }
        if (bl2) {
            this.firePropertyChange("permanentFocusOwner", component2, component);
        }
    }

    static void setMostRecentFocusOwner(Component component) {
        Component component2 = component;
        while (component2 != null && !(component2 instanceof Window)) {
            component2 = component2.parent;
        }
        if (component2 != null) {
            KeyboardFocusManager.setMostRecentFocusOwner((Window)component2, component);
        }
    }

    public abstract void upFocusCycle(Component var1);

    static void heavyweightButtonDown(Component component, long l2) {
        KeyboardFocusManager.heavyweightButtonDown(component, l2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void heavyweightButtonDown(Component component, long l2, boolean bl2) {
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            Component component2;
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getLast() : null);
            Component component3 = component2 = heavyweightFocusRequest == null ? KeyboardFocusManager.getNativeFocusOwner() : heavyweightFocusRequest.heavyweight;
            if (bl2 || component != component2) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(component)).enqueueKeyEvents(l2, component);
                heavyweightRequests.add(new HeavyweightFocusRequest(component, component, false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container getCurrentFocusCycleRoot() {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (currentFocusCycleRoot == null) {
                return null;
            }
            return KeyboardFocusManager.currentFocusCycleRoot.appContext == AppContext.getAppContext() ? currentFocusCycleRoot : null;
        }
    }

    protected Container getGlobalCurrentFocusCycleRoot() throws SecurityException {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (this == KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
                return currentFocusCycleRoot;
            }
            throw new SecurityException(notPrivileged);
        }
    }

    public abstract void downFocusCycle(Container var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalCurrentFocusCycleRoot(Container container) {
        Container container2;
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            container2 = this.getCurrentFocusCycleRoot();
            currentFocusCycleRoot = container;
        }
        this.firePropertyChange("currentFocusCycleRoot", container2, container);
    }

    public synchronized FocusTraversalPolicy getDefaultFocusTraversalPolicy() {
        return this.defaultPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy focusTraversalPolicy2;
        if (focusTraversalPolicy == null) {
            throw new IllegalArgumentException("default focus traversal policy cannot be null");
        }
        KeyboardFocusManager keyboardFocusManager = this;
        synchronized (keyboardFocusManager) {
            focusTraversalPolicy2 = this.defaultPolicy;
            this.defaultPolicy = focusTraversalPolicy;
        }
        this.firePropertyChange("defaultFocusTraversalPolicy", focusTraversalPolicy2, focusTraversalPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        if (keyEventDispatcher != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventDispatchers == null) {
                    this.keyEventDispatchers = new LinkedList();
                }
                this.keyEventDispatchers.add(keyEventDispatcher);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyEventDispatcher(KeyEventDispatcher keyEventDispatcher) {
        if (keyEventDispatcher != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventDispatchers != null) {
                    this.keyEventDispatchers.remove(keyEventDispatcher);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        if (keyEventPostProcessor != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventPostProcessors == null) {
                    this.keyEventPostProcessors = new LinkedList();
                }
                this.keyEventPostProcessors.add(keyEventPostProcessor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyEventPostProcessor(KeyEventPostProcessor keyEventPostProcessor) {
        if (keyEventPostProcessor != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.keyEventPostProcessors != null) {
                    this.keyEventPostProcessors.remove(keyEventPostProcessor);
                }
            }
        }
    }

    public static KeyboardFocusManager getCurrentKeyboardFocusManager() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager(AppContext.getAppContext());
    }

    public static synchronized void setCurrentKeyboardFocusManager(KeyboardFocusManager keyboardFocusManager) throws SecurityException {
        AppContext appContext = AppContext.getAppContext();
        if (keyboardFocusManager != null) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (replaceKeyboardFocusManagerPermission == null) {
                    replaceKeyboardFocusManagerPermission = new AWTPermission("replaceKeyboardFocusManager");
                }
                securityManager.checkPermission(replaceKeyboardFocusManagerPermission);
            }
            appContext.put(KeyboardFocusManager.class, keyboardFocusManager);
        } else {
            appContext.remove(KeyboardFocusManager.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final SequencedEvent getCurrentSequencedEvent() {
        Class clazz = SequencedEvent.class;
        synchronized (clazz) {
            return this.currentSequencedEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCurrentSequencedEvent(SequencedEvent sequencedEvent) {
        Class clazz = SequencedEvent.class;
        synchronized (clazz) {
            if (!$assertionsDisabled && sequencedEvent != null && this.currentSequencedEvent != null) {
                throw new AssertionError();
            }
            this.currentSequencedEvent = sequencedEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getActiveWindow() {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (activeWindow == null) {
                return null;
            }
            return KeyboardFocusManager.activeWindow.appContext == AppContext.getAppContext() ? activeWindow : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getFocusedWindow() {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (focusedWindow == null) {
                return null;
            }
            return KeyboardFocusManager.focusedWindow.appContext == AppContext.getAppContext() ? focusedWindow : null;
        }
    }

    protected Window getGlobalActiveWindow() throws SecurityException {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (this == KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
                return activeWindow;
            }
            throw new SecurityException(notPrivileged);
        }
    }

    protected Window getGlobalFocusedWindow() throws SecurityException {
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            if (this == KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
                return focusedWindow;
            }
            throw new SecurityException(notPrivileged);
        }
    }

    static native Window getNativeFocusedWindow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Window markClearGlobalFocusOwner() {
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            Container container;
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getLast() : null);
            if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                return null;
            }
            heavyweightRequests.add(HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER);
            Window window = container = heavyweightFocusRequest != null ? KeyboardFocusManager.getContainingWindow(heavyweightFocusRequest.heavyweight) : KeyboardFocusManager.getNativeFocusedWindow();
            while (container != null && !(container instanceof Frame) && !(container instanceof Dialog)) {
                container = container.getParent();
            }
            return container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalActiveWindow(Window window) {
        Window window2;
        Class clazz = KeyboardFocusManager.class;
        synchronized (clazz) {
            window2 = this.getActiveWindow();
            try {
                this.fireVetoableChange("activeWindow", window2, window);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
            activeWindow = window;
        }
        this.firePropertyChange("activeWindow", window2, window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGlobalFocusedWindow(Window window) {
        Window window2 = null;
        boolean bl2 = false;
        if (window == null || window.isFocusableWindow()) {
            Class clazz = KeyboardFocusManager.class;
            synchronized (clazz) {
                window2 = this.getFocusedWindow();
                try {
                    this.fireVetoableChange("focusedWindow", window2, window);
                }
                catch (PropertyVetoException propertyVetoException) {
                    return;
                }
                focusedWindow = window;
                bl2 = true;
            }
        }
        if (bl2) {
            this.firePropertyChange("focusedWindow", window2, window);
        }
    }

    public abstract boolean dispatchKeyEvent(KeyEvent var1);

    static boolean isProxyActive(KeyEvent keyEvent) {
        if (!GraphicsEnvironment.isHeadless()) {
            return KeyboardFocusManager.isProxyActiveImpl(keyEvent);
        }
        return false;
    }

    private static native boolean isProxyActiveImpl(KeyEvent var0);

    public abstract boolean postProcessKeyEvent(KeyEvent var1);

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                }
                this.changeSupport.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport != null) {
                    this.changeSupport.removePropertyChangeListener(propertyChangeListener);
                }
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        return this.vetoableSupport.getVetoableChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport == null) {
                    this.vetoableSupport = new VetoableChangeSupport(this);
                }
                this.vetoableSupport.addVetoableChangeListener(vetoableChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport != null) {
                    this.vetoableSupport.removeVetoableChangeListener(vetoableChangeListener);
                }
            }
        }
    }

    protected synchronized List getKeyEventDispatchers() {
        return this.keyEventDispatchers != null ? (List)this.keyEventDispatchers.clone() : null;
    }

    protected List getKeyEventPostProcessors() {
        return this.keyEventPostProcessors != null ? (List)this.keyEventPostProcessors.clone() : null;
    }

    public Set getDefaultFocusTraversalKeys(int n2) {
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        return this.defaultFocusTraversalKeys[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultFocusTraversalKeys(int n2, Set set) {
        Set set2;
        if (n2 < 0 || n2 >= 4) {
            throw new IllegalArgumentException("invalid focus traversal key identifier");
        }
        if (set == null) {
            throw new IllegalArgumentException("cannot set null Set of default focus traversal keys");
        }
        KeyboardFocusManager keyboardFocusManager = this;
        synchronized (keyboardFocusManager) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object == null) {
                    throw new IllegalArgumentException("cannot set null focus traversal key");
                }
                AWTKeyStroke aWTKeyStroke = (AWTKeyStroke)object;
                if (aWTKeyStroke.getKeyChar() != '\uffff') {
                    throw new IllegalArgumentException("focus traversal keys cannot map to KEY_TYPED events");
                }
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (i2 == n2 || !this.defaultFocusTraversalKeys[i2].contains(aWTKeyStroke)) continue;
                    throw new IllegalArgumentException("focus traversal keys must be unique for a Component");
                }
            }
            set2 = this.defaultFocusTraversalKeys[n2];
            this.defaultFocusTraversalKeys[n2] = Collections.unmodifiableSet(new HashSet(set));
        }
        this.firePropertyChange(defaultFocusTraversalKeyPropertyNames[n2], set2, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AWTEvent retargetFocusEvent(AWTEvent aWTEvent) {
        if (clearingCurrentLightweightRequests) {
            return aWTEvent;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            if (newFocusOwner != null && aWTEvent.getID() == 1005) {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                if (keyboardFocusManager.getGlobalFocusOwner() == focusEvent.getComponent() && focusEvent.getOppositeComponent() == newFocusOwner) {
                    newFocusOwner = null;
                    return aWTEvent;
                }
            }
        }
        KeyboardFocusManager.processCurrentLightweightRequests();
        switch (aWTEvent.getID()) {
            case 1004: {
                aWTEvent = KeyboardFocusManager.retargetFocusGained((FocusEvent)aWTEvent);
                break;
            }
            case 1005: {
                aWTEvent = KeyboardFocusManager.retargetFocusLost((FocusEvent)aWTEvent);
                break;
            }
        }
        return aWTEvent;
    }

    public final void redispatchEvent(Component component, AWTEvent aWTEvent) {
        aWTEvent.focusManagerIsDispatching = true;
        component.dispatchEvent(aWTEvent);
        aWTEvent.focusManagerIsDispatching = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Component getCurrentWaitingRequest(Component component) {
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            LightweightFocusRequest lightweightFocusRequest;
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getFirst() : null);
            if (heavyweightFocusRequest != null && heavyweightFocusRequest.heavyweight == component && (lightweightFocusRequest = (LightweightFocusRequest)heavyweightFocusRequest.lightweightRequests.getFirst()) != null) {
                return lightweightFocusRequest.component;
            }
        }
        return null;
    }

    private static Component getHeavyweight(Component component) {
        if (component == null || component.getPeer() == null) {
            return null;
        }
        if (component.getPeer() instanceof LightweightPeer) {
            return component.getNativeContainer();
        }
        return component;
    }

    private static boolean focusedWindowChanged(Component component, Component component2) {
        Window window = KeyboardFocusManager.getContainingWindow(component);
        Window window2 = KeyboardFocusManager.getContainingWindow(component2);
        if (window == null || window2 == null) {
            return false;
        }
        return window != window2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int shouldNativelyFocusHeavyweight(Component component, Component component2, boolean bl2, boolean bl3, long l2) {
        if (component2 == null) {
            component2 = component;
        }
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getLast() : null);
            if (heavyweightFocusRequest == null && component == KeyboardFocusManager.getNativeFocusOwner()) {
                FocusEvent focusEvent;
                Component component3 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
                if (component2 == component3) {
                    return 0;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(component2)).enqueueKeyEvents(l2, component2);
                heavyweightFocusRequest = new HeavyweightFocusRequest(component, component2, bl2);
                heavyweightRequests.add(heavyweightFocusRequest);
                if (component3 != null) {
                    focusEvent = new FocusEvent(component3, 1005, bl2, component2);
                    SunToolkit.postEvent(component3.appContext, focusEvent);
                }
                focusEvent = new FocusEvent(component2, 1004, bl2, component3);
                SunToolkit.postEvent(component2.appContext, focusEvent);
                return 1;
            }
            if (heavyweightFocusRequest != null && heavyweightFocusRequest.heavyweight == component) {
                if (heavyweightFocusRequest.addLightweightRequest(component2, bl2)) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(component2)).enqueueKeyEvents(l2, component2);
                }
                return 1;
            }
            if (!bl3) {
                if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                    int n2 = heavyweightRequests.size();
                    heavyweightFocusRequest = (HeavyweightFocusRequest)(n2 >= 2 ? heavyweightRequests.get(n2 - 2) : null);
                }
                if (KeyboardFocusManager.focusedWindowChanged(component, heavyweightFocusRequest != null ? heavyweightFocusRequest.heavyweight : KeyboardFocusManager.getNativeFocusedWindow())) {
                    return 0;
                }
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(component2)).enqueueKeyEvents(l2, component2);
            heavyweightRequests.add(new HeavyweightFocusRequest(component, component2, bl2));
            return 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean processSynchronousLightweightTransfer(Component component, Component component2, boolean bl2, boolean bl3, long l2) {
        Window window = KeyboardFocusManager.getContainingWindow(component);
        if (window == null || !window.syncLWRequests) {
            return false;
        }
        if (component2 == null) {
            component2 = component;
        }
        FocusEvent focusEvent = null;
        FocusEvent focusEvent2 = null;
        Component component3 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getLast() : null);
            if (heavyweightFocusRequest == null && component == KeyboardFocusManager.getNativeFocusOwner() && allowSyncFocusRequests) {
                if (component2 == component3) {
                    return true;
                }
                KeyboardFocusManager.getCurrentKeyboardFocusManager(SunToolkit.targetToAppContext(component2)).enqueueKeyEvents(l2, component2);
                heavyweightFocusRequest = new HeavyweightFocusRequest(component, component2, bl2);
                heavyweightRequests.add(heavyweightFocusRequest);
                if (component3 != null) {
                    focusEvent = new FocusEvent(component3, 1005, bl2, component2);
                }
                focusEvent2 = new FocusEvent(component2, 1004, bl2, component3);
            }
        }
        boolean bl4 = false;
        boolean bl5 = clearingCurrentLightweightRequests;
        try {
            clearingCurrentLightweightRequests = false;
            Object object = Component.LOCK;
            synchronized (object) {
                if (focusEvent != null && component3 != null) {
                    component3.dispatchEvent(focusEvent);
                    bl4 = true;
                }
                if (focusEvent2 != null && component2 != null) {
                    component2.dispatchEvent(focusEvent2);
                    bl4 = true;
                }
            }
        }
        finally {
            clearingCurrentLightweightRequests = bl5;
        }
        return bl4;
    }

    static synchronized Component getMostRecentFocusOwner(Window window) {
        WeakReference weakReference = (WeakReference)mostRecentFocusOwners.get(window);
        return weakReference == null ? null : (Component)weakReference.get();
    }

    static synchronized void setMostRecentFocusOwner(Window window, Component component) {
        WeakReference weakReference = null;
        if (component != null) {
            weakReference = new WeakReference(component);
        }
        mostRecentFocusOwners.put(window, weakReference);
    }

    static synchronized KeyboardFocusManager getCurrentKeyboardFocusManager(AppContext appContext) {
        KeyboardFocusManager keyboardFocusManager = (KeyboardFocusManager)appContext.get(KeyboardFocusManager.class);
        if (keyboardFocusManager == null) {
            keyboardFocusManager = new DefaultKeyboardFocusManager();
            appContext.put(KeyboardFocusManager.class, keyboardFocusManager);
        }
        return keyboardFocusManager;
    }

    static Window getContainingWindow(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FocusEvent retargetFocusGained(FocusEvent focusEvent) {
        if (!$assertionsDisabled && focusEvent.getID() != 1004) {
            throw new AssertionError();
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
        Component component2 = focusEvent.getComponent();
        Component component3 = focusEvent.getOppositeComponent();
        Component component4 = KeyboardFocusManager.getHeavyweight(component2);
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getFirst() : null);
            if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                return KeyboardFocusManager.retargetUnexpectedFocusEvent(focusEvent);
            }
            if (component2 != null && component4 == null && heavyweightFocusRequest != null && component2 == heavyweightFocusRequest.getFirstLightweightRequest().component) {
                component4 = component2 = heavyweightFocusRequest.heavyweight;
            }
            if (heavyweightFocusRequest != null && component4 == heavyweightFocusRequest.heavyweight) {
                boolean bl2;
                heavyweightRequests.removeFirst();
                LightweightFocusRequest lightweightFocusRequest = (LightweightFocusRequest)heavyweightFocusRequest.lightweightRequests.removeFirst();
                Component component5 = lightweightFocusRequest.component;
                if (component != null) {
                    newFocusOwner = component5;
                }
                boolean bl3 = bl2 = component3 == null || KeyboardFocusManager.focusedWindowChanged(component5, component3) ? false : lightweightFocusRequest.temporary;
                if (heavyweightFocusRequest.lightweightRequests.size() > 0) {
                    currentLightweightRequests = heavyweightFocusRequest.lightweightRequests;
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            KeyboardFocusManager.processCurrentLightweightRequests();
                        }
                    });
                }
                return new FocusEvent(component5, 1004, bl2, component3);
            }
            if (component != null && KeyboardFocusManager.getContainingWindow(component) == component2 && (heavyweightFocusRequest == null || component2 != heavyweightFocusRequest.heavyweight)) {
                return new FocusEvent(component, 1004, false, null);
            }
            return KeyboardFocusManager.retargetUnexpectedFocusEvent(focusEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FocusEvent retargetFocusLost(FocusEvent focusEvent) {
        if (!$assertionsDisabled && focusEvent.getID() != 1005) {
            throw new AssertionError();
        }
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getGlobalFocusOwner();
        Component component2 = focusEvent.getOppositeComponent();
        Component component3 = KeyboardFocusManager.getHeavyweight(component2);
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            HeavyweightFocusRequest heavyweightFocusRequest = (HeavyweightFocusRequest)(heavyweightRequests.size() > 0 ? heavyweightRequests.getFirst() : null);
            if (heavyweightFocusRequest == HeavyweightFocusRequest.CLEAR_GLOBAL_FOCUS_OWNER) {
                if (component != null) {
                    heavyweightRequests.removeFirst();
                    return new FocusEvent(component, 1005, false, null);
                }
            } else {
                if (component2 == null) {
                    if (component != null) {
                        return new FocusEvent(component, 1005, true, null);
                    }
                    return focusEvent;
                }
                if (heavyweightFocusRequest != null && (component3 == heavyweightFocusRequest.heavyweight || component3 == null && component2 == heavyweightFocusRequest.getFirstLightweightRequest().component)) {
                    if (component == null) {
                        return focusEvent;
                    }
                    LightweightFocusRequest lightweightFocusRequest = (LightweightFocusRequest)heavyweightFocusRequest.lightweightRequests.getFirst();
                    boolean bl2 = KeyboardFocusManager.focusedWindowChanged(component2, component) ? true : lightweightFocusRequest.temporary;
                    return new FocusEvent(component, 1005, bl2, lightweightFocusRequest.component);
                }
            }
            return KeyboardFocusManager.retargetUnexpectedFocusEvent(focusEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static FocusEvent retargetUnexpectedFocusEvent(FocusEvent focusEvent) {
        LinkedList linkedList = heavyweightRequests;
        synchronized (linkedList) {
            if (KeyboardFocusManager.removeFirstRequest()) {
                return (FocusEvent)KeyboardFocusManager.retargetFocusEvent(focusEvent);
            }
            Component component = focusEvent.getComponent();
            Component component2 = focusEvent.getOppositeComponent();
            boolean bl2 = false;
            if (focusEvent.getID() == 1005 && (component2 == null || KeyboardFocusManager.focusedWindowChanged(component, component2))) {
                bl2 = true;
            }
            return new FocusEvent(component, focusEvent.getID(), bl2, component2);
        }
    }

    public abstract void processKeyEvent(Component var1, KeyEvent var2);

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport == null) {
                    this.changeSupport = new PropertyChangeSupport(this);
                }
                this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.changeSupport != null) {
                    this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
                }
            }
        }
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners(String string) {
        if (this.vetoableSupport == null) {
            this.vetoableSupport = new VetoableChangeSupport(this);
        }
        return this.vetoableSupport.getVetoableChangeListeners(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport == null) {
                    this.vetoableSupport = new VetoableChangeSupport(this);
                }
                this.vetoableSupport.addVetoableChangeListener(string, vetoableChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVetoableChangeListener(String string, VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener != null) {
            KeyboardFocusManager keyboardFocusManager = this;
            synchronized (keyboardFocusManager) {
                if (this.vetoableSupport != null) {
                    this.vetoableSupport.removeVetoableChangeListener(string, vetoableChangeListener);
                }
            }
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        VetoableChangeSupport vetoableChangeSupport = this.vetoableSupport;
        if (vetoableChangeSupport != null) {
            vetoableChangeSupport.fireVetoableChange(string, object, object2);
        }
    }

    static Set initFocusTraversalKeysSet(String string, Set set) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            set.add(AWTKeyStroke.getAWTKeyStroke(stringTokenizer.nextToken()));
        }
        return set.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(set);
    }

    private static final class HeavyweightFocusRequest {
        final Component heavyweight;
        final LinkedList lightweightRequests;
        static final HeavyweightFocusRequest CLEAR_GLOBAL_FOCUS_OWNER = new HeavyweightFocusRequest();

        private HeavyweightFocusRequest() {
            this.heavyweight = null;
            this.lightweightRequests = null;
        }

        boolean addLightweightRequest(Component component, boolean bl2) {
            Component component2;
            dbg;
            Component component3 = component2 = this.lightweightRequests.size() > 0 ? ((LightweightFocusRequest)this.lightweightRequests.getLast()).component : null;
            if (component != component2) {
                this.lightweightRequests.add(new LightweightFocusRequest(component, bl2));
                return true;
            }
            return false;
        }

        LightweightFocusRequest getFirstLightweightRequest() {
            if (this == CLEAR_GLOBAL_FOCUS_OWNER) {
                return null;
            }
            return (LightweightFocusRequest)this.lightweightRequests.getFirst();
        }

        public String toString() {
            boolean bl2 = true;
            String string = "HeavyweightFocusRequest[heavweight=" + this.heavyweight + ",lightweightRequests=";
            if (this.lightweightRequests == null) {
                string = string + null;
            } else {
                string = string + "[";
                Iterator iterator = this.lightweightRequests.iterator();
                while (iterator.hasNext()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        string = string + ",";
                    }
                    string = string + iterator.next();
                }
                string = string + "]";
            }
            string = string + "]";
            return string;
        }

        HeavyweightFocusRequest(Component component, Component component2, boolean bl2) {
            dbg;
            this.heavyweight = component;
            this.lightweightRequests = new LinkedList();
            this.addLightweightRequest(component2, bl2);
        }
    }

    private static final class LightweightFocusRequest {
        final Component component;
        final boolean temporary;

        LightweightFocusRequest(Component component, boolean bl2) {
            this.component = component;
            this.temporary = bl2;
        }

        public String toString() {
            return "LightweightFocusRequest[component=" + this.component + ",temporary=" + this.temporary + "]";
        }
    }
}

