/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParameters {
    private Provider provider;
    private AlgorithmParametersSpi paramSpi;
    private String algorithm;
    private boolean initialized = false;

    public final byte[] getEncoded() throws IOException {
        if (!this.initialized) {
            throw new IOException("not initialized");
        }
        return this.paramSpi.engineGetEncoded();
    }

    public final void init(byte[] byArray) throws IOException {
        if (this.initialized) {
            throw new IOException("already initialized");
        }
        this.paramSpi.engineInit(byArray);
        this.initialized = true;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final String toString() {
        if (!this.initialized) {
            return null;
        }
        return this.paramSpi.engineToString();
    }

    public final byte[] getEncoded(String string) throws IOException {
        if (!this.initialized) {
            throw new IOException("not initialized");
        }
        return this.paramSpi.engineGetEncoded(string);
    }

    public final void init(byte[] byArray, String string) throws IOException {
        if (this.initialized) {
            throw new IOException("already initialized");
        }
        this.paramSpi.engineInit(byArray, string);
        this.initialized = true;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (this.initialized) {
            throw new InvalidParameterSpecException("already initialized");
        }
        this.paramSpi.engineInit(algorithmParameterSpec);
        this.initialized = true;
    }

    public static AlgorithmParameters getInstance(String string) throws NoSuchAlgorithmException {
        try {
            Object[] objectArray = Security.getImpl(string, "AlgorithmParameters", (String)null);
            return new AlgorithmParameters((AlgorithmParametersSpi)objectArray[0], (Provider)objectArray[1], string);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new NoSuchAlgorithmException(string + " not found");
        }
    }

    public final AlgorithmParameterSpec getParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!this.initialized) {
            throw new InvalidParameterSpecException("not initialized");
        }
        return this.paramSpi.engineGetParameterSpec(clazz);
    }

    protected AlgorithmParameters(AlgorithmParametersSpi algorithmParametersSpi, Provider provider, String string) {
        this.paramSpi = algorithmParametersSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static AlgorithmParameters getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "AlgorithmParameters", string2);
        return new AlgorithmParameters((AlgorithmParametersSpi)objectArray[0], (Provider)objectArray[1], string);
    }

    public static AlgorithmParameters getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("missing provider");
        }
        Object[] objectArray = Security.getImpl(string, "AlgorithmParameters", provider);
        return new AlgorithmParameters((AlgorithmParametersSpi)objectArray[0], (Provider)objectArray[1], string);
    }
}

