/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import com.sun.imageio.plugins.gif.GIFImageReaderSpi;
import com.sun.imageio.plugins.jpeg.JPEGImageReaderSpi;
import com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi;
import com.sun.imageio.plugins.png.PNGImageReaderSpi;
import com.sun.imageio.plugins.png.PNGImageWriterSpi;
import com.sun.imageio.spi.FileImageInputStreamSpi;
import com.sun.imageio.spi.FileImageOutputStreamSpi;
import com.sun.imageio.spi.InputStreamImageInputStreamSpi;
import com.sun.imageio.spi.OutputStreamImageOutputStreamSpi;
import com.sun.imageio.spi.RAFImageInputStreamSpi;
import com.sun.imageio.spi.RAFImageOutputStreamSpi;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import sun.awt.AppContext;
import sun.misc.Service;

public final class IIORegistry
extends ServiceRegistry {
    private static final Vector initialCategories = new Vector(5);

    static {
        initialCategories.add(ImageReaderSpi.class);
        initialCategories.add(ImageWriterSpi.class);
        initialCategories.add(ImageTranscoderSpi.class);
        initialCategories.add(ImageInputStreamSpi.class);
        initialCategories.add(ImageOutputStreamSpi.class);
    }

    private IIORegistry() {
        super(initialCategories.iterator());
        this.registerStandardSpis();
        this.registerApplicationClasspathSpis();
    }

    public void registerApplicationClasspathSpis() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Iterator iterator = this.getCategories();
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            Iterator iterator2 = Service.providers(clazz, classLoader);
            while (iterator2.hasNext()) {
                IIOServiceProvider iIOServiceProvider = (IIOServiceProvider)iterator2.next();
                this.registerServiceProvider(iIOServiceProvider);
            }
        }
    }

    private void registerStandardSpis() {
        this.registerServiceProvider(new GIFImageReaderSpi());
        this.registerServiceProvider(new PNGImageReaderSpi());
        this.registerServiceProvider(new PNGImageWriterSpi());
        this.registerServiceProvider(new JPEGImageReaderSpi());
        this.registerServiceProvider(new JPEGImageWriterSpi());
        this.registerServiceProvider(new FileImageInputStreamSpi());
        this.registerServiceProvider(new FileImageOutputStreamSpi());
        this.registerServiceProvider(new InputStreamImageInputStreamSpi());
        this.registerServiceProvider(new OutputStreamImageOutputStreamSpi());
        this.registerServiceProvider(new RAFImageInputStreamSpi());
        this.registerServiceProvider(new RAFImageOutputStreamSpi());
    }

    public static IIORegistry getDefaultInstance() {
        AppContext appContext = AppContext.getAppContext();
        IIORegistry iIORegistry = (IIORegistry)appContext.get(IIORegistry.class);
        if (iIORegistry == null) {
            iIORegistry = new IIORegistry();
            appContext.put(IIORegistry.class, iIORegistry);
        }
        return iIORegistry;
    }
}

