/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Map;

public final class FontResolver {
    private Font[] allFonts;
    private static final float DEFAULT_SIZE = 12.0f;
    private static final int SHIFT = 9;
    private static final int BLOCKSIZE = 128;
    private static final int MASK = 127;
    private int[][] blocks = new int[512][];
    private static FontResolver INSTANCE;

    private FontResolver() {
        this.allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        this.allFonts = (Font[])this.allFonts.clone();
        for (int i2 = 0; i2 < this.allFonts.length; ++i2) {
            this.allFonts[i2] = this.allFonts[i2].deriveFont(12.0f);
        }
    }

    public int getFontIndex(char c2) {
        int n2;
        int n3 = c2 >> 9;
        int[] nArray = this.blocks[n3];
        if (nArray == null) {
            nArray = new int[128];
            this.blocks[n3] = nArray;
        }
        if (nArray[n2 = c2 & 0x7F] == 0) {
            nArray[n2] = this.getIndexFor(c2);
        }
        return nArray[n2];
    }

    private int getIndexFor(char c2) {
        for (int i2 = 0; i2 < this.allFonts.length; ++i2) {
            if (!this.allFonts[i2].canDisplay(c2)) continue;
            return i2 + 1;
        }
        return 1;
    }

    public static FontResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FontResolver();
        }
        return INSTANCE;
    }

    public Font getFont(int n2, Map map) {
        Font font = this.allFonts[n2 - 1];
        return font.deriveFont(map);
    }
}

