/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.text.Bidi;
import sun.awt.font.Decoration;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.ExtendedTextSourceLabel;
import sun.awt.font.StandardTextSource;
import sun.awt.font.TextLabel;
import sun.awt.font.TextSourceLabel;

public class TextLabelFactory {
    private FontRenderContext frc;
    private char[] text;
    private Bidi bidi;
    private Bidi lineBidi;
    private int flags;
    private int lineStart;
    private int lineLimit;

    public int getLayoutFlags() {
        return this.flags;
    }

    public int getLineLimit() {
        return this.lineLimit;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public char[] getText() {
        return this.text;
    }

    public void setLineContext(int n2, int n3) {
        this.lineStart = n2;
        this.lineLimit = n3;
        if (this.bidi != null) {
            this.lineBidi = this.bidi.createLineBidi(n2, n3);
        }
    }

    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    public Bidi getLineBidi() {
        return this.lineBidi;
    }

    public Bidi getParagraphBidi() {
        return this.bidi;
    }

    public TextLabelFactory(FontRenderContext fontRenderContext, char[] cArray, Bidi bidi, int n2) {
        this.frc = fontRenderContext;
        this.text = cArray;
        this.bidi = bidi;
        this.flags = n2;
        this.lineBidi = bidi;
        this.lineStart = 0;
        this.lineLimit = cArray.length;
    }

    public TextLabel createSimple(Font font, LineMetrics lineMetrics, int n2, int n3) {
        if (n2 >= n3 || n2 < this.lineStart || n3 > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + n2 + " or limit: " + n3);
        }
        int n4 = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(n2 - this.lineStart);
        boolean bl2 = this.lineBidi != null && !this.lineBidi.baseIsLeftToRight();
        int n5 = this.flags & 0xFFFFFFF6;
        if ((n4 & 1) != 0) {
            n5 |= 1;
        }
        if (bl2 & true) {
            n5 |= 8;
        }
        StandardTextSource standardTextSource = new StandardTextSource(this.text, n2, n3 - n2, this.lineStart, this.lineLimit - this.lineStart, n4, n5, font, this.frc, lineMetrics);
        return new TextSourceLabel(standardTextSource);
    }

    public ExtendedTextLabel createExtended(Font font, LineMetrics lineMetrics, Decoration decoration, int n2, int n3) {
        if (n2 >= n3 || n2 < this.lineStart || n3 > this.lineLimit) {
            throw new IllegalArgumentException("bad start: " + n2 + " or limit: " + n3);
        }
        int n4 = this.lineBidi == null ? 0 : this.lineBidi.getLevelAt(n2 - this.lineStart);
        boolean bl2 = this.lineBidi != null && !this.lineBidi.baseIsLeftToRight();
        int n5 = this.flags & 0xFFFFFFF6;
        if ((n4 & 1) != 0) {
            n5 |= 1;
        }
        if (bl2 & true) {
            n5 |= 8;
        }
        StandardTextSource standardTextSource = new StandardTextSource(this.text, n2, n3 - n2, this.lineStart, this.lineLimit - this.lineStart, n4, n5, font, this.frc, lineMetrics);
        return new ExtendedTextSourceLabel(standardTextSource, decoration);
    }
}

