/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.PlatformFont;
import sun.awt.image.ByteComponentRaster;
import sun.awt.windows.WImage;
import sun.awt.windows.WPrinterJob;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;
import sun.print.RasterPrinterJob;

class WPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;
    private static final float MIN_DEVICE_LINEWIDTH = 1.2f;
    private static final float MAX_THINLINE_INCHES = 0.014f;
    private Font lastFont;
    private Font lastDeviceSizeFont;
    private int lastAngle;
    private float lastScaledFontSize;
    private float lastAverageWidthScale;

    protected void deviceDrawLine(int n2, int n3, int n4, int n5, Color color) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            WPrinterJob wPrinterJob;
            BasicStroke basicStroke = (BasicStroke)stroke;
            if (basicStroke.getDashArray() != null) {
                this.draw(new Line2D.Float(n2, n3, n4, n5));
                return;
            }
            float f2 = basicStroke.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f2, f2);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f3 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            Point2D.Float float_2 = new Point2D.Float(n2, n3);
            affineTransform.transform(float_2, float_2);
            Point2D.Float float_3 = new Point2D.Float(n4, n5);
            affineTransform.transform(float_3, float_3);
            int n6 = basicStroke.getEndCap();
            int n7 = basicStroke.getLineJoin();
            if (float_3.getX() == float_2.getX() && float_3.getY() == float_2.getY()) {
                n6 = 1;
            }
            if ((wPrinterJob = (WPrinterJob)this.getPrinterJob()).selectStylePen(n6, n7, f3, color)) {
                wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
            } else {
                double d2 = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                if (n6 == 1 || (n2 == n4 || n3 == n5) && (double)f3 / d2 < (double)0.014f) {
                    wPrinterJob.selectPen(f3, color);
                    wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                    wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
                } else {
                    this.draw(new Line2D.Float(n2, n3, n4, n5));
                }
            }
        }
    }

    protected void deviceFillRect(int n2, int n3, int n4, int n5, Color color) {
        boolean bl2;
        AffineTransform affineTransform = this.getTransform();
        int n6 = affineTransform.getType();
        boolean bl3 = bl2 = (n6 & 0x30) != 0;
        if (bl2) {
            this.fill(new Rectangle2D.Float(n2, n3, n4, n5));
            return;
        }
        Point2D.Float float_ = new Point2D.Float(n2, n3);
        affineTransform.transform(float_, float_);
        Point2D.Float float_2 = new Point2D.Float(n2 + n4, n3 + n5);
        affineTransform.transform(float_2, float_2);
        float f2 = (float)(float_2.getX() - float_.getX());
        float f3 = (float)(float_2.getY() - float_.getY());
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        wPrinterJob.fillRect((float)float_.getX(), (float)float_.getY(), f2, f3, color);
    }

    protected void deviceFrameRect(int n2, int n3, int n4, int n5, Color color) {
        boolean bl2;
        AffineTransform affineTransform = this.getTransform();
        int n6 = affineTransform.getType();
        boolean bl3 = bl2 = (n6 & 0x30) != 0;
        if (bl2) {
            this.draw(new Rectangle2D.Float(n2, n3, n4, n5));
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            int n7 = basicStroke.getEndCap();
            int n8 = basicStroke.getLineJoin();
            if (n7 == 2 && n8 == 0 && basicStroke.getMiterLimit() == 10.0f) {
                float f2 = basicStroke.getLineWidth();
                Point2D.Float float_ = new Point2D.Float(f2, f2);
                affineTransform.deltaTransform(float_, float_);
                float f3 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
                Point2D.Float float_2 = new Point2D.Float(n2, n3);
                affineTransform.transform(float_2, float_2);
                Point2D.Float float_3 = new Point2D.Float(n2 + n4, n3 + n5);
                affineTransform.transform(float_3, float_3);
                float f4 = (float)(float_3.getX() - float_2.getX());
                float f5 = (float)(float_3.getY() - float_2.getY());
                WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
                if (wPrinterJob.selectStylePen(n7, n8, f3, color)) {
                    wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f4, f5);
                } else {
                    double d2 = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                    if ((double)f3 / d2 < (double)0.014f) {
                        wPrinterJob.selectPen(f3, color);
                        wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f4, f5);
                    } else {
                        this.draw(new Rectangle2D.Float(n2, n3, n4, n5));
                    }
                }
            } else {
                this.draw(new Rectangle2D.Float(n2, n3, n4, n5));
            }
        }
    }

    public Graphics create() {
        return new WPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    private boolean hasTransparentPixels(Image image) {
        Object object;
        ColorModel colorModel;
        boolean bl2 = true;
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof WImage) {
            object = (WImage)image;
            bufferedImage = ((sun.awt.image.Image)object).getBufferedImage();
            if (bufferedImage == null) {
                return false;
            }
            colorModel = ((sun.awt.image.Image)object).getColorModel();
        } else {
            if (image instanceof VolatileImage) {
                return false;
            }
            colorModel = null;
        }
        boolean bl3 = colorModel == null ? true : (bl2 = colorModel.getTransparency() != 1);
        if (bl2 && bufferedImage != null && bufferedImage.getType() == 2) {
            object = bufferedImage.getRaster().getDataBuffer();
            SampleModel sampleModel = bufferedImage.getRaster().getSampleModel();
            if (object instanceof DataBufferInt && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray = ((DataBufferInt)object).getData();
                int n2 = bufferedImage.getMinX();
                int n3 = bufferedImage.getMinY();
                int n4 = bufferedImage.getWidth();
                int n5 = bufferedImage.getHeight();
                int n6 = singlePixelPackedSampleModel.getScanlineStride();
                boolean bl4 = false;
                for (int i2 = n3; i2 < n3 + n5; ++i2) {
                    int n7 = n3 * n6;
                    for (int i3 = n2; i3 < n2 + n4; ++i3) {
                        if ((nArray[n7 + i3] & 0xFF000000) == -16777216) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) break;
                }
                if (!bl4) {
                    bl2 = false;
                }
            }
        }
        return bl2;
    }

    private boolean isBitmaskTransparency(Image image) {
        ColorModel colorModel = null;
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof WImage) {
            WImage wImage = (WImage)image;
            colorModel = wImage.getColorModel();
        } else if (image instanceof VolatileImage) {
            return false;
        }
        return colorModel != null && colorModel.getTransparency() == 2;
    }

    public void draw(Shape shape) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = null;
            BasicStroke basicStroke2 = (BasicStroke)stroke;
            float f2 = basicStroke2.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f2, f2);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f3 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            if (f3 < 1.2f) {
                Point2D.Float float_2 = new Point2D.Float(1.2f, 1.2f);
                try {
                    AffineTransform affineTransform2 = affineTransform.createInverse();
                    affineTransform2.deltaTransform(float_2, float_2);
                    float f4 = Math.max(Math.abs(float_2.x), Math.abs(float_2.y));
                    basicStroke = new BasicStroke(f4, basicStroke2.getEndCap(), basicStroke2.getLineJoin(), basicStroke2.getMiterLimit(), basicStroke2.getDashArray(), basicStroke2.getDashPhase());
                    this.setStroke(basicStroke);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            super.draw(shape);
            if (basicStroke != null) {
                this.setStroke(basicStroke2);
            }
        } else {
            super.draw(shape);
        }
    }

    private void convertToWPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        int n2 = pathIterator.getWindingRule() == 0 ? 1 : 2;
        wPrinterJob.setPolyFillMode(n2);
        wPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    wPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    wPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    int n4 = wPrinterJob.getPenX();
                    int n5 = wPrinterJob.getPenY();
                    float f2 = (float)n4 + (fArray[0] - (float)n4) * 2.0f / 3.0f;
                    float f3 = (float)n5 + (fArray[1] - (float)n5) * 2.0f / 3.0f;
                    float f4 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f5 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    wPrinterJob.polyBezierTo(f2, f3, f4, f5, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    wPrinterJob.polyBezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    wPrinterJob.closeFigure();
                }
            }
            pathIterator.next();
        }
        wPrinterJob.endPath();
    }

    protected void deviceClip(PathIterator pathIterator) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectClipPath();
    }

    private boolean stringNeedsShaping(String string) {
        boolean bl2 = false;
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if ((c2 & 0xFE00) == 0) continue;
            if (c2 >= '\u0590' && c2 <= '\u05ff') {
                bl2 = true;
                break;
            }
            if (c2 >= '\u0600' && c2 <= '\u06ff') {
                bl2 = true;
                break;
            }
            if (c2 >= '\u202a' && c2 <= '\u202e') {
                bl2 = true;
                break;
            }
            if (c2 < '\u206a' || c2 > '\u206f') continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public void drawString(String string, float f2, float f3) {
        boolean bl2 = false;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getFont().getTransform());
        int n2 = affineTransform2.getType();
        boolean bl3 = n2 != 32 && (n2 & 0x40) == 0;
        boolean bl4 = this.stringNeedsShaping(string);
        if (!WPrinterJob.shapeTextProp && bl3 && !bl4) {
            Font font;
            double d2;
            Point2D.Float float_ = new Point2D.Float(f2, f3);
            affineTransform.transform(float_, float_);
            Font font2 = this.getFont();
            float f4 = font2.getSize2D();
            Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
            affineTransform2.deltaTransform(double_, double_);
            double d3 = Math.sqrt(double_.x * double_.x + double_.y * double_.y);
            float f5 = (float)((double)f4 * d3);
            Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
            affineTransform2.deltaTransform(double_2, double_2);
            double d4 = Math.sqrt(double_2.x * double_2.x + double_2.y * double_2.y);
            float f6 = (float)((double)f4 * d4);
            float f7 = (float)(d4 / d3);
            if (f7 > 0.999f && f7 < 1.001f) {
                f7 = 1.0f;
            }
            if ((d2 = Math.toDegrees(Math.atan2(double_2.y, double_2.x))) < 0.0) {
                d2 += 360.0;
            }
            if (d2 != 0.0) {
                d2 = 360.0 - d2;
            }
            int n3 = (int)Math.round(d2 * 10.0);
            if (font2 != null && this.lastFont != null && this.lastDeviceSizeFont != null && f5 == this.lastScaledFontSize && f7 == this.lastAverageWidthScale && font2.equals(this.lastFont) && n3 == this.lastAngle) {
                font = this.lastDeviceSizeFont;
            } else {
                font = font2.deriveFont(f5);
                this.lastAngle = n3;
                this.lastScaledFontSize = f5;
                this.lastAverageWidthScale = f7;
                this.lastDeviceSizeFont = font;
                this.lastFont = font2;
            }
            WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
            boolean bl5 = false;
            boolean bl6 = wPrinterJob.setFont(font, n3, f7);
            if (!bl6 && SunGraphicsEnvironment.isLogicalFont(font) && (bl5 = wPrinterJob.setLogicalFont(font, n3, f7))) {
                try {
                    if (((PlatformFont)font.getPeer()).makeMultiCharsetString(string, false) == null) {
                        bl5 = false;
                    }
                }
                catch (Exception exception) {
                    bl5 = false;
                }
            }
            if (bl6 || bl5) {
                try {
                    wPrinterJob.setTextColor((Color)this.getPaint());
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Expected a Color instance");
                }
                if (this.getClip() != null) {
                    this.deviceClip(this.getClip().getPathIterator(affineTransform));
                }
                wPrinterJob.textOut(string, float_.x, float_.y, bl5 ? font : null);
                bl2 = true;
            }
        }
        if (!bl2) {
            super.drawString(string, f2, f3);
        }
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectSolidBrush(color);
        wPrinterJob.fillPath();
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        BufferedImage bufferedImage = null;
        int n2 = renderedImage.getWidth();
        int n3 = renderedImage.getHeight();
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            bufferedImage = new BufferedImage(n2, n3, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(renderedImage, affineTransform);
        }
        this.drawImageToGDI(bufferedImage, affineTransform, null, null, 0, 0, n2, n3, false);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        int n4 = bufferedImage.getWidth(null);
        int n5 = bufferedImage.getHeight(null);
        if (bufferedImageOp != null) {
            bufferedImage = bufferedImageOp.filter(bufferedImage, null);
        }
        if (n4 < 0 || n5 < 0) {
            boolean bl2 = false;
        } else {
            AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, n2, n3);
            boolean bl3 = this.drawImageToGDI(bufferedImage, affineTransform, null, null, 0, 0, n4, n5, false);
        }
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, n6, n7, n8, n9, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, n4, n5, null, imageObserver);
    }

    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        return this.drawImage(image, n2, n3, null, imageObserver);
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d2, double d3, Rectangle2D rectangle2D2, AffineTransform affineTransform) throws PrinterException {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n2 = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, wPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f2 = (float)(wPrinterJob.getXRes() / d2);
        float f3 = (float)(wPrinterJob.getYRes() / d3);
        proxyGraphics2D.scale(f2 / 72.0f, f3 / 72.0f);
        proxyGraphics2D.translate(-wPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / wPrinterJob.getXRes() * 72.0, -wPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / wPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n2);
        graphics2D.dispose();
        this.clip(affineTransform.createTransformedShape(rectangle2D2));
        this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d2), (float)(rectangle2D.getY() * d3), (float)(rectangle2D.getWidth() * d2), (float)(rectangle2D.getHeight() * d3));
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        wPrinterJob.drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        int n10 = n8 - n6;
        int n11 = n9 - n7;
        float f2 = (float)(n4 - n2) / (float)n10;
        float f3 = (float)(n5 - n3) / (float)n11;
        AffineTransform affineTransform = new AffineTransform(f2, 0.0f, 0.0f, f3, (float)n2 - (float)n6 * f2, (float)n3 - (float)n7 * f3);
        return this.drawImageToGDI(image, affineTransform, null, color, n6, n7, n10, n11, false);
    }

    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        boolean bl2 = n6 < 0 || n7 < 0 ? false : this.drawImage(image, n2, n3, n2 + n4, n3 + n5, 0, 0, n6, n7, imageObserver);
        return bl2;
    }

    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        boolean bl2 = n4 < 0 || n5 < 0 ? false : this.drawImage(image, n2, n3, n4, n5, color, imageObserver);
        return bl2;
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        boolean bl2 = n2 < 0 || n3 < 0 ? false : this.drawImageToGDI(image, affineTransform, null, null, 0, 0, n2, n3, false);
        return bl2;
    }

    private boolean drawBitmaskImage(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        Image image2;
        ColorModel colorModel;
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
            colorModel = bufferedImage.getColorModel();
        } else if (image instanceof WImage) {
            image2 = (WImage)image;
            bufferedImage = image2.getBufferedImage();
            if (bufferedImage == null) {
                return true;
            }
            colorModel = image2.getColorModel();
        } else if (image instanceof VolatileImage) {
            bufferedImage = ((VolatileImage)image).getSnapshot();
            colorModel = bufferedImage.getColorModel();
        } else {
            return false;
        }
        if (!(colorModel instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        if (colorModel.getTransparency() != 2) {
            return false;
        }
        if (bufferedImageOp != null) {
            return false;
        }
        if (color != null && color.getAlpha() < 128) {
            return false;
        }
        if ((affineTransform.getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        if ((this.getTransform().getType() & 0xFFFFFFF4) != 0) {
            return false;
        }
        image2 = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n10 = indexColorModel.getTransparentPixel();
        byte[] byArray = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray);
        if (n10 >= 0) {
            byArray[n10] = 0;
        }
        int n11 = writableRaster.getWidth();
        int n12 = writableRaster.getHeight();
        if (n2 > n11 || n3 > n12) {
            return false;
        }
        if (n2 + n4 > n11) {
            n9 = n11;
            n8 = n9 - n2;
        } else {
            n9 = n2 + n4;
            n8 = n4;
        }
        if (n3 + n5 > n12) {
            n7 = n12;
            n6 = n7 - n3;
        } else {
            n7 = n3 + n5;
            n6 = n5;
        }
        int[] nArray = new int[n8];
        for (int i2 = n3; i2 < n7; ++i2) {
            int n13 = -1;
            writableRaster.getPixels(n2, i2, n8, 1, nArray);
            for (int i3 = n2; i3 < n9; ++i3) {
                if (byArray[nArray[i3 - n2]] == 0) {
                    if (n13 < 0) continue;
                    image2 = bufferedImage.getSubimage(n13, i2, i3 - n13, 1);
                    affineTransform.translate(n13, i2);
                    this.drawImageToGDI(image2, affineTransform, bufferedImageOp, color, 0, 0, i3 - n13, 1, true);
                    affineTransform.translate(-n13, -i2);
                    n13 = -1;
                    continue;
                }
                if (n13 >= 0) continue;
                n13 = i3;
            }
            if (n13 < 0) continue;
            image2 = bufferedImage.getSubimage(n13, i2, n9 - n13, 1);
            affineTransform.translate(n13, i2);
            this.drawImageToGDI(image2, affineTransform, bufferedImageOp, color, 0, 0, n9 - n13, 1, true);
            affineTransform.translate(-n13, -i2);
        }
        return true;
    }

    private boolean drawImageToGDI(Image image, AffineTransform affineTransform, BufferedImageOp bufferedImageOp, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        Object object;
        if (image instanceof WImage && ((sun.awt.image.Image)(object = (WImage)image)).getBufferedImage() == null) {
            return false;
        }
        object = (WPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d2 = float_.distance(float_3);
        double d3 = float_2.distance(float_3);
        if (d2 != 0.0 && d3 != 0.0) {
            dArray[0] = dArray[0] / d2;
            dArray[1] = dArray[1] / d3;
            dArray[2] = dArray[2] / d2;
            dArray[3] = dArray[3] / d3;
            dArray[4] = dArray[4] / d2;
            dArray[5] = dArray[5] / d3;
            for (int i2 = 0; i2 < 6; ++i2) {
                int n6 = (int)Math.floor(dArray[i2] + 0.5);
                if (!(Math.abs(dArray[i2] - (double)n6) < 1.0E-4)) continue;
                dArray[i2] = n6;
            }
            AffineTransform affineTransform3 = new AffineTransform(dArray);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n2, n3, n4, n5);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n7 = (int)rectangle2D.getWidth();
            int n8 = (int)rectangle2D.getHeight();
            if (n7 > 0 && n8 > 0) {
                boolean bl3 = true;
                if (!bl2 && this.hasTransparentPixels(image)) {
                    bl3 = false;
                    if (this.isBitmaskTransparency(image)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(image, affineTransform, bufferedImageOp, color, n2, n3, n4, n5)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl3 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl3 = true;
                    }
                } else {
                    color = null;
                }
                if ((n2 + n4 > image.getWidth(null) || n3 + n5 > image.getHeight(null)) && this.canDoRedraws()) {
                    bl3 = false;
                }
                if (!bl3) {
                    ((RasterPrinterJob)object).saveState(this.getTransform(), this.getClip(), rectangle2D, d2, d3, float_4, affineTransform);
                    return true;
                }
                BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(image, n2, n3, n2 + n4, n3 + n5, n2, n3, n2 + n4, n3 + n5, color, null);
                Shape shape2 = this.getClip();
                this.clip(affineTransform.createTransformedShape(float_4));
                this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
                Rectangle2D.Float float_5 = new Rectangle2D.Float((float)(rectangle2D.getX() * d2), (float)(rectangle2D.getY() * d3), (float)(rectangle2D.getWidth() * d2), (float)(rectangle2D.getHeight() * d3));
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
                ((WPrinterJob)object).drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_5.x, float_5.y, (float)Math.rint((double)float_5.width + 0.5), (float)Math.rint((double)float_5.height + 0.5), 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight());
                graphics2D.dispose();
                this.setClip(shape2);
            }
        }
        return true;
    }

    WPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2, boolean bl2) {
        super(graphics2D, printerJob, printable, pageFormat, n2, bl2);
    }
}

