/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import sun.awt.font.GlyphList;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.DrawGlyphList;
import sun.java2d.loops.DrawGlyphListAA;
import sun.java2d.loops.DrawLine;
import sun.java2d.loops.DrawPolygons;
import sun.java2d.loops.DrawRect;
import sun.java2d.loops.FillRect;
import sun.java2d.loops.FillSpans;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.PixelWriter;
import sun.java2d.loops.SolidPixelWriter;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.XORComposite;
import sun.java2d.loops.XorPixelWriter;
import sun.java2d.pipe.Region;

public final class GeneralRenderer {
    static final int OUTCODE_TOP = 1;
    static final int OUTCODE_BOTTOM = 2;
    static final int OUTCODE_LEFT = 4;
    static final int OUTCODE_RIGHT = 8;

    public static void register() {
        Class clazz = GeneralRenderer.class;
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[]{new GraphicsPrimitiveProxy(clazz, "SetFillRectANY", FillRect.methodSignature, FillRect.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetFillSpansANY", FillSpans.methodSignature, FillSpans.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetDrawLineANY", DrawLine.methodSignature, DrawLine.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetDrawPolygonsANY", DrawPolygons.methodSignature, DrawPolygons.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "SetDrawRectANY", DrawRect.methodSignature, DrawRect.primTypeID, SurfaceType.AnyColor, CompositeType.SrcNoEa, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorFillRectANY", FillRect.methodSignature, FillRect.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorFillSpansANY", FillSpans.methodSignature, FillSpans.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawLineANY", DrawLine.methodSignature, DrawLine.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawPolygonsANY", DrawPolygons.methodSignature, DrawPolygons.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawRectANY", DrawRect.methodSignature, DrawRect.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawGlyphListANY", DrawGlyphList.methodSignature, DrawGlyphList.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any), new GraphicsPrimitiveProxy(clazz, "XorDrawGlyphListAAANY", DrawGlyphListAA.methodSignature, DrawGlyphListAA.primTypeID, SurfaceType.AnyColor, CompositeType.Xor, SurfaceType.Any)};
        GraphicsPrimitiveMgr.register(graphicsPrimitiveArray);
    }

    static int outcode(int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n3 < n5 ? 1 : (n3 > n7 ? 2 : 0);
        if (n2 < n4) {
            n8 |= 4;
        } else if (n2 > n6) {
            n8 |= 8;
        }
        return n8;
    }

    public static boolean adjustLine(int[] nArray, int n2, int n3, int n4, int n5) {
        int n6 = n4 - 1;
        int n7 = n5 - 1;
        int n8 = nArray[0];
        int n9 = nArray[1];
        int n10 = nArray[2];
        int n11 = nArray[3];
        if (n6 < n2 || n7 < n3) {
            return false;
        }
        if (n8 == n10) {
            if (n8 < n2 || n8 > n6) {
                return false;
            }
            if (n9 > n11) {
                int n12 = n9;
                n9 = n11;
                n11 = n12;
            }
            if (n9 < n3) {
                n9 = n3;
            }
            if (n11 > n7) {
                n11 = n7;
            }
            if (n9 > n11) {
                return false;
            }
            nArray[1] = n9;
            nArray[3] = n11;
        } else if (n9 == n11) {
            if (n9 < n3 || n9 > n7) {
                return false;
            }
            if (n8 > n10) {
                int n13 = n8;
                n8 = n10;
                n10 = n13;
            }
            if (n8 < n2) {
                n8 = n2;
            }
            if (n10 > n6) {
                n10 = n6;
            }
            if (n8 > n10) {
                return false;
            }
            nArray[0] = n8;
            nArray[2] = n10;
        } else {
            int n14 = n10 - n8;
            int n15 = n11 - n9;
            int n16 = n14 < 0 ? -n14 : n14;
            int n17 = n15 < 0 ? -n15 : n15;
            boolean bl2 = n16 >= n17;
            int n18 = GeneralRenderer.outcode(n8, n9, n2, n3, n6, n7);
            int n19 = GeneralRenderer.outcode(n10, n11, n2, n3, n6, n7);
            while ((n18 | n19) != 0) {
                int n20;
                int n21;
                if ((n18 & n19) != 0) {
                    return false;
                }
                if (n18 != 0) {
                    if (0 != (n18 & 3)) {
                        n9 = 0 != (n18 & 1) ? n3 : n7;
                        n21 = n9 - nArray[1];
                        if (n21 < 0) {
                            n21 = -n21;
                        }
                        n20 = 2 * n21 * n16 + n17;
                        if (bl2) {
                            n20 += n17 - n16 - 1;
                        }
                        n20 /= 2 * n17;
                        if (n14 < 0) {
                            n20 = -n20;
                        }
                        n8 = nArray[0] + n20;
                    } else if (0 != (n18 & 0xC)) {
                        n8 = 0 != (n18 & 4) ? n2 : n6;
                        n20 = n8 - nArray[0];
                        if (n20 < 0) {
                            n20 = -n20;
                        }
                        n21 = 2 * n20 * n17 + n16;
                        if (!bl2) {
                            n21 += n16 - n17 - 1;
                        }
                        n21 /= 2 * n16;
                        if (n15 < 0) {
                            n21 = -n21;
                        }
                        n9 = nArray[1] + n21;
                    }
                    n18 = GeneralRenderer.outcode(n8, n9, n2, n3, n6, n7);
                    continue;
                }
                if (0 != (n19 & 3)) {
                    n11 = 0 != (n19 & 1) ? n3 : n7;
                    n21 = n11 - nArray[3];
                    if (n21 < 0) {
                        n21 = -n21;
                    }
                    n20 = 2 * n21 * n16 + n17;
                    n20 = bl2 ? (n20 += n17 - n16) : --n20;
                    n20 /= 2 * n17;
                    if (n14 > 0) {
                        n20 = -n20;
                    }
                    n10 = nArray[2] + n20;
                } else if (0 != (n19 & 0xC)) {
                    n10 = 0 != (n19 & 4) ? n2 : n6;
                    n20 = n10 - nArray[2];
                    if (n20 < 0) {
                        n20 = -n20;
                    }
                    n21 = 2 * n20 * n17 + n16;
                    n21 = bl2 ? --n21 : (n21 += n16 - n17);
                    n21 /= 2 * n16;
                    if (n15 > 0) {
                        n21 = -n21;
                    }
                    n11 = nArray[3] + n21;
                }
                n19 = GeneralRenderer.outcode(n10, n11, n2, n3, n6, n7);
            }
            nArray[0] = n8;
            nArray[1] = n9;
            nArray[2] = n10;
            nArray[3] = n11;
            nArray[4] = n14;
            nArray[5] = n15;
            nArray[6] = n16;
            nArray[7] = n17;
        }
        return true;
    }

    static void doSetRect(SurfaceData surfaceData, PixelWriter pixelWriter, int n2, int n3, int n4, int n5) {
        WritableRaster writableRaster = (WritableRaster)surfaceData.getRaster(n2, n3, n4 - n2, n5 - n3);
        pixelWriter.setRaster(writableRaster);
        while (n3 < n5) {
            for (int i2 = n2; i2 < n4; ++i2) {
                pixelWriter.writePixel(i2, n3);
            }
            ++n3;
        }
    }

    public static void doDrawRect(PixelWriter pixelWriter, SunGraphics2D sunGraphics2D, SurfaceData surfaceData, int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            return;
        }
        int n6 = Region.dimAdd(Region.dimAdd(n2, n4), 1);
        int n7 = Region.dimAdd(Region.dimAdd(n3, n5), 1);
        Region region = sunGraphics2D.getCompClip().getBoundsIntersectionXYXY(n2, n3, n6, n7);
        if (region.isEmpty()) {
            return;
        }
        int n8 = region.getLoX();
        int n9 = region.getLoY();
        int n10 = region.getHiX();
        int n11 = region.getHiY();
        if (n4 < 2 || n5 < 2) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n8, n9, n10, n11);
            return;
        }
        if (n9 == n3) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n8, n9, n10, n9 + 1);
        }
        if (n8 == n2) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n8, n9 + 1, n8 + 1, n11 - 1);
        }
        if (n10 == n6) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n10 - 1, n9 + 1, n10, n11 - 1);
        }
        if (n11 == n7) {
            GeneralRenderer.doSetRect(surfaceData, pixelWriter, n8, n11 - 1, n10, n11);
        }
    }

    static PixelWriter createSolidPixelWriter(SunGraphics2D sunGraphics2D, SurfaceData surfaceData) {
        ColorModel colorModel = surfaceData.getColorModel();
        Object object = colorModel.getDataElements(sunGraphics2D.rgb, null);
        return new SolidPixelWriter(object);
    }

    static PixelWriter createXorPixelWriter(SunGraphics2D sunGraphics2D, SurfaceData surfaceData) {
        ColorModel colorModel = surfaceData.getColorModel();
        Object object = colorModel.getDataElements(sunGraphics2D.rgb, null);
        XORComposite xORComposite = (XORComposite)sunGraphics2D.getComposite();
        int n2 = xORComposite.getXorColor().getRGB();
        Object object2 = colorModel.getDataElements(n2, null);
        switch (colorModel.getTransferType()) {
            case 0: {
                return new XorPixelWriter.ByteData(object, object2);
            }
            case 1: 
            case 2: {
                return new XorPixelWriter.ShortData(object, object2);
            }
            case 3: {
                return new XorPixelWriter.IntData(object, object2);
            }
            case 4: {
                return new XorPixelWriter.FloatData(object, object2);
            }
            case 5: {
                return new XorPixelWriter.DoubleData(object, object2);
            }
        }
        throw new InternalError("Unsupported XOR pixel type");
    }

    static int[] doDrawLine(SurfaceData surfaceData, PixelWriter pixelWriter, int[] nArray, Region region, int n2, int n3, int n4, int n5) {
        if (nArray == null) {
            nArray = new int[8];
        }
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = n4;
        nArray[3] = n5;
        if (!GeneralRenderer.adjustLine(nArray, region.getLoX(), region.getLoY(), region.getHiX(), region.getHiY())) {
            return nArray;
        }
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = nArray[2];
        int n9 = nArray[3];
        WritableRaster writableRaster = (WritableRaster)surfaceData.getRaster(Math.min(n6, n8), Math.min(n7, n9), Math.abs(n6 - n8) + 1, Math.abs(n7 - n9) + 1);
        pixelWriter.setRaster(writableRaster);
        if (n6 == n8) {
            if (n7 > n9) {
                do {
                    pixelWriter.writePixel(n6, n7);
                } while (--n7 >= n9);
            } else {
                do {
                    pixelWriter.writePixel(n6, n7);
                } while (++n7 <= n9);
            }
        } else if (n7 == n9) {
            if (n6 > n8) {
                do {
                    pixelWriter.writePixel(n6, n7);
                } while (--n6 >= n8);
            } else {
                do {
                    pixelWriter.writePixel(n6, n7);
                } while (++n6 <= n8);
            }
        } else {
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            boolean bl2;
            int n16 = nArray[4];
            int n17 = nArray[5];
            int n18 = nArray[6];
            int n19 = nArray[7];
            if (n18 >= n19) {
                bl2 = true;
                n15 = n19 * 2;
                n14 = n18 * 2;
                n13 = n16 < 0 ? -1 : 1;
                n12 = n17 < 0 ? -1 : 1;
                n18 = -n18;
                n11 = n8 - n6;
            } else {
                bl2 = false;
                n15 = n18 * 2;
                n14 = n19 * 2;
                n13 = n17 < 0 ? -1 : 1;
                n12 = n16 < 0 ? -1 : 1;
                n19 = -n19;
                n11 = n9 - n7;
            }
            int n20 = -(n14 / 2);
            if (n7 != n3) {
                n10 = n7 - n3;
                if (n10 < 0) {
                    n10 = -n10;
                }
                n20 += n10 * n18 * 2;
            }
            if (n6 != n2) {
                n10 = n6 - n2;
                if (n10 < 0) {
                    n10 = -n10;
                }
                n20 += n10 * n19 * 2;
            }
            if (n11 < 0) {
                n11 = -n11;
            }
            if (bl2) {
                do {
                    pixelWriter.writePixel(n6, n7);
                    n6 += n13;
                    if ((n20 += n15) < 0) continue;
                    n7 += n12;
                    n20 -= n14;
                } while (--n11 >= 0);
            } else {
                do {
                    pixelWriter.writePixel(n6, n7);
                    n7 += n13;
                    if ((n20 += n15) < 0) continue;
                    n6 += n12;
                    n20 -= n14;
                } while (--n11 >= 0);
            }
        }
        return nArray;
    }

    static void doDrawPoly(SurfaceData surfaceData, PixelWriter pixelWriter, int[] nArray, int[] nArray2, int n2, int n3, Region region, int n4, int n5, boolean bl2) {
        int n6;
        int n7;
        int[] nArray3 = null;
        int n8 = n7 = nArray[n2] + n4;
        int n9 = n6 = nArray2[n2] + n5;
        while (--n3 > 0) {
            int n10 = nArray[++n2] + n4;
            int n11 = nArray2[n2] + n5;
            nArray3 = GeneralRenderer.doDrawLine(surfaceData, pixelWriter, nArray3, region, n7, n6, n10, n11);
            n7 = n10;
            n6 = n11;
        }
        if (bl2 && (n7 != n8 || n6 != n9)) {
            nArray3 = GeneralRenderer.doDrawLine(surfaceData, pixelWriter, nArray3, region, n7, n6, n8, n9);
        }
    }

    static void doDrawGlyphList(SurfaceData surfaceData, PixelWriter pixelWriter, GlyphList glyphList, Region region) {
        int[] nArray = glyphList.getBounds();
        region.clipBoxToBounds(nArray);
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        WritableRaster writableRaster = (WritableRaster)surfaceData.getRaster(n2, n3, n4 - n2, n5 - n3);
        pixelWriter.setRaster(writableRaster);
        int n6 = glyphList.getNumGlyphs();
        for (int i2 = 0; i2 < n6; ++i2) {
            glyphList.setGlyphIndex(i2);
            int[] nArray2 = glyphList.getMetrics();
            int n7 = nArray2[0];
            int n8 = nArray2[1];
            int n9 = nArray2[2];
            int n10 = n7 + n9;
            int n11 = n8 + nArray2[3];
            int n12 = 0;
            if (n7 < n2) {
                n12 = n2 - n7;
                n7 = n2;
            }
            if (n8 < n3) {
                n12 += (n3 - n8) * n9;
                n8 = n3;
            }
            if (n10 > n4) {
                n10 = n4;
            }
            if (n11 > n5) {
                n11 = n5;
            }
            if (n10 <= n7 || n11 <= n8) continue;
            byte[] byArray = glyphList.getGrayBits();
            n9 -= n10 - n7;
            for (int i3 = n8; i3 < n11; ++i3) {
                for (int i4 = n7; i4 < n10; ++i4) {
                    if (byArray[n12++] >= 0) continue;
                    pixelWriter.writePixel(i4, i3);
                }
                n12 += n9;
            }
        }
    }
}

