/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.security.AccessController;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.LoadLibraryAction;

public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock;
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private static boolean changed;
    private static long lastRefresh;
    private static final int TIMEOUT = 120000;
    private static String os_searchlist;
    private static String os_nameservers;
    private static LinkedList searchlist;
    private static LinkedList nameservers;
    static final /* synthetic */ boolean $assertionsDisabled;

    static native int notifyAddrChange0();

    static {
        $assertionsDisabled = !ResolverConfigurationImpl.class.desiredAssertionStatus();
        lock = new Object();
        changed = false;
        lastRefresh = -1L;
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        ResolverConfigurationImpl.init0();
        AddressChangeListener addressChangeListener = new AddressChangeListener();
        addressChangeListener.setDaemon(true);
        addressChangeListener.start();
    }

    ResolverConfigurationImpl() {
    }

    static native void init0();

    private void loadConfig() {
        long l2;
        if (!$assertionsDisabled && !Thread.holdsLock(lock)) {
            throw new AssertionError();
        }
        if (changed) {
            changed = false;
        } else if (lastRefresh >= 0L && (l2 = System.currentTimeMillis()) - lastRefresh < 120000L) {
            return;
        }
        ResolverConfigurationImpl.loadDNSconfig0();
        lastRefresh = System.currentTimeMillis();
        searchlist = this.stringToList(os_searchlist);
        nameservers = this.stringToList(os_nameservers);
        os_searchlist = null;
        os_nameservers = null;
    }

    static native void loadDNSconfig0();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)nameservers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)searchlist.clone();
        }
    }

    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    private LinkedList stringToList(String string) {
        LinkedList linkedList = new LinkedList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (linkedList.contains(string2)) continue;
            linkedList.add(string2);
        }
        return linkedList;
    }

    static class AddressChangeListener
    extends Thread {
        AddressChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (ResolverConfigurationImpl.notifyAddrChange0() == 0) {
                Object object = lock;
                synchronized (object) {
                    changed = true;
                }
            }
            return;
        }
    }
}

