/*
 * Decompiled with CFR 0.152.
 */
package sun.net.smtp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.AccessController;
import sun.net.TransferProtocolClient;
import sun.net.smtp.SmtpPrintStream;
import sun.net.smtp.SmtpProtocolException;
import sun.security.action.GetPropertyAction;

public class SmtpClient
extends TransferProtocolClient {
    String mailhost;
    SmtpPrintStream message;

    public SmtpClient() throws IOException {
        this(null);
    }

    void closeMessage() throws IOException {
        if (this.message != null) {
            this.message.close();
        }
    }

    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.closeMessage();
            this.issueCommand("QUIT\r\n", 221);
            super.closeServer();
        }
    }

    public PrintStream startMessage() throws IOException {
        this.issueCommand("data\r\n", 354);
        try {
            this.message = new SmtpPrintStream((OutputStream)this.serverOutput, this);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError(encoding + " encoding not found");
        }
        return this.message;
    }

    String getEncoding() {
        return encoding;
    }

    public String getMailHost() {
        return this.mailhost;
    }

    public SmtpClient(String string) throws IOException {
        if (string != null) {
            try {
                this.openServer(string);
                this.mailhost = string;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.mailhost = (String)AccessController.doPrivileged(new GetPropertyAction("mail.host"));
            if (this.mailhost != null) {
                this.openServer(this.mailhost);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mailhost = "localhost";
            this.openServer(this.mailhost);
        }
        catch (Exception exception) {
            this.mailhost = "mailhost";
            this.openServer(this.mailhost);
        }
    }

    public void from(String string) throws IOException {
        if (string.startsWith("<")) {
            this.issueCommand("mail from: " + string + "\r\n", 250);
        } else {
            this.issueCommand("mail from: <" + string + ">\r\n", 250);
        }
    }

    private void openServer(String string) throws IOException {
        this.mailhost = string;
        this.openServer(this.mailhost, 25);
        this.issueCommand("helo " + InetAddress.getLocalHost().getHostName() + "\r\n", 250);
    }

    public void to(String string) throws IOException {
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (n5 > 0) {
                if (c2 == '(') {
                    ++n5;
                } else if (c2 == ')') {
                    --n5;
                }
                if (n5 != 0) continue;
                if (n4 > n2) {
                    bl2 = true;
                    continue;
                }
                n2 = i2 + 1;
                continue;
            }
            if (c2 == '(') {
                ++n5;
                continue;
            }
            if (c2 == '<') {
                n2 = n4 = i2 + 1;
                continue;
            }
            if (c2 == '>') {
                bl2 = true;
                continue;
            }
            if (c2 == ',') {
                if (n4 > n2) {
                    this.toCanonical(string.substring(n2, n4));
                }
                n2 = i2 + 1;
                bl2 = false;
                continue;
            }
            if (c2 > ' ' && !bl2) {
                n4 = i2 + 1;
                continue;
            }
            if (n2 != i2) continue;
            ++n2;
        }
        if (n4 > n2) {
            this.toCanonical(string.substring(n2, n4));
        }
    }

    private void toCanonical(String string) throws IOException {
        if (string.startsWith("<")) {
            this.issueCommand("rcpt to: " + string + "\r\n", 250);
        } else {
            this.issueCommand("rcpt to: <" + string + ">\r\n", 250);
        }
    }

    void issueCommand(String string, int n2) throws IOException {
        int n3;
        this.sendServer(string);
        while ((n3 = this.readServerResponse()) != n2) {
            if (n3 == 220) continue;
            throw new SmtpProtocolException(this.getResponseString());
        }
    }
}

