/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CollectionCertStoreParameters;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;

public class CollectionCertStore
extends CertStoreSpi {
    private Collection coll;

    public CollectionCertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof CollectionCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be CollectionCertStoreParameters");
        }
        this.coll = ((CollectionCertStoreParameters)certStoreParameters).getCollection();
    }

    public Collection engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            try {
                HashSet hashSet = new HashSet();
                Iterator iterator = this.coll.iterator();
                if (cRLSelector != null) {
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof CRL) || !cRLSelector.match((CRL)object)) continue;
                        hashSet.add(object);
                    }
                } else {
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof CRL)) continue;
                        hashSet.add(object);
                    }
                }
                return hashSet;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }

    public Collection engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        if (this.coll == null) {
            throw new CertStoreException("Collection is null");
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            try {
                HashSet hashSet = new HashSet();
                Iterator iterator = this.coll.iterator();
                if (certSelector != null) {
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof Certificate) || !certSelector.match((Certificate)object)) continue;
                        hashSet.add(object);
                    }
                } else {
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        if (!(object instanceof Certificate)) continue;
                        hashSet.add(object);
                    }
                }
                return hashSet;
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Too many ConcurrentModificationExceptions");
    }
}

