/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class StackLayout
extends Layout {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public Control topControl;

    protected Point computeSize(Composite composite, int n2, int n3, boolean bl2) {
        Control[] controlArray = composite.getChildren();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < controlArray.length) {
            Point point = controlArray[n6].computeSize(n2, n3, bl2);
            n4 = Math.max(point.x, n4);
            n5 = Math.max(point.y, n5);
            ++n6;
        }
        n6 = n4 + 2 * this.marginWidth;
        int n7 = n5 + 2 * this.marginHeight;
        if (n2 != -1) {
            n6 = n2;
        }
        if (n3 != -1) {
            n7 = n3;
        }
        return new Point(n6, n7);
    }

    protected boolean flushCache(Control control) {
        return true;
    }

    protected void layout(Composite composite, boolean bl2) {
        Control[] controlArray = composite.getChildren();
        Rectangle rectangle = composite.getClientArea();
        rectangle.x += this.marginWidth;
        rectangle.y += this.marginHeight;
        rectangle.width -= 2 * this.marginWidth;
        rectangle.height -= 2 * this.marginHeight;
        int n2 = 0;
        while (n2 < controlArray.length) {
            controlArray[n2].setBounds(rectangle);
            controlArray[n2].setVisible(controlArray[n2] == this.topControl);
            ++n2;
        }
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    public String toString() {
        String string = String.valueOf(this.getName()) + " {";
        if (this.marginWidth != 0) {
            string = String.valueOf(string) + "marginWidth=" + this.marginWidth + " ";
        }
        if (this.marginHeight != 0) {
            string = String.valueOf(string) + "marginHeight=" + this.marginHeight + " ";
        }
        if (this.topControl != null) {
            string = String.valueOf(string) + "topControl=" + this.topControl + " ";
        }
        string = string.trim();
        string = String.valueOf(string) + "}";
        return string;
    }
}

