/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.GdiplusStartupInput;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    public int hPalette = 0;
    int[] colorRefCount;
    int systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    TEXTMETRIC metrics;
    int[] pixels;
    int[] scripts;
    int[] gdipToken;
    boolean disposed;
    static final Object CREATE_LOCK;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        CREATE_LOCK = new Object();
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Object object = CREATE_LOCK;
        synchronized (object) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            this.create(deviceData);
            this.init();
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
            }
            this.systemFont = this.getSystemFont().handle;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkGDIP() {
        if (this.gdipToken != null) {
            return;
        }
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n2 = OS.SetErrorMode(1);
        try {
            try {
                int[] nArray = new int[1];
                GdiplusStartupInput gdiplusStartupInput = new GdiplusStartupInput();
                gdiplusStartupInput.GdiplusVersion = 1;
                if (Gdip.GdiplusStartup(nArray, gdiplusStartupInput, 0) == 0) {
                    this.gdipToken = nArray;
                }
            }
            catch (Throwable throwable) {
                SWT.error(16, throwable, " [GDI+ is required]");
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            OS.SetErrorMode(n2);
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        OS.SetErrorMode(n2);
    }

    protected void create(DeviceData deviceData) {
    }

    int computePixels(float f2) {
        int n2 = this.internal_new_GC(null);
        int n3 = -((int)(0.5f + f2 * (float)OS.GetDeviceCaps(n2, 90) / 72.0f));
        this.internal_dispose_GC(n2, null);
        return n3;
    }

    float computePoints(LOGFONT lOGFONT, int n2) {
        int n3 = this.internal_new_GC(null);
        int n4 = OS.GetDeviceCaps(n3, 90);
        int n5 = 0;
        if (lOGFONT.lfHeight > 0) {
            int n6 = OS.SelectObject(n3, n2);
            TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n3, tEXTMETRIC);
            OS.SelectObject(n3, n6);
            n5 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
        } else {
            n5 = -lOGFONT.lfHeight;
        }
        this.internal_dispose_GC(n3, null);
        return (float)n5 * 72.0f / (float)n4;
    }

    protected void destroy() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int n2 = 0;
        while (n2 < this.objects.length) {
            if (this.objects[n2] == object) {
                this.objects[n2] = null;
                this.errors[n2] = null;
                return;
            }
            ++n2;
        }
    }

    int EnumFontFamProc(int n2, int n3, int n4, int n5) {
        boolean bl2;
        boolean bl3 = (n4 & 1) == 0;
        boolean bl4 = bl2 = n5 == 1;
        if (bl3 == bl2) {
            Object object;
            if (this.nFonts == this.logFonts.length) {
                object = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, object, 0, this.nFonts);
                this.logFonts = object;
                int[] nArray = new int[((LOGFONT[])object).length];
                System.arraycopy(this.pixels, 0, nArray, 0, this.nFonts);
                this.pixels = nArray;
            }
            if ((object = this.logFonts[this.nFonts]) == null) {
                object = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            }
            OS.MoveMemory((LOGFONT)object, n2, LOGFONT.sizeof);
            this.logFonts[this.nFonts] = object;
            if (object.lfHeight > 0) {
                OS.MoveMemory(this.metrics, n3, TEXTMETRIC.sizeof);
                this.pixels[this.nFonts] = object.lfHeight - this.metrics.tmInternalLeading;
            } else {
                this.pixels[this.nFonts] = -object.lfHeight;
            }
            ++this.nFonts;
        }
        return 1;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 8);
        int n4 = OS.GetDeviceCaps(n2, 10);
        this.internal_dispose_GC(n2, null);
        return new Rectangle(0, 0, n3, n4);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        int n2 = 0;
        int n3 = 0;
        if (this.tracking) {
            n3 = this.objects.length;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (this.objects[n4] != null) {
                ++n2;
            }
            ++n4;
        }
        n4 = 0;
        deviceData.objects = new Object[n2];
        deviceData.errors = new Error[n2];
        int n5 = 0;
        while (n5 < n3) {
            if (this.objects[n5] != null) {
                deviceData.objects[n4] = this.objects[n5];
                deviceData.errors[n4] = this.errors[n5];
                ++n4;
            }
            ++n5;
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 12);
        int n4 = OS.GetDeviceCaps(n2, 14);
        this.internal_dispose_GC(n2, null);
        return n3 * n4;
    }

    public Point getDPI() {
        this.checkDevice();
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 88);
        int n4 = OS.GetDeviceCaps(n2, 90);
        this.internal_dispose_GC(n2, null);
        return new Point(n3, n4);
    }

    public FontData[] getFontList(String string, boolean bl2) {
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        int n2 = callback.getAddress();
        if (n2 == 0) {
            SWT.error(3);
        }
        this.metrics = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        this.pixels = new int[this.nFonts];
        this.logFonts = new LOGFONT[this.nFonts];
        int n3 = 0;
        while (n3 < this.logFonts.length) {
            this.logFonts[n3] = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            ++n3;
        }
        this.nFonts = 0;
        n3 = 0;
        int n4 = this.internal_new_GC(null);
        if (string == null) {
            OS.EnumFontFamilies(n4, null, n2, bl2 ? 1 : 0);
            n3 = this.nFonts;
            int n5 = 0;
            while (n5 < n3) {
                LOGFONT lOGFONT = this.logFonts[n5];
                if (OS.IsUnicode) {
                    OS.EnumFontFamiliesW(n4, ((LOGFONTW)lOGFONT).lfFaceName, n2, bl2 ? 1 : 0);
                } else {
                    OS.EnumFontFamiliesA(n4, ((LOGFONTA)lOGFONT).lfFaceName, n2, bl2 ? 1 : 0);
                }
                ++n5;
            }
        } else {
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.EnumFontFamilies(n4, tCHAR, n2, bl2 ? 1 : 0);
        }
        int n6 = OS.GetDeviceCaps(n4, 90);
        this.internal_dispose_GC(n4, null);
        int n7 = 0;
        FontData[] fontDataArray = new FontData[this.nFonts - n3];
        int n8 = n3;
        while (n8 < this.nFonts) {
            FontData fontData = FontData.win32_new(this.logFonts[n8], (float)this.pixels[n8] * 72.0f / (float)n6);
            int n9 = 0;
            while (n9 < n7) {
                if (fontData.equals(fontDataArray[n9])) break;
                ++n9;
            }
            if (n9 == n7) {
                fontDataArray[n7++] = fontData;
            }
            ++n8;
        }
        if (n7 != fontDataArray.length) {
            FontData[] fontDataArray2 = new FontData[n7];
            System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n7);
            fontDataArray = fontDataArray2;
        }
        callback.dispose();
        this.logFonts = null;
        this.pixels = null;
        this.metrics = null;
        return fontDataArray;
    }

    String getLastError() {
        int n2 = OS.GetLastError();
        if (n2 == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(n2) + "]";
    }

    String getLastErrorText() {
        int n2 = OS.GetLastError();
        if (n2 == 0) {
            return "";
        }
        int n3 = 4864;
        int[] nArray = new int[1];
        int n4 = OS.FormatMessage(n3, 0, n2, 1024, nArray, 0, 0);
        if (n4 == 0) {
            return " [GetLastError=0x" + Integer.toHexString(n2) + "]";
        }
        TCHAR tCHAR = new TCHAR(0, n4);
        OS.MoveMemory(tCHAR, nArray[0], n4 * TCHAR.sizeof);
        if (nArray[0] != 0) {
            OS.LocalFree(nArray[0]);
        }
        return tCHAR.toString(0, n4);
    }

    public Color getSystemColor(int n2) {
        this.checkDevice();
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = 0xFFFFFF;
                break;
            }
            case 2: {
                n3 = 0;
                break;
            }
            case 3: {
                n3 = 255;
                break;
            }
            case 4: {
                n3 = 128;
                break;
            }
            case 5: {
                n3 = 65280;
                break;
            }
            case 6: {
                n3 = 32768;
                break;
            }
            case 7: {
                n3 = 65535;
                break;
            }
            case 8: {
                n3 = 32896;
                break;
            }
            case 9: {
                n3 = 0xFF0000;
                break;
            }
            case 10: {
                n3 = 0x800000;
                break;
            }
            case 11: {
                n3 = 0xFF00FF;
                break;
            }
            case 12: {
                n3 = 0x800080;
                break;
            }
            case 13: {
                n3 = 0xFFFF00;
                break;
            }
            case 14: {
                n3 = 0x808000;
                break;
            }
            case 15: {
                n3 = 0xC0C0C0;
                break;
            }
            case 16: {
                n3 = 0x808080;
            }
        }
        return Color.win32_new(this, n3);
    }

    public Font getSystemFont() {
        this.checkDevice();
        int n2 = OS.GetStockObject(13);
        return Font.win32_new(this, n2);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug && !OS.IsWinCE) {
            OS.GdiSetBatchLimit(1);
        }
        if (!OS.IsWinCE) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.ScriptGetProperties(nArray, nArray2);
            this.scripts = new int[nArray2[0]];
            OS.MoveMemory(this.scripts, nArray[0], this.scripts.length * 4);
        }
        int n2 = this.internal_new_GC(null);
        int n3 = OS.GetDeviceCaps(n2, 38);
        int n4 = OS.GetDeviceCaps(n2, 12);
        int n5 = OS.GetDeviceCaps(n2, 14);
        if ((n3 & 0x100) == 0 || (n4 *= n5) != 8) {
            this.internal_dispose_GC(n2, null);
            return;
        }
        int n6 = OS.GetDeviceCaps(n2, 106);
        int n7 = OS.GetDeviceCaps(n2, 104);
        if (OS.IsWinCE && n6 == 0 && n7 >= 20) {
            n6 = 20;
        }
        this.colorRefCount = new int[n7];
        byte[] byArray = new byte[4 + 4 * n7];
        byArray[0] = 0;
        byArray[1] = 3;
        byArray[2] = 0;
        byArray[3] = 1;
        byte[] byArray2 = new byte[4 * n7];
        OS.GetSystemPaletteEntries(n2, 0, n7, byArray2);
        System.arraycopy(byArray2, 0, byArray, 4, 4 * n7);
        int n8 = 0;
        while (n8 < n6 / 2) {
            this.colorRefCount[n8] = 1;
            this.colorRefCount[n7 - 1 - n8] = 1;
            ++n8;
        }
        this.internal_dispose_GC(n2, null);
        this.hPalette = OS.CreatePalette(byArray);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        if (OS.IsWinNT && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
            TCHAR tCHAR = new TCHAR(0, string, true);
            return OS.AddFontResourceEx(tCHAR, 16, 0) != 0;
        }
        return false;
    }

    void new_Object(Object object) {
        int n2 = 0;
        while (n2 < this.objects.length) {
            if (this.objects[n2] == null) {
                this.objects[n2] = object;
                this.errors[n2] = new Error();
                return;
            }
            ++n2;
        }
        Object[] objectArray = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
        objectArray[this.objects.length] = object;
        this.objects = objectArray;
        Error[] errorArray = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
        errorArray[this.errors.length] = new Error();
        this.errors = errorArray;
    }

    protected void release() {
        if (this.gdipToken != null) {
            Gdip.GdiplusShutdown(this.gdipToken[0]);
        }
        this.gdipToken = null;
        this.scripts = null;
        if (this.hPalette != 0) {
            OS.DeleteObject(this.hPalette);
        }
        this.hPalette = 0;
        this.colorRefCount = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean bl2) {
        this.checkDevice();
    }
}

