/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;

public class Group
extends Composite {
    String text = "";
    static final int CLIENT_INSET = 3;
    static final int GroupProc;
    static final TCHAR GroupClass;

    static {
        GroupClass = new TCHAR(0, OS.IsWinCE ? "BUTTON" : "SWT_GROUP", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        if (OS.IsWinCE) {
            OS.GetClassInfo(0, GroupClass, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
        } else {
            TCHAR tCHAR = new TCHAR(0, "BUTTON", true);
            OS.GetClassInfo(0, tCHAR, wNDCLASS);
            GroupProc = wNDCLASS.lpfnWndProc;
            int n2 = OS.GetModuleHandle(null);
            if (!OS.GetClassInfo(n2, GroupClass, wNDCLASS)) {
                int n3 = OS.GetProcessHeap();
                wNDCLASS.hInstance = n2;
                wNDCLASS.style &= 0xFFFFFFFC;
                int n4 = GroupClass.length() * TCHAR.sizeof;
                int n5 = OS.HeapAlloc(n3, 8, n4);
                OS.MoveMemory(n5, GroupClass, n4);
                wNDCLASS.lpszClassName = n5;
                OS.RegisterClass(wNDCLASS);
                OS.HeapFree(n3, 0, n5);
            }
        }
    }

    public Group(Composite composite, int n2) {
        super(composite, Group.checkStyle(n2));
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        switch (n3) {
            case 513: 
            case 515: {
                return OS.DefWindowProc(n2, n3, n4, n5);
            }
        }
        return OS.CallWindowProc(GroupProc, n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        return (n2 |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        Point point = super.computeSize(n2, n3, bl2);
        int n4 = this.text.length();
        if (n4 != 0) {
            String string = this.text;
            if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
                string = " " + string + " ";
            }
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            int n5 = 0;
            int n6 = OS.GetDC(this.handle);
            int n7 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n7 != 0) {
                n5 = OS.SelectObject(n6, n7);
            }
            RECT rECT = new RECT();
            int n8 = 1056;
            OS.DrawText(n6, tCHAR, -1, rECT, n8);
            if (n7 != 0) {
                OS.SelectObject(n6, n5);
            }
            OS.ReleaseDC(this.handle, n6);
            point.x = Math.max(point.x, rECT.right - rECT.left + 18);
        }
        return point;
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n2, n3, n4, n5);
        int n6 = 0;
        int n7 = OS.GetDC(this.handle);
        int n8 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n8 != 0) {
            n6 = OS.SelectObject(n7, n8);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n7, tEXTMETRIC);
        if (n8 != 0) {
            OS.SelectObject(n7, n6);
        }
        OS.ReleaseDC(this.handle, n7);
        rectangle.x -= 3;
        rectangle.y -= tEXTMETRIC.tmHeight;
        rectangle.width += 6;
        rectangle.height += tEXTMETRIC.tmHeight + 3;
        return rectangle;
    }

    void createHandle() {
        super.createHandle();
        this.state |= 0x200;
        this.state &= 0xFFFFFFFD;
    }

    void enableWidget(boolean bl2) {
        super.enableWidget(bl2);
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            String string = bl2 || this.text.length() == 0 ? this.text : " " + this.text + " ";
            TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
            OS.SetWindowText(this.handle, tCHAR);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(n3, tEXTMETRIC);
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        int n5 = 3;
        int n6 = tEXTMETRIC.tmHeight;
        int n7 = Math.max(0, rECT.right - 6);
        int n8 = Math.max(0, rECT.bottom - n6 - 3);
        return new Rectangle(n5, n6, n7, n8);
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean mnemonicHit(char c2) {
        return this.setFocus();
    }

    boolean mnemonicMatch(char c2) {
        char c3 = this.findMnemonic(this.getText());
        if (c3 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c2) == Character.toUpperCase(c3);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
    }

    public void setFont(Font font) {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        super.setFont(font);
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.sendResize();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if (!((this.style & 0x4000000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || OS.IsWindowEnabled(this.handle) || string.length() == 0)) {
            string = " " + string + " ";
        }
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, tCHAR);
    }

    int widgetStyle() {
        return super.widgetStyle() | 7 | 0x2000000 | 0x4000000;
    }

    TCHAR windowClass() {
        return GroupClass;
    }

    int windowProc() {
        return GroupProc;
    }

    LRESULT WM_ERASEBKGND(int n2, int n3) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.drawBackground(n2);
        return LRESULT.ONE;
    }

    LRESULT WM_NCHITTEST(int n2, int n3) {
        LRESULT lRESULT = super.WM_NCHITTEST(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n4 = this.callWindowProc(this.handle, 132, n2, n3);
        if (n4 == -1) {
            n4 = 1;
        }
        return new LRESULT(n4);
    }

    LRESULT WM_MOUSEMOVE(int n2, int n3) {
        LRESULT lRESULT = super.WM_MOUSEMOVE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PRINTCLIENT(int n2, int n3) {
        LRESULT lRESULT = super.WM_PRINTCLIENT(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n4 = OS.SaveDC(n2);
            int n5 = this.callWindowProc(this.handle, 792, n2, n3);
            OS.RestoreDC(n2, n4);
            return new LRESULT(n5);
        }
        return lRESULT;
    }

    LRESULT WM_UPDATEUISTATE(int n2, int n3) {
        boolean bl2;
        LRESULT lRESULT = super.WM_UPDATEUISTATE(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl3 = bl2 = this.findImageControl() != null;
        if (!bl2) {
            if ((this.state & 0x100) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
                boolean bl4 = bl2 = this.findThemeControl() != null;
            }
            if (!bl2) {
                boolean bl5 = bl2 = this.findBackgroundControl() != null;
            }
        }
        if (bl2) {
            OS.InvalidateRect(this.handle, null, false);
            int n4 = OS.DefWindowProc(this.handle, 296, n2, n3);
            return new LRESULT(n4);
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsWinCE) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n3, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT);
        int n5 = rECT.right - rECT.left;
        int n6 = rECT.bottom - rECT.top;
        OS.GetClientRect(this.handle, rECT);
        int n7 = rECT.right - rECT.left;
        int n8 = rECT.bottom - rECT.top;
        if (n5 == n7 && n6 == n8) {
            return lRESULT;
        }
        if (n5 != n7) {
            n4 = n7;
            if (n5 < n7) {
                n4 = n5;
            }
            OS.SetRect(rECT, n4 - 3, 0, n5, n6);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        if (n6 != n8) {
            n4 = n8;
            if (n6 < n8) {
                n4 = n6;
            }
            if (n5 < n7) {
                n7 -= 3;
            }
            OS.SetRect(rECT, 0, n4 - 3, n7, n6);
            OS.InvalidateRect(this.handle, rECT, true);
        }
        return lRESULT;
    }
}

