/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int hBitmap;
    int id;
    int accelerator;
    static final int MARGIN_WIDTH = OS.IsWin95 ? 2 : 1;
    static final int MARGIN_HEIGHT = OS.IsWin95 ? 2 : 1;

    public MenuItem(Menu menu, int n2) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        menu.createItem(this, menu.getItemCount());
    }

    public MenuItem(Menu menu, int n2, int n3) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        menu.createItem(this, n3);
    }

    MenuItem(Menu menu, Menu menu2, int n2, int n3) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        this.menu = menu2;
        if (menu2 != null) {
            menu2.cascade = this;
        }
        this.display.addMenuItem(this);
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        return MenuItem.checkBits(n2, 8, 32, 16, 2, 64, 0);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    void fillAccel(ACCEL aCCEL) {
        aCCEL.fVirt = 0;
        aCCEL.key = 0;
        aCCEL.cmd = 0;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return;
        }
        boolean bl2 = true;
        int n2 = this.accelerator & 0x100FFFF;
        int n3 = Display.untranslateKey(n2);
        if (n3 != 0) {
            n2 = n3;
        } else {
            switch (n2) {
                case 27: {
                    n2 = 27;
                    break;
                }
                case 127: {
                    n2 = 46;
                    break;
                }
                default: {
                    n2 = Display.wcsToMbcs((char)n2);
                    if (n2 == 0) {
                        return;
                    }
                    if (OS.IsWinCE) {
                        n2 = OS.CharUpper((short)n2);
                        break;
                    }
                    n3 = OS.VkKeyScan((short)n2) & 0xFF;
                    if (n3 == -1) {
                        bl2 = false;
                        break;
                    }
                    n2 = n3;
                }
            }
        }
        aCCEL.key = (short)n2;
        aCCEL.cmd = (short)this.id;
        aCCEL.fVirt = (byte)(bl2 ? 1 : 0);
        if ((this.accelerator & 0x10000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 0x10);
        }
        if ((this.accelerator & 0x20000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 4);
        }
        if ((this.accelerator & 0x40000) != 0) {
            aCCEL.fVirt = (byte)(aCCEL.fVirt | 8);
        }
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        if ((this.parent.style & 2) != 0) {
            Decorations decorations = this.parent.parent;
            if (decorations.menuBar != this.parent) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n3 = decorations.handle;
            MENUBARINFO mENUBARINFO = new MENUBARINFO();
            mENUBARINFO.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(n3, -3, 1, mENUBARINFO)) {
                return new Rectangle(0, 0, 0, 0);
            }
            MENUBARINFO mENUBARINFO2 = new MENUBARINFO();
            mENUBARINFO2.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(n3, -3, n2 + 1, mENUBARINFO2)) {
                return new Rectangle(0, 0, 0, 0);
            }
            int n4 = mENUBARINFO2.left - mENUBARINFO.left;
            int n5 = mENUBARINFO2.top - mENUBARINFO.top;
            int n6 = mENUBARINFO2.right - mENUBARINFO2.left;
            int n7 = mENUBARINFO2.bottom - mENUBARINFO2.top;
            return new Rectangle(n4, n5, n6, n7);
        }
        int n8 = this.parent.handle;
        RECT rECT = new RECT();
        if (!OS.GetMenuItemRect(0, n8, 0, rECT)) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT2 = new RECT();
        if (!OS.GetMenuItemRect(0, n8, n2, rECT2)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n9 = rECT2.left - rECT.left + 2;
        int n10 = rECT2.top - rECT.top + 2;
        int n11 = rECT2.right - rECT2.left;
        int n12 = rECT2.bottom - rECT2.top;
        return new Rectangle(n9, n10, n11, n12);
    }

    public boolean getEnabled() {
        boolean bl2;
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n2 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n2, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            return (tBBUTTONINFO.fsState & 4) != 0;
        }
        int n3 = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        if (OS.IsWinCE) {
            int n4 = this.parent.indexOf(this);
            if (n4 == -1) {
                this.error(31);
            }
            bl2 = OS.GetMenuItemInfo(n3, n4, true, mENUITEMINFO);
        } else {
            bl2 = OS.GetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
        }
        if (!bl2) {
            this.error(31);
        }
        return (mENUITEMINFO.fState & 3) == 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return false;
        }
        int n2 = this.parent.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 1;
        boolean bl2 = OS.GetMenuItemInfo(n2, this.id, false, mENUITEMINFO);
        if (!bl2) {
            this.error(9);
        }
        return (mENUITEMINFO.fState & 8) != 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChildren(boolean bl2) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl2);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
    }

    void releaseMenu() {
        if (!OS.IsSP) {
            this.setMenu(null);
        }
        this.menu = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.hBitmap != 0) {
            OS.DeleteObject(this.hBitmap);
        }
        this.hBitmap = 0;
        if (this.accelerator != 0) {
            this.parent.destroyAccelerators();
        }
        this.accelerator = 0;
        this.display.removeMenuItem(this);
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        int n2 = 0;
        MenuItem[] menuItemArray = this.parent.getItems();
        while (n2 < menuItemArray.length && menuItemArray[n2] != this) {
            ++n2;
        }
        int n3 = n2 - 1;
        while (n3 >= 0 && menuItemArray[n3].setRadioSelection(false)) {
            --n3;
        }
        int n4 = n2 + 1;
        while (n4 < menuItemArray.length && menuItemArray[n4].setRadioSelection(false)) {
            ++n4;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n2) {
        this.checkWidget();
        if (this.accelerator == n2) {
            return;
        }
        this.accelerator = n2;
        this.parent.destroyAccelerators();
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n2 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 4;
            OS.SendMessage(n2, OS.TB_GETBUTTONINFO, this.id, tBBUTTONINFO);
            tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState & 0xFFFFFFFB);
            if (bl2) {
                tBBUTTONINFO.fsState = (byte)(tBBUTTONINFO.fsState | 4);
            }
            OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
        } else {
            int n3 = this.parent.handle;
            if (OS.IsWinCE) {
                int n4 = this.parent.indexOf(this);
                if (n4 == -1) {
                    return;
                }
                int n5 = 0x400 | (bl2 ? 0 : 1);
                OS.EnableMenuItem(n3, n4, n5);
            } else {
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 1;
                boolean bl3 = OS.GetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
                if (!bl3) {
                    this.error(30);
                }
                int n6 = 3;
                if (bl2) {
                    if ((mENUITEMINFO.fState & n6) == 0) {
                        return;
                    }
                    mENUITEMINFO.fState &= ~n6;
                } else {
                    if ((mENUITEMINFO.fState & n6) == n6) {
                        return;
                    }
                    mENUITEMINFO.fState |= n6;
                }
                bl3 = OS.SetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
                if (!bl3) {
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        boolean bl4 = bl3 = this.id == OS.GetMenuDefaultItem(n3, 0, 1);
                    }
                    if (!bl3) {
                        this.error(30);
                    }
                }
            }
        }
        this.parent.destroyAccelerators();
        this.parent.redraw();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (OS.IsWinCE) {
            if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
                int n2 = this.parent.hwndCB;
                TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                tBBUTTONINFO.dwMask = 1;
                tBBUTTONINFO.iImage = this.parent.imageIndex(image);
                OS.SendMessage(n2, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO);
            }
            return;
        }
        if (OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return;
        }
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 128;
        if (this.parent.foreground != -1) {
            mENUITEMINFO.hbmpItem = -1;
        } else if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            if (this.hBitmap != 0) {
                OS.DeleteObject(this.hBitmap);
            }
            this.hBitmap = image != null ? Display.create32bitDIB(image) : 0;
            mENUITEMINFO.hbmpItem = this.hBitmap;
        } else {
            mENUITEMINFO.hbmpItem = -1;
        }
        int n3 = this.parent.handle;
        OS.SetMenuItemInfo(n3, this.id, false, mENUITEMINFO);
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        Menu menu2;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if ((menu2 = this.menu) == menu) {
            return;
        }
        if (menu2 != null) {
            menu2.cascade = null;
        }
        this.menu = menu;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            if (OS.IsPPC) {
                int n2 = this.parent.hwndCB;
                int n3 = menu == null ? 0 : menu.handle;
                OS.SendMessage(n2, 1424, this.id, n3);
            }
            if (OS.IsSP) {
                this.error(29);
            }
        } else {
            int n4 = this.parent.handle;
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 32;
            int n5 = 0;
            while (OS.GetMenuItemInfo(n4, n5, true, mENUITEMINFO)) {
                if (mENUITEMINFO.dwItemData == this.id) break;
                ++n5;
            }
            if (mENUITEMINFO.dwItemData != this.id) {
                return;
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                mENUITEMINFO.fMask = 128;
                OS.GetMenuItemInfo(n4, n5, true, mENUITEMINFO);
                boolean bl4 = bl2 = mENUITEMINFO.hbmpItem != 0 || this.parent.foreground != -1;
                if (bl2) {
                    mENUITEMINFO.hbmpItem = 0;
                    bl3 = OS.SetMenuItemInfo(n4, this.id, false, mENUITEMINFO);
                }
            }
            int n6 = 128;
            int n7 = OS.GetProcessHeap();
            int n8 = n6 * TCHAR.sizeof;
            int n9 = OS.HeapAlloc(n7, 8, n8);
            mENUITEMINFO.fMask = 51;
            mENUITEMINFO.dwTypeData = n9;
            mENUITEMINFO.cch = n6;
            bl3 = OS.GetMenuItemInfo(n4, n5, true, mENUITEMINFO);
            if (menu != null) {
                menu.cascade = this;
                mENUITEMINFO.fMask |= 4;
                mENUITEMINFO.hSubMenu = menu.handle;
            }
            OS.RemoveMenu(n4, n5, 1024);
            if (OS.IsWinCE) {
                TCHAR tCHAR;
                int n10 = this.id;
                int n11 = 1024;
                if (menu != null) {
                    n11 |= 0x10;
                    n10 = menu.handle;
                }
                if (bl3 = OS.InsertMenu(n4, n5, n11, n10, tCHAR = new TCHAR(0, " ", true))) {
                    mENUITEMINFO.fMask = 48;
                    bl3 = OS.SetMenuItemInfo(n4, n5, true, mENUITEMINFO);
                    if ((mENUITEMINFO.fState & 3) != 0) {
                        OS.EnableMenuItem(n4, n5, 1025);
                    }
                    if ((mENUITEMINFO.fState & 8) != 0) {
                        OS.CheckMenuItem(n4, n5, 1032);
                    }
                }
            } else {
                bl3 = OS.InsertMenuItem(n4, n5, true, mENUITEMINFO);
                if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && bl2) {
                    mENUITEMINFO.fMask = 128;
                    mENUITEMINFO.hbmpItem = this.parent.foreground != -1 ? -1 : (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) ? this.hBitmap : -1);
                    bl3 = OS.SetMenuItemInfo(n4, this.id, false, mENUITEMINFO);
                }
            }
            if (n9 != 0) {
                OS.HeapFree(n7, 0, n9);
            }
            if (!bl3) {
                this.error(29);
            }
        }
        this.parent.destroyAccelerators();
    }

    boolean setRadioSelection(boolean bl2) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl2) {
            this.setSelection(bl2);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl2) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            return;
        }
        int n2 = this.parent.handle;
        if (OS.IsWinCE) {
            int n3 = this.parent.indexOf(this);
            if (n3 == -1) {
                return;
            }
            int n4 = 0x400 | (bl2 ? 8 : 0);
            OS.CheckMenuItem(n2, n3, n4);
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 1;
            boolean bl3 = OS.GetMenuItemInfo(n2, this.id, false, mENUITEMINFO);
            if (!bl3) {
                this.error(28);
            }
            mENUITEMINFO.fState &= 0xFFFFFFF7;
            if (bl2) {
                mENUITEMINFO.fState |= 8;
            }
            if (!(bl3 = OS.SetMenuItemInfo(n2, this.id, false, mENUITEMINFO))) {
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    boolean bl4 = bl3 = this.id == OS.GetMenuDefaultItem(n2, 0, 1);
                }
                if (!bl3) {
                    this.error(28);
                }
            }
        }
        this.parent.redraw();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        int n2 = OS.GetProcessHeap();
        int n3 = 0;
        boolean bl2 = false;
        if ((OS.IsPPC || OS.IsSP) && this.parent.hwndCB != 0) {
            int n4;
            if (string.indexOf(38) != -1) {
                int n5 = string.length();
                char[] cArray = new char[n5];
                string.getChars(0, n5, cArray, 0);
                n4 = 0;
                int n6 = 0;
                n4 = 0;
                while (n4 < n5) {
                    if (cArray[n4] != '&') {
                        cArray[n6++] = cArray[n4];
                    }
                    ++n4;
                }
                if (n6 < n4) {
                    string = new String(cArray, 0, n6);
                }
            }
            TCHAR tCHAR = new TCHAR(0, string, true);
            int n7 = tCHAR.length() * TCHAR.sizeof;
            n3 = OS.HeapAlloc(n2, 8, n7);
            OS.MoveMemory(n3, tCHAR, n7);
            n4 = this.parent.hwndCB;
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 2;
            tBBUTTONINFO.pszText = n3;
            bl2 = OS.SendMessage(n4, OS.TB_SETBUTTONINFO, this.id, tBBUTTONINFO) != 0;
        } else {
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            int n8 = this.parent.handle;
            boolean bl3 = false;
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10)) {
                mENUITEMINFO.fMask = 128;
                OS.GetMenuItemInfo(n8, this.id, false, mENUITEMINFO);
                bl3 = mENUITEMINFO.hbmpItem != 0 || this.parent.foreground != -1;
            }
            TCHAR tCHAR = new TCHAR(0, string, true);
            int n9 = tCHAR.length() * TCHAR.sizeof;
            n3 = OS.HeapAlloc(n2, 8, n9);
            OS.MoveMemory(n3, tCHAR, n9);
            mENUITEMINFO.fMask = 16;
            mENUITEMINFO.fType = this.widgetStyle();
            mENUITEMINFO.dwTypeData = n3;
            bl2 = OS.SetMenuItemInfo(n8, this.id, false, mENUITEMINFO);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && bl3) {
                mENUITEMINFO.fMask = 128;
                mENUITEMINFO.hbmpItem = this.parent.foreground != -1 ? -1 : (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) ? this.hBitmap : -1);
                bl2 = OS.SetMenuItemInfo(n8, this.id, false, mENUITEMINFO);
            }
        }
        if (n3 != 0) {
            OS.HeapFree(n2, 0, n3);
        }
        if (!bl2) {
            this.error(13);
        }
        this.parent.redraw();
    }

    int widgetStyle() {
        int n2 = 0;
        Decorations decorations = this.parent.parent;
        if ((decorations.style & 0x8000000) != 0) {
            if ((this.parent.style & 0x2000000) != 0) {
                n2 |= 0x6000;
            }
        } else if ((this.parent.style & 0x4000000) != 0) {
            n2 |= 0x6000;
        }
        if ((this.style & 2) != 0) {
            return n2 | 0x800;
        }
        if ((this.style & 0x10) != 0) {
            return n2 | 0x200;
        }
        return n2;
    }

    LRESULT wmCommandChild(int n2, int n3) {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        Event event = new Event();
        this.setInputState(event, 13);
        this.postEvent(13, event);
        return null;
    }

    LRESULT wmDrawChild(int n2, int n3) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n3, DRAWITEMSTRUCT.sizeof);
        if (this.image != null) {
            GCData gCData = new GCData();
            gCData.device = this.display;
            GC gC = GC.win32_new(dRAWITEMSTRUCT.hDC, gCData);
            int n4 = (this.parent.style & 2) != 0 ? MARGIN_WIDTH * 2 : dRAWITEMSTRUCT.left;
            Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
            gC.drawImage(image, n4, dRAWITEMSTRUCT.top + MARGIN_HEIGHT);
            if (this.image != image) {
                image.dispose();
            }
            gC.dispose();
        }
        if (this.parent.foreground != -1) {
            OS.SetTextColor(dRAWITEMSTRUCT.hDC, this.parent.foreground);
        }
        return null;
    }

    LRESULT wmMeasureChild(int n2, int n3) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n3, MEASUREITEMSTRUCT.sizeof);
        int n4 = 0;
        int n5 = 0;
        if (this.image != null) {
            Rectangle rectangle = this.image.getBounds();
            n4 = rectangle.width;
            n5 = rectangle.height;
        } else {
            MENUINFO mENUINFO = new MENUINFO();
            mENUINFO.cbSize = MENUINFO.sizeof;
            mENUINFO.fMask = 16;
            int n6 = this.parent.handle;
            OS.GetMenuInfo(n6, mENUINFO);
            if ((mENUINFO.dwStyle & 0x4000000) == 0) {
                MenuItem[] menuItemArray = this.parent.getItems();
                int n7 = 0;
                while (n7 < menuItemArray.length) {
                    MenuItem menuItem = menuItemArray[n7];
                    if (menuItem.image != null) {
                        Rectangle rectangle = menuItem.image.getBounds();
                        n4 = Math.max(n4, rectangle.width);
                    }
                    ++n7;
                }
            }
        }
        if (n4 != 0 || n5 != 0) {
            mEASUREITEMSTRUCT.itemWidth = n4 + MARGIN_WIDTH * 2;
            mEASUREITEMSTRUCT.itemHeight = n5 + MARGIN_HEIGHT * 2;
            OS.MoveMemory(n3, mEASUREITEMSTRUCT, MEASUREITEMSTRUCT.sizeof);
        }
        return null;
    }
}

