/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int resizeCursor;
    int clientCursor;
    int cursorOrientation = 0;
    boolean inEvent = false;
    int hwndTransparent;
    int oldProc;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n2) {
        super(composite, Tracker.checkStyle(n2));
        this.parent = composite;
    }

    public Tracker(Display display, int n2) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n2);
        this.display = display;
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n2 = this.bounds.x + this.bounds.width / 2;
        int n3 = this.bounds.y;
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        return new Point(pOINT.x, pOINT.y);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n2 = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n3 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        if (this.clientCursor == 0) {
            int n4 = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    n4 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 1024: {
                    n4 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 16384: {
                    n4 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 131072: {
                    n4 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 16512: {
                    n4 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 132096: {
                    n4 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 17408: {
                    n4 = OS.LoadCursor(0, 32643);
                    break;
                }
                case 131200: {
                    n4 = OS.LoadCursor(0, 32643);
                    break;
                }
                default: {
                    n4 = OS.LoadCursor(0, 32646);
                }
            }
            OS.SetCursor(n4);
            if (this.resizeCursor != 0) {
                OS.DestroyCursor(this.resizeCursor);
            }
            this.resizeCursor = n4;
        }
        return new Point(pOINT.x, pOINT.y);
    }

    static int checkStyle(int n2) {
        if ((n2 & 0x24480) == 0) {
            n2 |= 0x24480;
        }
        return n2;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n2 = this.rectangles[0].x;
        int n3 = this.rectangles[0].y;
        int n4 = this.rectangles[0].x + this.rectangles[0].width;
        int n5 = this.rectangles[0].y + this.rectangles[0].height;
        int n6 = 1;
        while (n6 < this.rectangles.length) {
            int n7;
            int n8;
            if (this.rectangles[n6].x < n2) {
                n2 = this.rectangles[n6].x;
            }
            if (this.rectangles[n6].y < n3) {
                n3 = this.rectangles[n6].y;
            }
            if ((n8 = this.rectangles[n6].x + this.rectangles[n6].width) > n4) {
                n4 = n8;
            }
            if ((n7 = this.rectangles[n6].y + this.rectangles[n6].height) > n5) {
                n5 = n7;
            }
            ++n6;
        }
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int n2 = 0;
            while (n2 < rectangleArray.length) {
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                if (this.bounds.width != 0) {
                    n3 = (rectangleArray[n2].x - this.bounds.x) * 100 / this.bounds.width;
                    n5 = rectangleArray[n2].width * 100 / this.bounds.width;
                } else {
                    n5 = 100;
                }
                if (this.bounds.height != 0) {
                    n4 = (rectangleArray[n2].y - this.bounds.y) * 100 / this.bounds.height;
                    n6 = rectangleArray[n2].height * 100 / this.bounds.height;
                } else {
                    n6 = 100;
                }
                rectangleArray2[n2] = new Rectangle(n3, n4, n5, n6);
                ++n2;
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray, boolean bl2) {
        if (this.parent == null && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            RECT rECT = new RECT();
            int n2 = bl2 ? 3 : 1;
            int n3 = 0;
            while (n3 < rectangleArray.length) {
                Rectangle rectangle = rectangleArray[n3];
                rECT.left = rectangle.x - n2;
                rECT.top = rectangle.y - n2;
                rECT.right = rectangle.x + rectangle.width + n2 * 2;
                rECT.bottom = rectangle.y + rectangle.height + n2 * 2;
                OS.RedrawWindow(this.hwndTransparent, rECT, 0, 1);
                ++n3;
            }
            return;
        }
        int n4 = 1;
        int n5 = OS.GetDesktopWindow();
        if (this.parent != null) {
            n5 = this.parent.handle;
        }
        int n6 = OS.GetDCEx(n5, 0, 2);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (bl2) {
            n4 = 3;
            byte[] byArray = new byte[16];
            byArray[0] = -86;
            byArray[2] = 85;
            byArray[4] = -86;
            byArray[6] = 85;
            byArray[8] = -86;
            byArray[10] = 85;
            byArray[12] = -86;
            byArray[14] = 85;
            byte[] byArray2 = byArray;
            n7 = OS.CreateBitmap(8, 8, 1, 1, byArray2);
            n8 = OS.CreatePatternBrush(n7);
            n9 = OS.SelectObject(n6, n8);
        }
        int n10 = 0;
        while (n10 < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n10];
            OS.PatBlt(n6, rectangle.x, rectangle.y, rectangle.width, n4, 5898313);
            OS.PatBlt(n6, rectangle.x, rectangle.y + n4, n4, rectangle.height - n4 * 2, 5898313);
            OS.PatBlt(n6, rectangle.x + rectangle.width - n4, rectangle.y + n4, n4, rectangle.height - n4 * 2, 5898313);
            OS.PatBlt(n6, rectangle.x, rectangle.y + rectangle.height - n4, rectangle.width, n4, 5898313);
            ++n10;
        }
        if (bl2) {
            OS.SelectObject(n6, n9);
            OS.DeleteObject(n8);
            OS.DeleteObject(n7);
        }
        OS.ReleaseDC(n5, n6);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n2 = 0;
        while (n2 < this.rectangles.length) {
            Rectangle rectangle = this.rectangles[n2];
            rectangleArray[n2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n2;
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int n2, int n3) {
        if (this.bounds == null) {
            return;
        }
        if (n2 < 0 && (this.style & 0x4000) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x20000) == 0) {
            n2 = 0;
        }
        if (n3 < 0 && (this.style & 0x80) == 0) {
            n3 = 0;
        }
        if (n3 > 0 && (this.style & 0x400) == 0) {
            n3 = 0;
        }
        if (n2 == 0 && n3 == 0) {
            return;
        }
        this.bounds.x += n2;
        this.bounds.y += n3;
        int n4 = 0;
        while (n4 < this.rectangles.length) {
            this.rectangles[n4].x += n2;
            this.rectangles[n4].y += n3;
            ++n4;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open() {
        Callback callback;
        block29: {
            boolean bl2;
            int n2;
            this.checkWidget();
            this.cancelled = false;
            this.tracking = true;
            int n3 = this.style & 0x480;
            if (n3 == 128 || n3 == 1024) {
                this.cursorOrientation |= n3;
            }
            if ((n2 = this.style & 0x24000) == 16384 || n2 == 131072) {
                this.cursorOrientation |= n2;
            }
            callback = null;
            boolean bl3 = OS.GetKeyState(1) < 0;
            boolean bl4 = bl2 = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0);
            if (this.parent == null && bl2 || !bl3) {
                int n4 = OS.GetSystemMetrics(0);
                int n5 = OS.GetSystemMetrics(1);
                this.hwndTransparent = OS.CreateWindowEx(bl2 ? 0x8080000 : 32, this.display.windowClass, null, Integer.MIN_VALUE, 0, 0, n4, n5, 0, 0, OS.GetModuleHandle(null), null);
                this.oldProc = OS.GetWindowLong(this.hwndTransparent, -4);
                callback = new Callback(this, "transparentProc", 4);
                int n6 = callback.getAddress();
                if (n6 == 0) {
                    SWT.error(3);
                }
                OS.SetWindowLong(this.hwndTransparent, -4, n6);
                if (bl2) {
                    OS.SetLayeredWindowAttributes(this.hwndTransparent, 0xFFFFFF, (byte)-1, 3);
                }
                OS.ShowWindow(this.hwndTransparent, 4);
            }
            this.update();
            this.drawRectangles(this.rectangles, this.stippled);
            Point point = null;
            if (bl3) {
                POINT pOINT = new POINT();
                OS.GetCursorPos(pOINT);
                point = new Point(pOINT.x, pOINT.y);
            } else {
                point = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            }
            if (point != null) {
                this.oldX = point.x;
                this.oldY = point.y;
            }
            try {
                MSG mSG = new MSG();
                while (!(!this.tracking || this.cancelled || this.parent != null && this.parent.isDisposed())) {
                    OS.GetMessage(mSG, 0, 0, 0);
                    OS.TranslateMessage(mSG);
                    switch (mSG.message) {
                        case 512: 
                        case 514: {
                            this.wmMouse(mSG.message, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 646: {
                            this.wmIMEChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 258: {
                            this.wmChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 256: {
                            this.wmKeyDown(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 257: {
                            this.wmKeyUp(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 262: {
                            this.wmSysChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 260: {
                            this.wmSysKeyDown(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 261: {
                            this.wmSysKeyUp(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                    }
                    if (256 <= mSG.message && mSG.message <= 264 || 512 <= mSG.message && mSG.message <= 525) continue;
                    if (!(this.parent == null && bl2 || mSG.message != 15)) {
                        this.update();
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    OS.DispatchMessage(mSG);
                    if (this.parent == null && bl2 || mSG.message != 15) continue;
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                if (bl3) {
                    OS.ReleaseCapture();
                }
                if (!this.isDisposed()) {
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                if (this.hwndTransparent != 0) {
                    OS.DestroyWindow(this.hwndTransparent);
                    this.hwndTransparent = 0;
                }
                if (callback != null) {
                    callback.dispose();
                    this.oldProc = 0;
                }
                if (this.resizeCursor == 0) throw throwable;
                OS.DestroyCursor(this.resizeCursor);
                this.resizeCursor = 0;
                throw throwable;
            }
            {
                Object var8_13 = null;
                if (this.hwndTransparent == 0) break block29;
            }
            OS.DestroyWindow(this.hwndTransparent);
            this.hwndTransparent = 0;
        }
        if (callback != null) {
            callback.dispose();
            this.oldProc = 0;
        }
        if (this.resizeCursor != 0) {
            OS.DestroyCursor(this.resizeCursor);
            this.resizeCursor = 0;
        }
        this.tracking = false;
        if (!this.cancelled) return true;
        return false;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    void resizeRectangles(int n2, int n3) {
        Rectangle rectangle;
        int n4;
        if (this.bounds == null) {
            return;
        }
        if (n2 < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (n2 > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (n3 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (n3 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n2 > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n2 -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    n4 = 0;
                    while (n4 < this.proportions.length) {
                        rectangle = this.proportions[n4];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                        ++n4;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n2) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n2 += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                n4 = 0;
                while (n4 < this.proportions.length) {
                    rectangle = this.proportions[n4];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                    ++n4;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n3 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n3 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    n4 = 0;
                    while (n4 < this.proportions.length) {
                        rectangle = this.proportions[n4];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                        ++n4;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n3) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n3 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                n4 = 0;
                while (n4 < this.proportions.length) {
                    rectangle = this.proportions[n4];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                    ++n4;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n2;
            this.bounds.width -= n2;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n2;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n3;
            this.bounds.height -= n3;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n3;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n5 = 0;
        while (n5 < this.rectangles.length) {
            Rectangle rectangle2 = this.proportions[n5];
            rectangleArray[n5] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
            ++n5;
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.clientCursor = 0;
        if (cursor != null) {
            this.clientCursor = cursor.handle;
            if (this.inEvent) {
                OS.SetCursor(this.clientCursor);
            }
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        this.rectangles = new Rectangle[rectangleArray.length];
        int n2 = 0;
        while (n2 < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n2];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[n2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n2;
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl2) {
        this.checkWidget();
        this.stippled = bl2;
    }

    int transparentProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 132: {
                if (!this.inEvent) break;
                return -1;
            }
            case 32: {
                if (this.clientCursor != 0) {
                    OS.SetCursor(this.clientCursor);
                    return 1;
                }
                if (this.resizeCursor == 0) break;
                OS.SetCursor(this.resizeCursor);
                return 1;
            }
            case 15: {
                Object[] objectArray;
                if (this.parent != null || OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(6, 0)) break;
                PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
                int n6 = OS.BeginPaint(n2, pAINTSTRUCT);
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                int n10 = OS.CreateSolidBrush(0xFFFFFF);
                n9 = OS.SelectObject(n6, n10);
                OS.PatBlt(n6, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right - pAINTSTRUCT.left, pAINTSTRUCT.bottom - pAINTSTRUCT.top, 15728673);
                OS.SelectObject(n6, n9);
                OS.DeleteObject(n10);
                int n11 = 1;
                if (this.stippled) {
                    n11 = 3;
                    byte[] byArray = new byte[16];
                    byArray[0] = -86;
                    byArray[2] = 85;
                    byArray[4] = -86;
                    byArray[6] = 85;
                    byArray[8] = -86;
                    byArray[10] = 85;
                    byArray[12] = -86;
                    byArray[14] = 85;
                    objectArray = byArray;
                    n7 = OS.CreateBitmap(8, 8, 1, 1, (byte[])objectArray);
                    n8 = OS.CreatePatternBrush(n7);
                    n9 = OS.SelectObject(n6, n8);
                    OS.SetBkColor(n6, 0xF0F0F0);
                } else {
                    n9 = OS.SelectObject(n6, OS.GetStockObject(4));
                }
                objectArray = this.rectangles;
                int n12 = 0;
                while (n12 < objectArray.length) {
                    Rectangle rectangle = objectArray[n12];
                    OS.PatBlt(n6, rectangle.x, rectangle.y, rectangle.width, n11, 15728673);
                    OS.PatBlt(n6, rectangle.x, rectangle.y + n11, n11, rectangle.height - n11 * 2, 15728673);
                    OS.PatBlt(n6, rectangle.x + rectangle.width - n11, rectangle.y + n11, n11, rectangle.height - n11 * 2, 15728673);
                    OS.PatBlt(n6, rectangle.x, rectangle.y + rectangle.height - n11, rectangle.width, n11, 15728673);
                    ++n12;
                }
                OS.SelectObject(n6, n9);
                if (this.stippled) {
                    OS.DeleteObject(n8);
                    OS.DeleteObject(n7);
                }
                OS.EndPaint(n2, pAINTSTRUCT);
                return 0;
            }
        }
        return OS.CallWindowProc(this.oldProc, n2, n3, n4, n5);
    }

    void update() {
        if (this.parent == null && !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            return;
        }
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            Shell shell = this.parent.getShell();
            shell.update(true);
        } else {
            this.display.update();
        }
    }

    LRESULT wmKeyDown(int n2, int n3, int n4) {
        LRESULT lRESULT = super.wmKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl2 = this.parent != null && (this.parent.style & 0x8000000) != 0;
        int n5 = OS.GetKeyState(17) < 0 ? 1 : 9;
        int n6 = 0;
        int n7 = 0;
        switch (n3) {
            case 27: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 13: {
                this.tracking = false;
                break;
            }
            case 37: {
                n6 = bl2 ? n5 : -n5;
                break;
            }
            case 39: {
                n6 = bl2 ? -n5 : n5;
                break;
            }
            case 38: {
                n7 = -n5;
                break;
            }
            case 40: {
                n7 = n5;
            }
        }
        if (n6 != 0 || n7 != 0) {
            SerializableCompatibility serializableCompatibility;
            Rectangle[] rectangleArray = this.rectangles;
            boolean bl3 = this.stippled;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            int n8 = 0;
            while (n8 < this.rectangles.length) {
                serializableCompatibility = this.rectangles[n8];
                rectangleArray2[n8] = new Rectangle(serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height);
                ++n8;
            }
            Event event = new Event();
            event.x = this.oldX + n6;
            event.y = this.oldY + n7;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(n6, n7);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl4 = false;
                if (this.rectangles != rectangleArray) {
                    int n9 = this.rectangles.length;
                    if (n9 != rectangleArray2.length) {
                        bl4 = true;
                    } else {
                        int n10 = 0;
                        while (n10 < n9) {
                            if (!this.rectangles[n10].equals(rectangleArray2[n10])) {
                                bl4 = true;
                                break;
                            }
                            ++n10;
                        }
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                serializableCompatibility = this.adjustResizeCursor();
            } else {
                this.moveRectangles(n6, n7);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl5 = false;
                if (this.rectangles != rectangleArray) {
                    int n11 = this.rectangles.length;
                    if (n11 != rectangleArray2.length) {
                        bl5 = true;
                    } else {
                        int n12 = 0;
                        while (n12 < n11) {
                            if (!this.rectangles[n12].equals(rectangleArray2[n12])) {
                                bl5 = true;
                                break;
                            }
                            ++n12;
                        }
                    }
                } else {
                    bl5 = true;
                }
                if (bl5) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                serializableCompatibility = this.adjustMoveCursor();
            }
            if (serializableCompatibility != null) {
                this.oldX = ((Point)serializableCompatibility).x;
                this.oldY = ((Point)serializableCompatibility).y;
            }
        }
        return lRESULT;
    }

    LRESULT wmSysKeyDown(int n2, int n3, int n4) {
        LRESULT lRESULT = super.wmSysKeyDown(n2, n3, n4);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.cancelled = true;
        this.tracking = false;
        return lRESULT;
    }

    LRESULT wmMouse(int n2, int n3, int n4) {
        boolean bl2 = this.parent != null && (this.parent.style & 0x8000000) != 0;
        int n5 = OS.GetMessagePos();
        int n6 = n5 & 0xFFFF;
        int n7 = n5 >> 16;
        if (n6 != this.oldX || n7 != this.oldY) {
            Rectangle[] rectangleArray = this.rectangles;
            boolean bl3 = this.stippled;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            int n8 = 0;
            while (n8 < this.rectangles.length) {
                Rectangle rectangle = this.rectangles[n8];
                rectangleArray2[n8] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n8;
            }
            Event event = new Event();
            event.x = n6;
            event.y = n7;
            if ((this.style & 0x10) != 0) {
                Point point;
                if (bl2) {
                    this.resizeRectangles(this.oldX - n6, n7 - this.oldY);
                } else {
                    this.resizeRectangles(n6 - this.oldX, n7 - this.oldY);
                }
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl4 = false;
                if (this.rectangles != rectangleArray) {
                    int n9 = this.rectangles.length;
                    if (n9 != rectangleArray2.length) {
                        bl4 = true;
                    } else {
                        int n10 = 0;
                        while (n10 < n9) {
                            if (!this.rectangles[n10].equals(rectangleArray2[n10])) {
                                bl4 = true;
                                break;
                            }
                            ++n10;
                        }
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    n6 = point.x;
                    n7 = point.y;
                }
            } else {
                if (bl2) {
                    this.moveRectangles(this.oldX - n6, n7 - this.oldY);
                } else {
                    this.moveRectangles(n6 - this.oldX, n7 - this.oldY);
                }
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl5 = false;
                if (this.rectangles != rectangleArray) {
                    int n11 = this.rectangles.length;
                    if (n11 != rectangleArray2.length) {
                        bl5 = true;
                    } else {
                        int n12 = 0;
                        while (n12 < n11) {
                            if (!this.rectangles[n12].equals(rectangleArray2[n12])) {
                                bl5 = true;
                                break;
                            }
                            ++n12;
                        }
                    }
                } else {
                    bl5 = true;
                }
                if (bl5) {
                    this.drawRectangles(rectangleArray2, bl3);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
            }
            this.oldX = n6;
            this.oldY = n7;
        }
        this.tracking = n2 != 514;
        return null;
    }
}

