/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.VersionString;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JREMatcher;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.ResourceVisitor;
import com.sun.javaws.jnl.ResourcesDesc;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

public class LaunchSelection {
    private static final String anyJREVersion = "0+";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static JREInfo selectJRE(LaunchDesc launchDesc, JREMatcher jREMatcher, boolean bl) {
        JREMatcher jREMatcher2 = jREMatcher;
        synchronized (jREMatcher2) {
            if (!jREMatcher.hasBeenRun() || bl) {
                jREMatcher.beginTraversal(launchDesc);
                ResourcesDesc resourcesDesc = launchDesc.getResources();
                if (resourcesDesc != null) {
                    LaunchSelection.selectJREDescHelper(launchDesc, jREMatcher);
                    JREDesc jREDesc = jREMatcher.getRunningJREDesc();
                    if (jREDesc != null) {
                        resourcesDesc.addNested(jREDesc.getNestedResources());
                    }
                    LaunchSelection.selectJREExtensionHelper(launchDesc, jREMatcher);
                }
                jREMatcher.endTraversal(launchDesc);
            }
            return jREMatcher.getSelectedJREInfo();
        }
    }

    private static void selectJREDescHelper(final LaunchDesc launchDesc, JREMatcher jREMatcher) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitJREDesc(JREDesc jREDesc) {
                if (launchDesc.isLibrary()) {
                    Trace.println((String)("JNLP JREDesc in Component ignored: " + launchDesc.getLocation()), (TraceLevel)TraceLevel.BASIC);
                } else {
                    arrayList.add(jREDesc);
                }
            }
        });
        JREDesc jREDesc = null;
        JREInfo jREInfo = null;
        JavaFXRuntimeDesc javaFXRuntimeDesc = launchDesc.getJavaFXRuntimeDescriptor();
        if (arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                jREDesc = (JREDesc)arrayList.get(i);
                if (jREInfo == null) {
                    jREInfo = LaunchSelection.selectJRE(jREDesc, javaFXRuntimeDesc == null ? null : javaFXRuntimeDesc.getVersion(), jREMatcher);
                }
                if (jREMatcher.getRunningJREDesc() != null || !jREMatcher.isVersionMatch(JREInfo.getHomeJRE(), jREDesc)) continue;
                jREMatcher.setRunningJREDesc(jREDesc);
            }
            if (jREInfo == null) {
                jREDesc = (JREDesc)arrayList.get(0);
            }
        } else {
            jREDesc = new JREDesc(anyJREVersion, -1L, -1L, null, null, new ResourcesDesc());
            resourcesDesc.addResource(jREDesc);
            jREInfo = LaunchSelection.selectJRE(jREDesc, javaFXRuntimeDesc == null ? null : javaFXRuntimeDesc.getVersion(), jREMatcher);
        }
        jREMatcher.digest(jREDesc, jREInfo);
    }

    private static void selectJREExtensionHelper(LaunchDesc launchDesc, JREMatcher jREMatcher) {
        ResourcesDesc resourcesDesc = launchDesc.getResources();
        if (resourcesDesc == null) {
            return;
        }
        final ArrayList arrayList = new ArrayList();
        resourcesDesc.visit(new ResourceVisitor(){

            public void visitExtensionDesc(ExtensionDesc extensionDesc) {
                arrayList.add(extensionDesc);
            }
        });
        jREMatcher.digest(launchDesc);
        if (launchDesc.isInstaller()) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ExtensionDesc extensionDesc = (ExtensionDesc)arrayList.get(i);
            LaunchDesc launchDesc2 = extensionDesc.getExtensionDesc();
            if (launchDesc2 == null) {
                try {
                    File file = ResourceProvider.get().getCachedJNLPFile(extensionDesc.getLocation(), extensionDesc.getVersion());
                    if (null != file) {
                        launchDesc2 = LaunchDescFactory.buildDescriptor(file, extensionDesc.getCodebase(), extensionDesc.getLocation(), extensionDesc.getLocation());
                    }
                }
                catch (Exception exception) {
                    Trace.ignoredException((Exception)exception);
                }
            }
            if (null == launchDesc2 || launchDesc2.isInstaller()) continue;
            extensionDesc.setExtensionDesc(launchDesc2);
            LaunchSelection.selectJREExtensionHelper(launchDesc2, jREMatcher);
        }
    }

    public static JREInfo selectJRE(URL uRL, String string) {
        JREDesc jREDesc = new JREDesc(string, -1L, -1L, null, uRL, new ResourcesDesc());
        return LaunchSelection.selectJRE(jREDesc, null, new JREMatcher());
    }

    public static JREInfo selectJRE(JREDesc jREDesc, String string, JREMatcher jREMatcher) {
        VersionString versionString;
        JREInfo[] jREInfoArray = JREInfo.getAll();
        if (jREInfoArray == null) {
            return null;
        }
        for (int i = 0; i < jREInfoArray.length; ++i) {
            if (!jREInfoArray[i].isOsInfoMatch(Config.getOSName(), Config.getOSArch()) || !jREInfoArray[i].isEnabled()) continue;
            versionString = new VersionString(string);
            if (!jREMatcher.isVersionMatch(jREInfoArray[i], jREDesc) || !jREMatcher.isFXVersionMatch(jREInfoArray[i], versionString)) continue;
            return jREInfoArray[i];
        }
        JREInfo jREInfo = JREInfo.getHomeJRE();
        if (jREInfo.isOsInfoMatch(Config.getOSName(), Config.getOSArch())) {
            versionString = new VersionString(string);
            if (jREMatcher.isVersionMatch(jREInfo, jREDesc) && jREMatcher.isFXVersionMatch(jREInfo, versionString)) {
                return jREInfo;
            }
        }
        return null;
    }
}

