/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.locale.provider.ResourceBundleBasedAdapter;
import sun.util.locale.provider.TimeZoneNameUtility;

public class DateFormatSymbols
implements Serializable,
Cloneable {
    String[] eras = null;
    String[] months = null;
    String[] shortMonths = null;
    String[] weekdays = null;
    String[] shortWeekdays = null;
    String[] ampms = null;
    String[][] zoneStrings = null;
    transient boolean isZoneStringsSet = false;
    static final String patternChars = "GyMdkHmsSEDFwWahKzZYuXL";
    static final int PATTERN_ERA = 0;
    static final int PATTERN_YEAR = 1;
    static final int PATTERN_MONTH = 2;
    static final int PATTERN_DAY_OF_MONTH = 3;
    static final int PATTERN_HOUR_OF_DAY1 = 4;
    static final int PATTERN_HOUR_OF_DAY0 = 5;
    static final int PATTERN_MINUTE = 6;
    static final int PATTERN_SECOND = 7;
    static final int PATTERN_MILLISECOND = 8;
    static final int PATTERN_DAY_OF_WEEK = 9;
    static final int PATTERN_DAY_OF_YEAR = 10;
    static final int PATTERN_DAY_OF_WEEK_IN_MONTH = 11;
    static final int PATTERN_WEEK_OF_YEAR = 12;
    static final int PATTERN_WEEK_OF_MONTH = 13;
    static final int PATTERN_AM_PM = 14;
    static final int PATTERN_HOUR1 = 15;
    static final int PATTERN_HOUR0 = 16;
    static final int PATTERN_ZONE_NAME = 17;
    static final int PATTERN_ZONE_VALUE = 18;
    static final int PATTERN_WEEK_YEAR = 19;
    static final int PATTERN_ISO_DAY_OF_WEEK = 20;
    static final int PATTERN_ISO_ZONE = 21;
    static final int PATTERN_MONTH_STANDALONE = 22;
    String localPatternChars = null;
    Locale locale = null;
    static final long serialVersionUID = -5987973545549424702L;
    static final int millisPerHour = 3600000;
    private static final ConcurrentMap<Locale, SoftReference<DateFormatSymbols>> cachedInstances = new ConcurrentHashMap<Locale, SoftReference<DateFormatSymbols>>(3);
    private transient int lastZoneIndex = 0;
    volatile transient int cachedHashCode = 0;

    public DateFormatSymbols() {
        this.initializeData(Locale.getDefault(Locale.Category.FORMAT));
    }

    public DateFormatSymbols(Locale locale) {
        this.initializeData(locale);
    }

    public static Locale[] getAvailableLocales() {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(DateFormatSymbolsProvider.class);
        return localeServiceProviderPool.getAvailableLocales();
    }

    public static final DateFormatSymbols getInstance() {
        return DateFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT));
    }

    public static final DateFormatSymbols getInstance(Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getProviderInstance(locale);
        if (dateFormatSymbols != null) {
            return dateFormatSymbols;
        }
        throw new RuntimeException("DateFormatSymbols instance creation failed.");
    }

    static final DateFormatSymbols getInstanceRef(Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getProviderInstance(locale);
        if (dateFormatSymbols != null) {
            return dateFormatSymbols;
        }
        throw new RuntimeException("DateFormatSymbols instance creation failed.");
    }

    private static DateFormatSymbols getProviderInstance(Locale locale) {
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(DateFormatSymbolsProvider.class, locale);
        DateFormatSymbolsProvider dateFormatSymbolsProvider = localeProviderAdapter.getDateFormatSymbolsProvider();
        DateFormatSymbols dateFormatSymbols = dateFormatSymbolsProvider.getInstance(locale);
        if (dateFormatSymbols == null) {
            dateFormatSymbolsProvider = LocaleProviderAdapter.forJRE().getDateFormatSymbolsProvider();
            dateFormatSymbols = dateFormatSymbolsProvider.getInstance(locale);
        }
        return dateFormatSymbols;
    }

    public String[] getEras() {
        return Arrays.copyOf(this.eras, this.eras.length);
    }

    public void setEras(String[] stringArray) {
        this.eras = Arrays.copyOf(stringArray, stringArray.length);
        this.cachedHashCode = 0;
    }

    public String[] getMonths() {
        return Arrays.copyOf(this.months, this.months.length);
    }

    public void setMonths(String[] stringArray) {
        this.months = Arrays.copyOf(stringArray, stringArray.length);
        this.cachedHashCode = 0;
    }

    public String[] getShortMonths() {
        return Arrays.copyOf(this.shortMonths, this.shortMonths.length);
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = Arrays.copyOf(stringArray, stringArray.length);
        this.cachedHashCode = 0;
    }

    public String[] getWeekdays() {
        return Arrays.copyOf(this.weekdays, this.weekdays.length);
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = Arrays.copyOf(stringArray, stringArray.length);
        this.cachedHashCode = 0;
    }

    public String[] getShortWeekdays() {
        return Arrays.copyOf(this.shortWeekdays, this.shortWeekdays.length);
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = Arrays.copyOf(stringArray, stringArray.length);
        this.cachedHashCode = 0;
    }

    public String[] getAmPmStrings() {
        return Arrays.copyOf(this.ampms, this.ampms.length);
    }

    public void setAmPmStrings(String[] stringArray) {
        this.ampms = Arrays.copyOf(stringArray, stringArray.length);
        this.cachedHashCode = 0;
    }

    public String[][] getZoneStrings() {
        return this.getZoneStringsImpl(true);
    }

    public void setZoneStrings(String[][] stringArray) {
        String[][] stringArrayArray = new String[stringArray.length][];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].length;
            if (n < 5) {
                throw new IllegalArgumentException();
            }
            stringArrayArray[i] = Arrays.copyOf(stringArray[i], n);
        }
        this.zoneStrings = stringArrayArray;
        this.isZoneStringsSet = true;
        this.cachedHashCode = 0;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = string.toString();
        this.cachedHashCode = 0;
    }

    public Object clone() {
        try {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)super.clone();
            this.copyMembers(this, dateFormatSymbols);
            return dateFormatSymbols;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    public int hashCode() {
        int n = this.cachedHashCode;
        if (n == 0) {
            n = 5;
            n = 11 * n + Arrays.hashCode(this.eras);
            n = 11 * n + Arrays.hashCode(this.months);
            n = 11 * n + Arrays.hashCode(this.shortMonths);
            n = 11 * n + Arrays.hashCode(this.weekdays);
            n = 11 * n + Arrays.hashCode(this.shortWeekdays);
            n = 11 * n + Arrays.hashCode(this.ampms);
            n = 11 * n + Arrays.deepHashCode((Object[])this.getZoneStringsWrapper());
            this.cachedHashCode = n = 11 * n + Objects.hashCode(this.localPatternChars);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
        return Arrays.equals(this.eras, dateFormatSymbols.eras) && Arrays.equals(this.months, dateFormatSymbols.months) && Arrays.equals(this.shortMonths, dateFormatSymbols.shortMonths) && Arrays.equals(this.weekdays, dateFormatSymbols.weekdays) && Arrays.equals(this.shortWeekdays, dateFormatSymbols.shortWeekdays) && Arrays.equals(this.ampms, dateFormatSymbols.ampms) && Arrays.deepEquals((Object[])this.getZoneStringsWrapper(), (Object[])dateFormatSymbols.getZoneStringsWrapper()) && (this.localPatternChars != null && this.localPatternChars.equals(dateFormatSymbols.localPatternChars) || this.localPatternChars == null && dateFormatSymbols.localPatternChars == null);
    }

    private void initializeData(Locale locale) {
        DateFormatSymbols dateFormatSymbols;
        ResourceBundle resourceBundle;
        DateFormatSymbols dateFormatSymbols2;
        this.locale = locale;
        SoftReference<DateFormatSymbols> softReference = (SoftReference<DateFormatSymbols>)cachedInstances.get(this.locale);
        if (softReference != null && (dateFormatSymbols2 = (DateFormatSymbols)softReference.get()) != null) {
            this.copyMembers(dateFormatSymbols2, this);
            return;
        }
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getAdapter(DateFormatSymbolsProvider.class, this.locale);
        if (!(localeProviderAdapter instanceof ResourceBundleBasedAdapter)) {
            localeProviderAdapter = LocaleProviderAdapter.getResourceBundleBased();
        }
        if ((resourceBundle = ((ResourceBundleBasedAdapter)((Object)localeProviderAdapter)).getLocaleData().getDateFormatData(this.locale)).containsKey("Eras")) {
            this.eras = resourceBundle.getStringArray("Eras");
        } else if (resourceBundle.containsKey("long.Eras")) {
            this.eras = resourceBundle.getStringArray("long.Eras");
        } else if (resourceBundle.containsKey("short.Eras")) {
            this.eras = resourceBundle.getStringArray("short.Eras");
        }
        this.months = resourceBundle.getStringArray("MonthNames");
        this.shortMonths = resourceBundle.getStringArray("MonthAbbreviations");
        this.ampms = resourceBundle.getStringArray("AmPmMarkers");
        this.localPatternChars = resourceBundle.getString("DateTimePatternChars");
        this.weekdays = DateFormatSymbols.toOneBasedArray(resourceBundle.getStringArray("DayNames"));
        this.shortWeekdays = DateFormatSymbols.toOneBasedArray(resourceBundle.getStringArray("DayAbbreviations"));
        softReference = new SoftReference<DateFormatSymbols>((DateFormatSymbols)this.clone());
        SoftReference<DateFormatSymbols> softReference2 = cachedInstances.putIfAbsent(this.locale, softReference);
        if (softReference2 != null && (dateFormatSymbols = softReference2.get()) == null) {
            cachedInstances.put(this.locale, softReference);
        }
    }

    private static String[] toOneBasedArray(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        stringArray2[0] = "";
        for (int i = 0; i < n; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        return stringArray2;
    }

    final int getZoneIndex(String string) {
        String[][] stringArray = this.getZoneStringsWrapper();
        if (this.lastZoneIndex < stringArray.length && string.equals(stringArray[this.lastZoneIndex][0])) {
            return this.lastZoneIndex;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i][0])) continue;
            this.lastZoneIndex = i;
            return i;
        }
        return -1;
    }

    final String[][] getZoneStringsWrapper() {
        if (this.isSubclassObject()) {
            return this.getZoneStrings();
        }
        return this.getZoneStringsImpl(false);
    }

    private String[][] getZoneStringsImpl(boolean bl) {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        if (!bl) {
            return this.zoneStrings;
        }
        int n = this.zoneStrings.length;
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = Arrays.copyOf(this.zoneStrings[i], this.zoneStrings[i].length);
        }
        return stringArray;
    }

    private boolean isSubclassObject() {
        return !this.getClass().getName().equals("java.text.DateFormatSymbols");
    }

    private void copyMembers(DateFormatSymbols dateFormatSymbols, DateFormatSymbols dateFormatSymbols2) {
        dateFormatSymbols2.eras = Arrays.copyOf(dateFormatSymbols.eras, dateFormatSymbols.eras.length);
        dateFormatSymbols2.months = Arrays.copyOf(dateFormatSymbols.months, dateFormatSymbols.months.length);
        dateFormatSymbols2.shortMonths = Arrays.copyOf(dateFormatSymbols.shortMonths, dateFormatSymbols.shortMonths.length);
        dateFormatSymbols2.weekdays = Arrays.copyOf(dateFormatSymbols.weekdays, dateFormatSymbols.weekdays.length);
        dateFormatSymbols2.shortWeekdays = Arrays.copyOf(dateFormatSymbols.shortWeekdays, dateFormatSymbols.shortWeekdays.length);
        dateFormatSymbols2.ampms = Arrays.copyOf(dateFormatSymbols.ampms, dateFormatSymbols.ampms.length);
        dateFormatSymbols2.zoneStrings = dateFormatSymbols.zoneStrings != null ? dateFormatSymbols.getZoneStringsImpl(true) : (String[][])null;
        dateFormatSymbols2.localPatternChars = dateFormatSymbols.localPatternChars;
        dateFormatSymbols2.cachedHashCode = 0;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.zoneStrings == null) {
            this.zoneStrings = TimeZoneNameUtility.getZoneStrings(this.locale);
        }
        objectOutputStream.defaultWriteObject();
    }
}

