/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.LongConsumer;
import java.util.stream.Nodes;
import java.util.stream.Sink;
import java.util.stream.StreamShape;
import java.util.stream.Tripwire;

interface Node<T> {
    public Spliterator<T> spliterator();

    public void forEach(Consumer<? super T> var1);

    default public int getChildCount() {
        return 0;
    }

    default public Node<T> getChild(int n) {
        throw new IndexOutOfBoundsException();
    }

    default public Node<T> truncate(long l, long l2, IntFunction<T[]> intFunction) {
        if (l == 0L && l2 == this.count()) {
            return this;
        }
        Spliterator<Object> spliterator = this.spliterator();
        long l3 = l2 - l;
        Builder builder = Nodes.builder(l3, intFunction);
        builder.begin(l3);
        int n = 0;
        while ((long)n < l && spliterator.tryAdvance(object -> {})) {
            ++n;
        }
        n = 0;
        while ((long)n < l3 && spliterator.tryAdvance(builder)) {
            ++n;
        }
        builder.end();
        return builder.build();
    }

    public T[] asArray(IntFunction<T[]> var1);

    public void copyInto(T[] var1, int var2);

    default public StreamShape getShape() {
        return StreamShape.REFERENCE;
    }

    public long count();

    public static interface Builder<T>
    extends Sink<T> {
        public Node<T> build();

        public static interface OfDouble
        extends Builder<Double>,
        Sink.OfDouble {
            public java.util.stream.Node$OfDouble build();
        }

        public static interface OfInt
        extends Builder<Integer>,
        Sink.OfInt {
            public java.util.stream.Node$OfInt build();
        }

        public static interface OfLong
        extends Builder<Long>,
        Sink.OfLong {
            public java.util.stream.Node$OfLong build();
        }
    }

    public static interface OfDouble
    extends OfPrimitive<Double, DoubleConsumer, double[], Spliterator.OfDouble, OfDouble> {
        @Override
        default public void forEach(Consumer<? super Double> consumer) {
            if (consumer instanceof DoubleConsumer) {
                this.forEach((DoubleConsumer)((Object)consumer));
            } else {
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling Node.OfLong.forEachRemaining(Consumer)");
                }
                ((Spliterator.OfDouble)this.spliterator()).forEachRemaining(consumer);
            }
        }

        @Override
        default public void copyInto(Double[] doubleArray, int n) {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling Node.OfDouble.copyInto(Double[], int)");
            }
            double[] dArray = (double[])this.asPrimitiveArray();
            for (int i = 0; i < dArray.length; ++i) {
                doubleArray[n + i] = dArray[i];
            }
        }

        @Override
        default public OfDouble truncate(long l, long l2, IntFunction<Double[]> intFunction) {
            if (l == 0L && l2 == this.count()) {
                return this;
            }
            long l3 = l2 - l;
            Spliterator.OfDouble ofDouble = (Spliterator.OfDouble)this.spliterator();
            Builder.OfDouble ofDouble2 = Nodes.doubleBuilder(l3);
            ofDouble2.begin(l3);
            int n = 0;
            while ((long)n < l && ofDouble.tryAdvance(d -> {})) {
                ++n;
            }
            n = 0;
            while ((long)n < l3 && ofDouble.tryAdvance(ofDouble2)) {
                ++n;
            }
            ofDouble2.end();
            return ofDouble2.build();
        }

        @Override
        default public double[] newArray(int n) {
            return new double[n];
        }

        @Override
        default public StreamShape getShape() {
            return StreamShape.DOUBLE_VALUE;
        }
    }

    public static interface OfInt
    extends OfPrimitive<Integer, IntConsumer, int[], Spliterator.OfInt, OfInt> {
        @Override
        default public void forEach(Consumer<? super Integer> consumer) {
            if (consumer instanceof IntConsumer) {
                this.forEach((IntConsumer)((Object)consumer));
            } else {
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling Node.OfInt.forEachRemaining(Consumer)");
                }
                ((Spliterator.OfInt)this.spliterator()).forEachRemaining(consumer);
            }
        }

        @Override
        default public void copyInto(Integer[] integerArray, int n) {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling Node.OfInt.copyInto(Integer[], int)");
            }
            int[] nArray = (int[])this.asPrimitiveArray();
            for (int i = 0; i < nArray.length; ++i) {
                integerArray[n + i] = nArray[i];
            }
        }

        @Override
        default public OfInt truncate(long l, long l2, IntFunction<Integer[]> intFunction) {
            if (l == 0L && l2 == this.count()) {
                return this;
            }
            long l3 = l2 - l;
            Spliterator.OfInt ofInt = (Spliterator.OfInt)this.spliterator();
            Builder.OfInt ofInt2 = Nodes.intBuilder(l3);
            ofInt2.begin(l3);
            int n2 = 0;
            while ((long)n2 < l && ofInt.tryAdvance(n -> {})) {
                ++n2;
            }
            n2 = 0;
            while ((long)n2 < l3 && ofInt.tryAdvance(ofInt2)) {
                ++n2;
            }
            ofInt2.end();
            return ofInt2.build();
        }

        @Override
        default public int[] newArray(int n) {
            return new int[n];
        }

        @Override
        default public StreamShape getShape() {
            return StreamShape.INT_VALUE;
        }
    }

    public static interface OfLong
    extends OfPrimitive<Long, LongConsumer, long[], Spliterator.OfLong, OfLong> {
        @Override
        default public void forEach(Consumer<? super Long> consumer) {
            if (consumer instanceof LongConsumer) {
                this.forEach((LongConsumer)((Object)consumer));
            } else {
                if (Tripwire.ENABLED) {
                    Tripwire.trip(this.getClass(), "{0} calling Node.OfLong.forEachRemaining(Consumer)");
                }
                ((Spliterator.OfLong)this.spliterator()).forEachRemaining(consumer);
            }
        }

        @Override
        default public void copyInto(Long[] longArray, int n) {
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling Node.OfInt.copyInto(Long[], int)");
            }
            long[] lArray = (long[])this.asPrimitiveArray();
            for (int i = 0; i < lArray.length; ++i) {
                longArray[n + i] = lArray[i];
            }
        }

        @Override
        default public OfLong truncate(long l2, long l3, IntFunction<Long[]> intFunction) {
            if (l2 == 0L && l3 == this.count()) {
                return this;
            }
            long l4 = l3 - l2;
            Spliterator.OfLong ofLong = (Spliterator.OfLong)this.spliterator();
            Builder.OfLong ofLong2 = Nodes.longBuilder(l4);
            ofLong2.begin(l4);
            int n = 0;
            while ((long)n < l2 && ofLong.tryAdvance(l -> {})) {
                ++n;
            }
            n = 0;
            while ((long)n < l4 && ofLong.tryAdvance(ofLong2)) {
                ++n;
            }
            ofLong2.end();
            return ofLong2.build();
        }

        @Override
        default public long[] newArray(int n) {
            return new long[n];
        }

        @Override
        default public StreamShape getShape() {
            return StreamShape.LONG_VALUE;
        }
    }

    public static interface OfPrimitive<T, T_CONS, T_ARR, T_SPLITR extends Spliterator.OfPrimitive<T, T_CONS, T_SPLITR>, T_NODE extends OfPrimitive<T, T_CONS, T_ARR, T_SPLITR, T_NODE>>
    extends Node<T> {
        public T_SPLITR spliterator();

        public void forEach(T_CONS var1);

        default public T_NODE getChild(int n) {
            throw new IndexOutOfBoundsException();
        }

        public T_NODE truncate(long var1, long var3, IntFunction<T[]> var5);

        @Override
        default public T[] asArray(IntFunction<T[]> intFunction) {
            long l;
            if (Tripwire.ENABLED) {
                Tripwire.trip(this.getClass(), "{0} calling Node.OfPrimitive.asArray");
            }
            if ((l = this.count()) >= 0x7FFFFFF7L) {
                throw new IllegalArgumentException("Stream size exceeds max array size");
            }
            T[] TArray = intFunction.apply((int)this.count());
            this.copyInto((T_ARR)TArray, 0);
            return TArray;
        }

        public T_ARR asPrimitiveArray();

        public T_ARR newArray(int var1);

        public void copyInto(T_ARR var1, int var2);
    }
}

