/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.security.AccessController;
import java.util.Arrays;
import jdk.management.resource.ResourceAccuracy;
import jdk.management.resource.ResourceContext;
import jdk.management.resource.ResourceId;
import jdk.management.resource.ResourceMeter;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;
import jdk.management.resource.internal.ResourceIdImpl;
import jdk.management.resource.internal.ResourceNatives;
import jdk.management.resource.internal.SimpleResourceContext;
import jdk.management.resource.internal.UnassignedContext;

class HeapMetrics
implements Runnable {
    private static final HeapMetrics instance = new HeapMetrics();
    private static volatile Thread thread;
    private static ResourceIdImpl[] idWithAccuracy;
    private static ResourceIdImpl[] idWithAccuracyForced;

    private HeapMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init() {
        HeapMetrics heapMetrics = instance;
        synchronized (heapMetrics) {
            if (thread != null) {
                if (thread.isAlive()) {
                    return;
                }
                HeapMetrics.terminate();
            }
            thread = AccessController.doPrivileged(() -> {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                while (threadGroup.getParent() != null) {
                    threadGroup = threadGroup.getParent();
                }
                ResourceContext resourceContext = SimpleResourceContext.getThreadContext(Thread.currentThread());
                UnassignedContext.getSystemContext().bindThreadContext();
                thread = new Thread(threadGroup, instance, "HeapMetrics");
                thread.setDaemon(true);
                resourceContext.bindThreadContext();
                return thread;
            }, null, new RuntimePermission("modifyThreadGroup"), new RuntimePermission("modifyThread"));
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void terminate() {
        HeapMetrics heapMetrics = instance;
        synchronized (heapMetrics) {
            if (thread != null) {
                Thread thread = HeapMetrics.thread;
                HeapMetrics.thread = null;
                thread.interrupt();
            }
        }
    }

    private ResourceId selectId(int n, boolean bl) {
        return bl ? idWithAccuracyForced[n] : idWithAccuracy[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = new Object();
        ResourceNatives.setRetainedMemoryNotificationEnabled(object);
        UnassignedContext.getSystemContext().bindThreadContext();
        UnassignedContext unassignedContext = UnassignedContext.getUnassignedContext();
        long[] lArray = new long[1];
        int[] nArray = new int[1];
        byte[] byArray = new byte[1];
        Object object2 = object;
        synchronized (object2) {
            while (Thread.currentThread().equals(thread)) {
                try {
                    boolean bl = false;
                    do {
                        int n;
                        SimpleResourceContext[] simpleResourceContextArray;
                        int n2;
                        if ((n2 = (simpleResourceContextArray = SimpleResourceContext.getContexts().values().toArray(new SimpleResourceContext[0])).length) + 1 != lArray.length) {
                            lArray = new long[n2 + 1];
                            nArray = new int[n2 + 1];
                            byArray = new byte[n2 + 1];
                        }
                        for (n = 0; n < n2; ++n) {
                            nArray[n] = simpleResourceContextArray[n].nativeThreadContext();
                        }
                        nArray[n2] = unassignedContext.nativeThreadContext();
                        Arrays.fill(lArray, -1L);
                        bl = ResourceNatives.getContextsRetainedMemory(nArray, lArray, byArray);
                        for (n = 0; n <= n2; ++n) {
                            boolean bl2;
                            UnassignedContext unassignedContext2;
                            ResourceRequest resourceRequest;
                            if (lArray[n] == -1L || (resourceRequest = (unassignedContext2 = n < n2 ? simpleResourceContextArray[n] : unassignedContext).getResourceRequest(ResourceType.HEAP_RETAINED)) == null) continue;
                            long l = lArray[n] - ((ResourceMeter)((Object)resourceRequest)).getValue();
                            boolean bl3 = bl2 = byArray[n] >= ResourceAccuracy.HIGH.ordinal();
                            if (l == 0L && !bl2) continue;
                            resourceRequest.request(l, this.selectId(byArray[n], bl2));
                        }
                    } while (bl);
                    object.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    static {
        idWithAccuracy = new ResourceIdImpl[]{ResourceIdImpl.of("Heap", ResourceAccuracy.LOW), ResourceIdImpl.of("Heap", ResourceAccuracy.MEDIUM), ResourceIdImpl.of("Heap", ResourceAccuracy.HIGH), ResourceIdImpl.of("Heap", ResourceAccuracy.HIGHEST)};
        idWithAccuracyForced = new ResourceIdImpl[]{ResourceIdImpl.of("Heap", ResourceAccuracy.LOW, true), ResourceIdImpl.of("Heap", ResourceAccuracy.MEDIUM, true), ResourceIdImpl.of("Heap", ResourceAccuracy.HIGH, true), ResourceIdImpl.of("Heap", ResourceAccuracy.HIGHEST, true)};
    }
}

