/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import org.j4me.util.MathFunc;

public class Coordinates {
    private static final double METERS_PER_RADIAN = 6371000.0;
    public static final int DD_MM_SS = 1;
    public static final int DD_MM = 2;
    private float altitude;
    private double latitude;
    private double longitude;

    public Coordinates(double latitude, double longitude, float altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setAltitude(altitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public void setAltitude(float altitude) {
        this.altitude = altitude;
    }

    public void setLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude >= 90.0) {
            throw new IllegalArgumentException("Latitude (" + latitude + ") is invalid.");
        }
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude >= 180.0) {
            throw new IllegalArgumentException("Longitude (" + longitude + ") is invalid.");
        }
        this.longitude = longitude;
    }

    public float azimuthTo(Coordinates to) {
        if (to == null) {
            throw new IllegalArgumentException("azimuthTo does not accept a null parameter.");
        }
        double lat1 = Math.toRadians(this.latitude);
        double lon1 = Math.toRadians(this.longitude);
        double lat2 = Math.toRadians(to.latitude);
        double lon2 = Math.toRadians(to.longitude);
        double deltaLon = lon2 - lon1;
        double cosLat2 = Math.cos(lat2);
        double c1 = Math.sin(deltaLon) * cosLat2;
        double c2 = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * cosLat2 * Math.cos(deltaLon);
        double courseInRadians = MathFunc.atan2(c1, c2);
        double course = Math.toDegrees(courseInRadians);
        course = (360.0 + course) % 360.0;
        return (float)course;
    }

    public float distance(Coordinates to) {
        if (to == null) {
            throw new IllegalArgumentException("distance does not accept a null parameter.");
        }
        double lat1 = Math.toRadians(this.latitude);
        double lon1 = Math.toRadians(this.longitude);
        double lat2 = Math.toRadians(to.latitude);
        double lon2 = Math.toRadians(to.longitude);
        double d1 = Math.sin((lat1 - lat2) / 2.0);
        double d2 = d1 * d1;
        double d3 = Math.cos(lat1) * Math.cos(lat2);
        double d4 = Math.sin((lon1 - lon2) / 2.0);
        double d5 = d4 * d4;
        double d6 = d2 + d3 * d5;
        double distanceInRadians = 2.0 * MathFunc.asin(Math.sqrt(d6));
        double distance = 6371000.0 * distanceInRadians;
        return (float)distance;
    }

    public boolean equals(Object other) {
        double tolerance = 1.0E-6;
        if (other == null) {
            return false;
        }
        if (!(other instanceof Coordinates)) {
            return false;
        }
        Coordinates c = (Coordinates)other;
        if (this.latitude < c.latitude - 1.0E-6 || this.latitude > c.latitude + 1.0E-6) {
            return false;
        }
        if (this.longitude < c.longitude - 1.0E-6 || this.longitude > c.longitude + 1.0E-6) {
            return false;
        }
        if (Float.isNaN(this.altitude) && !Float.isNaN(c.altitude)) {
            return false;
        }
        if (!Float.isNaN(this.altitude) && Float.isNaN(c.altitude)) {
            return false;
        }
        if (Float.isNaN(this.altitude) && Float.isNaN(c.altitude)) {
            return true;
        }
        return !((double)this.altitude < (double)c.altitude - 1.0E-6) && !((double)this.altitude > (double)c.altitude + 1.0E-6);
    }

    public String toString() {
        String s;
        if (this.latitude >= 0.0) {
            s = String.valueOf(this.latitude);
            s = s + "\ufffdN ";
        } else {
            s = String.valueOf(-1.0 * this.latitude);
            s = s + "\ufffdS ";
        }
        if (this.longitude >= 0.0) {
            s = s + String.valueOf(this.longitude);
            s = s + "\ufffdE";
        } else {
            s = s + String.valueOf(-1.0 * this.longitude);
            s = s + "\ufffdW";
        }
        if (!Float.isNaN(this.altitude)) {
            s = s + " " + this.altitude + "m";
        }
        return s;
    }
}

