/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;

public class Label
extends Component {
    private String text = "";
    private Image icon;
    private int valign = 2;
    private int textPosition = 3;
    private int gap = 2;
    private int shiftText = 0;
    private boolean tickerRunning = false;
    private static boolean defaultTickerEnabled = true;
    private boolean tickerEnabled = defaultTickerEnabled;
    private long tickerStartTime;
    private long tickerDelay;
    private boolean rightToLeft;
    private boolean endsWith3Points = true;

    public Label(String string) {
        this.setUIID("Label");
        this.text = string;
        this.localize();
        this.setFocusable(false);
        this.endsWith3Points = UIManager.getInstance().getLookAndFeel().isDefaultEndsWith3Points();
    }

    Label(String string, String string2) {
        this.text = string;
        this.localize();
        this.setFocusable(false);
        this.setUIID(string2);
    }

    public Label() {
        this("");
    }

    public Label(Image image) {
        this("");
        this.icon = image;
    }

    public int getBaselineResizeBehavior() {
        switch (this.valign) {
            case 0: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        return 4;
    }

    public void setText(String string) {
        this.text = string;
        this.localize();
        this.setShouldCalcPreferredSize(true);
        this.repaint();
    }

    private void localize() {
        this.text = UIManager.getInstance().localize(this.text, this.text);
    }

    void initComponentImpl() {
        LookAndFeel lookAndFeel;
        super.initComponentImpl();
        if (this.hasFocus() && (lookAndFeel = UIManager.getInstance().getLookAndFeel()) instanceof DefaultLookAndFeel) {
            ((DefaultLookAndFeel)lookAndFeel).focusGained(this);
        }
        if (this.isTickerEnabled() && this.isTickerRunning() && !this.isCellRenderer()) {
            this.getComponentForm().registerAnimatedInternal(this);
        }
    }

    public String getText() {
        return this.text;
    }

    public void setIcon(Image image) {
        if (this.icon == image) {
            return;
        }
        this.icon = image;
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
        this.repaint();
    }

    void checkAnimation() {
        Form form;
        super.checkAnimation();
        if (this.icon != null && this.icon.isAnimation() && (form = this.getComponentForm()) != null) {
            form.registerAnimated(this);
        }
    }

    public Image getIcon() {
        return this.icon;
    }

    public void setAlignment(int n) {
        this.getSelectedStyle().setAlignment(n);
        this.getUnselectedStyle().setAlignment(n);
    }

    public void setVerticalAlignment(int n) {
        if (n != 4 && n != 0 && n != 2) {
            throw new IllegalArgumentException("Alignment can't be set to " + n);
        }
        this.valign = n;
    }

    public int getVerticalAlignment() {
        return this.valign;
    }

    public int getAlignment() {
        return this.getStyle().getAlignment();
    }

    public void setTextPosition(int n) {
        if (n != 1 && n != 3 && n != 2 && n != 0) {
            throw new IllegalArgumentException("Text position can't be set to " + n);
        }
        this.textPosition = n;
    }

    public int getTextPosition() {
        return this.textPosition;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public int getGap() {
        return this.gap;
    }

    protected String paramString() {
        return super.paramString() + ", text = " + this.getText() + ", gap = " + this.gap;
    }

    public void paint(Graphics graphics) {
        UIManager.getInstance().getLookAndFeel().drawLabel(graphics, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getLabelPreferredSize(this);
    }

    public int getShiftText() {
        return this.shiftText;
    }

    public void setShiftText(int n) {
        this.shiftText = n;
    }

    public boolean shouldTickerStart() {
        int n;
        if (!this.tickerEnabled) {
            return false;
        }
        Style style = this.getStyle();
        int n2 = style.getFont().stringWidth(this.getText());
        return n2 > (n = this.getAvaliableSpaceForText()) && n > 0;
    }

    Image getIconFromState() {
        return this.getIcon();
    }

    int getAvaliableSpaceForText() {
        Style style = this.getStyle();
        int n = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1);
        Image image = this.getIconFromState();
        if (image != null && (this.getTextPosition() == 3 || this.getTextPosition() == 1)) {
            n -= image.getWidth();
        }
        return n;
    }

    public void startTicker() {
        this.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
    }

    public void startTicker(long l, boolean bl) {
        Form form;
        if (!this.tickerEnabled) {
            return;
        }
        if (!this.isCellRenderer() && (form = this.getComponentForm()) != null) {
            form.registerAnimatedInternal(this);
        }
        this.tickerStartTime = System.currentTimeMillis();
        this.tickerDelay = l;
        this.tickerRunning = true;
        this.rightToLeft = bl;
        if (this.isRTL()) {
            this.rightToLeft = !this.rightToLeft;
        }
    }

    public void stopTicker() {
        this.tickerRunning = false;
        this.setShiftText(0);
        this.deregisterAnimatedInternal();
    }

    void tryDeregisterAnimated() {
    }

    public boolean isTickerRunning() {
        return this.tickerRunning;
    }

    public void setTickerEnabled(boolean bl) {
        this.tickerEnabled = bl;
    }

    public boolean isTickerEnabled() {
        return this.tickerEnabled;
    }

    public void setEndsWith3Points(boolean bl) {
        this.endsWith3Points = bl;
    }

    public boolean isEndsWith3Points() {
        return this.endsWith3Points;
    }

    public boolean animate() {
        boolean bl = false;
        if (this.tickerRunning && this.tickerStartTime + this.tickerDelay < System.currentTimeMillis()) {
            this.tickerStartTime = System.currentTimeMillis();
            this.shiftText = this.rightToLeft ? (this.shiftText -= 2) : (this.shiftText += 2);
            bl = true;
        }
        boolean bl2 = this.icon != null && this.icon.isAnimation() && this.icon.animate();
        boolean bl3 = super.animate();
        return bl2 || bl3 || bl;
    }

    public static boolean isDefaultTickerEnabled() {
        return defaultTickerEnabled;
    }

    public static void setDefaultTickerEnabled(boolean bl) {
        defaultTickerEnabled = bl;
    }
}

