/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.MenuBar;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Hashtable;
import java.util.Vector;

public class TextField
extends TextArea {
    private static boolean replaceMenuDefault = true;
    private long cursorBlinkTime = System.currentTimeMillis();
    private boolean drawCursor = true;
    private int cursorY = 0;
    private int cursorX = -1;
    private boolean pressedAndNotReleased;
    private long pressTime;
    private boolean useSoftkeys = true;
    private long releaseTime;
    private String previousText;
    private int commitTimeout = 1000;
    private boolean pendingCommit;
    private int pressCount = 0;
    private int lastKeyCode;
    private int pressedKeyCode;
    private static String clearText = "Clear";
    private static String t9Text = "T9";
    private boolean longClick;
    private Command originalClearCommand;
    private static Hashtable inputModes;
    private static String[] defaultInputModeOrder;
    private String inputMode = defaultInputModeOrder[0];
    private String[] inputModeOrder = defaultInputModeOrder;
    private static Vector firstUppercaseInputMode;
    private int blinkOnTime = 800;
    private int blinkOffTime = 200;
    private static boolean qwertyAutoDetect;
    private boolean qwertyInitialized;
    private static boolean qwertyDevice;
    private boolean qwerty = qwertyDevice;
    private boolean replaceMenu = replaceMenuDefault;
    private Command[] originalCommands;
    private EventDispatcher listeners = new EventDispatcher();
    private boolean overwriteMode;
    private boolean enableInputScroll = true;
    private int keyFwd = 5;
    private int keyBack = 2;
    private boolean leftAndRightEditingTrigger = true;
    private static int defaultChangeInputModeKey;
    private static int defaultSymbolDialogKey;
    private Command selectCommand;
    private Command DELETE_COMMAND = new CommandHandler(clearText, 1);
    private Command T9_COMMAND = new CommandHandler(t9Text, 2);
    private static final char[] DEFAULT_SYMBOL_TABLE;
    private static char[] symbolTable;
    private static final String[] DEFAULT_KEY_CODES;

    public static void setClearText(String string) {
        clearText = string;
    }

    public static void setT9Text(String string) {
        t9Text = string;
    }

    public boolean isEnableInputScroll() {
        return this.enableInputScroll;
    }

    public void setEnableInputScroll(boolean bl) {
        this.enableInputScroll = bl;
    }

    public TextField() {
        super(1, 20);
        this.setUIID("TextField");
        this.setSingleLineTextArea(true);
    }

    public TextField(int n) {
        super(1, n);
        this.setUIID("TextField");
        this.setSingleLineTextArea(true);
    }

    public TextField(String string) {
        super(string, 1, 20);
        this.setUIID("TextField");
        this.setSingleLineTextArea(true);
    }

    public void deleteChar() {
        int n;
        String string = this.getText();
        if (string.length() > 0 && (n = this.getCursorPosition()) > 0) {
            int n2 = n - 1;
            if (!this.overwriteMode) {
                string = n2 == string.length() ? string.substring(0, string.length() - 1) : string.substring(0, n2) + string.substring(n2 + 1, string.length());
                super.setText(string);
                this.commitChange();
                this.fireDataChanged(0, n2);
            }
            if (n == 1) {
                this.cursorX = 0;
                n = 0;
            } else {
                this.setCursorPosition(n2);
            }
        }
    }

    public TextField(String string, int n) {
        super(string, 1, n);
        this.setSingleLineTextArea(true);
    }

    public static TextArea create(String string, int n) {
        if (Display.getInstance().getImplementation().isNativeInputSupported()) {
            return new TextArea(string, 1, n);
        }
        return new TextField(string, n);
    }

    public static TextArea create() {
        return TextField.create(20);
    }

    public static TextArea create(int n) {
        return TextField.create("", n);
    }

    public static TextArea create(String string) {
        return TextField.create(string, 20);
    }

    protected void commitChange() {
        this.pendingCommit = false;
        this.previousText = null;
        this.pressCount = 0;
    }

    public boolean isPendingCommit() {
        return this.pendingCommit;
    }

    public void setCommitTimeout(int n) {
        this.commitTimeout = n;
    }

    public int getCommitTimeout() {
        return this.commitTimeout;
    }

    public void setInputMode(String string) {
        this.inputMode = string;
        this.repaint();
    }

    public String getInputMode() {
        return this.inputMode;
    }

    protected boolean isChangeInputMode(int n) {
        return n == defaultChangeInputModeKey;
    }

    private static void initInputModes() {
        if (inputModes == null) {
            firstUppercaseInputMode.addElement("Abc");
            inputModes = new Hashtable();
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            for (int i = 0; i < DEFAULT_KEY_CODES.length; ++i) {
                hashtable.put(new Integer(48 + i), DEFAULT_KEY_CODES[i]);
            }
            inputModes.put("ABC", hashtable);
            Hashtable<Integer, String> hashtable2 = new Hashtable<Integer, String>();
            for (int i = 0; i < DEFAULT_KEY_CODES.length; ++i) {
                hashtable2.put(new Integer(48 + i), DEFAULT_KEY_CODES[i].toLowerCase());
            }
            inputModes.put("abc", hashtable2);
            Hashtable<Integer, String> hashtable3 = new Hashtable<Integer, String>();
            for (int i = 0; i < 10; ++i) {
                hashtable3.put(new Integer(48 + i), "" + i);
            }
            inputModes.put("123", hashtable3);
        }
    }

    public static void addInputMode(String string, Hashtable hashtable, boolean bl) {
        TextField.initInputModes();
        inputModes.put(string, hashtable);
        if (bl) {
            firstUppercaseInputMode.addElement(string);
        }
    }

    public String[] getInputModeOrder() {
        return this.inputModeOrder;
    }

    public void setInputModeOrder(String[] stringArray) {
        this.inputModeOrder = stringArray;
        this.inputMode = stringArray[0];
    }

    public static String[] getDefaultInputModeOrder() {
        return defaultInputModeOrder;
    }

    public static void setDefaultInputModeOrder(String[] stringArray) {
        defaultInputModeOrder = stringArray;
    }

    private String pickLowerOrUpper(String string) {
        String string2;
        int n = this.getCursorPosition() - 1;
        if (this.pendingCommit) {
            --n;
        }
        if (n >= (string2 = this.getText()).length()) {
            n = string2.length() - 1;
        }
        while (n > -1) {
            if (string2.charAt(n) == '.') {
                return string.toUpperCase();
            }
            if (string2.charAt(n) != ' ') {
                return string.toLowerCase();
            }
            --n;
        }
        return string.toUpperCase();
    }

    protected String getLongClickInputMode() {
        return "123";
    }

    protected char getCharPerKeyCode(int n, int n2, boolean bl) {
        String string;
        TextField.initInputModes();
        String string2 = this.inputMode;
        if (bl) {
            string2 = this.getLongClickInputMode();
        } else if (firstUppercaseInputMode.contains(string2)) {
            string2 = this.pickLowerOrUpper(string2);
        }
        Hashtable hashtable = (Hashtable)inputModes.get(string2);
        if (hashtable != null && (string = (String)hashtable.get(new Integer(n2))) != null) {
            return string.charAt(n %= string.length());
        }
        return '\u0000';
    }

    void onClick() {
    }

    public void setCursorPosition(int n) {
        if (n < -1) {
            throw new IllegalArgumentException("Illegal cursor position: " + n);
        }
        n = Math.min(n, this.getText().length());
        n = Math.max(0, n);
        this.updateCursorLocation(n);
    }

    private void increaseCursor() {
        ++this.cursorX;
        String string = this.getCurrentTextLine();
        if (this.cursorX > string.length() || this.cursorY >= this.getLines()) {
            if (this.isSingleLineTextArea()) {
                this.cursorX = 0;
                return;
            }
            ++this.cursorY;
            if (this.cursorY > this.getLines()) {
                this.cursorY = 0;
                if (!this.isCursorPositionCycle()) {
                    this.cursorY = this.getLines();
                    this.cursorX = string.length();
                }
            } else {
                this.cursorX = 0;
            }
        }
        this.updateScroll();
    }

    private void decreaseCursor() {
        --this.cursorX;
        if (this.cursorX < 0 || this.cursorY >= this.getLines()) {
            if (this.isSingleLineTextArea()) {
                this.cursorX = this.getCurrentTextLine().length();
                return;
            }
            --this.cursorY;
            if (this.cursorY < 0) {
                this.cursorY = this.getLines() - 1;
                if (!this.isCursorPositionCycle()) {
                    this.cursorY = 0;
                    this.cursorX = 0;
                }
            } else {
                this.cursorX = this.getTextAt(this.cursorY).length();
            }
        }
        this.updateScroll();
    }

    private void increaseCursorLine() {
        String string;
        ++this.cursorY;
        if (this.cursorY >= this.getLines()) {
            this.cursorY = this.isCursorPositionCycle() ? 0 : --this.cursorY;
        }
        if (this.cursorX > (string = this.getTextAt(this.cursorY)).length()) {
            this.cursorX = string.length();
        }
        this.updateScroll();
    }

    private void decreaseCursorLine() {
        String string;
        --this.cursorY;
        if (this.cursorY < 0) {
            this.cursorY = this.isCursorPositionCycle() ? this.getLines() - 1 : ++this.cursorY;
        }
        if (this.cursorX > (string = this.getTextAt(this.cursorY)).length()) {
            this.cursorX = string.length();
        }
        this.updateScroll();
    }

    private void updateScroll() {
        if (!this.isSingleLineTextArea() && this.isScrollableY()) {
            Font font = this.getStyle().getFont();
            int n = this.getRowsGap();
            int n2 = font.getHeight() + n;
            Rectangle rectangle = new Rectangle(this.getScrollX(), this.getCursorY() * n2, this.getWidth(), n2);
            this.scrollRectToVisible(rectangle, this);
        }
    }

    private void updateCursorLocation(int n) {
        int n2;
        if (this.isSingleLineTextArea()) {
            this.cursorX = n;
            return;
        }
        String string = this.getText();
        String string2 = "";
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n4 <= n && n2 < this.getLines(); n4 += n3, ++n2) {
            string2 = this.getTextAt(n2);
            n3 = string2.length();
            if (n4 + n3 >= string.length() || string.charAt(n4 + n3) != '\n' && string.charAt(n4 + n3) != ' ') continue;
            ++n3;
        }
        this.cursorY = Math.max(0, n2 - 1);
        this.cursorX = n3 - (n4 - n);
        if (this.cursorX == n3 && n3 > string2.length()) {
            --this.cursorX;
        }
    }

    private String getCurrentTextLine() {
        if (this.isSingleLineTextArea()) {
            return this.getText();
        }
        return this.getTextAt(this.getCursorY());
    }

    private void moveCursor(int n) {
        if (this.handlesInput()) {
            if (n == this.keyFwd) {
                this.increaseCursor();
                this.repaint();
            } else if (n == this.keyBack) {
                this.decreaseCursor();
                this.repaint();
            }
            if (!this.isSingleLineTextArea()) {
                if (n == 1) {
                    this.decreaseCursorLine();
                    this.repaint();
                } else if (n == 6) {
                    this.increaseCursorLine();
                    this.repaint();
                }
            }
        }
    }

    public int getCursorPosition() {
        String string = this.getText();
        if (string == null || string.length() == 0) {
            this.updateCursorLocation(0);
            return 0;
        }
        if (this.cursorX == -1) {
            this.updateCursorLocation(this.getText().length());
        }
        if (this.isSingleLineTextArea()) {
            return this.getCursorX();
        }
        int n = 0;
        for (int i = 0; i < this.cursorY && i < this.getLines(); ++i) {
            String string2 = this.getTextAt(i);
            if ((n += string2.length()) >= string.length() || string.charAt(n) != '\n' && string.charAt(n) != ' ') continue;
            ++n;
        }
        return Math.min(this.getText().length(), n + this.cursorX);
    }

    public int getCursorY() {
        return this.cursorY;
    }

    public int getCursorX() {
        return this.cursorX;
    }

    public void setText(String string) {
        super.setText(string);
        this.fireDataChanged(2, -1);
        int n = this.getCursorPosition();
        if (n < 0) {
            n = string.length();
        } else if (n > string.length()) {
            n = string.length();
        }
        this.setCursorPosition(n);
    }

    public void clear() {
        this.setText("");
        this.commitChange();
    }

    private void longClick(int n) {
        this.longClick = true;
        this.keyReleaseOrLongClick(n, true);
        this.moveCursor(Display.getInstance().getGameAction(n));
    }

    protected boolean isClearKey(int n) {
        return n == MenuBar.clearSK || n == MenuBar.backspaceSK;
    }

    protected void longKeyPress(int n) {
        if (this.isClearKey(n)) {
            this.setText("");
        }
    }

    public boolean isQwertyInput() {
        if (!this.qwertyInitialized) {
            this.qwertyInitialized = true;
            int n = Display.getInstance().getKeyboardType();
            if (n == 0) {
                this.qwerty = qwertyDevice;
            } else {
                boolean bl = this.qwerty = n == 2 || n == 3;
                if (!qwertyDevice) {
                    qwertyDevice = this.qwerty;
                }
            }
        }
        return this.qwerty;
    }

    public void setQwertyInput(boolean bl) {
        this.qwerty = bl;
    }

    protected boolean isImmediateInputMode(String string) {
        return "123".equals(string);
    }

    private boolean keyReleaseOrLongClick(int n, boolean bl) {
        char c;
        if (this.lastKeyCode != n && this.pendingCommit) {
            this.commitChange();
        }
        this.lastKeyCode = n;
        boolean bl2 = this.isClearKey(n);
        int n2 = this.getCursorPosition();
        if (this.isQwertyInput() && !bl2) {
            if (n > 0) {
                if (this.previousText == null) {
                    this.previousText = this.getText();
                }
                if (n2 < 0) {
                    n2 = 0;
                    this.setCursorPosition(n2);
                }
                this.insertChars("" + (char)n);
                this.commitChange();
                this.fireDataChanged(1, n2);
                return true;
            }
        } else {
            c = this.getCharPerKeyCode(this.pressCount, n, bl);
            if (c != '\u0000') {
                if (this.previousText == null) {
                    this.previousText = this.getText();
                }
                if (!this.pendingCommit) {
                    this.insertChars("" + c);
                    this.pendingCommit = true;
                    ++this.pressCount;
                } else if (this.overwriteMode) {
                    this.decreaseCursor();
                    this.insertChars("" + c);
                    ++this.pressCount;
                } else if (n2 > 0 && n2 < this.getMaxSize() && this.previousText.length() < this.getMaxSize() && this.validChar("" + c)) {
                    String string = this.previousText.substring(0, n2 - 1) + c + this.previousText.substring(n2 - 1, this.previousText.length());
                    this.pendingCommit = true;
                    ++this.pressCount;
                    super.setText(string);
                }
                if (this.isImmediateInputMode(this.inputMode)) {
                    this.commitChange();
                    this.fireDataChanged(1, n2);
                } else if (this.pressCount == 1) {
                    this.fireDataChanged(1, n2);
                } else {
                    this.fireDataChanged(2, n2);
                }
                return true;
            }
        }
        if (this.isChangeInputMode(n)) {
            for (c = '\u0000'; c < this.inputModeOrder.length; ++c) {
                if (!this.inputModeOrder[c].equals(this.inputMode)) continue;
                if (++c < this.inputModeOrder.length) {
                    this.setInputMode(this.inputModeOrder[c]);
                } else {
                    this.setInputMode(this.inputModeOrder[0]);
                }
                return true;
            }
            return true;
        }
        if (bl2) {
            if (bl) {
                this.setText("");
                this.commitChange();
            } else {
                this.deleteChar();
            }
            return true;
        }
        if (this.isSymbolDialogKey(n)) {
            this.showSymbolDialog();
            return true;
        }
        return false;
    }

    public void insertChars(String string) {
        String string2 = this.getText();
        if (!this.validChar(string)) {
            return;
        }
        int n = this.getCursorPosition() + 1;
        if (this.overwriteMode && n <= string2.length()) {
            this.setText(string2.substring(0, n - 1) + string + string2.substring(n, string2.length()));
        } else {
            if (string2.length() + string.length() > this.getMaxSize()) {
                return;
            }
            this.setText(string2.substring(0, n - 1) + string + string2.substring(n - 1, string2.length()));
        }
        if (string.length() > 1) {
            this.setCursorPosition(n += string.length() - 1);
            return;
        }
        this.increaseCursor();
    }

    public boolean validChar(String string) {
        return !(this.getConstraint() == 2 ? string.charAt(0) < '0' || string.charAt(0) > '9' : (this.getConstraint() == 3 ? (string.charAt(0) < '0' || string.charAt(0) > '9') && string.charAt(0) != '+' : this.getConstraint() == 5 && (string.charAt(0) < '0' || string.charAt(0) > '9') && string.charAt(0) != '+' && string.charAt(0) != '-' && string.charAt(0) != '.'));
    }

    protected void showSymbolDialog() {
        Command command = new Command(UIManager.getInstance().localize("cancel", "Cancel"));
        Command command2 = Dialog.show(null, this.createSymbolTable(), new Command[]{command});
        if (command2 != null && command2 != command) {
            this.insertChars(command2.getCommandName());
        }
    }

    protected Container createSymbolTable() {
        char[] cArray = TextField.getSymbolTable();
        Container container = new Container(new GridLayout(cArray.length / 5, 5));
        for (int i = 0; i < cArray.length; ++i) {
            Button button = new Button(new Command("" + cArray[i]));
            button.setAlignment(4);
            container.addComponent(button);
        }
        return container;
    }

    public void keyReleased(int n) {
        if (!this.isEditable()) {
            return;
        }
        this.pressedAndNotReleased = false;
        this.releaseTime = System.currentTimeMillis();
        if (!this.longClick && this.keyReleaseOrLongClick(n, false)) {
            return;
        }
        this.longClick = false;
        super.keyReleased(n);
    }

    protected int getLongClickDuration() {
        return 800;
    }

    public static char[] getSymbolTable() {
        return symbolTable;
    }

    public static void setSymbolTable(char[] cArray) {
        symbolTable = cArray;
    }

    protected boolean isCursorPositionCycle() {
        return true;
    }

    protected boolean isSymbolDialogKey(int n) {
        return n == defaultSymbolDialogKey;
    }

    protected void deinitialize() {
        this.getComponentForm().deregisterAnimated(this);
        if (this.handlesInput()) {
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form form = this.getComponentForm();
                if (form != null) {
                    form.setClearCommand(this.originalClearCommand);
                }
                this.originalClearCommand = null;
            }
            this.pressedAndNotReleased = false;
            this.setHandlesInput(false);
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        if (!bl && this.handlesInput()) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form form = this.getComponentForm();
                form.setClearCommand(this.originalClearCommand);
                this.originalClearCommand = null;
            }
            this.pressedAndNotReleased = false;
        }
    }

    public void keyRepeated(int n) {
        if (this.isQwertyInput()) {
            super.keyRepeated(n);
        }
    }

    public void keyPressed(int n) {
        if (!this.isEditable()) {
            return;
        }
        this.pressedAndNotReleased = true;
        this.pressedKeyCode = n;
        this.pressTime = System.currentTimeMillis();
        if (qwertyAutoDetect && !this.qwerty && (n >= 97 && n <= 122 || n >= 65 && n <= 90)) {
            qwertyDevice = true;
            this.qwerty = true;
        }
        if (!this.handlesInput() && this.isEditingTrigger(n)) {
            this.setHandlesInput(true);
            if (this.useSoftkeys) {
                this.T9_COMMAND.setDisposesDialog(false);
                this.DELETE_COMMAND.setDisposesDialog(false);
                this.originalClearCommand = this.installCommands(this.DELETE_COMMAND, this.T9_COMMAND);
            } else {
                Form form = this.getComponentForm();
                if (form != null) {
                    this.originalClearCommand = form.getClearCommand();
                    form.setClearCommand(this.DELETE_COMMAND);
                }
            }
            return;
        }
        this.moveCursor(Display.getInstance().getGameAction(n));
        if (this.handlesInput() && this.isEditingEndTrigger(n)) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form form = this.getComponentForm();
                if (form != null) {
                    form.setClearCommand(this.originalClearCommand);
                    this.originalClearCommand = null;
                }
            }
            this.fireActionEvent();
            return;
        }
        if (this.handlesInput()) {
            return;
        }
        super.keyPressed(n);
    }

    protected Command installCommands(Command command, Command command2) {
        Form form = this.getComponentForm();
        if (form != null) {
            Command command3 = form.getClearCommand();
            if (command3 instanceof CommandHandler) {
                command3 = this.originalClearCommand;
            }
            if (this.replaceMenu && this.originalCommands == null) {
                this.originalCommands = new Command[form.getCommandCount()];
                for (int i = 0; i < this.originalCommands.length; ++i) {
                    this.originalCommands[i] = form.getCommand(i);
                }
                form.removeAllCommands();
                if (Display.getInstance().isThirdSoftButton()) {
                    this.getComponentForm().getMenuBar().addSelectCommand(this.getSelectCommandText());
                    this.selectCommand = this.getComponentForm().getCommand(0);
                }
            }
            form.addCommand(command, 0);
            form.addCommand(command2, 0);
            form.setClearCommand(command);
            return command3;
        }
        return null;
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    protected void fireClicked() {
        if (!this.handlesInput()) {
            this.setHandlesInput(true);
            if (this.useSoftkeys) {
                this.T9_COMMAND.setDisposesDialog(false);
                this.DELETE_COMMAND.setDisposesDialog(false);
                this.originalClearCommand = this.installCommands(this.DELETE_COMMAND, this.T9_COMMAND);
            } else {
                Form form = this.getComponentForm();
                this.originalClearCommand = form.getClearCommand();
                form.setClearCommand(this.DELETE_COMMAND);
            }
            return;
        }
        if (this.handlesInput()) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form form = this.getComponentForm();
                form.setClearCommand(this.originalClearCommand);
                this.originalClearCommand = null;
            }
            this.fireActionEvent();
            return;
        }
        if (this.handlesInput()) {
            return;
        }
    }

    protected void removeCommands(Command command, Command command2, Command command3) {
        Form form = this.getComponentForm();
        if (form != null) {
            form.removeCommand(command);
            form.removeCommand(command2);
            if (this.selectCommand != null) {
                form.removeCommand(this.selectCommand);
            }
            form.setClearCommand(this.originalClearCommand);
            if (this.replaceMenu && this.originalCommands != null) {
                for (int i = this.originalCommands.length - 1; i >= 0; --i) {
                    form.addCommand(this.originalCommands[i]);
                }
                this.originalCommands = null;
            }
        }
    }

    void focusLostInternal() {
        this.stopComponentLableTicker();
        if (this.handlesInput() || this.pressedAndNotReleased || this.pendingCommit) {
            this.setHandlesInput(false);
            Form form = this.getComponentForm();
            if (form != null) {
                if (this.useSoftkeys) {
                    this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
                } else {
                    form.setClearCommand(this.originalClearCommand);
                }
            }
            this.releaseTime = System.currentTimeMillis();
            this.commitChange();
            this.pressedAndNotReleased = false;
            this.longClick = false;
        }
        Display.getInstance().setShowVirtualKeyboard(false);
    }

    void focusGainedInternal() {
        this.startComponentLableTicker();
        this.releaseTime = System.currentTimeMillis();
        this.pressedAndNotReleased = false;
        this.longClick = false;
    }

    protected boolean isEditingTrigger(int n) {
        if (!this.isEditable()) {
            return false;
        }
        int n2 = Display.getInstance().getGameAction(n);
        if (this.isQwertyInput()) {
            return n > 0 || n2 == 8 || this.isClearKey(n) || this.isEnterKey(n) || this.leftAndRightEditingTrigger && (n2 == 2 || n2 == 5);
        }
        return n >= 48 && n <= 57 || this.isClearKey(n) || n2 == 8 || this.leftAndRightEditingTrigger && (n2 == 2 || n2 == 5);
    }

    protected boolean isEditingEndTrigger(int n) {
        int n2 = Display.getInstance().getGameAction(n);
        boolean bl = false;
        bl = this.isQwertyInput() ? (this.isSingleLineTextArea() ? n < 0 && (n2 == 8 || n2 == 1 || n2 == 6 || this.isEnterKey(n)) : n < 0 && n2 == 8) : (this.isSingleLineTextArea() ? n2 == 8 || n2 == 1 || n2 == 6 : n2 == 8);
        return bl;
    }

    public void paint(Graphics graphics) {
        UIManager.getInstance().getLookAndFeel().drawTextField(graphics, this);
        if (this.drawCursor && this.hasFocus() && this.isEditable()) {
            UIManager.getInstance().getLookAndFeel().drawTextFieldCursor(graphics, this);
        }
        this.paintHint(graphics);
    }

    protected Dimension calcPreferredSize() {
        if (this.isSingleLineTextArea()) {
            return UIManager.getInstance().getLookAndFeel().getTextFieldPreferredSize(this);
        }
        return UIManager.getInstance().getLookAndFeel().getTextAreaSize(this, true);
    }

    protected void initComponent() {
        boolean bl = this.isRTL();
        this.keyFwd = bl ? 2 : 5;
        this.keyBack = bl ? 5 : 2;
        this.getComponentForm().registerAnimated(this);
    }

    public void setCursorBlinkTimeOn(int n) {
        this.blinkOnTime = n;
    }

    public void setCursorBlinkTimeOff(int n) {
        this.blinkOffTime = n;
    }

    public int getCursorBlinkTimeOn() {
        return this.blinkOnTime;
    }

    public int getCursorBlinkTimeOff() {
        return this.blinkOffTime;
    }

    public boolean animate() {
        boolean bl = super.animate();
        if (this.hasFocus()) {
            long l = System.currentTimeMillis();
            if (this.drawCursor) {
                if (l - this.cursorBlinkTime > (long)this.blinkOnTime) {
                    this.cursorBlinkTime = l;
                    this.drawCursor = false;
                    return true;
                }
            } else if (l - this.cursorBlinkTime > (long)this.blinkOffTime) {
                this.cursorBlinkTime = l;
                this.drawCursor = true;
                return true;
            }
            if (this.pressedAndNotReleased) {
                if (l - this.pressTime >= (long)this.getLongClickDuration()) {
                    this.longClick(this.pressedKeyCode);
                }
            } else if (this.pendingCommit && l - this.releaseTime > (long)this.commitTimeout) {
                this.commitChange();
            }
        } else {
            this.drawCursor = false;
        }
        return bl;
    }

    public void pointerReleased(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getStyle().getFont().getHeight() + this.getRowsGap();
        this.cursorY = n4 = (n2 - this.getAbsoluteY()) / n5;
        this.cursorY = Math.min(this.cursorY, this.getLines() - 1);
        String string = this.getTextAt(this.cursorY);
        int n6 = string.length();
        int n7 = 0;
        Font font = this.getStyle().getFont();
        n -= this.getAbsoluteX();
        int n8 = 0;
        while (n8 < n6 && n > (n3 = font.substringWidth(string, 0, n8))) {
            n7 = n8++;
        }
        if (n7 == n6 - 1 && font.stringWidth(string) < n) {
            n7 = n6;
        }
        this.cursorX = n7;
        if (!this.isEditable()) {
            return;
        }
        if (!Display.getInstance().isVirtualKeyboardShowing()) {
            Display.getInstance().setShowVirtualKeyboard(true);
        }
        super.pointerReleased(n, n2);
    }

    public boolean isUseSoftkeys() {
        return this.useSoftkeys;
    }

    public void setUseSoftkeys(boolean bl) {
        this.useSoftkeys = bl;
    }

    public void addDataChangeListener(DataChangedListener dataChangedListener) {
        this.listeners.addListener(dataChangedListener);
    }

    public void removeDataChangeListener(DataChangedListener dataChangedListener) {
        this.listeners.removeListener(dataChangedListener);
    }

    private void fireDataChanged(int n, int n2) {
        if (this.listeners != null) {
            this.listeners.fireDataChangeEvent(n2, n);
        }
    }

    void onEditComplete(String string) {
        super.onEditComplete(string);
        this.setCursorPosition(string.length());
    }

    public boolean isReplaceMenu() {
        return this.replaceMenu;
    }

    public void setReplaceMenu(boolean bl) {
        this.replaceMenu = bl;
    }

    public static boolean isReplaceMenuDefault() {
        return replaceMenuDefault;
    }

    public static void setReplaceMenuDefault(boolean bl) {
        replaceMenuDefault = bl;
    }

    public static void setQwertyAutoDetect(boolean bl) {
        qwertyAutoDetect = bl;
    }

    public static void setQwertyDevice(boolean bl) {
        qwertyDevice = bl;
    }

    public static boolean isQwertyAutoDetect() {
        return qwertyAutoDetect;
    }

    public static boolean isQwertyDevice() {
        return qwertyDevice;
    }

    public static void setDefaultChangeInputModeKey(int n) {
        defaultChangeInputModeKey = n;
    }

    public static int getDefaultChangeInputModeKey() {
        return defaultChangeInputModeKey;
    }

    public static void setDefaultSymbolDialogKey(int n) {
        defaultSymbolDialogKey = n;
    }

    public static int getDefaultSymbolDialogKey() {
        return defaultSymbolDialogKey;
    }

    public void setOverwriteMode(boolean bl) {
        this.overwriteMode = bl;
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode;
    }

    public void setLeftAndRightEditingTrigger(boolean bl) {
        this.leftAndRightEditingTrigger = bl;
    }

    public boolean isLeftAndRightEditingTrigger() {
        return this.leftAndRightEditingTrigger;
    }

    public void setAlignment(int n) {
        if (n == 4) {
            throw new IllegalArgumentException("CENTER alignment is not supported in TextField.");
        }
        super.setAlignment(n);
    }

    static {
        defaultInputModeOrder = new String[]{"Abc", "ABC", "abc", "123"};
        firstUppercaseInputMode = new Vector();
        qwertyAutoDetect = true;
        defaultChangeInputModeKey = 35;
        defaultSymbolDialogKey = 42;
        DEFAULT_SYMBOL_TABLE = new char[]{'.', ',', '?', '!', '$', '@', '\'', '-', '_', ')', '(', ':', ';', '&', '/', '~', '\\', '%', '*', '#', '+', '>', '=', '<', '\"'};
        symbolTable = DEFAULT_SYMBOL_TABLE;
        DEFAULT_KEY_CODES = new String[]{" 0", ".,?!'\"1-()@/:_", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9"};
    }

    class CommandHandler
    extends Command {
        CommandHandler(String string, int n) {
            super(string, n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            actionEvent.consume();
            switch (this.getId()) {
                case 1: {
                    TextField.this.releaseTime = System.currentTimeMillis();
                    TextField.this.pressedAndNotReleased = false;
                    TextField.this.longClick = false;
                    TextField.this.deleteChar();
                    break;
                }
                case 2: {
                    actionEvent.consume();
                    TextField.this.editString();
                }
            }
        }
    }
}

