/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.UIManager;

public class CheckBox
extends Button {
    private boolean selected = false;

    public CheckBox(String string) {
        this(string, (Image)null);
    }

    public CheckBox() {
        this("");
    }

    public CheckBox(Image image) {
        this("", image);
    }

    public CheckBox(String string, Image image) {
        super(string, image);
        this.setUIID("CheckBox");
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public void released(int n, int n2) {
        this.selected = !this.isSelected();
        super.released(n, n2);
    }

    public void paint(Graphics graphics) {
        if (this.isToggle()) {
            UIManager.getInstance().getLookAndFeel().drawButton(graphics, this);
        } else {
            UIManager.getInstance().getLookAndFeel().drawCheckBox(graphics, this);
        }
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getCheckBoxPreferredSize(this);
    }

    protected String paramString() {
        return super.paramString() + ", selected = " + this.selected;
    }

    int getAvaliableSpaceForText() {
        Image[] imageArray;
        if (this.isToggle()) {
            return super.getAvaliableSpaceForText();
        }
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        if (lookAndFeel instanceof DefaultLookAndFeel && (imageArray = ((DefaultLookAndFeel)lookAndFeel).getCheckBoxImages()) != null) {
            int n = this.isSelected() ? 1 : 0;
            return super.getAvaliableSpaceForText() - imageArray[n].getWidth();
        }
        return super.getAvaliableSpaceForText() - (this.getHeight() + this.getGap());
    }
}

