/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.IndexedImage;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public class StaticAnimation
extends IndexedImage
implements Animation {
    private Frame[] frames;
    private int currentFrame;
    private long animationStartTime;
    private int totalAnimationTime;
    private boolean loop;

    StaticAnimation(int n, int n2, int[] nArray, byte[] byArray) {
        super(n, n2, nArray, byArray);
    }

    public int getFrameCount() {
        return this.frames.length + 1;
    }

    public int getFrameTime(int n) {
        if (n == 0) {
            return 0;
        }
        return this.frames[n - 1].time;
    }

    public int getTotalAnimationTime() {
        return this.totalAnimationTime;
    }

    public int[] getFrameRGB(int n) {
        if (n == 0) {
            return this.getRGBCached();
        }
        Frame frame = this.frames[n - 1];
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int[] nArray = new int[n3 * n2];
        byte[] byArray = frame.getKeyFrame();
        int[] nArray2 = this.getPalette();
        for (int i = 0; i < n2; ++i) {
            int n4;
            int n5;
            byte[] byArray2 = frame.getModifiedRow(i);
            if (byArray2 != null) {
                for (n5 = 0; n5 < n3; ++n5) {
                    n4 = byArray2[n5] & 0xFF;
                    nArray[n5 + n3 * i] = nArray2[n4];
                }
                continue;
            }
            n5 = i * n3;
            for (n4 = 0; n4 < n3; ++n4) {
                int n6 = byArray[n4 + n5] & 0xFF;
                nArray[n4 + n3 * i] = nArray2[n6];
            }
        }
        return nArray;
    }

    public static StaticAnimation createAnimation(DataInputStream dataInputStream) throws IOException {
        int n;
        byte by = dataInputStream.readByte();
        int[] nArray = new int[by & 0xFF];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = dataInputStream.readInt();
        }
        n = dataInputStream.readShort();
        short s = dataInputStream.readShort();
        int n2 = dataInputStream.readByte() & 0xFF;
        int n3 = Math.max(1, dataInputStream.readInt());
        boolean bl = dataInputStream.readBoolean();
        byte[] byArray = new byte[n * s];
        dataInputStream.readFully(byArray);
        StaticAnimation staticAnimation = new StaticAnimation(n, s, nArray, byArray);
        staticAnimation.frames = new Frame[n2 - 1];
        staticAnimation.totalAnimationTime = n3;
        staticAnimation.loop = bl;
        int n4 = 0;
        byte[] byArray2 = byArray;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<byte[]> vector2 = new Vector<byte[]>();
        for (int i = 1; i < n2; ++i) {
            n4 += dataInputStream.readInt();
            if (dataInputStream.readBoolean()) {
                byArray = new byte[n * s];
                dataInputStream.readFully(byArray);
                staticAnimation.frames[i - 1] = new Frame(n4, byArray);
                byArray2 = byArray;
                vector2.removeAllElements();
                vector.removeAllElements();
                continue;
            }
            boolean bl2 = dataInputStream.readBoolean();
            short s2 = dataInputStream.readShort();
            while (s2 != -1) {
                byte[] byArray3 = new byte[n];
                dataInputStream.readFully(byArray3);
                Integer n5 = new Integer(s2);
                int n6 = vector.indexOf(n5);
                if (n6 > -1) {
                    vector.removeElementAt(n6);
                    vector2.removeElementAt(n6);
                }
                vector.addElement(n5);
                vector2.addElement(byArray3);
                s2 = dataInputStream.readShort();
            }
            staticAnimation.frames[i - 1] = new Frame(n4, byArray2, vector, vector2, bl2);
        }
        return staticAnimation;
    }

    public boolean animate() {
        if (this.animationStartTime == 0L) {
            this.animationStartTime = System.currentTimeMillis();
            return false;
        }
        long l = System.currentTimeMillis();
        int n = (int)(l - this.animationStartTime);
        if (this.loop) {
            n %= this.totalAnimationTime;
        } else if (n > this.totalAnimationTime) {
            return false;
        }
        if (this.currentFrame == this.frames.length) {
            if (n >= this.totalAnimationTime || n < this.frames[this.frames.length - 1].getTime()) {
                this.currentFrame = 0;
                return true;
            }
        } else if (n >= this.frames[this.currentFrame].getTime()) {
            ++this.currentFrame;
            if (this.currentFrame > this.frames.length + 1) {
                this.currentFrame = 0;
            }
            return true;
        }
        return false;
    }

    public void restart() {
        this.animationStartTime = System.currentTimeMillis();
    }

    public void paint(Graphics graphics) {
        this.drawImage(graphics, graphics.getGraphics(), 0, 0);
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
    }

    protected void drawImage(Graphics graphics, Object object, int n, int n2) {
        if (this.currentFrame == 0) {
            super.drawImage(graphics, object, n, n2);
            return;
        }
        int n3 = this.getWidth();
        if (lineCache == null || lineCache.length < n3) {
            lineCache = new int[n3];
        }
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipHeight() + n4;
        int n6 = 0;
        int n7 = this.getHeight();
        if (n4 > n2) {
            n6 = n4 - n2;
        }
        if (n5 < n2 + this.getHeight()) {
            n7 = n5 - n2;
        }
        Frame frame = this.frames[this.currentFrame - 1];
        byte[] byArray = frame.getKeyFrame();
        int[] nArray = this.getPalette();
        for (int i = n6; i < n7; ++i) {
            int n8;
            int n9;
            byte[] byArray2 = frame.getModifiedRow(i);
            if (byArray2 != null) {
                for (n9 = 0; n9 < n3; ++n9) {
                    n8 = byArray2[n9] & 0xFF;
                    StaticAnimation.lineCache[n9] = nArray[n8];
                }
            } else {
                n9 = i * n3;
                for (n8 = 0; n8 < n3; ++n8) {
                    int n10 = byArray[n8 + n9] & 0xFF;
                    StaticAnimation.lineCache[n8] = nArray[n10];
                }
            }
            graphics.drawRGB(lineCache, 0, n, n2 + i, n3, 1, true);
        }
    }

    public void scale(int n, int n2) {
        StaticAnimation staticAnimation = (StaticAnimation)this.scaled(n, n2);
        super.scale(n, n2);
        this.frames = staticAnimation.frames;
    }

    public Image scaled(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        if (n3 == n && n4 == n2) {
            return this;
        }
        byte[] byArray = this.getImageDataByte();
        StaticAnimation staticAnimation = new StaticAnimation(n, n2, this.getPalette(), this.scaleArray(byArray, n, n2));
        staticAnimation.loop = this.loop;
        staticAnimation.totalAnimationTime = this.totalAnimationTime;
        staticAnimation.animationStartTime = this.animationStartTime;
        staticAnimation.currentFrame = this.currentFrame;
        staticAnimation.frames = new Frame[this.frames.length];
        byte[] byArray2 = staticAnimation.getImageDataByte();
        int n5 = (n4 << 16) / n2;
        int n6 = (n3 << 16) / n;
        for (int i = 0; i < this.frames.length; ++i) {
            byte[] byArray3 = this.frames[i].getKeyFrame();
            if (byArray3 != byArray) {
                byArray = byArray3;
                byArray3 = this.scaleArray(byArray3, n, n2);
                byArray2 = byArray3;
            }
            staticAnimation.frames[i] = new Frame(this.frames[i].getTime(), byArray2, this.frames[i], n6, n5, n, n2);
        }
        return staticAnimation;
    }

    public boolean isAnimation() {
        return true;
    }

    boolean isKeyframe(int n) {
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            return this.frames[n - 1].getKeyFrame() != this.imageDataByte;
        }
        return this.frames[n - 1].getKeyFrame() != this.frames[n - 2].getKeyFrame();
    }

    byte[] getKeyframe(int n) {
        return this.frames[n - 1].getKeyFrame();
    }

    boolean isDrawPrevious(int n) {
        return this.frames[n - 1].isDrawPrevious();
    }

    byte[][] getModifiedRows(int n) {
        return this.frames[n - 1].modifiedRows;
    }

    int[] getModifiedRowOffsets(int n) {
        return this.frames[n - 1].modifiedRowOffsets;
    }

    Rectangle getDirtyRegion() {
        int n = this.currentFrame;
        if (n == 0) {
            return null;
        }
        if (n == this.frames.length) {
            n = 0;
        }
        Rectangle rectangle = new Rectangle(0, this.frames[n].smallestChangedRow, new Dimension(this.getWidth(), this.frames[n].highestChangedRow - this.frames[n].smallestChangedRow));
        return rectangle;
    }

    static class Frame {
        private int time;
        private byte[] keyFrame;
        byte[][] modifiedRows;
        int[] modifiedRowOffsets;
        private boolean drawPrevious;
        int smallestChangedRow;
        int highestChangedRow;

        public Frame(int n, byte[] byArray, Vector vector, Vector vector2, boolean bl) {
            this.time = n;
            this.keyFrame = byArray;
            this.drawPrevious = bl;
            this.initArrays(vector, vector2);
        }

        private void initArrays(Vector vector, Vector vector2) {
            int n;
            this.modifiedRowOffsets = new int[vector.size()];
            this.modifiedRows = new byte[this.modifiedRowOffsets.length][];
            for (n = 0; n < this.modifiedRowOffsets.length; ++n) {
                this.modifiedRowOffsets[n] = (Integer)vector.elementAt(n);
                this.modifiedRows[n] = (byte[])vector2.elementAt(n);
            }
            this.smallestChangedRow = this.modifiedRowOffsets[0];
            this.highestChangedRow = this.modifiedRowOffsets[0];
            for (n = 1; n < this.modifiedRowOffsets.length; ++n) {
                this.smallestChangedRow = Math.min(this.smallestChangedRow, this.modifiedRowOffsets[n]);
                this.highestChangedRow = Math.max(this.highestChangedRow, this.modifiedRowOffsets[n]);
            }
        }

        public Frame(int n, byte[] byArray) {
            this.time = n;
            this.keyFrame = byArray;
            this.modifiedRowOffsets = new int[0];
        }

        public Frame(int n, byte[] byArray, Frame frame, int n2, int n3, int n4, int n5) {
            this.time = n;
            this.keyFrame = byArray;
            if (frame.modifiedRowOffsets.length == 0) {
                this.modifiedRowOffsets = frame.modifiedRowOffsets;
                return;
            }
            Vector<Integer> vector = new Vector<Integer>();
            Vector<byte[]> vector2 = new Vector<byte[]>();
            int n6 = n2 / 2;
            int n7 = n3 / 2;
            for (int i = 0; i < n5; ++i) {
                int n8 = n7 >> 16;
                int n9 = -1;
                for (int j = 0; j < frame.modifiedRowOffsets.length; ++j) {
                    if (frame.modifiedRowOffsets[j] != n8) continue;
                    n9 = j;
                    break;
                }
                if (n9 != -1) {
                    byte[] byArray2 = new byte[n4];
                    for (int j = 0; j < n4; ++j) {
                        int n10 = n6 >> 16;
                        byArray2[j] = frame.modifiedRows[n9][n10];
                        n6 += n2;
                    }
                    vector.addElement(new Integer(i));
                    vector2.addElement(byArray2);
                }
                n7 += n3;
                n6 = n2 / 2;
            }
            this.initArrays(vector, vector2);
        }

        public boolean isDrawPrevious() {
            return this.drawPrevious;
        }

        public int getTime() {
            return this.time;
        }

        private byte[] getModifiedRow(int n) {
            for (int i = 0; i < this.modifiedRowOffsets.length; ++i) {
                if (this.modifiedRowOffsets[i] != n) continue;
                return this.modifiedRows[i];
            }
            return null;
        }

        private byte[] getKeyFrame() {
            return this.keyFrame;
        }

        private void setKeyFrame(byte[] byArray) {
            this.keyFrame = byArray;
        }
    }
}

