/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.list;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.list.CellRenderer;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.UIManager;
import java.util.Hashtable;

public class DefaultListCellRenderer
extends Label
implements ListCellRenderer,
CellRenderer {
    private boolean showNumbers;
    private static boolean showNumbersDefault = true;
    private Label focusComponent = new Label();

    public DefaultListCellRenderer() {
        super("");
        this.setCellRenderer(true);
        this.setEndsWith3Points(false);
        this.showNumbers = UIManager.getInstance().isThemeConstant("rendererShowsNumbersBool", showNumbersDefault);
        this.focusComponent.setUIID("ListRendererFocus");
        this.focusComponent.setFocus(true);
        this.setUIID("ListRenderer");
    }

    public void refreshTheme() {
        super.refreshTheme();
        this.focusComponent.refreshTheme();
    }

    public DefaultListCellRenderer(boolean bl) {
        this();
        this.showNumbers = bl;
    }

    public Component getCellRendererComponent(Component component, Object object, Object object2, int n, boolean bl) {
        if (!Display.getInstance().shouldRenderSelection()) {
            bl = false;
        }
        this.setFocus(bl);
        if (this.showNumbers) {
            Object v;
            String string = "" + object2;
            Hashtable hashtable = UIManager.getInstance().getResourceBundle();
            if (hashtable != null && object2 != null && (v = hashtable.get(object2.toString())) != null) {
                string = (String)v;
            }
            if (this.isRTL()) {
                this.setText(string + " ." + (n + 1));
            } else {
                this.setText("" + (n + 1) + ". " + string);
            }
        } else if (object2 != null) {
            this.setText(object2.toString());
        } else {
            this.setText("null");
        }
        if (object2 instanceof Command) {
            this.setIcon(((Command)object2).getIcon());
            this.setEnabled(((Command)object2).isEnabled());
        }
        return this;
    }

    public Component getListCellRendererComponent(List list, Object object, int n, boolean bl) {
        return this.getCellRendererComponent(list, list.getModel(), object, n, bl);
    }

    public Component getListFocusComponent(List list) {
        return this.focusComponent;
    }

    public void repaint() {
    }

    public boolean isShowNumbers() {
        return this.showNumbers;
    }

    public void setShowNumbers(boolean bl) {
        this.showNumbers = bl;
    }

    public int getSelectionTransparency() {
        return this.focusComponent.getUnselectedStyle().getBgTransparency() & 0xFF;
    }

    public void setSelectionTransparency(int n) {
        this.focusComponent.getUnselectedStyle().setBgTransparency(n);
    }

    public static void setShowNumbersDefault(boolean bl) {
        showNumbersDefault = bl;
    }

    public static boolean isShowNumbersDefault() {
        return showNumbersDefault;
    }

    public Component getFocusComponent(Component component) {
        return this.focusComponent;
    }
}

