/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;

public class Style {
    public static final String BG_COLOR = "bgColor";
    public static final String FG_COLOR = "fgColor";
    public static final String BG_IMAGE = "bgImage";
    public static final String BACKGROUND_TYPE = "bgType";
    public static final String BACKGROUND_ALIGNMENT = "bgAlign";
    public static final String BACKGROUND_GRADIENT = "bgGradient";
    public static final String FONT = "font";
    public static final String TRANSPARENCY = "transparency";
    public static final String MARGIN = "margin";
    public static final String BORDER = "border";
    public static final String PADDING = "padding";
    public static final String PAINTER = "painter";
    public static final String ALIGNMENT = "align";
    public static final String TEXT_DECORATION = "textDecoration";
    public static final byte BACKGROUND_NONE = 0;
    public static final byte BACKGROUND_IMAGE_SCALED = 1;
    public static final byte BACKGROUND_IMAGE_TILE_BOTH = 2;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL = 3;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL = 4;
    public static final byte BACKGROUND_IMAGE_ALIGNED = 5;
    public static final byte BACKGROUND_IMAGE_ALIGNED_TOP = 20;
    public static final byte BACKGROUND_IMAGE_ALIGNED_BOTTOM = 21;
    public static final byte BACKGROUND_IMAGE_ALIGNED_LEFT = 22;
    public static final byte BACKGROUND_IMAGE_ALIGNED_RIGHT = 23;
    public static final byte BACKGROUND_IMAGE_ALIGNED_CENTER = 24;
    public static final byte BACKGROUND_IMAGE_ALIGNED_TOP_LEFT = 25;
    public static final byte BACKGROUND_IMAGE_ALIGNED_TOP_RIGHT = 26;
    public static final byte BACKGROUND_IMAGE_ALIGNED_BOTTOM_LEFT = 27;
    public static final byte BACKGROUND_IMAGE_ALIGNED_BOTTOM_RIGHT = 28;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL_ALIGN_TOP = 4;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL_ALIGN_CENTER = 29;
    public static final byte BACKGROUND_IMAGE_TILE_HORIZONTAL_ALIGN_BOTTOM = 30;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL_ALIGN_LEFT = 3;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL_ALIGN_CENTER = 31;
    public static final byte BACKGROUND_IMAGE_TILE_VERTICAL_ALIGN_RIGHT = 32;
    public static final byte BACKGROUND_GRADIENT_LINEAR_VERTICAL = 6;
    public static final byte BACKGROUND_GRADIENT_LINEAR_HORIZONTAL = 7;
    public static final byte BACKGROUND_GRADIENT_RADIAL = 8;
    public static final byte BACKGROUND_IMAGE_ALIGN_TOP = -95;
    public static final byte BACKGROUND_IMAGE_ALIGN_BOTTOM = -94;
    public static final byte BACKGROUND_IMAGE_ALIGN_LEFT = -93;
    public static final byte BACKGROUND_IMAGE_ALIGN_RIGHT = -92;
    public static final byte BACKGROUND_IMAGE_ALIGN_CENTER = -91;
    public static final byte TEXT_DECORATION_NONE = 0;
    public static final byte TEXT_DECORATION_UNDERLINE = 1;
    public static final byte TEXT_DECORATION_STRIKETHRU = 2;
    public static final byte TEXT_DECORATION_OVERLINE = 4;
    private int fgColor = 0;
    private int bgColor = 0xFFFFFF;
    private Font font = Font.getDefaultFont();
    private Image bgImage;
    private int[] padding = new int[4];
    private int[] margin = new int[4];
    private byte transparency = (byte)-1;
    private Painter bgPainter;
    private byte backgroundType = 1;
    private byte backgroundAlignment = (byte)-95;
    private Object[] backgroundGradient;
    private Border border = null;
    private int align = 1;
    private int textDecoration;
    private int modifiedFlag;
    private static final int FG_COLOR_MODIFIED = 1;
    private static final int BG_COLOR_MODIFIED = 2;
    private static final int FONT_MODIFIED = 16;
    private static final int BG_IMAGE_MODIFIED = 32;
    private static final int TRANSPARENCY_MODIFIED = 128;
    private static final int PADDING_MODIFIED = 256;
    private static final int MARGIN_MODIFIED = 512;
    private static final int BORDER_MODIFIED = 1024;
    private static final int BACKGROUND_TYPE_MODIFIED = 2048;
    private static final int BACKGROUND_ALIGNMENT_MODIFIED = 4096;
    private static final int BACKGROUND_GRADIENT_MODIFIED = 8192;
    private static final int ALIGNMENT_MODIFIED = 16384;
    private static final int TEXT_DECORATION_MODIFIED = 64;
    private EventDispatcher listeners;
    Object roundRectCache;

    public Style() {
        this.setPadding(3, 3, 3, 3);
        this.setMargin(2, 2, 2, 2);
        this.modifiedFlag = 0;
    }

    public Style(Style style) {
        this(style.getFgColor(), style.getBgColor(), 0, 0, style.getFont(), style.getBgTransparency(), style.getBgImage(), true);
        this.setPadding(style.padding[0], style.padding[2], style.padding[1], style.padding[3]);
        this.setMargin(style.margin[0], style.margin[2], style.margin[1], style.margin[3]);
        this.setBorder(style.getBorder());
        this.modifiedFlag = 0;
        this.align = style.align;
        this.backgroundType = style.backgroundType;
        this.backgroundAlignment = style.backgroundAlignment;
        this.textDecoration = style.textDecoration;
        if (style.backgroundGradient != null) {
            this.backgroundGradient = new Object[style.backgroundGradient.length];
            System.arraycopy(style.backgroundGradient, 0, this.backgroundGradient, 0, this.backgroundGradient.length);
        }
    }

    public Style(int n, int n2, Font font, byte by) {
        this(n, n2, font, by, null, 1);
    }

    private Style(int n, int n2, int n3, int n4, Font font, byte by, Image image, boolean bl) {
        this();
        this.fgColor = n;
        this.bgColor = n2;
        this.font = font;
        this.transparency = by;
        this.bgImage = image;
    }

    public Style(int n, int n2, Font font, byte by, Image image, byte by2) {
        this();
        this.fgColor = n;
        this.bgColor = n2;
        this.font = font;
        this.transparency = by;
        this.backgroundType = by2;
        this.bgImage = image;
    }

    public void merge(Style style) {
        int n = this.modifiedFlag;
        if ((this.modifiedFlag & 1) == 0) {
            this.setFgColor(style.getFgColor());
        }
        if ((this.modifiedFlag & 2) == 0) {
            this.setBgColor(style.getBgColor());
        }
        if ((this.modifiedFlag & 0x20) == 0) {
            this.setBgImage(style.getBgImage());
        }
        if ((this.modifiedFlag & 0x800) == 0) {
            this.setBackgroundType(style.getBackgroundType());
        }
        if ((this.modifiedFlag & 0x1000) == 0) {
            this.setBackgroundAlignment(style.getBackgroundAlignment());
        }
        if ((this.modifiedFlag & 0x2000) == 0) {
            this.setBackgroundGradientStartColor(style.getBackgroundGradientStartColor());
            this.setBackgroundGradientEndColor(style.getBackgroundGradientEndColor());
            this.setBackgroundGradientRelativeX(style.getBackgroundGradientRelativeX());
            this.setBackgroundGradientRelativeY(style.getBackgroundGradientRelativeY());
            this.setBackgroundGradientRelativeSize(style.getBackgroundGradientRelativeSize());
        }
        if ((this.modifiedFlag & 0x10) == 0) {
            this.setFont(style.getFont());
        }
        if ((this.modifiedFlag & 0x80) == 0) {
            this.setBgTransparency(style.getBgTransparency());
        }
        if ((this.modifiedFlag & 0x100) == 0) {
            this.setPadding(style.padding[0], style.padding[2], style.padding[1], style.padding[3]);
        }
        if ((this.modifiedFlag & 0x200) == 0) {
            this.setMargin(style.margin[0], style.margin[2], style.margin[1], style.margin[3]);
        }
        if ((this.modifiedFlag & 0x400) == 0) {
            this.setBorder(style.getBorder());
        }
        if ((this.modifiedFlag & 0x40) == 0) {
            this.setTextDecoration(style.getTextDecoration());
        }
        if ((this.modifiedFlag & 0x4000) == 0) {
            this.setAlignment(style.getAlignment());
        }
        this.bgPainter = style.bgPainter;
        this.modifiedFlag = n;
    }

    public boolean isModified() {
        return this.modifiedFlag != 0;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public Image getBgImage() {
        return this.bgImage;
    }

    public byte getBackgroundType() {
        return this.backgroundType;
    }

    public byte getBackgroundAlignment() {
        return this.backgroundAlignment;
    }

    public int getBackgroundGradientStartColor() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 1) {
            return (Integer)this.backgroundGradient[0];
        }
        return 0xFFFFFF;
    }

    public int getBackgroundGradientEndColor() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 1) {
            return (Integer)this.backgroundGradient[1];
        }
        return 0;
    }

    public float getBackgroundGradientRelativeX() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 2) {
            return ((Float)this.backgroundGradient[2]).floatValue();
        }
        return 0.5f;
    }

    public float getBackgroundGradientRelativeY() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 3) {
            return ((Float)this.backgroundGradient[3]).floatValue();
        }
        return 0.5f;
    }

    public float getBackgroundGradientRelativeSize() {
        if (this.backgroundGradient != null && this.backgroundGradient.length > 4) {
            return ((Float)this.backgroundGradient[4]).floatValue();
        }
        return 1.0f;
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public Font getFont() {
        return this.font;
    }

    public void setBgColor(int n) {
        this.setBgColor(n, false);
    }

    public void setAlignment(int n) {
        this.setAlignment(n, false);
    }

    public void setAlignment(int n, boolean bl) {
        if (this.align != n) {
            this.align = n;
            if (!bl) {
                this.modifiedFlag |= 0x4000;
            }
            this.firePropertyChanged(ALIGNMENT);
        }
    }

    public int getAlignment() {
        return this.align;
    }

    public void setBgImage(Image image) {
        this.setBgImage(image, false);
    }

    public void setBackgroundType(byte by) {
        this.setBackgroundType(by, false);
    }

    public void setBackgroundAlignment(byte by) {
        this.setBackgroundAlignment(by, false);
    }

    public void setBackgroundGradientStartColor(int n) {
        this.setBackgroundGradientStartColor(n, false);
    }

    public void setBackgroundGradientEndColor(int n) {
        this.setBackgroundGradientEndColor(n, false);
    }

    public void setBackgroundGradientRelativeX(float f) {
        this.setBackgroundGradientRelativeX(f, false);
    }

    public void setBackgroundGradientRelativeY(float f) {
        this.setBackgroundGradientRelativeY(f, false);
    }

    public void setBackgroundGradientRelativeSize(float f) {
        this.setBackgroundGradientRelativeSize(f, false);
    }

    public void setFgColor(int n) {
        this.setFgColor(n, false);
    }

    public void setFont(Font font) {
        this.setFont(font, false);
    }

    public void setUnderline(boolean bl) {
        if (bl != this.isUnderline()) {
            this.textDecoration = bl ? (this.textDecoration |= 1) : --this.textDecoration;
        }
    }

    public boolean isUnderline() {
        return (this.textDecoration & 1) != 0;
    }

    public void setOverline(boolean bl) {
        if (bl != this.isOverline()) {
            this.textDecoration = bl ? (this.textDecoration |= 4) : (this.textDecoration -= 4);
        }
    }

    public boolean isOverline() {
        return (this.textDecoration & 4) != 0;
    }

    public void setStrikeThru(boolean bl) {
        if (bl != this.isStrikeThru()) {
            this.textDecoration = bl ? (this.textDecoration |= 2) : (this.textDecoration -= 2);
        }
    }

    public boolean isStrikeThru() {
        return (this.textDecoration & 2) != 0;
    }

    public int getTextDecoration() {
        return this.textDecoration;
    }

    public void setTextDecoration(int n) {
        this.setTextDecoration(n, false);
    }

    public void setTextDecoration(int n, boolean bl) {
        this.textDecoration = n;
        if (this.textDecoration != n) {
            this.textDecoration = n;
            if (!bl) {
                this.modifiedFlag |= 0x40;
            }
            this.firePropertyChanged(TEXT_DECORATION);
        }
    }

    public byte getBgTransparency() {
        if (this.bgImage != null && this.backgroundType <= 2 && (this.bgImage.isAnimation() || this.bgImage.isOpaque())) {
            return -1;
        }
        return this.transparency;
    }

    public void setBgTransparency(byte by) {
        this.setBgTransparency(by & 0xFF, false);
    }

    public void setBgTransparency(int n) {
        this.setBgTransparency(n, false);
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        if (n < 0 || n3 < 0 || n4 < 0 || n2 < 0) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[0] != n || this.padding[2] != n2 || this.padding[1] != n3 || this.padding[3] != n4) {
            this.padding[0] = n;
            this.padding[2] = n2;
            this.padding[1] = n3;
            this.padding[3] = n4;
            this.modifiedFlag |= 0x100;
            this.firePropertyChanged(PADDING);
        }
    }

    public void setPadding(int n, int n2) {
        this.setPadding(n, n2, false);
    }

    public void setMargin(int n, int n2, int n3, int n4) {
        if (n < 0 || n3 < 0 || n4 < 0 || n2 < 0) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        if (this.margin[0] != n || this.margin[2] != n2 || this.margin[1] != n3 || this.margin[3] != n4) {
            this.margin[0] = n;
            this.margin[2] = n2;
            this.margin[1] = n3;
            this.margin[3] = n4;
            this.modifiedFlag |= 0x200;
            this.firePropertyChanged(MARGIN);
        }
    }

    public void setMargin(int n, int n2) {
        this.setMargin(n, n2, false);
    }

    public int getPadding(boolean bl, int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("wrong orientation " + n);
        }
        if (bl) {
            switch (n) {
                case 1: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 1;
                }
            }
        }
        return this.padding[n];
    }

    public int getPadding(int n) {
        return this.getPadding(UIManager.getInstance().getLookAndFeel().isRTL(), n);
    }

    public int getMargin(int n) {
        return this.getMargin(UIManager.getInstance().getLookAndFeel().isRTL(), n);
    }

    public int getMargin(boolean bl, int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("wrong orientation " + n);
        }
        if (bl) {
            switch (n) {
                case 1: {
                    n = 3;
                    break;
                }
                case 3: {
                    n = 1;
                }
            }
        }
        return this.margin[n];
    }

    public void setBgColor(int n, boolean bl) {
        if (this.bgColor != n) {
            this.bgColor = n;
            if (!bl) {
                this.modifiedFlag |= 2;
            }
            this.firePropertyChanged(BG_COLOR);
        }
    }

    public void setBgImage(Image image, boolean bl) {
        if (this.bgImage != image) {
            this.bgImage = image;
            if (!bl) {
                this.modifiedFlag |= 0x20;
            }
            this.firePropertyChanged(BG_IMAGE);
        }
    }

    public void setBackgroundType(byte by, boolean bl) {
        if (this.backgroundType != by) {
            this.backgroundType = by;
            if (!bl) {
                this.modifiedFlag |= 0x800;
            }
            this.firePropertyChanged(BACKGROUND_TYPE);
        }
    }

    public void setBackgroundAlignment(byte by, boolean bl) {
        if (this.backgroundAlignment != by) {
            this.backgroundAlignment = by;
            if (!bl) {
                this.modifiedFlag |= 0x1000;
            }
            this.firePropertyChanged(BACKGROUND_ALIGNMENT);
        }
    }

    Object[] getBackgroundGradient() {
        if (this.backgroundGradient == null) {
            Float f = new Float(0.5f);
            this.backgroundGradient = new Object[]{new Integer(0xFFFFFF), new Integer(0), f, f, new Float(1.0f)};
        }
        return this.backgroundGradient;
    }

    void setBackgroundGradient(Object[] objectArray) {
        this.backgroundGradient = objectArray;
    }

    public void setBackgroundGradientStartColor(int n, boolean bl) {
        if ((Integer)this.getBackgroundGradient()[0] != n) {
            this.getBackgroundGradient()[0] = new Integer(n);
            if (!bl) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientEndColor(int n, boolean bl) {
        if ((Integer)this.getBackgroundGradient()[1] != n) {
            this.getBackgroundGradient()[1] = new Integer(n);
            if (!bl) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeX(float f, boolean bl) {
        if (((Float)this.getBackgroundGradient()[2]).floatValue() != f) {
            this.getBackgroundGradient()[2] = new Float(f);
            if (!bl) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeY(float f, boolean bl) {
        if (((Float)this.getBackgroundGradient()[3]).floatValue() != f) {
            this.getBackgroundGradient()[3] = new Float(f);
            if (!bl) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setBackgroundGradientRelativeSize(float f, boolean bl) {
        if (((Float)this.getBackgroundGradient()[4]).floatValue() != f) {
            this.getBackgroundGradient()[4] = new Float(f);
            if (!bl) {
                this.modifiedFlag |= 0x2000;
            }
            this.firePropertyChanged(BACKGROUND_GRADIENT);
        }
    }

    public void setFgColor(int n, boolean bl) {
        if (this.fgColor != n) {
            this.fgColor = n;
            if (!bl) {
                this.modifiedFlag |= 1;
            }
            this.firePropertyChanged(FG_COLOR);
        }
    }

    public void setFont(Font font, boolean bl) {
        if (this.font == null && font != null || this.font != null && !this.font.equals(font)) {
            this.font = font;
            if (!bl) {
                this.modifiedFlag |= 0x10;
            }
            this.firePropertyChanged(FONT);
        }
    }

    public void setBgTransparency(int n, boolean bl) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("valid values are between 0-255");
        }
        if (this.transparency != (byte)n) {
            this.transparency = (byte)n;
            if (!bl) {
                this.modifiedFlag |= 0x80;
            }
            this.firePropertyChanged(TRANSPARENCY);
        }
    }

    public void setPadding(int n, int n2, boolean bl) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("wrong orientation " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("padding cannot be negative");
        }
        if (this.padding[n] != n2) {
            this.padding[n] = n2;
            if (!bl) {
                this.modifiedFlag |= 0x100;
            }
            this.firePropertyChanged(PADDING);
        }
    }

    public void setMargin(int n, int n2, boolean bl) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("wrong orientation " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("margin cannot be negative");
        }
        if (this.margin[n] != n2) {
            this.margin[n] = n2;
            if (!bl) {
                this.modifiedFlag |= 0x200;
            }
            this.firePropertyChanged(MARGIN);
        }
    }

    private void firePropertyChanged(String string) {
        this.roundRectCache = null;
        if (this.listeners == null) {
            return;
        }
        this.listeners.fireStyleChangeEvent(string, this);
    }

    public void addStyleListener(StyleListener styleListener) {
        if (this.listeners == null) {
            this.listeners = new EventDispatcher();
        }
        this.listeners.addListener(styleListener);
    }

    public void removeStyleListener(StyleListener styleListener) {
        if (this.listeners != null) {
            this.listeners.removeListener(styleListener);
        }
    }

    void resetModifiedFlag() {
        this.modifiedFlag = 0;
    }

    public void setBorder(Border border) {
        this.setBorder(border, false);
    }

    public void setBorder(Border border, boolean bl) {
        if (this.border == null && border != null || this.border != null && !this.border.equals(border)) {
            this.border = border;
            if (!bl) {
                this.modifiedFlag |= 0x400;
            }
            this.firePropertyChanged(BORDER);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Painter getBgPainter() {
        return this.bgPainter;
    }

    public void setBgPainter(Painter painter) {
        this.bgPainter = painter;
        this.firePropertyChanged(PAINTER);
    }
}

