/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.xml;

import com.sun.lwuit.xml.Element;
import com.sun.lwuit.xml.ParserCallback;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public class XMLParser {
    private static final Element END_TAG = new Element();
    private boolean eventParser;
    ParserCallback parserCallback;
    boolean includeWhitespacesBetweenTags;
    private Hashtable userDefinedCharEntities;
    private static final String CDATA_STR = "DATA[";

    protected String getSupportedStandardName() {
        return "XML";
    }

    public void addCharEntity(String string, int n) {
        if (this.userDefinedCharEntities == null) {
            this.userDefinedCharEntities = new Hashtable();
        }
        this.userDefinedCharEntities.put(XMLParser.trimCharEntity(string), new Integer(n));
    }

    public void addCharEntitiesRange(String[] stringArray, int n) {
        if (this.userDefinedCharEntities == null) {
            this.userDefinedCharEntities = new Hashtable();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.userDefinedCharEntities.put(XMLParser.trimCharEntity(stringArray[i]), new Integer(n + i));
        }
    }

    private static String trimCharEntity(String string) {
        if (string.startsWith("&")) {
            string = string.substring(1);
        }
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected String convertCharEntity(String string) {
        try {
            return "&" + string + ";";
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.notifyError(4, null, null, null, "Unrecognized char entity: " + string);
            return "&" + string + ";";
        }
    }

    public Element parse(Reader reader) {
        this.eventParser = false;
        Element element = this.createNewElement("ROOT");
        try {
            this.parseTagContent(element, reader);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (element.getNumChildren() == 0) {
            this.notifyError(8, null, null, null, "XML document contains no root element.");
            return null;
        }
        if (element.getNumChildren() > 1) {
            Object object;
            String string = "";
            for (int i = 1; i < element.getNumChildren(); ++i) {
                object = element.getChildAt(i);
                string = ((Element)object).isTextElement() ? string + "Text (" + ((Element)object).getText() + ")," : string + ((Element)object).getTagName() + ",";
            }
            if (string.endsWith(",")) {
                string = string.substring(0, string.length() - 1);
            }
            Element element2 = element.getChildAt(0);
            object = null;
            object = element2.isTextElement() ? "TEXT:" + element2.getText() : element2.getTagName();
            this.notifyError(7, null, null, null, "XML document contains multiple root elements, only the first root (" + (String)object + ") will be used. Excessive roots: " + string);
        }
        element = element.getChildAt(0);
        return element;
    }

    protected Element createNewElement(String string) {
        return new Element(string);
    }

    protected Element createNewTextElement(String string) {
        return new Element(string, true);
    }

    public void setIncludeWhitespacesBetweenTags(boolean bl) {
        this.includeWhitespacesBetweenTags = bl;
    }

    public void eventParser(Reader reader) throws IOException {
        this.eventParser = true;
        this.parseTagContent(null, reader);
    }

    protected void textElement(String string) {
    }

    protected boolean startTag(String string) {
        return true;
    }

    protected void endTag(String string) {
    }

    protected void attribute(String string, String string2, String string3) {
    }

    private boolean isLegalCharEntityCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '#';
    }

    protected void parseTagContent(Element element, Reader reader) throws IOException {
        String string = null;
        boolean bl = false;
        char c = (char)reader.read();
        String string2 = null;
        while ((byte)c != -1) {
            if (c == '<') {
                Element element2;
                if (this.includeWhitespacesBetweenTags && bl && string == null && element != null && element.getNumChildren() > 0) {
                    bl = false;
                    string = " ";
                }
                if (string != null) {
                    if (string2 != null) {
                        string = string + "&" + string2;
                        string2 = null;
                    }
                    if (bl) {
                        string = " " + string;
                    }
                    if (element != null) {
                        element2 = this.createNewTextElement(string);
                        element.addChild(element2);
                    } else {
                        this.textElement(string);
                    }
                    string = null;
                    bl = false;
                }
                if ((element2 = this.parseTag(reader)) == END_TAG) {
                    String string3 = "";
                    c = (char)reader.read();
                    while (c != '>') {
                        string3 = string3 + c;
                        c = (char)reader.read();
                    }
                    if (this.eventParser) {
                        this.endTag(string3);
                    }
                    if (element != null) {
                        if (string3.equalsIgnoreCase(element.getTagName())) {
                            return;
                        }
                        if (!this.isEmptyTag(string3)) {
                            this.notifyError(3, element.getTagName(), null, null, "Malformed XML - no appropriate closing tag for " + element.getTagName());
                        }
                    }
                } else if (element != null && !element2.isComment) {
                    element.addChild(element2);
                }
            } else if (string != null) {
                if (string2 != null) {
                    if (c == ';') {
                        string = string + this.convertCharEntity(string2);
                        string2 = null;
                    } else if (this.isLegalCharEntityCharacter(c)) {
                        string2 = string2 + c;
                    } else {
                        string = string + "&" + string2 + c;
                        string2 = null;
                    }
                } else if (c == '&') {
                    string2 = "";
                } else {
                    string = string + c;
                }
            } else if (!this.isWhiteSpace(c)) {
                if (c == '&') {
                    string2 = "";
                    string = "";
                } else {
                    string = "" + c;
                }
            } else {
                bl = true;
            }
            c = (char)reader.read();
        }
    }

    protected boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\n' || c == '\r';
    }

    protected Element parseTag(Reader reader) throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "";
        char c = (char)reader.read();
        if (c == '/') {
            return END_TAG;
        }
        if (c == '!') {
            c = (char)reader.read();
            char c2 = (char)reader.read();
            if (c == '-' && c2 == '-') {
                return this.parseCommentOrXMLDeclaration(reader, "-->");
            }
            if (c == '[' && c2 == 'C') {
                c = (char)reader.read();
                int n = 0;
                while (n < CDATA_STR.length() && c == CDATA_STR.charAt(n)) {
                    if (++n >= CDATA_STR.length()) continue;
                    c = (char)reader.read();
                }
                if (n == CDATA_STR.length()) {
                    return this.parseCommentOrXMLDeclaration(reader, "]]>");
                }
                return this.parseCommentOrXMLDeclaration(reader, ">");
            }
            return this.parseCommentOrXMLDeclaration(reader, ">");
        }
        if (c == '?') {
            return this.parseCommentOrXMLDeclaration(reader, ">");
        }
        while (this.isWhiteSpace(c)) {
            c = (char)reader.read();
        }
        while (!this.isWhiteSpace(c) && c != '>' && c != '/') {
            string = string + c;
            c = (char)reader.read();
        }
        while (this.isWhiteSpace(c)) {
            c = (char)reader.read();
        }
        boolean bl = true;
        if (this.eventParser) {
            bl = this.startTag(string);
        }
        string = string.toLowerCase();
        Element element = null;
        if (!this.eventParser) {
            element = this.createNewElement(string);
        }
        if (!bl || !this.isSupported(element)) {
            this.notifyError(0, string, null, null, "The tag '" + string + "' is not supported in " + this.getSupportedStandardName());
            if (!bl || !this.shouldEvaluate(element)) {
                char c3 = c;
                while (c != '>') {
                    c3 = c;
                    c = (char)reader.read();
                }
                if (c3 != '/') {
                    String string4 = "</" + string + ">";
                    int n = 0;
                    while (n < string4.length()) {
                        c = (char)reader.read();
                        if (c >= 'A' && c <= 'Z') {
                            c = (char)(c - 65 + 97);
                        }
                        if (c == string4.charAt(n)) {
                            ++n;
                            continue;
                        }
                        n = 0;
                    }
                }
                return element;
            }
        }
        if (c == '>') {
            if (!this.isEmptyTag(string)) {
                this.parseTagContent(element, reader);
            }
            return element;
        }
        if (c == '/') {
            c = (char)reader.read();
            if (c == '>') {
                if (this.eventParser) {
                    this.endTag(string);
                }
                return element;
            }
            this.notifyError(6, string, null, null, "XML malformed - no > after /");
        }
        while (true) {
            string2 = "" + c;
            c = (char)reader.read();
            while (!this.isWhiteSpace(c) && c != '=' && c != '>') {
                string2 = string2 + c;
                c = (char)reader.read();
            }
            if (c == '>') {
                this.notifyError(5, string, string2, null, "Unexpected tag closing in tag " + string + ", attribute=" + string2);
                if (!this.isEmptyTag(string)) {
                    this.parseTagContent(element, reader);
                }
                return element;
            }
            while (this.isWhiteSpace(c)) {
                c = (char)reader.read();
            }
            if (c != '=') {
                this.notifyError(6, string, string2, null, "Unexpected character " + c + ", expected '=' after attribute " + string2 + " in tag " + string);
                if (c != '>') continue;
                if (!this.isEmptyTag(string)) {
                    this.parseTagContent(element, reader);
                }
                return element;
            }
            c = (char)reader.read();
            while (this.isWhiteSpace(c)) {
                c = (char)reader.read();
            }
            char c4 = ' ';
            if (c == '\"' || c == '\'') {
                c4 = c;
            } else {
                string3 = string3 + c;
            }
            String string5 = null;
            boolean bl2 = false;
            while (!bl2) {
                c = (char)reader.read();
                if (c == c4) {
                    bl2 = true;
                    c = (char)reader.read();
                    continue;
                }
                if (c4 == ' ' && (c == '/' || c == '>' || this.isWhiteSpace(c))) {
                    bl2 = true;
                    continue;
                }
                if (c == '&') {
                    if (string5 != null) {
                        string3 = string3 + "&" + string5;
                    }
                    string5 = "";
                    continue;
                }
                if (string5 != null) {
                    if (c == ';') {
                        string3 = string3 + this.convertCharEntity(string5);
                        string5 = null;
                        continue;
                    }
                    if (this.isLegalCharEntityCharacter(c)) {
                        string5 = string5 + c;
                        continue;
                    }
                    string3 = string3 + "&" + string5 + c;
                    string5 = null;
                    continue;
                }
                string3 = string3 + c;
            }
            if (string5 != null) {
                string3 = string3 + "&" + string5;
                string5 = null;
            }
            if (this.eventParser) {
                this.attribute(string, string2, string3);
            } else {
                int n = element.setAttribute(string2 = string2.toLowerCase(), string3);
                if (n == 1) {
                    this.notifyError(n, string, string2, string3, "Attribute '" + string2 + "' is not supported for tag '" + string + "'.");
                } else if (n == 2) {
                    this.notifyError(n, string, string2, string3, "Attribute '" + string2 + "' in tag '" + string + "' has an invalid value (" + string3 + ")");
                }
            }
            while (this.isWhiteSpace(c)) {
                c = (char)reader.read();
            }
            if (c == '>') {
                if (!this.isEmptyTag(string)) {
                    this.parseTagContent(element, reader);
                }
                return element;
            }
            if (c == '/') {
                c = (char)reader.read();
                if (c == '>') {
                    return element;
                }
                this.notifyError(6, string, string2, string3, "XML malformed - no > after /");
            }
            string2 = "";
            string3 = "";
        }
    }

    protected Element parseCommentOrXMLDeclaration(Reader reader, String string) throws IOException {
        int n = 0;
        String string2 = "";
        boolean bl = false;
        while (!bl) {
            char c = (char)reader.read();
            if (c == string.charAt(n)) {
                if (++n != string.length()) continue;
                bl = true;
                continue;
            }
            if (n != 0) {
                string2 = string2 + string.substring(0, n);
                n = 0;
            }
            string2 = string2 + c;
        }
        String string3 = null;
        if (string.equals("-->")) {
            string3 = "comment";
        } else if (string.equals(">")) {
            string3 = "XML declaration";
        } else {
            if (this.eventParser) {
                this.textElement(string2);
                return null;
            }
            return this.createNewTextElement(string2);
        }
        if (this.eventParser) {
            return null;
        }
        Element element = this.createNewElement(string3);
        element.setAttribute("content", string2);
        element.isComment = true;
        return element;
    }

    protected boolean isEmptyTag(String string) {
        return false;
    }

    protected void notifyError(int n, String string, String string2, String string3, String string4) {
        boolean bl;
        if (this.parserCallback != null && !(bl = this.parserCallback.parsingError(n, string, string2, string3, string4))) {
            throw new IllegalArgumentException(string4);
        }
    }

    protected boolean isSupported(Element element) {
        return true;
    }

    protected boolean shouldEvaluate(Element element) {
        return true;
    }

    public void setParserCallback(ParserCallback parserCallback) {
        this.parserCallback = parserCallback;
    }
}

