/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.Command;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Label;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import framework.Common;
import framework.Network;
import framework.NetworkListener;
import framework.XMLParser;
import javax.microedition.rms.RecordStore;

public class AuthManager
implements ActionListener,
NetworkListener {
    TextField txtSignupEmail;
    TextField txtSignupPassword;
    TextField txtSignupName;
    TextField txtSignupYear;
    RadioButton radSignupMale;
    RadioButton radSignupFemale;
    ButtonGroup btnGroupSignup;
    TextField txtEmail;
    TextField txtPassword;
    Form frmLogin;
    Form frmJoin;
    Button btnSignup;
    String _emailID = "";
    String _password = "";
    String _newEmail = "";
    String _newPass = "";
    CheckBox _chkRemember = null;
    boolean _loggedIn = false;
    boolean _authSet = false;
    public Command cmdLogin;
    public Command cmdBack;
    public Command cmdExit;
    int _operation = -1;
    public static final int LOGIN = 1;
    public static final int SIGNUP = 2;
    public static final int SIGNUP2 = 3;
    XMLParser _xmlParser;
    Common _common;

    public AuthManager(Common common) {
        this._common = common;
        this.cmdBack = new Command("Login");
    }

    public boolean isAuthDataAvailable() {
        return this._authSet;
    }

    public boolean isAuthenticated() {
        return this._loggedIn;
    }

    public void readLoginData() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"tubri", (boolean)true);
            if (recordStore != null) {
                for (int i = 0; i < recordStore.getNumRecords(); ++i) {
                    int n = recordStore.getNextRecordID();
                    byte[] byArray = recordStore.getRecord(n);
                    String string = new String(byArray);
                    int n2 = string.indexOf("`");
                    if (n2 == -1) continue;
                    this._emailID = string.substring(0, n2);
                    this._password = string.substring(n2 + 1, string.length());
                    this._authSet = true;
                    break;
                }
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void openHomeWindow() {
        this._common._main._chatManager.startChatService();
        this._common._main.showHome();
    }

    public void onDataReceived(String string) {
        this._common.hideProgress();
        if (this._operation == 1 || this._operation == 3) {
            if (this._operation == 3 && string.indexOf("<msg>") == -1) {
                this.showLoginForm();
            } else if (this._operation == 3 && string.indexOf("<msg>") != -1) {
                this._loggedIn = true;
                this._xmlParser = XMLParser.parse(string);
                String string2 = this._xmlParser.getTagValue("ver");
                if (string2 != null && !string2.trim().equals(Common._appVersion)) {
                    Common.newVersion = string2;
                }
                this.openHomeWindow();
            } else if (this._operation == 1) {
                if (string == null || string.indexOf("<err>") != -1) {
                    this._common.showDialog("Login failed, try again", 0);
                } else {
                    this._loggedIn = true;
                    this._xmlParser = XMLParser.parse(string);
                    String string3 = this._xmlParser.getTagValue("ver");
                    if (string3 != null && !string3.trim().equals(Common._appVersion)) {
                        Common.newVersion = string3;
                    }
                    if (!this._newEmail.equals(this._emailID) || !this._newPass.equals(this._password)) {
                        try {
                            RecordStore recordStore = RecordStore.openRecordStore((String)"tubri", (boolean)true);
                            String string4 = this._newEmail + "`" + this._newPass;
                            recordStore.addRecord(string4.getBytes(), 0, string4.getBytes().length);
                            recordStore.closeRecordStore();
                            recordStore = RecordStore.openRecordStore((String)"tubri", (boolean)true);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    this.openHomeWindow();
                }
            }
        } else if (this._operation == 2) {
            if (string == null) {
                String string5 = "Unable to signup currently, try again";
                if (Common._nokiaError != null) {
                    string5 = Common._nokiaError;
                }
                this._common.showDialog(string5, 0);
            } else {
                this._xmlParser = XMLParser.parse(string);
                String string6 = this._xmlParser.getTagValue("err");
                if (string6 != null) {
                    this._common.showDialog(string6, 0);
                } else if (this._xmlParser.getTagValue("msg") != null) {
                    String string7 = this.txtSignupEmail.getText();
                    String string8 = this.txtSignupPassword.getText();
                    this._emailID = string7;
                    this._password = string8;
                    this._operation = 3;
                    this._common.showProgress();
                    this.doLogin(string7, string8);
                } else {
                    String string9 = "Unexpected problem happened, try again later";
                    if (Common._nokiaError != null) {
                        string9 = Common._nokiaError;
                    }
                    this._common.showDialog(string9, 0);
                }
            }
        }
    }

    public void onNetworkError(String string) {
        this._common.hideProgress();
        this._common.showDialog("Network error", 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdLogin) {
            this._operation = 1;
            this._common.showProgress();
            this.doLogin(this.txtEmail.getText(), this.txtPassword.getText());
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdExit) {
            this._common._main.midlet.notifyDestroyed();
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Signup")) {
            String string = this.txtSignupEmail.getText();
            String string2 = this.txtSignupPassword.getText();
            String string3 = this.txtSignupName.getText();
            string3 = Network.replaceAll(" ", "%20", string3);
            Common._logNokiaError = true;
            Common._nokiaError = null;
            this._operation = 2;
            this._common.showProgress();
            Network.post2(Common._baseURL + "m_auth.php", "dosignup=1&name=" + string3 + "&email=" + this.txtSignupEmail.getText() + "&gender=" + (this.btnGroupSignup.getSelectedIndex() + 1) + "&year=" + this.txtSignupYear.getText() + "&password=" + this.txtSignupPassword.getText() + "&origin=" + Common.origin + Common._appVersion, true, (NetworkListener)this);
            Common._logNokiaError = false;
        } else if (actionEvent.getSource() == this.btnSignup) {
            this.showJoinForm();
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Login")) {
            this._common.showPreviousScreen();
        }
    }

    public void showJoinForm() {
        this.prepareJoinForm();
        this._common.showForm(this.frmJoin);
    }

    private void prepareJoinForm() {
        if (this.frmJoin != null) {
            return;
        }
        this.frmJoin = new Form();
        this.frmJoin.setTitle("Join Tubri");
        this.frmJoin.setLayout(new BoxLayout(2));
        this.frmJoin.addComponent(new Label("Email Address:"));
        this.txtSignupEmail = new TextField();
        this.txtSignupEmail.setConstraint(1);
        this.frmJoin.addComponent(this.txtSignupEmail);
        this.frmJoin.addComponent(new Label("Password:"));
        this.txtSignupPassword = new TextField();
        this.txtSignupPassword.setConstraint(65536);
        this.frmJoin.addComponent(this.txtSignupPassword);
        this.frmJoin.addComponent(new Label("Your Name:"));
        this.txtSignupName = new TextField();
        this.frmJoin.addComponent(this.txtSignupName);
        this.txtSignupName.setConstraint(0);
        this.frmJoin.addComponent(new Label("Birth Year:"));
        this.txtSignupYear = new TextField();
        this.txtSignupYear.setConstraint(2);
        this.frmJoin.addComponent(this.txtSignupYear);
        this.frmJoin.addComponent(new Label("Gender"));
        this.radSignupMale = new RadioButton("Male");
        this.radSignupMale.setSelected(true);
        this.radSignupFemale = new RadioButton("Female");
        this.btnGroupSignup = new ButtonGroup();
        this.btnGroupSignup.add(this.radSignupMale);
        this.btnGroupSignup.add(this.radSignupFemale);
        this.frmJoin.addComponent(this.radSignupMale);
        this.frmJoin.addComponent(this.radSignupFemale);
        this.frmJoin.addCommand(new Command("Signup"));
        this.frmJoin.addCommand(this.cmdBack);
        this.frmJoin.addCommandListener(this);
    }

    public int doLogin() {
        return this.doLogin(this.txtEmail.getText(), this.txtPassword.getText());
    }

    private int doLogin(String string, String string2) {
        try {
            this._newEmail = string;
            this._newPass = string2;
            Network.post2(Common._baseURL + "m_auth.php", "email=" + string + "&pass=" + string2 + "&dologin=1&origin=" + Common.origin + Common._appVersion, true, (NetworkListener)this);
            return Common.SUCCESS;
        }
        catch (Exception exception) {
            return Common.SUCCESS;
        }
    }

    public void showLoginForm() {
        this.prepareLoginForm();
        this._common.showForm(this.frmLogin);
    }

    private void prepareLoginForm() {
        if (this.frmLogin != null) {
            return;
        }
        this.frmLogin = new Form();
        this.frmLogin.setTitle("Login");
        this.frmLogin.setLayout(new BoxLayout(2));
        this.txtEmail = new TextField(this._emailID);
        this.txtPassword = new TextField(this._password);
        this.txtPassword.setRows(1);
        this.txtPassword.setConstraint(65536);
        this.txtEmail.setConstraint(1);
        this.frmLogin.addComponent(new Label("Email:"));
        this.frmLogin.addComponent(this.txtEmail);
        this.frmLogin.addComponent(new Label("Password:"));
        this.frmLogin.addComponent(this.txtPassword);
        this.frmLogin.addComponent(new Label(""));
        Container container = new Container(new FlowLayout());
        container.addComponent(new Label("New User?"));
        this.btnSignup = new Button("Signup");
        this.btnSignup.addActionListener(this);
        container.addComponent(this.btnSignup);
        this.frmLogin.addComponent(container);
        this.cmdLogin = new Command("Login");
        this.cmdExit = new Command("Exit");
        this.frmLogin.addCommand(this.cmdLogin);
        this.frmLogin.addCommand(this.cmdExit);
        this.frmLogin.addCommandListener(this);
    }
}

