/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.notepad;

import com.mot.j2me.midlets.notepad.Note;
import com.mot.j2me.midlets.notepad.NotePersistence$NoteStruct;
import com.mot.j2me.midlets.notepad.exceptions.NoteAlreadyExistsException;
import com.mot.j2me.midlets.notepad.exceptions.NoteDoesNotExistException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class NotePersistence {
    private static final String NOTEPAD_DB = "Notepad_DB";
    private RecordStore notepadRecordStore;
    private RecordEnumeration notepadRecordEnumeration;
    private Vector noteStructs = new Vector(20);

    public NotePersistence() throws RecordStoreException, IOException {
        this.loadAllnoteStructs();
    }

    public void closeRMS() throws Exception {
        if (this.notepadRecordStore != null) {
            this.notepadRecordStore.closeRecordStore();
        }
        this.notepadRecordStore = null;
    }

    public void deleteNote(Note note) throws RecordStoreException, IOException, NoteDoesNotExistException {
        NotePersistence$NoteStruct notePersistence$NoteStruct = null;
        notePersistence$NoteStruct = this.getNoteStructByTitle(note.getTitle());
        if (notePersistence$NoteStruct == null) {
            throw new NoteDoesNotExistException();
        }
        this.notepadRecordStore.deleteRecord(NotePersistence$NoteStruct.access$0(notePersistence$NoteStruct));
        this.noteStructs.removeElement(notePersistence$NoteStruct);
    }

    public Note getNoteByTitle(String string) throws RecordStoreException, IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        String string2 = null;
        Note note = null;
        try {
            NotePersistence$NoteStruct notePersistence$NoteStruct = this.getNoteStructByTitle(string);
            if (notePersistence$NoteStruct != null) {
                int n = NotePersistence$NoteStruct.access$0(notePersistence$NoteStruct);
                byteArrayInputStream = new ByteArrayInputStream(this.notepadRecordStore.getRecord(n));
                filterInputStream = new DataInputStream(byteArrayInputStream);
                if (!string.equals(((DataInputStream)filterInputStream).readUTF())) {
                    throw new RecordStoreException();
                }
                string2 = ((DataInputStream)filterInputStream).readUTF();
                note = new Note(string, string2);
            }
        }
        catch (Throwable throwable) {}
        if (filterInputStream != null) {
            filterInputStream.close();
        }
        if (byteArrayInputStream != null) {
            byteArrayInputStream.close();
        }
        return note;
    }

    public NotePersistence$NoteStruct getNoteStructByTitle(String string) {
        NotePersistence$NoteStruct notePersistence$NoteStruct = null;
        int n = this.noteStructs.indexOf(new NotePersistence$NoteStruct(this, string));
        if (n != -1) {
            notePersistence$NoteStruct = (NotePersistence$NoteStruct)this.noteStructs.elementAt(n);
        }
        return notePersistence$NoteStruct;
    }

    public Vector getNoteTitles() {
        int n = this.noteStructs.size();
        Vector<String> vector = new Vector<String>(20);
        int n2 = 0;
        while (n2 < n) {
            NotePersistence$NoteStruct notePersistence$NoteStruct = (NotePersistence$NoteStruct)this.noteStructs.elementAt(n2);
            if (notePersistence$NoteStruct != null) {
                String string = NotePersistence$NoteStruct.access$1(notePersistence$NoteStruct);
                vector.addElement(string);
            }
            ++n2;
        }
        return vector;
    }

    public void loadAllnoteStructs() throws RecordStoreException, IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        DataInputStream dataInputStream = null;
        String string = null;
        int n = 0;
        try {
            this.notepadRecordStore = RecordStore.openRecordStore((String)NOTEPAD_DB, (boolean)true);
            this.notepadRecordEnumeration = this.notepadRecordStore.enumerateRecords(null, null, false);
            this.noteStructs.removeAllElements();
            while (this.notepadRecordEnumeration.hasNextElement()) {
                n = this.notepadRecordEnumeration.nextRecordId();
                byteArrayInputStream = new ByteArrayInputStream(this.notepadRecordStore.getRecord(n));
                dataInputStream = new DataInputStream(byteArrayInputStream);
                string = dataInputStream.readUTF();
                this.noteStructs.addElement(new NotePersistence$NoteStruct(this, n, string));
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
                if (byteArrayInputStream == null) continue;
                byteArrayInputStream.close();
            }
        }
        finally {
            if (this.notepadRecordEnumeration != null) {
                this.notepadRecordEnumeration.destroy();
            }
            this.notepadRecordEnumeration = null;
            dataInputStream = null;
            byteArrayInputStream = null;
        }
    }

    public boolean noteExists(String string) {
        return this.noteStructs.contains(new NotePersistence$NoteStruct(this, string));
    }

    public static void resetRecordStore() throws Exception {
        RecordStore.deleteRecordStore((String)NOTEPAD_DB);
    }

    public void saveNote(Note note) throws RecordStoreException, IOException, NoteAlreadyExistsException {
        block6: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            int n = 0;
            try {
                if (!this.noteExists(note.getTitle())) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                    ((DataOutputStream)filterOutputStream).writeUTF(note.getTitle());
                    ((DataOutputStream)filterOutputStream).writeUTF(note.getText());
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    n = this.notepadRecordStore.addRecord(byArray, 0, byArray.length);
                    this.noteStructs.addElement(new NotePersistence$NoteStruct(this, n, note.getTitle()));
                    break block6;
                }
                throw new NoteAlreadyExistsException();
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                byteArrayOutputStream = null;
                filterOutputStream = null;
            }
        }
    }

    public void updateNote(Note note) throws RecordStoreException, IOException, NoteDoesNotExistException {
        block6: {
            ByteArrayOutputStream byteArrayOutputStream = null;
            FilterOutputStream filterOutputStream = null;
            NotePersistence$NoteStruct notePersistence$NoteStruct = null;
            try {
                notePersistence$NoteStruct = this.getNoteStructByTitle(note.getTitle());
                if (notePersistence$NoteStruct != null) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    filterOutputStream = new DataOutputStream(byteArrayOutputStream);
                    ((DataOutputStream)filterOutputStream).writeUTF(note.getTitle());
                    ((DataOutputStream)filterOutputStream).writeUTF(note.getText());
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    this.notepadRecordStore.setRecord(NotePersistence$NoteStruct.access$0(notePersistence$NoteStruct), byArray, 0, byArray.length);
                    break block6;
                }
                throw new NoteDoesNotExistException();
            }
            finally {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                byteArrayOutputStream = null;
                filterOutputStream = null;
            }
        }
    }
}

