/*
 * Decompiled with CFR 0.152.
 */
package com.mot.j2me.midlets.notepad;

import com.mot.j2me.midlets.notepad.Note;
import com.mot.j2me.midlets.notepad.NotePersistence;
import com.mot.j2me.midlets.notepad.NotepadConstants;
import com.mot.j2me.midlets.notepad.NotepadServices;
import com.mot.j2me.midlets.notepad.exceptions.InvalidArgumentException;
import com.mot.j2me.midlets.notepad.exceptions.NoteAlreadyExistsException;
import com.mot.j2me.midlets.notepad.exceptions.NoteDoesNotExistException;
import com.mot.j2me.midlets.util.AbstractMIDlet;
import com.mot.j2me.midlets.util.ApplicationController;
import com.mot.j2me.midlets.util.ResourceBundle;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class NotepadController
extends ApplicationController
implements CommandListener {
    public static final String IMG_DIR_PATH = "/com/mot/j2me/midlets/notepad/";
    public static final String IMG_FILE_PATH = "/com/mot/j2me/midlets/notepad/notepad.png";
    public static final byte NOTEPAD_SCREEN = 1;
    public static final byte SAVE_MESSAGE_SCREEN = 2;
    public static final byte CANCEL_MESSAGE_SCREEN = 3;
    public static final byte DELETE_MESSAGE_SCREEN = 4;
    public static final byte VIEW_NOTES_SCREEN = 5;
    public static final byte EDIT_DELETE_SCREEN = 6;
    public static final byte SAVING_ALERT_SCREEN = 7;
    public static final byte ERROR_ALERT_SCREEN = 8;
    public static final short SAVING_ALERT_DELAY = 2000;
    private NotepadServices notepadServices;
    private Alert savingAlert;
    private Form cancelMessage;
    private Form deleteMessage;
    private Form errorMessage;
    private Form saveMessage;
    private List editDeleteScreen;
    private List viewNotesScreen;
    private TextBox notepadScreen;
    private String noteTitleSelected;
    private String noteTextSelected;
    private int previousScreen;

    public NotepadController() {
        try {
            this.notepadServices = new NotepadServices();
        }
        catch (Exception exception) {
            try {
                NotePersistence.resetRecordStore();
                this.notepadServices = new NotepadServices();
            }
            catch (Exception exception2) {
                this.initializeErrorScreen();
                this.showErrorScreen("038");
            }
        }
    }

    private final void buildViewNotesScreen() {
        int n;
        Vector vector = this.notepadServices.getNoteTitles();
        int n2 = vector.size();
        int n3 = n = this.viewNotesScreen.size() - 1;
        while (n3 >= 0) {
            this.viewNotesScreen.delete(n3);
            --n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            String string = (String)vector.elementAt(n4);
            this.viewNotesScreen.append(string, null);
            ++n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.notepadScreen) {
            if (command == NotepadConstants.DONE_COMMAND) {
                if (this.notepadScreen.getTitle() != null && this.notepadScreen.getTitle().equals(ResourceBundle.getString("com.mot.j2me.midlets.notepad.languages.Notepad", "009"))) {
                    if (!this.notepadScreen.getString().trim().equals("")) {
                        ((TextField)this.saveMessage.get(0)).setString("");
                        super.changeScreen(2);
                        return;
                    } else {
                        this.showErrorScreen("031");
                    }
                    return;
                } else {
                    try {
                        this.notepadServices.updateNote(this.noteTitleSelected, this.notepadScreen.getString());
                        this.savingAlert.setTitle(this.noteTitleSelected);
                        this.buildViewNotesScreen();
                        AbstractMIDlet.getDisplay().setCurrent((Alert)super.getScreen(7), super.getScreen(5));
                        return;
                    }
                    catch (NoteDoesNotExistException noteDoesNotExistException) {
                        this.showErrorScreen("032");
                        return;
                    }
                    catch (IOException iOException) {
                        this.showErrorScreen("038");
                        return;
                    }
                    catch (InvalidArgumentException invalidArgumentException) {
                        this.showErrorScreen(invalidArgumentException.getMessage());
                        return;
                    }
                    catch (RecordStoreFullException recordStoreFullException) {
                        this.showErrorScreen("037");
                        return;
                    }
                    catch (RecordStoreException recordStoreException) {
                        this.showErrorScreen("038");
                    }
                }
                return;
            } else {
                if (command != NotepadConstants.CANCEL_COMMAND) return;
                String string = this.notepadScreen.getString();
                if (this.notepadScreen.getTitle() != null && this.notepadScreen.getTitle().equals(ResourceBundle.getString("com.mot.j2me.midlets.notepad.languages.Notepad", "009"))) {
                    if (string.trim().equals("")) {
                        super.changeScreen(-11);
                        return;
                    } else {
                        this.cancelMessage.setTitle(ResourceBundle.getString("com.mot.j2me.midlets.notepad.languages.Notepad", "009"));
                        super.changeScreen(3);
                    }
                    return;
                } else if (string.trim().equals(this.noteTextSelected)) {
                    super.changeScreen(6);
                    return;
                } else {
                    this.cancelMessage.setTitle(this.noteTitleSelected);
                    super.changeScreen(3);
                }
            }
            return;
        }
        if (displayable == this.cancelMessage) {
            if (command == NotepadConstants.YES_COMMAND) {
                if (this.notepadScreen.getTitle() != null && this.notepadScreen.getTitle().equals(ResourceBundle.getString("com.mot.j2me.midlets.notepad.languages.Notepad", "009"))) {
                    this.notepadScreen.setString("");
                    super.changeScreen(-11);
                    return;
                } else {
                    super.changeScreen(6);
                }
                return;
            } else {
                if (command != NotepadConstants.NO_COMMAND) return;
                super.changeScreen(1);
            }
            return;
        }
        if (displayable == this.saveMessage) {
            if (command == NotepadConstants.SAVE_COMMAND) {
                String string = ((TextField)this.saveMessage.get(0)).getString().trim();
                if (string.equals("")) return;
                String string2 = this.notepadScreen.getString();
                try {
                    this.notepadServices.saveNote(string, string2);
                    this.savingAlert.setTitle(string);
                    AbstractMIDlet.getDisplay().setCurrent((Alert)super.getScreen(7), super.getScreen(-11));
                    return;
                }
                catch (NoteAlreadyExistsException noteAlreadyExistsException) {
                    this.showErrorScreen("029");
                    return;
                }
                catch (IOException iOException) {
                    this.showErrorScreen("038");
                    return;
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    this.showErrorScreen(invalidArgumentException.getMessage());
                    return;
                }
                catch (RecordStoreFullException recordStoreFullException) {
                    this.showErrorScreen("037");
                    return;
                }
                catch (RecordStoreException recordStoreException) {
                    this.showErrorScreen("038");
                }
                return;
            } else {
                if (command != NotepadConstants.BACK_COMMAND) return;
                super.changeScreen(1);
            }
            return;
        }
        if (displayable == this.viewNotesScreen) {
            if (command == NotepadConstants.BACK_COMMAND) {
                super.changeScreen(-11);
                return;
            } else {
                if (command != NotepadConstants.SELECT_COMMAND || this.viewNotesScreen.size() <= 0) return;
                this.noteTitleSelected = this.viewNotesScreen.getString(this.viewNotesScreen.getSelectedIndex());
                this.editDeleteScreen.setTitle(this.noteTitleSelected);
                super.changeScreen(6);
            }
            return;
        }
        if (displayable == this.editDeleteScreen) {
            if (command == NotepadConstants.BACK_COMMAND) {
                this.noteTextSelected = null;
                this.buildViewNotesScreen();
                super.changeScreen(5);
                return;
            }
            if (command != NotepadConstants.SELECT_COMMAND) return;
            switch (this.editDeleteScreen.getSelectedIndex()) {
                case 0: {
                    try {
                        try {
                            Note note = this.notepadServices.getNoteByTitle(this.noteTitleSelected);
                            if (note != null) {
                                this.noteTextSelected = note.getText();
                            }
                            this.notepadScreen.setTitle(this.noteTitleSelected);
                            this.notepadScreen.setString(this.noteTextSelected);
                            super.changeScreen(1);
                            return;
                        }
                        catch (IOException iOException) {
                            this.showErrorScreen("038");
                            return;
                        }
                        catch (RecordStoreException recordStoreException) {
                            this.showErrorScreen("038");
                            return;
                        }
                    }
                    catch (Throwable throwable) {}
                    return;
                }
                case 1: {
                    this.noteTextSelected = null;
                    this.deleteMessage.setTitle(this.noteTitleSelected);
                    super.changeScreen(4);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (displayable == this.deleteMessage) {
            if (command == NotepadConstants.YES_COMMAND) {
                try {
                    this.notepadServices.deleteNote(this.noteTitleSelected);
                    this.buildViewNotesScreen();
                    super.changeScreen(5);
                    return;
                }
                catch (NoteDoesNotExistException noteDoesNotExistException) {
                    this.showErrorScreen("032");
                    return;
                }
                catch (IOException iOException) {
                    this.showErrorScreen("038");
                    return;
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    this.showErrorScreen(invalidArgumentException.getMessage());
                    return;
                }
                catch (RecordStoreException recordStoreException) {
                    this.showErrorScreen("038");
                }
                return;
            } else {
                if (command != NotepadConstants.NO_COMMAND) return;
                super.changeScreen(6);
            }
            return;
        } else {
            if (displayable != this.errorMessage || command != NotepadConstants.BACK_COMMAND) return;
            super.changeScreen(this.previousScreen);
        }
    }

    public NotepadServices getNotepadServices() {
        return this.notepadServices;
    }

    public void initializeAllScreens() {
        this.notepadScreen = (TextBox)super.getScreen(1);
        this.saveMessage = (Form)super.getScreen(2);
        this.cancelMessage = (Form)super.getScreen(3);
        this.savingAlert = (Alert)super.getScreen(7);
        this.viewNotesScreen = (List)super.getScreen(5);
        this.editDeleteScreen = (List)super.getScreen(6);
        this.deleteMessage = (Form)super.getScreen(4);
        this.initializeErrorScreen();
    }

    public void initializeErrorScreen() {
        this.errorMessage = (Form)super.getScreen(8);
    }

    public void paintScreen(String string, Graphics graphics) {
    }

    public void processAction(int n) {
        switch (n) {
            case 0: {
                this.notepadScreen.setTitle(ResourceBundle.getString("com.mot.j2me.midlets.notepad.languages.Notepad", "009"));
                this.notepadScreen.setString("");
                super.changeScreen(1);
                break;
            }
            case 1: {
                this.buildViewNotesScreen();
                super.changeScreen(5);
            }
        }
    }

    private final void showErrorScreen(String string) {
        this.errorMessage.setTitle(ResourceBundle.getString("com.mot.j2me.midlets.notepad.languages.Notepad", "036"));
        if (this.errorMessage.size() == 1) {
            this.errorMessage.delete(0);
        }
        this.errorMessage.append(ResourceBundle.getString("com.mot.j2me.midlets.notepad.languages.Notepad", string));
        this.previousScreen = super.getCurrentScreen();
        super.changeScreen(8);
    }

    public void startAppAction() {
    }
}

