/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.midlet.MIDlet;

public class engine {
    private boolean[] pan_is_active;
    private boolean[] pan_is_alert;
    private long[] start_time;
    private long[] end_time;
    private Player pl;
    private InputStream is;
    private VolumeControl vc;
    private CookTimerMidlet emid;

    public engine(CookTimerMidlet m) {
        this.emid = m;
        try {
            this.is = this.getClass().getResourceAsStream("ding.mp3");
            this.pl = Manager.createPlayer((InputStream)this.is, (String)"audio/mpeg");
            this.pl.realize();
            this.vc = (VolumeControl)this.pl.getControl("VolumeControl");
            this.pl.prefetch();
        }
        catch (MediaException pe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.pan_is_active = new boolean[4];
        this.pan_is_alert = new boolean[4];
        this.start_time = new long[4];
        this.end_time = new long[4];
        for (int i = 0; i <= 3; ++i) {
            this.pan_is_active[i] = false;
            this.pan_is_alert[i] = false;
        }
    }

    public void playAlarm() {
        Display.getDisplay((MIDlet)this.emid).vibrate(2000);
        try {
            if (this.pl.getState() != 400) {
                this.pl.start();
            }
            if (this.vc != null) {
                this.vc.setLevel(100);
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public boolean isPanActive(int p) {
        return this.pan_is_active[p];
    }

    public boolean isPanAlert(int p) {
        return this.pan_is_alert[p];
    }

    public void setPanTimer(int p, int m) {
        long curtime;
        this.start_time[p] = curtime = System.currentTimeMillis();
        this.end_time[p] = curtime + (long)(m * 60000);
        this.pan_is_active[p] = true;
        this.pan_is_alert[p] = false;
    }

    public long getProgress(int p) {
        this.progress();
        if (this.pan_is_alert[p]) {
            this.playAlarm();
            return -1L;
        }
        if (!this.pan_is_active[p]) {
            return -2L;
        }
        long curtime = System.currentTimeMillis();
        long ret = (long)((float)(curtime - this.start_time[p]) / (float)(this.end_time[p] - this.start_time[p]) * 100.0f);
        return ret;
    }

    private void progress() {
        long curtime = System.currentTimeMillis();
        for (int i = 0; i <= 3; ++i) {
            if (!this.pan_is_active[i] || curtime < this.end_time[i]) continue;
            this.pan_is_active[i] = false;
            this.pan_is_alert[i] = true;
        }
    }

    public void stopPanAlert(int p) {
        this.pan_is_alert[p] = false;
    }

    public String getPanStatusStr(int p) {
        this.progress();
        if (this.pan_is_alert[p]) {
            return "IT IS TIME!!!";
        }
        if (!this.pan_is_active[p]) {
            return "Inactive.";
        }
        long curtime = System.currentTimeMillis();
        long ret = this.end_time[p] - curtime;
        long smins = ret / 60000L;
        long ssecs = (ret - smins * 60000L) / 1000L;
        String ss = "Left: " + String.valueOf(smins) + (ssecs < 10L ? ":0" : ":") + String.valueOf(ssecs);
        return ss;
    }
}

