/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CookTimerCanvas
extends Canvas {
    public Display disp;
    public int selectedpan;
    public engine eng;
    private CookTimerMidlet midl;

    public void cycle() {
        long l = this.eng.getProgress(this.selectedpan);
        this.repaint();
    }

    public CookTimerCanvas(Display d, CookTimerMidlet m) {
        this.disp = d;
        this.midl = m;
        this.selectedpan = 0;
        this.eng = new engine(m);
    }

    public void gotMinutes(int m) {
        this.eng.setPanTimer(this.selectedpan, m);
    }

    protected void hideNotify() {
    }

    protected void showNotify() {
    }

    public void init() {
        this.setFullScreenMode(true);
        this.repaint();
    }

    protected void keyPressed(int keyCode) {
        int gc = this.getGameAction(keyCode);
        switch (gc) {
            case 2: {
                --this.selectedpan;
                if (this.selectedpan >= 0) break;
                this.selectedpan = 3;
                break;
            }
            case 5: {
                ++this.selectedpan;
                if (this.selectedpan <= 3) break;
                this.selectedpan = 0;
                break;
            }
            case 1: {
                this.selectedpan -= 2;
                if (this.selectedpan >= 0) break;
                this.selectedpan += 4;
                break;
            }
            case 6: {
                this.selectedpan += 2;
                if (this.selectedpan <= 3) break;
                this.selectedpan -= 4;
                break;
            }
            case 8: {
                if (this.eng.isPanAlert(this.selectedpan)) {
                    this.eng.stopPanAlert(this.selectedpan);
                    break;
                }
                this.midl.askMinutes();
                break;
            }
        }
        this.repaint();
    }

    protected void paint(Graphics g) {
        int i;
        int x = g.getClipX();
        int y = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        g.setColor(0xFFFFFF);
        g.fillRect(x, y, w, h);
        Font font = g.getFont();
        int fontHeight = font.getHeight();
        int fontWidth = font.stringWidth("Hello World!");
        g.setColor(0);
        g.setFont(font);
        StringBuffer stringBuffer = new StringBuffer().append("Cook Timer ");
        ((Object)((Object)this.midl)).getClass();
        g.drawString(stringBuffer.append("0.9").toString(), x + 2, y + 2, 0x10 | 4);
        g.drawString(this.getTimeStr(), w - 18, y + 2, 0x10 | 1);
        g.drawString(this.eng.getPanStatusStr(this.selectedpan), x + 2, y + 4 + fontHeight, 0x10 | 4);
        int d = (w - 30) / 2;
        int[] xp = new int[4];
        int[] yp = new int[4];
        xp[0] = 10;
        yp[0] = h - (d + 10) * 2;
        xp[1] = 20 + d;
        yp[1] = h - (d + 10) * 2;
        xp[2] = 10;
        yp[2] = h - (d + 10);
        xp[3] = 20 + d;
        yp[3] = h - (d + 10);
        for (i = 0; i <= 3; ++i) {
            g.drawArc(xp[i], yp[i], d, d, 0, 360);
        }
        g.setColor(0xFF0000);
        g.drawArc(xp[this.selectedpan] - 5, yp[this.selectedpan] - 5, d + 10, d + 10, 0, 360);
        for (i = 0; i <= 3; ++i) {
            long pr = this.eng.getProgress(i);
            if (pr >= 0L) {
                g.setColor(0xCCCCCC);
                g.fillArc(xp[i] + 1, yp[i] + 1, d - 2, d - 2, 0, 360);
                int ext = (int)(3.6 * (double)((int)pr));
                g.setColor(255);
                g.fillArc(xp[i], yp[i], d, d, 0, -ext);
                continue;
            }
            if (pr != -1L) continue;
            g.setColor(0xFF0000);
            g.fillArc(xp[i] + 1, yp[i] + 1, d - 2, d - 2, 0, 360);
        }
    }

    public String getTimeStr() {
        Date nowd = new Date();
        String ss = nowd.toString().substring(11, 16);
        nowd = null;
        return ss;
    }
}

