# -*- coding: utf-8 -*-
# Autor: Vladislav KaBaSya Kurtoglu
# ICQ: 423078768

__name__ = 'ini'
__version__ = '1.00'
__doc__ = """
# ----- Example ----- #
>>> import ini
>>> dictionary = {'key': 1}
>>> ini.write('C:\\filename.ini', dictionary, label=None, add=False)
>>> ini.read('C:\\filename.ini')
{'key': 1}
>>> 
# ----- Example ----- #
"""

def read(filename):
    dictionary = {}
    file = open(filename, 'rb')
    exec (file, {}, dictionary)
    file.close()
    return dictionary
        
def write(filename, dictionary, label=None, add=False):
    if add:
        mode = 'ab'
    else:
        mode = 'wb'
    file = open(filename, mode)
    if label:
        file.write('\n'.join(['# %s' % line for line in label.splitlines()])+'\n')
    file.write('\n'.join(['%s = %r' % (key, dictionary[key]) for key in dictionary.keys()])+'\n\n')
    file.close()