/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.RGBImage;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.LWUITImplementation;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Hashtable;

public class Image {
    private WeakReference rgbCache;
    private Object image;
    int transform;
    private boolean opaqueTested = false;
    private boolean opaque;
    private Hashtable scaleCache;

    Image(Object image) {
        this.image = image;
    }

    Image(int[] imageArray, int w, int h) {
        this(Display.getInstance().getImplementation().createImage(imageArray, w, h));
    }

    Image getCachedImage(Dimension size) {
        WeakReference w;
        if (this.scaleCache != null && (w = (WeakReference)this.scaleCache.get(size)) != null) {
            return (Image)w.get();
        }
        return null;
    }

    void cacheImage(Dimension size, Image i) {
        if (this.scaleCache == null) {
            this.scaleCache = new Hashtable();
        }
        WeakReference<Image> w = new WeakReference<Image>(i);
        this.scaleCache.put(size, w);
    }

    void setImage(Object image) {
        this.image = image;
    }

    void setOpaque(boolean opaque) {
        this.opaque = opaque;
    }

    public Image subImage(int x, int y, int width, int height, boolean processAlpha) {
        int[] arr = new int[width * height];
        this.getRGB(arr, 0, x, y, width, height);
        Image i = new Image(Display.getInstance().getImplementation().createImage(arr, width, height));
        i.opaque = this.opaque;
        i.opaqueTested = this.opaqueTested;
        return i;
    }

    public Image rotate(int degrees) {
        LWUITImplementation i = Display.getInstance().getImplementation();
        if (i.isRotationDrawingSupported()) {
            if (degrees >= 90) {
                int newTransform = 0;
                newTransform = this.transform != 0 ? (this.transform + degrees) % 360 : degrees % 360;
                newTransform -= (degrees %= 90);
                if (degrees != 0) {
                    Image newImage = new Image(Display.getInstance().getImplementation().rotate(this.image, degrees));
                    newImage.transform = newTransform;
                    return newImage;
                }
                Image newImage = new Image(this.image);
                newImage.transform = newTransform;
                return newImage;
            }
            if (degrees != 0) {
                return new Image(Display.getInstance().getImplementation().rotate(this.image, degrees));
            }
            return this;
        }
        return new Image(Display.getInstance().getImplementation().rotate(this.image, degrees));
    }

    public Image modifyAlpha(byte alpha) {
        int w = this.getWidth();
        int h = this.getHeight();
        int size = w * h;
        int[] arr = new int[size];
        this.getRGB(arr, 0, 0, 0, w, h);
        int alphaInt = alpha << 24 & 0xFF000000;
        for (int iter = 0; iter < size; ++iter) {
            if ((arr[iter] & 0xFF000000) == 0) continue;
            arr[iter] = arr[iter] & 0xFFFFFF | alphaInt;
        }
        Image i = new Image(arr, w, h);
        i.opaqueTested = true;
        i.opaque = false;
        return i;
    }

    public Image modifyAlpha(byte alpha, int removeColor) {
        removeColor &= 0xFFFFFF;
        int w = this.getWidth();
        int h = this.getHeight();
        int size = w * h;
        int[] arr = new int[size];
        this.getRGB(arr, 0, 0, 0, w, h);
        int alphaInt = alpha << 24 & 0xFF000000;
        for (int iter = 0; iter < size; ++iter) {
            if ((arr[iter] & 0xFF000000) == 0) continue;
            arr[iter] = arr[iter] & 0xFFFFFF | alphaInt;
            if (removeColor != (0xFFFFFF & arr[iter])) continue;
            arr[iter] = 0;
        }
        Image i = new Image(arr, w, h);
        i.opaqueTested = true;
        i.opaque = false;
        return i;
    }

    public static Image createImage(String path) throws IOException {
        try {
            return new Image(Display.getInstance().getImplementation().createImage(path));
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(path));
        }
    }

    public static Image createImage(InputStream stream) throws IOException {
        try {
            return new Image(Display.getInstance().getImplementation().createImage(stream));
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(stream));
        }
    }

    public static Image createImage(int[] rgb, int width, int height) {
        try {
            Image i = new Image(Display.getInstance().getImplementation().createImage(rgb, width, height));
            i.testOpaque(rgb);
            return i;
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(rgb, width, height));
        }
    }

    public static Image createImage(int width, int height) {
        return Image.createImage(width, height, -1);
    }

    public static boolean isAlphaMutableImageSupported() {
        return Display.getInstance().getImplementation().isAlphaMutableImageSupported();
    }

    public static Image createImage(int width, int height, int fillColor) {
        try {
            return new Image(Display.getInstance().getImplementation().createMutableImage(width, height, fillColor));
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createMutableImage(width, height, fillColor));
        }
    }

    public static Image createImage(byte[] bytes, int offset, int len) {
        try {
            return new Image(Display.getInstance().getImplementation().createImage(bytes, offset, len));
        }
        catch (OutOfMemoryError err) {
            System.gc();
            System.gc();
            return new Image(Display.getInstance().getImplementation().createImage(bytes, offset, len));
        }
    }

    public Graphics getGraphics() {
        return new Graphics(Display.getInstance().getImplementation().getNativeGraphics(this.image));
    }

    public int getWidth() {
        return Display.getInstance().getImplementation().getImageWidth(this.image);
    }

    public int getHeight() {
        return Display.getInstance().getImplementation().getImageHeight(this.image);
    }

    void drawImage(Graphics g, int x, int y) {
        g.drawImage(this.image, x, y, this.transform);
    }

    void getRGB(int[] rgbData, int offset, int x, int y, int width, int height) {
        Display.getInstance().getImplementation().getRGB(this.image, rgbData, offset, x, y, width, height);
    }

    public void toRGB(RGBImage image, int destX, int destY, int x, int y, int width, int height) {
        this.getRGB(image.getRGB(), destX * destY, x, y, width, height);
    }

    public int[] getRGB() {
        int[] r = this.getRGBCache();
        if (r == null) {
            r = this.getRGBImpl();
            this.rgbCache = new WeakReference<int[]>(r);
        }
        return r;
    }

    int[] getRGBCache() {
        if (this.rgbCache != null) {
            int[] rgb = (int[])this.rgbCache.get();
            return rgb;
        }
        return null;
    }

    int[] getRGBImpl() {
        int width = this.getWidth();
        int height = this.getHeight();
        int[] rgbData = new int[width * height];
        this.getRGB(rgbData, 0, 0, 0, width, height);
        return rgbData;
    }

    public Image scaledWidth(int width) {
        float ratio = (float)width / (float)this.getWidth();
        return this.scaled(width, (int)((float)this.getHeight() * ratio));
    }

    public Image scaledHeight(int height) {
        float ratio = (float)height / (float)this.getHeight();
        return this.scaled((int)((float)this.getWidth() * ratio), height);
    }

    public Image scaledSmallerRatio(int width, int height) {
        float wRatio;
        float hRatio = (float)height / (float)this.getHeight();
        if (hRatio < (wRatio = (float)width / (float)this.getWidth())) {
            return this.scaled(width, (int)((float)this.getHeight() * hRatio));
        }
        return this.scaled((int)((float)this.getWidth() * wRatio), height);
    }

    public Image scaled(int width, int height) {
        if (width == this.getWidth() && height == this.getHeight()) {
            return this;
        }
        Dimension d = new Dimension(width, height);
        Image i = this.getCachedImage(d);
        if (i != null) {
            return i;
        }
        i = new Image(this.image);
        i.scale(width, height);
        i.transform = this.transform;
        this.cacheImage(d, i);
        return i;
    }

    Object getImage() {
        return this.image;
    }

    public void scale(int width, int height) {
        this.image = Display.getInstance().getImplementation().scale(this.image, width, height);
    }

    boolean scaleArray(int srcWidth, int srcHeight, int height, int width, int[] currentArray, int[] destinationArray) {
        int yRatio = (srcHeight << 16) / height;
        int xRatio = (srcWidth << 16) / width;
        int xPos = xRatio / 2;
        int yPos = yRatio / 2;
        boolean opaque = Display.getInstance().numColors() <= 65536;
        for (int y = 0; y < height; ++y) {
            int srcY = yPos >> 16;
            this.getRGB(currentArray, 0, 0, srcY, srcWidth, 1);
            for (int x = 0; x < width; ++x) {
                int srcX = xPos >> 16;
                int destPixel = x + y * width;
                if (destPixel >= 0 && destPixel < destinationArray.length && srcX < currentArray.length) {
                    destinationArray[destPixel] = currentArray[srcX];
                    opaque = opaque && (currentArray[srcX] & 0xFF000000) == -16777216;
                }
                xPos += xRatio;
            }
            yPos += yRatio;
            xPos = xRatio / 2;
        }
        this.opaque = opaque;
        return opaque;
    }

    public boolean isAnimation() {
        return false;
    }

    private void testOpaque(int[] rgb) {
        if (!this.opaqueTested) {
            this.opaque = true;
            for (int iter = 0; iter < rgb.length; ++iter) {
                if ((rgb[iter] & 0xFF000000) == -16777216) continue;
                this.opaque = false;
                break;
            }
            this.opaqueTested = true;
        }
    }

    public boolean isOpaque() {
        if (!this.opaqueTested) {
            this.testOpaque(this.getRGB());
        }
        return this.opaque;
    }
}

