/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.EventDispatcher;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Label;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class List
extends Component {
    public static final int FIXED_NONE = 0;
    public static final int FIXED_NONE_CYCLIC = 1;
    public static final int FIXED_NONE_ONE_ELEMENT_MARGIN_FROM_EDGE = 2;
    private static final int FIXED_NONE_BOUNDRY = 9;
    public static final int FIXED_LEAD = 10;
    public static final int FIXED_TRAIL = 11;
    public static final int FIXED_CENTER = 12;
    private Object renderingPrototype;
    private int fixedSelection;
    private ListModel model;
    private ListCellRenderer renderer = new DefaultListCellRenderer();
    private int orientation = 0;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private static final String id = "List";
    private EventDispatcher dispatcher = new EventDispatcher();
    private Dimension elemSize;
    private Dimension selectedElemSize;
    private boolean inputOnFocus = true;
    private boolean numericKeyActions = true;
    private boolean paintFocusBehindList = true;
    private int itemGap = 2;
    private int borderGap = 2;
    private Listeners listener;
    private int animationPosition;
    private int destination;
    private Motion listMotion;
    private boolean fireOnClick = true;

    public List(Vector items) {
        this(new DefaultListModel(items));
    }

    public List(Object[] items) {
        this(new DefaultListModel(items));
    }

    public List() {
        this(new DefaultListModel());
    }

    public List(ListModel model) {
        this.setModel(model);
        LookAndFeel laf = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(laf.isDefaultSmoothScrolling());
    }

    void initComponentImpl() {
        super.initComponentImpl();
        this.dataChanged(0, 0);
        this.bindListeners();
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        if (this.listener != null) {
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.listener = null;
        }
    }

    protected void initComponent() {
        if (this.isSmoothScrolling()) {
            this.getComponentForm().registerAnimated(this);
        }
    }

    protected void modelChanged(int status, int index) {
    }

    public boolean isScrollableY() {
        return this.getPreferredH() > this.getHeight() && this.fixedSelection < 9 && this.orientation == 0;
    }

    public boolean isScrollableX() {
        return this.getPreferredW() > this.getWidth() && this.fixedSelection < 9 && this.orientation != 0;
    }

    public int size() {
        return this.model.getSize();
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public void setSelectedIndex(int index) {
        this.setSelectedIndex(index, true);
    }

    public void setSelectedIndex(int index, boolean scrollToSelection) {
        if (index < 0) {
            throw new IllegalArgumentException("Selection index is negative:" + index);
        }
        this.model.setSelectedIndex(index);
        if (scrollToSelection) {
            Dimension size = this.getElementSize(false);
            Rectangle rect = this.getOrientation() == 0 ? new Rectangle(this.getX(), (size.getHeight() + this.itemGap) * Math.max(0, index), size) : new Rectangle((size.getWidth() + this.itemGap) * Math.max(0, index), this.getY(), size);
            this.scrollRectToVisible(rect);
        }
    }

    public Object getSelectedItem() {
        int idx = this.model.getSelectedIndex();
        if (idx < this.model.getSize()) {
            return this.model.getItemAt(idx);
        }
        return null;
    }

    public void setSelectedItem(Object item) {
        int size = this.model.getSize();
        for (int iter = 0; iter < size; ++iter) {
            if (this.model.getItemAt(iter) != item) continue;
            this.model.setSelectedIndex(iter);
            break;
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    void dataChanged(int status, int index) {
        this.setShouldCalcPreferredSize(true);
        this.elemSize = null;
        this.selectedElemSize = null;
        if (this.getSelectedIndex() >= this.model.getSize()) {
            this.setSelectedIndex(Math.max(this.model.getSize() - 1, 0));
        }
        this.modelChanged(status, index);
        this.repaint();
    }

    private void bindListeners() {
        if (this.listener == null) {
            this.listener = new Listeners();
            this.model.addDataChangedListener(this.listener);
            this.model.addSelectionListener(this.listener);
        }
    }

    public void setModel(ListModel model) {
        if (this.model != null) {
            this.setShouldCalcPreferredSize(true);
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.model = model;
            this.listener = null;
            if (this.getPreferredH() < this.getScrollY() + this.getHeight()) {
                this.setScrollY(0);
            }
            if (this.getPreferredW() < this.getScrollX() + this.getWidth()) {
                this.setScrollX(0);
            }
        }
        this.model = model;
        if (this.isInitialized()) {
            this.bindListeners();
        }
        this.repaint();
    }

    public boolean isNumericKeyActions() {
        return this.numericKeyActions;
    }

    public void setNumericKeyActions(boolean numericKeyActions) {
        this.numericKeyActions = numericKeyActions;
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        if (this.renderer != null) {
            this.elemSize = null;
            this.selectedElemSize = null;
            this.setShouldCalcPreferredSize(true);
        }
        this.renderer = renderer;
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void refreshTheme() {
        ListCellRenderer r = this.getRenderer();
        if (this.renderingPrototype != null) {
            r.getListCellRendererComponent(this, this.renderingPrototype, 0, false).refreshTheme();
        } else if (this.getModel().getSize() > 0) {
            r.getListCellRendererComponent(this, this.getModel().getItemAt(0), 0, false).refreshTheme();
        } else {
            r.getListCellRendererComponent(this, null, 0, false).refreshTheme();
        }
        Component focus = r.getListFocusComponent(this);
        if (focus != null) {
            focus.refreshTheme();
        }
        super.refreshTheme();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void scrollRectToVisible(Rectangle rect) {
        if (this.fixedSelection < 9) {
            if (this.orientation == 0) {
                super.scrollRectToVisible(new Rectangle(this.getScrollX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight() + this.itemGap), this);
            } else {
                super.scrollRectToVisible(new Rectangle(rect.getX(), this.getScrollY(), rect.getSize().getWidth() + this.itemGap, rect.getSize().getHeight()), this);
            }
        }
    }

    public void setHandlesInput(boolean b) {
        Form f = this.getComponentForm();
        if (f != null) {
            super.setHandlesInput(b || f.isSingleFocusMode());
        } else {
            super.setHandlesInput(b);
        }
    }

    protected void fireClicked() {
        boolean h = this.handlesInput();
        this.setHandlesInput(!h);
        if (h) {
            this.fireActionEvent();
        }
        this.repaint();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void keyReleased(int keyCode) {
        int offset;
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (gameAction == 8) {
            boolean h = this.handlesInput();
            this.setHandlesInput(!h);
            if (h) {
                this.fireActionEvent();
            }
            this.repaint();
            return;
        }
        if (this.numericKeyActions && gameAction != 2 && gameAction != 5 && gameAction != 1 && gameAction != 6 && keyCode >= 49 && keyCode <= 57 && (offset = keyCode - 49) < this.getModel().getSize()) {
            this.setSelectedIndex(offset);
            this.fireActionEvent();
        }
    }

    public void keyPressed(int keyCode) {
        int keyBck;
        int keyFwd;
        if (!this.handlesInput()) {
            return;
        }
        int gameAction = Display.getInstance().getGameAction(keyCode);
        if (this.getOrientation() == 0) {
            keyFwd = 6;
            keyBck = 1;
            if (gameAction == 2 || gameAction == 5) {
                this.setHandlesInput(false);
            }
        } else {
            keyFwd = 5;
            keyBck = 2;
            if (gameAction == 6 || gameAction == 1) {
                this.setHandlesInput(false);
            }
        }
        int selectedIndex = this.model.getSelectedIndex();
        if (gameAction == keyBck) {
            if (--selectedIndex < 0) {
                if (this.fixedSelection != 0 && this.fixedSelection != 2) {
                    selectedIndex = this.size() - 1;
                } else {
                    selectedIndex = 0;
                    this.setHandlesInput(false);
                }
            }
        } else if (gameAction == keyFwd && ++selectedIndex >= this.size()) {
            if (this.fixedSelection != 0 && this.fixedSelection != 2) {
                selectedIndex = 0;
            } else {
                selectedIndex = this.size() - 1;
                this.setHandlesInput(false);
            }
        }
        if (selectedIndex != this.model.getSelectedIndex()) {
            this.model.setSelectedIndex(selectedIndex);
            this.updateAnimationPosition(gameAction == keyFwd ? 1 : -1);
            if (this.fixedSelection == 0 || this.fixedSelection == 1) {
                this.selectElement(selectedIndex);
            }
            if (this.fixedSelection == 2) {
                if (keyFwd == gameAction) {
                    this.selectElement(Math.min(selectedIndex + 1, this.getModel().getSize() - 1));
                } else {
                    this.selectElement(Math.max(selectedIndex - 1, 0));
                }
            }
        }
        this.repaint();
    }

    private void selectElement(int selectedIndex) {
        Dimension size = this.getElementSize(false);
        Rectangle rect = this.getOrientation() == 0 ? new Rectangle(this.getX(), (size.getHeight() + this.itemGap) * selectedIndex, this.getElementSize(true)) : new Rectangle((size.getWidth() + this.itemGap) * selectedIndex, this.getY(), this.getElementSize(true));
        this.scrollRectToVisible(rect);
    }

    private void updateAnimationPosition(int direction) {
        if (this.animationPosition != 0) {
            return;
        }
        if (this.isSmoothScrolling()) {
            this.animationPosition = this.orientation == 0 ? (this.animationPosition += direction * this.getElementSize(false).getHeight()) : (this.animationPosition += direction * this.getElementSize(false).getWidth());
            this.destination = Math.abs(this.animationPosition);
            this.initListMotion();
        }
    }

    private void initListMotion() {
        this.listMotion = Motion.createSplineMotion(0, this.destination, this.getScrollAnimationSpeed());
        this.listMotion.start();
    }

    private void calculateComponentPosition(int index, int defaultWidth, Rectangle rect, Dimension rendererSize, Dimension selectedSize, boolean beforeSelected) {
        Style style = this.getStyle();
        int initialY = style.getPadding(0);
        int initialX = style.getPadding(1);
        int selection = this.getSelectedIndex();
        Dimension d = rect.getSize();
        if (this.orientation == 0) {
            int height = rendererSize.getHeight();
            int selectedDiff = selectedSize.getHeight() - height;
            rect.setX(initialX);
            d.setHeight(height);
            d.setWidth(defaultWidth);
            int y = 0;
            int listHeight = this.getHeight() - style.getPadding(0) - style.getPadding(2);
            int totalHeight = (height + this.itemGap) * this.getModel().getSize() + selectedDiff;
            switch (this.fixedSelection) {
                case 12: {
                    y = listHeight / 2 - (height + this.itemGap + selectedDiff) / 2 + (index - selection) * (height + this.itemGap);
                    if (!beforeSelected) {
                        y += selectedDiff;
                    }
                    y = this.recalcOffset(y, totalHeight, listHeight, height + this.itemGap);
                    break;
                }
                case 11: {
                    y = listHeight - (height + this.itemGap + selectedDiff);
                }
                case 10: {
                    y += (index - selection) * (height + this.itemGap);
                    if (index - selection > 0) {
                        y += selectedDiff;
                    }
                    y = this.recalcOffset(y, totalHeight, listHeight, height + this.itemGap);
                    break;
                }
                default: {
                    y = index * (height + this.itemGap);
                    if (beforeSelected) break;
                    y += selectedDiff;
                }
            }
            rect.setY(y + initialY);
            if (index == selection) {
                d.setHeight(d.getHeight() + selectedDiff);
            }
        } else {
            int width = rendererSize.getWidth();
            int selectedDiff = selectedSize.getWidth() - width;
            rect.setY(initialY);
            d.setHeight(this.getHeight() - style.getPadding(0) - style.getPadding(2));
            d.setWidth(width);
            int x = 0;
            int listWidth = this.getWidth() - style.getPadding(3) - style.getPadding(1);
            int totalWidth = (width + this.itemGap) * this.getModel().getSize() + selectedDiff;
            switch (this.fixedSelection) {
                case 12: {
                    x = listWidth / 2 - (width + this.itemGap + selectedDiff) / 2 + (index - selection) * (width + this.itemGap);
                    if (!beforeSelected) {
                        x += selectedDiff;
                    }
                    x = this.recalcOffset(x, totalWidth, listWidth, width + this.itemGap);
                    break;
                }
                case 11: {
                    x = listWidth - (width + this.itemGap + selectedDiff);
                }
                case 10: {
                    x += (index - selection) * (width + this.itemGap);
                    if (index - selection > 0) {
                        x += selectedDiff;
                    }
                    x = this.recalcOffset(x, totalWidth, listWidth, width + this.itemGap);
                    break;
                }
                default: {
                    x = index * (width + this.itemGap);
                    if (beforeSelected) break;
                    x += selectedDiff;
                }
            }
            rect.setX(initialX + x);
            if (index == selection) {
                d.setWidth(d.getWidth() + selectedDiff);
            }
        }
    }

    private int recalcOffset(int offset, int totalSize, int viewSize, int componentSize) {
        if (offset + this.animationPosition % componentSize > viewSize) {
            offset -= totalSize;
        } else if (offset + this.animationPosition % componentSize < 1 - componentSize) {
            offset += totalSize;
        }
        return offset;
    }

    public void paint(Graphics g) {
        int numOfcomponents;
        UIManager.getInstance().getLookAndFeel().drawList(g, this);
        Style style = this.getStyle();
        int width = this.getWidth() - style.getPadding(3) - style.getPadding(1) - this.getSideGap();
        if (this.isScrollableX()) {
            width = Math.max(width, this.getPreferredW() - style.getPadding(3) - style.getPadding(1) - this.getSideGap());
        }
        if ((numOfcomponents = this.model.getSize()) == 0) {
            return;
        }
        int xTranslate = this.getX();
        int yTranslate = this.getY();
        g.translate(xTranslate, yTranslate);
        Rectangle pos = new Rectangle();
        Dimension rendererSize = this.getElementSize(false);
        int selection = this.model.getSelectedIndex();
        if (this.animationPosition != 0 && this.fixedSelection > 9) {
            selection = -1;
            if (this.orientation == 0) {
                yTranslate += this.animationPosition;
                g.translate(0, this.animationPosition);
            } else {
                xTranslate += this.animationPosition;
                g.translate(this.animationPosition, 0);
            }
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (this.paintFocusBehindList) {
            this.paintFocus(g, width, pos, rendererSize);
        }
        boolean shouldBreak = false;
        int startingPoint = 0;
        if (this.fixedSelection < 9) {
            startingPoint = Math.max(0, this.pointerSelect(clipX + this.getAbsoluteX(), clipY + this.getAbsoluteY()) - 1);
        }
        for (int i = startingPoint; i < numOfcomponents; ++i) {
            if (i == this.getSelectedIndex() && this.animationPosition == 0) continue;
            this.calculateComponentPosition(i, width, pos, rendererSize, this.getElementSize(true), i <= this.getSelectedIndex());
            if (pos.intersects(clipX, clipY, clipWidth, clipHeight)) {
                Object value = this.model.getItemAt(i);
                Component cmp = this.renderer.getListCellRendererComponent(this, value, i, false);
                cmp.setCellRenderer(true);
                Dimension size = pos.getSize();
                this.renderComponent(g, cmp, pos.getX(), pos.getY(), size.getWidth(), size.getHeight());
                shouldBreak = true;
                continue;
            }
            if (shouldBreak && this.fixedSelection < 9) break;
        }
        if (!this.paintFocusBehindList) {
            this.paintFocus(g, width, pos, rendererSize);
        } else {
            this.calculateComponentPosition(this.getSelectedIndex(), width, pos, rendererSize, this.getElementSize(true), true);
        }
        Dimension size = pos.getSize();
        if (this.animationPosition == 0 && this.model.getSize() > 0) {
            Component selected = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(selection), selection, true);
            this.renderComponent(g, selected, pos.getX(), pos.getY(), size.getWidth(), size.getHeight());
        }
        g.translate(-xTranslate, -yTranslate);
    }

    private void paintFocus(Graphics g, int width, Rectangle pos, Dimension rendererSize) {
        this.calculateComponentPosition(this.getSelectedIndex(), width, pos, rendererSize, this.getElementSize(true), true);
        Dimension size = pos.getSize();
        Component cmp = this.renderer.getListFocusComponent(this);
        if (cmp != null) {
            cmp.setCellRenderer(true);
            int x = pos.getX();
            int y = pos.getY();
            if (this.orientation == 0) {
                y -= this.animationPosition;
            } else {
                x -= this.animationPosition;
            }
            this.renderComponent(g, cmp, x, y, size.getWidth(), size.getHeight());
        }
    }

    private void renderComponent(Graphics g, Component cmp, int x, int y, int width, int height) {
        Style s = cmp.getStyle();
        int left = s.getMargin(1);
        int top = s.getMargin(0);
        cmp.setWidth(width - left - s.getMargin(3));
        cmp.setHeight(height - top - s.getMargin(2));
        cmp.setX(x + left);
        cmp.setY(y + top);
        cmp.paintInternal(g);
    }

    protected String getUIID() {
        return id;
    }

    public void addSelectionListener(SelectionListener l) {
        this.model.addSelectionListener(l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.model.removeSelectionListener(l);
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    protected void fireActionEvent() {
        if (this.isEnabled()) {
            super.fireActionEvent();
            this.dispatcher.fireActionEvent(new ActionEvent(this));
        }
    }

    public void setInputOnFocus(boolean inputOnFocus) {
        this.inputOnFocus = inputOnFocus;
    }

    public void setPaintFocusBehindList(boolean paintFocusBehindList) {
        this.paintFocusBehindList = paintFocusBehindList;
    }

    void focusGainedInternal() {
        if (this.inputOnFocus) {
            this.setHandlesInput(true);
        }
    }

    void focusLostInternal() {
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public void setItemGap(int itemGap) {
        this.itemGap = itemGap;
    }

    public void setRenderingPrototype(Object renderingPrototype) {
        this.renderingPrototype = renderingPrototype;
    }

    public Object getRenderingPrototype() {
        return this.renderingPrototype;
    }

    Dimension getElementSize(boolean selected) {
        if (selected) {
            if (this.selectedElemSize == null) {
                if (this.renderingPrototype == null && this.model.getSize() == 0) {
                    return new Label("XXXXXX").getPreferredSize();
                }
                this.selectedElemSize = this.calculateElementSize(true);
            }
            return this.selectedElemSize;
        }
        if (this.elemSize == null) {
            if (this.renderingPrototype == null && this.model.getSize() == 0) {
                return new Label("XXXXXX").getPreferredSize();
            }
            this.elemSize = this.calculateElementSize(false);
        }
        return this.elemSize;
    }

    private Dimension calculateElementSize(boolean selected) {
        if (this.renderingPrototype != null) {
            Component unselected = this.renderer.getListCellRendererComponent(this, this.renderingPrototype, 0, selected);
            return unselected.getPreferredSize();
        }
        int width = 0;
        int height = 0;
        int elements = Math.min(5, this.model.getSize());
        for (int iter = 0; iter < elements; ++iter) {
            Component cmp = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(iter), iter, selected);
            Dimension d = cmp.getPreferredSize();
            width = Math.max(width, d.getWidth());
            height = Math.max(height, d.getHeight());
        }
        return new Dimension(width, height);
    }

    public void pointerDragged(int x, int y) {
        if (this.isSmoothScrolling()) {
            super.pointerDragged(x, y);
        } else {
            this.model.setSelectedIndex(this.pointerSelect(x, y));
        }
    }

    private int pointerSelect(int x, int y) {
        int selectedIndex = -1;
        int numOfcomponents = this.getModel().getSize();
        Style style = this.getStyle();
        Dimension rendererSize = this.getElementSize(false);
        Dimension selectedSize = this.getElementSize(true);
        Rectangle pos = new Rectangle();
        int width = this.getWidth() - style.getPadding(3) - style.getPadding(1) - this.getSideGap();
        if (this.isScrollableX()) {
            width = Math.max(width, this.getPreferredW() - style.getPadding(3) - style.getPadding(1) - this.getSideGap());
        }
        y -= this.getAbsoluteY();
        x -= this.getAbsoluteX();
        if (this.fixedSelection < 9) {
            this.calculateComponentPosition(this.getSelectedIndex(), width, pos, rendererSize, this.getElementSize(true), true);
            if (this.orientation == 0) {
                if (y < pos.getY()) {
                    selectedIndex = y / (rendererSize.getHeight() + this.itemGap);
                } else {
                    int current = this.getSelectedIndex();
                    selectedIndex = y < pos.getY() + selectedSize.getHeight() ? current : current + 1 + (y - (pos.getY() + selectedSize.getHeight())) / (rendererSize.getHeight() + this.itemGap);
                }
            } else if (x < pos.getX()) {
                selectedIndex = x / (rendererSize.getWidth() + this.itemGap);
            } else {
                int current = this.getSelectedIndex();
                selectedIndex = x < pos.getX() + selectedSize.getWidth() ? current : current + 1 + (x - (pos.getX() + selectedSize.getWidth())) / (rendererSize.getWidth() + this.itemGap);
            }
        } else {
            for (int i = 0; i < numOfcomponents; ++i) {
                this.calculateComponentPosition(i, width, pos, rendererSize, selectedSize, true);
                if (!pos.contains(x, y)) continue;
                selectedIndex = i;
                break;
            }
        }
        if (selectedIndex < 0 || selectedIndex >= this.size()) {
            return -1;
        }
        return selectedIndex;
    }

    public void setFireOnClick(boolean fireOnClick) {
        this.fireOnClick = fireOnClick;
    }

    public void pointerReleased(int x, int y) {
        if (this.isDragActivated()) {
            super.pointerReleased(x, y);
            return;
        }
        int current = this.model.getSelectedIndex();
        int selection = this.pointerSelect(x, y);
        if (selection > -1) {
            this.model.setSelectedIndex(selection);
            if (this.fireOnClick) {
                this.fireActionEvent();
            } else if (current == selection) {
                this.fireActionEvent();
            }
        }
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getListPreferredSize(this);
    }

    public void addItem(Object item) {
        this.model.addItem(item);
    }

    public int getFixedSelection() {
        return this.fixedSelection;
    }

    public void setFixedSelection(int fixedSelection) {
        this.fixedSelection = fixedSelection;
    }

    public boolean animate() {
        boolean parentFinished = super.animate();
        if (this.animationPosition != 0) {
            this.animationPosition = this.animationPosition < 0 ? Math.min(this.listMotion.getValue() - this.destination, 0) : Math.max(this.destination - this.listMotion.getValue(), 0);
            return true;
        }
        return parentFinished;
    }

    public void setBorderGap(int borderGap) {
        this.borderGap = borderGap;
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    protected String paramString() {
        String elemSizeStr = "element size = ";
        if (this.elemSize != null) {
            elemSizeStr = elemSizeStr + this.elemSize.toString();
        }
        return super.paramString() + ", " + elemSizeStr + ", itemGap = " + this.itemGap + ", orientation = " + this.orientation + ", selected index = " + this.getSelectedIndex() + ", size = " + this.size();
    }

    private class Listeners
    implements DataChangedListener,
    SelectionListener {
        private Listeners() {
        }

        public void dataChanged(int status, int index) {
            List.this.dataChanged(status, index);
        }

        public void selectionChanged(int oldSelected, int newSelected) {
            List.this.repaint();
        }
    }
}

