/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Button;
import com.sun.lwuit.Calendar;
import com.sun.lwuit.CheckBox;
import com.sun.lwuit.ComboBox;
import com.sun.lwuit.Component;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Date;

public class DefaultLookAndFeel
extends LookAndFeel
implements FocusListener {
    private static final long DAY = 86400000L;
    private Image[] chkBoxImages = null;
    private Image comboImage = null;
    private Image[] rButtonImages = null;
    private static int DAY_SPACE_W = 12;
    private static int DAY_SPACE_H = 15;
    private long tickerSpeed = 50L;
    private boolean tickWhenFocused = true;

    public void bind(Component cmp) {
        if (this.tickWhenFocused && cmp instanceof Label) {
            ((Label)cmp).addFocusListener(this);
        }
    }

    public long getTickerSpeed() {
        return this.tickerSpeed;
    }

    public void setTickerSpeed(long tickerSpeed) {
        this.tickerSpeed = tickerSpeed;
    }

    public void setTickWhenFocused(boolean tickWhenFocused) {
        this.tickWhenFocused = tickWhenFocused;
    }

    public void setCheckBoxImages(Image checked, Image unchecked) {
        this.chkBoxImages = checked == null || unchecked == null ? null : new Image[]{unchecked, checked};
    }

    public void setComboBoxImage(Image picker) {
        this.comboImage = picker;
    }

    public void setRadioButtonImages(Image selected, Image unselected) {
        this.rButtonImages = selected == null || unselected == null ? null : new Image[]{unselected, selected};
    }

    public void drawButton(Graphics g, Button b) {
        this.drawComponent(g, b, this.getIconFromState(b), null, 0);
    }

    public void drawCheckBox(Graphics g, CheckBox cb) {
        if (this.chkBoxImages != null) {
            this.drawComponent(g, cb, this.getIconFromState(cb), this.chkBoxImages[cb.isSelected() ? 1 : 0], 0);
        } else {
            int gradientColor;
            Style style = cb.getStyle();
            int height = cb.getHeight();
            this.drawComponent(g, cb, this.getIconFromState(cb), null, height);
            if (cb.hasFocus()) {
                g.setColor(style.getFgSelectionColor());
                gradientColor = style.getBgSelectionColor();
            } else {
                g.setColor(style.getFgColor());
                gradientColor = style.getBgColor();
            }
            int width = height;
            int tX = cb.getX() + style.getPadding(1);
            int tY = cb.getY() + style.getPadding(0) + (cb.getHeight() - style.getPadding(0) - style.getPadding(2)) / 2 - height / 2;
            g.translate(tX, tY);
            int x = DefaultLookAndFeel.scaleCoordinate(1.04f, 16.0f, width);
            int y = DefaultLookAndFeel.scaleCoordinate(4.0f, 16.0f, height);
            int rectWidth = DefaultLookAndFeel.scaleCoordinate(10.9515f, 16.0f, width);
            int rectHeight = DefaultLookAndFeel.scaleCoordinate(10.0f, 16.0f, height);
            int destColor = this.findDestColor(gradientColor);
            g.fillLinearGradient(gradientColor, destColor, x + 1, y + 1, rectWidth - 2, rectHeight - 1, false);
            g.drawRoundRect(x, y, rectWidth, rectHeight, 5, 5);
            if (cb.isSelected()) {
                int color = g.getColor();
                g.setColor(0x111111);
                g.translate(0, 1);
                DefaultLookAndFeel.fillCheckbox(g, width, height);
                g.setColor(color);
                g.translate(0, -1);
                DefaultLookAndFeel.fillCheckbox(g, width, height);
            }
            g.translate(-tX, -tY);
        }
    }

    private static void fillCheckbox(Graphics g, int width, int height) {
        int x1 = DefaultLookAndFeel.scaleCoordinate(2.0450494f, 16.0f, width);
        int y1 = DefaultLookAndFeel.scaleCoordinate(9.422772f, 16.0f, height);
        int x2 = DefaultLookAndFeel.scaleCoordinate(5.8675723f, 16.0f, width);
        int y2 = DefaultLookAndFeel.scaleCoordinate(13.921746f, 16.0f, height);
        int x3 = DefaultLookAndFeel.scaleCoordinate(5.8675723f, 16.0f, width);
        int y3 = DefaultLookAndFeel.scaleCoordinate(11.0f, 16.0f, height);
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
        x1 = DefaultLookAndFeel.scaleCoordinate(14.38995f, 16.0f, width);
        y1 = DefaultLookAndFeel.scaleCoordinate(0.887668f, 16.0f, height);
        g.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    private static int round(float x) {
        int rounded = (int)x;
        if (x - (float)rounded > 0.5f) {
            return rounded + 1;
        }
        return rounded;
    }

    private static int scaleCoordinate(float coordinate, float plain, int pixelSize) {
        return DefaultLookAndFeel.round(coordinate / plain * (float)pixelSize);
    }

    public void drawLabel(Graphics g, Label l) {
        this.drawComponent(g, l, l.getIcon(), null, 0);
    }

    public void drawRadioButton(Graphics g, RadioButton rb) {
        if (this.rButtonImages != null) {
            this.drawComponent(g, rb, this.getIconFromState(rb), this.rButtonImages[rb.isSelected() ? 1 : 0], 0);
        } else {
            Style style = rb.getStyle();
            int height = rb.getHeight();
            this.drawComponent(g, rb, this.getIconFromState(rb), null, height + rb.getGap());
            if (rb.hasFocus()) {
                g.setColor(style.getFgSelectionColor());
            } else {
                g.setColor(style.getFgColor());
            }
            int x = rb.getX() + style.getPadding(1);
            int y = rb.getY() + style.getPadding(0);
            g.drawArc(x, y, height -= style.getPadding(0) + style.getPadding(2), height, 0, 360);
            if (rb.isSelected()) {
                int color = g.getColor();
                int destColor = this.findDestColor(color);
                g.fillRadialGradient(color, destColor, x + 3, y + 3, height - 5, height - 5);
            }
        }
    }

    public void drawComboBox(Graphics g, ComboBox cb) {
        int border = 2;
        Style style = cb.getStyle();
        int leftPadding = style.getPadding(1);
        int rightPadding = style.getPadding(3);
        this.setFG(g, cb);
        ListModel model = cb.getModel();
        ListCellRenderer renderer = cb.getRenderer();
        Object value = model.getItemAt(model.getSelectedIndex());
        int comboImageWidth = this.comboImage != null ? this.comboImage.getWidth() : style.getFont().getHeight();
        if (model.getSize() > 0) {
            Component cmp = renderer.getListCellRendererComponent(cb, value, model.getSelectedIndex(), cb.hasFocus());
            cmp.setX(cb.getX() + leftPadding);
            cmp.setY(cb.getY() + style.getPadding(0));
            cmp.setWidth(cb.getWidth() - comboImageWidth - 2 * rightPadding - leftPadding);
            cmp.setHeight(cb.getHeight() - style.getPadding(0) - style.getPadding(2));
            cmp.paint(g);
        }
        g.setColor(style.getBgColor());
        int y = cb.getY();
        int height = cb.getHeight();
        int width = comboImageWidth + border;
        int x = cb.getX() + cb.getWidth() - comboImageWidth - rightPadding - border;
        if (this.comboImage != null) {
            g.fillRect(x, y, width, height);
            g.drawImage(this.comboImage, x, y + height / 2 - this.comboImage.getHeight() / 2);
        } else {
            int color = g.getColor();
            int destColor = this.findDestColor(color);
            g.fillLinearGradient(g.getColor(), destColor, x, y, width, height, false);
            g.setColor(color);
            g.drawRect(x, y, width, height - 1);
            g.translate(x + 1, y + 1);
            g.setColor(0x111111);
            int x1 = DefaultLookAndFeel.scaleCoordinate(2.5652082f, 16.0f, --width);
            int y1 = DefaultLookAndFeel.scaleCoordinate(4.4753666f, 16.0f, --height);
            int x2 = DefaultLookAndFeel.scaleCoordinate(8.287269f, 16.0f, width);
            int y2 = DefaultLookAndFeel.scaleCoordinate(10.0f, 16.0f, height);
            int x3 = DefaultLookAndFeel.scaleCoordinate(13.516078f, 16.0f, width);
            int y3 = y1;
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
            g.translate(-1, -1);
            if (cb.hasFocus()) {
                g.setColor(style.getFgSelectionColor());
            } else {
                g.setColor(style.getFgColor());
            }
            g.fillTriangle(x1, y1, x2, y2, x3, y3);
            g.translate(-x, -y);
        }
    }

    private int findDestColor(int color) {
        int sourceR = color >> 16 & 0xFF;
        int sourceG = color >> 8 & 0xFF;
        int sourceB = color & 0xFF;
        if (sourceR > 128 && sourceG > 128 && sourceB > 128) {
            sourceR = Math.max(sourceR >> 1, 0);
            sourceG = Math.max(sourceG >> 1, 0);
            sourceB = Math.max(sourceB >> 1, 0);
        } else {
            if (color == 0) {
                return 0x222222;
            }
            sourceR = Math.min(sourceR << 1, 255);
            sourceG = Math.min(sourceG << 1, 255);
            sourceB = Math.min(sourceB << 1, 255);
        }
        return sourceR << 16 & 0xFF0000 | sourceG << 8 & 0xFF00 | sourceB & 0xFF;
    }

    public void drawList(Graphics g, List l) {
    }

    public void drawMonthView(Graphics g, Calendar cal, Component mv) {
        this.drawBorder(g, mv, 131586, 526344, 2);
        this.setFG(g, mv);
        Font f = mv.getStyle().getFont();
        int fh = f.getHeight();
        int w = mv.getWidth();
        int h = mv.getHeight();
        int labelH = fh + DAY_SPACE_H;
        int ch = h - labelH;
        int dayWidth = w / 7;
        int dayHeight = ch / 6;
        long sd = cal.getSelectedDay();
        Date date = new Date();
        int fix = f.stringWidth("22") / 2;
        g.setColor(mv.getStyle().getBgColor());
        g.fillRect(mv.getX() + 2, mv.getY() + 2, mv.getWidth() - 4, mv.getStyle().getFont().getHeight());
        g.setColor(mv.getStyle().getFgColor());
        g.setFont(mv.getStyle().getFont());
        String[] days = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
        String[] labels = new String[]{"Su", "M", "Tu", "W", "Th", "F", "Sa"};
        Style dayStyle = new Style(mv.getStyle());
        dayStyle.setFgColor(mv.getStyle().getFgSelectionColor());
        dayStyle.setPadding(0, 0, 0, 0);
        dayStyle.setMargin(0, 0, 0, 0);
        dayStyle.setBgTransparency(0);
        Label tmp = new Label();
        tmp.setStyle(dayStyle);
        tmp.setAlignment(4);
        tmp.setPreferredSize(new Dimension(dayWidth, dayHeight));
        for (int i = 0; i < labels.length; ++i) {
            String day = UIManager.getInstance().localize(days[i], labels[i]);
            tmp.setText(day);
            int dx = dayWidth * i;
            tmp.setX(mv.getX() + dx);
            tmp.setY(mv.getY());
            tmp.setSize(tmp.getPreferredSize());
            this.drawLabel(g, tmp);
        }
        this.paintDates(g, date, mv, sd, f, dayWidth, dayHeight, labelH, fix, fh, sd);
    }

    public void drawTextArea(Graphics g, TextArea ta) {
        this.setFG(g, ta);
        int line = ta.getLines();
        int oX = g.getClipX();
        int oY = g.getClipY();
        int oWidth = g.getClipWidth();
        int oHeight = g.getClipHeight();
        Font f = ta.getStyle().getFont();
        int fontHeight = f.getHeight();
        for (int i = 0; i < line; ++i) {
            int y;
            int x = ta.getX() + ta.getStyle().getPadding(1);
            if (!Rectangle.intersects(x, y = ta.getY() + ta.getStyle().getPadding(0) + (ta.getRowsGap() + fontHeight) * i, ta.getWidth(), fontHeight, oX, oY, oWidth, oHeight)) continue;
            String rowText = ta.getTextAt(i);
            String displayText = "";
            if ((ta.getConstraint() & 0x10000) != 0) {
                for (int j = 0; j < rowText.length(); ++j) {
                    displayText = displayText + "*";
                }
            } else {
                displayText = rowText;
            }
            g.drawString(displayText, x, y);
        }
    }

    public Dimension getButtonPreferredSize(Button b) {
        return this.getPreferredSize(b, new Image[]{b.getIcon(), b.getRolloverIcon(), b.getPressedIcon()}, null);
    }

    public Dimension getCheckBoxPreferredSize(CheckBox cb) {
        if (this.chkBoxImages != null) {
            return this.getPreferredSize(cb, new Image[]{cb.getIcon(), cb.getRolloverIcon(), cb.getPressedIcon()}, this.chkBoxImages[0]);
        }
        Dimension d = this.getPreferredSize(cb, new Image[]{cb.getIcon(), cb.getRolloverIcon(), cb.getPressedIcon()}, null);
        d.setHeight(Math.max(8, d.getHeight()));
        d.setWidth(d.getWidth() + d.getHeight() + cb.getGap());
        return d;
    }

    public Dimension getLabelPreferredSize(Label l) {
        return this.getPreferredSize(l, new Image[]{l.getIcon()}, null);
    }

    private Dimension getPreferredSize(Label l, Image[] icons, Image stateImage) {
        int prefW = 0;
        int prefH = 0;
        Style style = l.getStyle();
        int gap = l.getGap();
        for (int i = 0; i < icons.length; ++i) {
            Image icon = icons[i];
            if (icon == null) continue;
            prefW = Math.max(prefW, icon.getWidth());
            prefH = Math.max(prefH, icon.getHeight());
        }
        String text = l.getText();
        Font font = style.getFont();
        if (font == null) {
            System.out.println("Missing font for " + l);
            font = Font.getDefaultFont();
        }
        if (text != null && text.length() > 0) {
            switch (l.getTextPosition()) {
                case 1: 
                case 3: {
                    prefW += font.stringWidth(text);
                    prefH = Math.max(prefH, font.getHeight());
                    break;
                }
                case 0: 
                case 2: {
                    prefW = Math.max(prefW, font.stringWidth(text));
                    prefH += font.getHeight();
                }
            }
        }
        if (stateImage != null) {
            prefW += stateImage.getWidth() + gap;
            prefH = Math.max(prefH, stateImage.getHeight());
        }
        if (icons[0] != null && text != null && text.length() > 0) {
            switch (l.getTextPosition()) {
                case 1: 
                case 3: {
                    prefW += gap;
                    break;
                }
                case 0: 
                case 2: {
                    prefH += gap;
                }
            }
        }
        if (prefH != 0) {
            prefH += style.getPadding(0) + style.getPadding(2);
        }
        if (prefW != 0) {
            prefW += style.getPadding(3) + style.getPadding(1);
        }
        return new Dimension(prefW, prefH);
    }

    public Dimension getListPreferredSize(List l) {
        int selectedWidth;
        int selectedHeight;
        int width = 0;
        int height = 0;
        ListModel model = l.getModel();
        int numOfcomponents = model.getSize();
        Object prototype = l.getRenderingPrototype();
        if (prototype != null) {
            ListCellRenderer renderer = l.getRenderer();
            Component cmp = renderer.getListCellRendererComponent(l, prototype, 0, false);
            height = cmp.getPreferredH();
            width = cmp.getPreferredW();
            cmp = renderer.getListCellRendererComponent(l, prototype, 0, true);
            selectedHeight = Math.max(height, cmp.getPreferredH());
            selectedWidth = Math.max(width, cmp.getPreferredW());
        } else {
            int hightCalcComponents = Math.min(5, numOfcomponents);
            ListCellRenderer renderer = l.getRenderer();
            for (int i = 0; i < hightCalcComponents; ++i) {
                Object value = model.getItemAt(i);
                Component cmp = renderer.getListCellRendererComponent(l, value, i, false);
                height = Math.max(height, cmp.getPreferredH());
                width = Math.max(width, cmp.getPreferredW());
            }
            selectedHeight = height;
            selectedWidth = width;
            if (numOfcomponents > 0) {
                Object value = model.getItemAt(0);
                Component cmp = renderer.getListCellRendererComponent(l, value, 0, true);
                selectedHeight = Math.max(height, cmp.getPreferredH());
                selectedWidth = Math.max(width, cmp.getPreferredW());
            }
        }
        int verticalPadding = l.getStyle().getPadding(0) + l.getStyle().getPadding(2);
        int horizontalPadding = l.getStyle().getPadding(3) + l.getStyle().getPadding(1);
        if (numOfcomponents == 0) {
            return new Dimension(horizontalPadding, verticalPadding);
        }
        if (l instanceof ComboBox) {
            int boxWidth = l.getStyle().getFont().getHeight() + 2;
            return new Dimension(boxWidth + selectedWidth + horizontalPadding, selectedHeight + verticalPadding);
        }
        if (l.getOrientation() == 0) {
            return new Dimension(selectedWidth + horizontalPadding, selectedHeight + (height + l.getItemGap()) * (numOfcomponents - 1) + verticalPadding);
        }
        return new Dimension(selectedWidth + (width + l.getItemGap()) * (numOfcomponents - 1) + horizontalPadding, selectedHeight + verticalPadding);
    }

    public Dimension getMonthViewPreferredSize(Component mv) {
        Font f = mv.getStyle().getFont();
        int fh = f.getHeight();
        int dayWidth = f.stringWidth("22");
        int w = (dayWidth + DAY_SPACE_W) * 7;
        int h = (fh + DAY_SPACE_H) * 5;
        return new Dimension(w + mv.getStyle().getPadding(3) + mv.getStyle().getPadding(1), h + mv.getStyle().getPadding(0) + mv.getStyle().getPadding(2));
    }

    public Dimension getRadioButtonPreferredSize(RadioButton rb) {
        if (this.rButtonImages != null) {
            return this.getPreferredSize(rb, new Image[]{rb.getIcon(), rb.getRolloverIcon(), rb.getPressedIcon()}, this.rButtonImages[0]);
        }
        Dimension d = this.getPreferredSize(rb, new Image[]{rb.getIcon(), rb.getRolloverIcon(), rb.getPressedIcon()}, null);
        d.setHeight(Math.max(8, d.getHeight()));
        d.setWidth(d.getWidth() + rb.getStyle().getFont().getHeight());
        return d;
    }

    public Dimension getTextAreaPreferredSize(TextArea ta) {
        int prefW = 0;
        int prefH = 0;
        Font f = ta.getStyle().getFont();
        prefW = ta.getRows() == 1 ? f.stringWidth(ta.getText()) : f.stringWidth("W") * ta.getColumns();
        int rows = ta.getRows();
        prefH = (f.getHeight() + 2) * rows;
        int columns = ta.getColumns();
        String str = "";
        for (int iter = 0; iter < columns; ++iter) {
            str = str + 'W';
        }
        prefW = Math.max(prefW, f.stringWidth(str));
        prefH = Math.max(prefH, rows * f.getHeight());
        return new Dimension(prefW + ta.getStyle().getPadding(3) + ta.getStyle().getPadding(1), prefH + ta.getStyle().getPadding(0) + ta.getStyle().getPadding(2));
    }

    private void drawComponent(Graphics g, Label l, Image icon, Image stateIcon, int preserveSpaceForState) {
        this.setFG(g, l);
        int gap = l.getGap();
        int stateIconSize = 0;
        int stateIconYPosition = 0;
        String text = l.getText();
        Style style = l.getStyle();
        Font font = style.getFont();
        int fontHeight = 0;
        if (text == null) {
            text = "";
        }
        if (text.length() > 0) {
            fontHeight = font.getHeight();
        }
        if (stateIcon != null) {
            stateIconSize = stateIcon.getWidth();
            stateIconYPosition = l.getY() + l.getStyle().getPadding(0) + (l.getHeight() - l.getStyle().getPadding(0) - l.getStyle().getPadding(2)) / 2 - stateIconSize / 2;
            preserveSpaceForState = stateIconSize + gap;
            g.drawImage(stateIcon, l.getX() + l.getStyle().getPadding(1), stateIconYPosition);
        }
        int x = l.getX() + l.getStyle().getPadding(1) + preserveSpaceForState;
        int y = l.getY() + l.getStyle().getPadding(0);
        if (l.getAlignment() == 1) {
            switch (l.getTextPosition()) {
                case 1: 
                case 3: {
                    y += (l.getHeight() - (l.getStyle().getPadding(0) + l.getStyle().getPadding(2) + Math.max(icon != null ? icon.getHeight() : 0, l.getStyle().getFont().getHeight()))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    y += (l.getHeight() - (l.getStyle().getPadding(0) + l.getStyle().getPadding(2) + (icon != null ? icon.getHeight() + gap : 0) + l.getStyle().getFont().getHeight())) / 2;
                }
            }
        } else if (l.getAlignment() == 4) {
            switch (l.getTextPosition()) {
                case 1: 
                case 3: {
                    x += (l.getWidth() - (preserveSpaceForState + style.getPadding(1) + style.getPadding(3) + (icon != null ? icon.getWidth() : 0) + font.stringWidth(text))) / 2;
                    x = Math.max(x, l.getX() + style.getPadding(1) + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(0) + style.getPadding(2) + Math.max(icon != null ? icon.getHeight() : 0, fontHeight))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    x += (l.getWidth() - (preserveSpaceForState + style.getPadding(1) + style.getPadding(3) + Math.max(icon != null ? icon.getWidth() : 0, font.stringWidth(text)))) / 2;
                    x = Math.max(x, l.getX() + style.getPadding(1) + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(0) + style.getPadding(2) + (icon != null ? icon.getHeight() + gap : 0) + fontHeight)) / 2;
                }
            }
        } else if (l.getAlignment() == 3) {
            switch (l.getTextPosition()) {
                case 1: 
                case 3: {
                    x = l.getX() + l.getWidth() - style.getPadding(3) - (preserveSpaceForState + (icon != null ? icon.getWidth() + gap : 0) + font.stringWidth(text));
                    x = Math.max(x, l.getX() + style.getPadding(1) + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(0) + style.getPadding(2) + Math.max(icon != null ? icon.getHeight() : 0, fontHeight))) / 2;
                    break;
                }
                case 0: 
                case 2: {
                    x = l.getX() + l.getWidth() - style.getPadding(3) - preserveSpaceForState - Math.max(icon != null ? icon.getWidth() : 0, font.stringWidth(text));
                    x = Math.max(x, l.getX() + style.getPadding(1) + preserveSpaceForState);
                    y += (l.getHeight() - (style.getPadding(0) + style.getPadding(2) + (icon != null ? icon.getHeight() + gap : 0) + fontHeight)) / 2;
                }
            }
        }
        int textSpaceW = l.getWidth() - style.getPadding(3) - style.getPadding(1);
        if (icon != null && (l.getTextPosition() == 3 || l.getTextPosition() == 1)) {
            textSpaceW -= icon.getWidth();
        }
        textSpaceW = stateIcon != null ? (textSpaceW -= stateIcon.getWidth()) : (textSpaceW -= preserveSpaceForState);
        if (icon == null) {
            this.drawLabelString(g, l, text, x, y, textSpaceW, preserveSpaceForState);
        } else {
            int strWidth = l.getStyle().getFont().stringWidth(text);
            int iconWidth = icon.getWidth();
            int iconHeight = icon.getHeight();
            switch (l.getTextPosition()) {
                case 1: {
                    if (iconHeight > fontHeight) {
                        int iconStringHGap = (iconHeight - fontHeight) / 2;
                        strWidth = this.drawLabelStringValign(g, l, text, x, y, iconStringHGap, iconHeight, textSpaceW, fontHeight, preserveSpaceForState);
                        g.drawImage(icon, x + strWidth + gap, y);
                        break;
                    }
                    int iconStringHGap = (fontHeight - iconHeight) / 2;
                    strWidth = this.drawLabelString(g, l, text, x, y, textSpaceW, preserveSpaceForState);
                    g.drawImage(icon, x + strWidth + gap, y + iconStringHGap);
                    break;
                }
                case 3: {
                    if (iconHeight > fontHeight) {
                        int iconStringHGap = (iconHeight - fontHeight) / 2;
                        g.drawImage(icon, x, y);
                        this.drawLabelStringValign(g, l, text, x + iconWidth + gap, y, iconStringHGap, iconHeight, textSpaceW, fontHeight, preserveSpaceForState);
                        break;
                    }
                    int iconStringHGap = (fontHeight - iconHeight) / 2;
                    g.drawImage(icon, x, y + iconStringHGap);
                    this.drawLabelString(g, l, text, x + iconWidth + gap, y, textSpaceW, preserveSpaceForState);
                    break;
                }
                case 2: {
                    if (iconWidth > strWidth) {
                        int iconStringWGap = (iconWidth - strWidth) / 2;
                        g.drawImage(icon, x, y);
                        this.drawLabelString(g, l, text, x + iconStringWGap, y + iconHeight + gap, textSpaceW, preserveSpaceForState);
                        break;
                    }
                    int iconStringWGap = (strWidth - iconWidth) / 2;
                    g.drawImage(icon, x + iconStringWGap, y);
                    this.drawLabelString(g, l, text, x, y + iconHeight + gap, textSpaceW, preserveSpaceForState);
                    break;
                }
                case 0: {
                    if (iconWidth > strWidth) {
                        int iconStringWGap = (iconWidth - strWidth) / 2;
                        this.drawLabelString(g, l, text, x + iconStringWGap, y, textSpaceW, preserveSpaceForState);
                        g.drawImage(icon, x, y + fontHeight + gap);
                        break;
                    }
                    int iconStringWGap = (strWidth - iconWidth) / 2;
                    this.drawLabelString(g, l, text, x, y, textSpaceW, preserveSpaceForState);
                    g.drawImage(icon, x + iconStringWGap, y + fontHeight + gap);
                }
            }
        }
    }

    private int drawLabelStringValign(Graphics g, Label l, String str, int x, int y, int iconStringHGap, int iconHeight, int textSpaceW, int fontHeight, int preserveSpaceForState) {
        switch (l.getVerticalAlignment()) {
            case 0: {
                return this.drawLabelString(g, l, str, x, y, textSpaceW, preserveSpaceForState);
            }
            case 4: {
                return this.drawLabelString(g, l, str, x, y + iconHeight / 2 - fontHeight / 2, textSpaceW, preserveSpaceForState);
            }
        }
        return this.drawLabelString(g, l, str, x, y + iconStringHGap, textSpaceW, preserveSpaceForState);
    }

    private int drawLabelString(Graphics g, Label l, String text, int x, int y, int textSpaceW, int preserveSpaceForState) {
        int txtX;
        Style style = l.getStyle();
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        if (l.getTextPosition() == 3) {
            txtX = l.getX() + (l.getWidth() - style.getPadding(1) - textSpaceW);
            g.clipRect(l.getX() + (l.getWidth() - style.getPadding(1) - textSpaceW), cy, textSpaceW, ch);
        } else {
            txtX = x + preserveSpaceForState;
        }
        g.clipRect(txtX, cy, textSpaceW, ch);
        if (l.isTickerRunning()) {
            if (l.getShiftText() > 0) {
                if (l.getShiftText() > textSpaceW) {
                    l.setShiftText(x - l.getX() - style.getFont().stringWidth(text));
                }
            } else if (x + l.getShiftText() + style.getFont().stringWidth(text) < txtX) {
                l.setShiftText(textSpaceW - (x - txtX));
            }
        }
        int drawnW = this.drawLabelText(g, l, text, x, y, textSpaceW);
        g.setClip(cx, cy, cw, ch);
        return drawnW;
    }

    protected int drawLabelText(Graphics g, Label l, String text, int x, int y, int textSpaceW) {
        int txtW;
        Font f = l.getStyle().getFont();
        if (!l.isTickerRunning() && (txtW = f.stringWidth(text)) > textSpaceW && textSpaceW > 0 && l.isEndsWith3Points()) {
            String points = "...";
            int index = 1;
            String tmp = text.substring(0, index);
            int pointsW = f.stringWidth(points);
            while (f.stringWidth(tmp) + pointsW < textSpaceW && ++index < text.length()) {
                tmp = text.substring(0, index);
            }
            text = tmp = text.substring(0, index - 1) + points;
        }
        g.drawString(text, l.getShiftText() + x, y);
        return Math.min(f.stringWidth(text), textSpaceW);
    }

    private Image getIconFromState(Button b) {
        Image icon = null;
        switch (b.getState()) {
            case 2: {
                icon = b.getIcon();
                break;
            }
            case 1: {
                icon = b.getPressedIcon();
                if (icon != null) break;
                icon = b.getIcon();
                break;
            }
            case 0: {
                icon = b.getRolloverIcon();
                if (icon != null) break;
                icon = b.getIcon();
            }
        }
        return icon;
    }

    public long findDayAt(int x, int y, Calendar cal, Component mv) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        long firstOfMonth = this.getMonthExtent(calendar, cal.getDate(), true);
        int w = mv.getWidth();
        Font f = mv.getStyle().getFont();
        int fh = f.getHeight();
        int labelH = fh + DAY_SPACE_H;
        int dayWidth = w / 7;
        long currentDay = firstOfMonth;
        calendar.setTime(new Date(currentDay));
        int dayX = mv.getAbsoluteX() + dayWidth * (calendar.get(5) % 7);
        int dayY = mv.getAbsoluteY() + labelH;
        while (dayX >= x || dayX + dayWidth <= x || dayY >= y || dayY + labelH <= y) {
            calendar.setTime(new Date(currentDay += 86400000L));
            dayX = mv.getAbsoluteX() + dayWidth * (calendar.get(5) % 7);
            if (currentDay % 7L == 0L) {
                dayX = mv.getAbsoluteX();
                dayY += labelH;
            }
            if (dayX <= mv.getX() + mv.getWidth() || dayY <= mv.getY() + mv.getHeight()) continue;
            return currentDay;
        }
        return currentDay;
    }

    private void paintDates(Graphics g, Date date, Component mv, long sd, Font f, int dayWidth, int dayHeight, int labelH, int fix, int fh, long selectedDay) {
        int w = f.stringWidth("22");
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        date.setTime(sd);
        long firstOfMonth = this.getMonthExtent(calendar, date, true);
        date.setTime(sd);
        long endOfMonth = this.getMonthExtent(calendar, date, false);
        long day = firstOfMonth;
        int d = 1;
        int sats = 0;
        g.setColor(mv.getStyle().getFgColor());
        do {
            date.setTime(day);
            calendar.setTime(date);
            String dayString = Integer.toString(d);
            int dow = calendar.get(7);
            int dx = mv.getX() + dayWidth * (dow - 1) + fix;
            int dy = mv.getY() + sats * dayHeight + labelH;
            if (day == selectedDay) {
                g.setColor(mv.getStyle().getBgSelectionColor());
                g.fillRoundRect(dx - 2, dy - 2, w + 5, fh + 4, 4, 4);
                g.setColor(mv.getStyle().getFgSelectionColor());
                g.drawString(dayString, w / 2 - f.stringWidth(dayString) / 2 + dx + 2, dy);
                g.drawRoundRect(dx - 2, dy - 2, w + 5, fh + 4, 4, 4);
            } else {
                g.drawString(dayString, w / 2 - f.stringWidth(dayString) / 2 + dx + 2, dy);
            }
            g.setColor(mv.getStyle().getFgColor());
            day += 86400000L;
            ++d;
            if (dow != 7) continue;
            ++sats;
            g.setColor(mv.getStyle().getBgColor());
            g.fillRect(mv.getX() + 2, dy + fh + 3, mv.getWidth() - 4, 1);
            g.setColor(mv.getStyle().getFgColor());
        } while (day <= endOfMonth);
    }

    private long getMonthExtent(java.util.Calendar calendar, Date d, boolean first) {
        int adjacentMonth;
        long day = d.getTime();
        d.setTime(day);
        calendar.setTime(d);
        long origDay = day;
        int currentMonth = calendar.get(2);
        do {
            long adjacentDay = day + (long)(first ? -1 : 1) * 86400000L;
            d.setTime(adjacentDay);
            calendar.setTime(d);
            adjacentMonth = calendar.get(2);
            if (currentMonth != adjacentMonth) continue;
            day = adjacentDay;
        } while (currentMonth == adjacentMonth);
        d.setTime(origDay);
        calendar.setTime(d);
        return day;
    }

    public Dimension getComboBoxPreferredSize(ComboBox cb) {
        return this.getListPreferredSize(cb);
    }

    public void drawTabbedPane(Graphics g, TabbedPane tp) {
    }

    public Component getTabbedPaneCell(final TabbedPane tp, String text, Image icon, final boolean isSelected, final boolean cellHasFocus, final Style cellStyle, final Style tabbedPaneStyle, final int cellOffsetX, final int cellOffsetY, final Dimension cellsPreferredSize, final Dimension contentPaneSize) {
        Label cell = new Label(text){

            /*
             * Enabled aggressive block sorting
             */
            public void paint(Graphics g) {
                int tabP;
                int focusMarkWidth;
                int tPBorder;
                block16: {
                    block15: {
                        tPBorder = tp.getTabbedPaneBorderWidth();
                        focusMarkWidth = tPBorder * 2;
                        tabP = tp.getTabPlacement();
                        if (isSelected && cellHasFocus) {
                            focusMarkWidth = tPBorder * 3;
                            this.getStyle().setFgSelectionColor(cellStyle.getFgSelectionColor());
                        } else {
                            this.getStyle().setFgColor(cellStyle.getFgColor());
                        }
                        super.paint(g);
                        if (!isSelected) {
                            g.setColor(0);
                            g.fillRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), (byte)47);
                        }
                        g.setColor(this.getStyle().getFgColor());
                        if (tabP == 0) break block15;
                        if (tabP != 2) break block16;
                    }
                    if (tabP == 0) {
                        if (isSelected) {
                            g.fillRect(this.getX(), this.getY() + tPBorder, this.getWidth(), focusMarkWidth);
                        }
                        g.setColor(tabbedPaneStyle.getFgColor());
                        g.fillRect(this.getX(), this.getY(), this.getWidth(), tPBorder);
                        g.fillRect(this.getX(), this.getY(), tPBorder, this.getHeight());
                    } else {
                        if (isSelected) {
                            g.fillRect(this.getX(), this.getY() + this.getHeight() - focusMarkWidth, this.getWidth(), focusMarkWidth);
                        }
                        g.setColor(tabbedPaneStyle.getFgColor());
                        g.fillRect(this.getX(), this.getY() + this.getHeight() - tPBorder, this.getWidth(), tPBorder);
                        g.fillRect(this.getX(), this.getY(), tPBorder, this.getHeight());
                    }
                    int x = this.getX() - cellOffsetX + this.getWidth();
                    if (x == contentPaneSize.getWidth()) {
                        g.fillRect(x + cellOffsetX - tPBorder, this.getY(), tPBorder, this.getHeight());
                    }
                    if (cellsPreferredSize.getWidth() >= contentPaneSize.getWidth()) return;
                    if (this.getX() + this.getWidth() != cellsPreferredSize.getWidth()) return;
                    g.fillRect(this.getX() + this.getWidth() - tPBorder, this.getY(), tPBorder, this.getHeight());
                    return;
                }
                if (isSelected) {
                    g.fillRect(this.getX(), this.getY() + tPBorder, this.getWidth(), focusMarkWidth);
                }
                g.setColor(tabbedPaneStyle.getFgColor());
                g.fillRect(this.getX(), this.getY(), this.getWidth(), tPBorder);
                int y = this.getY() - cellOffsetY + this.getHeight();
                if (y == contentPaneSize.getHeight()) {
                    g.fillRect(this.getX(), y + cellOffsetY - tPBorder, this.getWidth(), tPBorder);
                }
                if (cellsPreferredSize.getHeight() < contentPaneSize.getHeight() && this.getY() + this.getHeight() == cellsPreferredSize.getHeight()) {
                    g.fillRect(this.getX(), this.getY() + this.getHeight() - tPBorder, this.getWidth(), tPBorder);
                }
                if (tabP == 1) {
                    g.fillRect(this.getX(), this.getY(), tPBorder, this.getHeight());
                    return;
                }
                g.fillRect(this.getX() + this.getWidth() - tPBorder, this.getY(), tPBorder, this.getHeight());
            }
        };
        cell.setCellRenderer(true);
        cell.getStyle().setBorder(null);
        cell.getStyle().setMargin(0, 0, 0, 0);
        cell.setIcon(icon);
        this.updateCellLook(tp, cell, isSelected);
        if (isSelected) {
            cellStyle.setBgSelectionColor(cellStyle.getBgColor());
        }
        cell.setAlignment(4);
        return cell;
    }

    private void updateCellLook(TabbedPane tp, Component c, boolean selected) {
        if (selected) {
            c.getStyle().setFgColor(tp.getStyle().getFgSelectionColor());
        } else {
            c.getStyle().setFgColor(tp.getStyle().getFgColor());
        }
        c.getStyle().setBgTransparency(tp.getStyle().getBgTransparency());
        c.getStyle().setFont(tp.getStyle().getFont());
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public void drawTabbedPaneContentPane(TabbedPane tp, Graphics g, Rectangle rect, Dimension cellsPreferredSize, int numOfTabs, int selectedTabIndex, Dimension tabsSize, int cellOffsetX, int cellOffsetY) {
        int tabP;
        int tPBorder;
        int maxTabHeight;
        int listPreferredH;
        int h;
        int w;
        int y;
        int x;
        block14: {
            int maxTabWidth;
            int listPreferredW;
            block13: {
                x = rect.getX();
                y = rect.getY();
                w = rect.getSize().getWidth();
                h = rect.getSize().getHeight();
                listPreferredW = cellsPreferredSize.getWidth();
                listPreferredH = cellsPreferredSize.getHeight();
                maxTabWidth = tabsSize.getWidth();
                maxTabHeight = tabsSize.getHeight();
                tPBorder = tp.getTabbedPaneBorderWidth();
                g.setColor(tp.getStyle().getBgColor());
                g.fillRect(x, y, w, h, tp.getStyle().getBgTransparency());
                g.setColor(tp.getStyle().getFgColor());
                tabP = tp.getTabPlacement();
                if (tabP == 0) break block13;
                if (tabP != 2) break block14;
            }
            g.fillRect(x, y, tPBorder, h);
            g.fillRect(x + w - tPBorder, y, tPBorder, h);
            int relativeY = y;
            if (tabP == 2) {
                relativeY = y + h - tPBorder;
                g.fillRect(x, y, w, tPBorder);
            } else {
                g.fillRect(x, y + h - tPBorder, w, tPBorder);
            }
            if (listPreferredW < w) {
                g.fillRect(listPreferredW - tPBorder, relativeY, w - listPreferredW, tPBorder);
            }
            int i = 0;
            while (i < numOfTabs) {
                if (i != selectedTabIndex) {
                    g.fillRect(x - cellOffsetX + maxTabWidth * i, relativeY, maxTabWidth + tPBorder, tPBorder);
                }
                ++i;
            }
            return;
        }
        g.fillRect(x, y, w, tPBorder);
        g.fillRect(x, y + h - tPBorder, w, tPBorder);
        int relativeX = x;
        if (tabP == 3) {
            g.fillRect(x, y, tPBorder, h);
            relativeX = x + w - tPBorder;
        } else {
            g.fillRect(x + w - tPBorder, y, tPBorder, h);
        }
        if (listPreferredH < h) {
            g.fillRect(relativeX, y + listPreferredH - tPBorder, tPBorder, h - listPreferredH + tPBorder);
        }
        int i = 0;
        while (i < numOfTabs) {
            if (i != selectedTabIndex) {
                g.fillRect(relativeX, y - cellOffsetY + maxTabHeight * i, tPBorder, maxTabHeight + tPBorder);
            }
            ++i;
        }
    }

    private String getTextFieldString(TextField ta) {
        String text = ta.getText();
        String displayText = "";
        if ((ta.getConstraint() & 0x10000) != 0) {
            if (ta.isPendingCommit()) {
                if (text.length() > 0) {
                    for (int j = 0; j < text.length() - 1; ++j) {
                        displayText = displayText + "*";
                    }
                    displayText = displayText + text.charAt(text.length() - 1);
                }
            } else {
                for (int j = 0; j < text.length(); ++j) {
                    displayText = displayText + "*";
                }
            }
        } else {
            displayText = text;
        }
        return displayText;
    }

    public void drawTextField(Graphics g, TextField ta) {
        this.setFG(g, ta);
        String text = ta.getText();
        String displayText = this.getTextFieldString(ta);
        Style style = ta.getStyle();
        int x = 0;
        int cursorCharPosition = ta.getCursorPosition();
        Font f = ta.getStyle().getFont();
        int cursorX = 0;
        int xPos = 0;
        if (cursorCharPosition > 0) {
            xPos = f.stringWidth(ta.getText().substring(0, cursorCharPosition));
            cursorX = ta.getX() + style.getPadding(1) + xPos;
            if (ta.getWidth() > f.getHeight() * 2 && cursorX >= ta.getWidth() - f.getHeight()) {
                while (x + xPos >= ta.getWidth() - f.getHeight() * 2) {
                    --x;
                }
            }
        }
        g.drawString(displayText, ta.getX() + x + style.getPadding(1), ta.getY() + style.getPadding(0));
        if (ta.getInputModeOrder() != null && ta.getInputModeOrder().length > 1) {
            String inputMode = ta.getInputMode();
            int inputModeWidth = f.stringWidth(inputMode);
            if (ta.handlesInput() && ta.getWidth() / 2 > inputModeWidth) {
                int drawXPos = ta.getX() + style.getPadding(1);
                if (xPos < ta.getWidth() / 2) {
                    drawXPos = drawXPos + ta.getWidth() - inputModeWidth - style.getPadding(3) - style.getPadding(1);
                }
                g.setColor(style.getFgSelectionColor());
                g.fillRect(drawXPos, ta.getY() + style.getPadding(0), inputModeWidth, ta.getHeight(), (byte)-116);
                g.setColor(style.getBgSelectionColor());
                g.drawString(inputMode, drawXPos, ta.getY() + style.getPadding(0));
            }
        }
    }

    public Dimension getTextFieldPreferredSize(TextField ta) {
        return this.getTextAreaPreferredSize(ta);
    }

    public void drawTextFieldCursor(Graphics g, TextField ta) {
        Style style = ta.getStyle();
        Font f = style.getFont();
        String displayText = this.getTextFieldString(ta);
        int xPos = 0;
        int cursorCharPosition = ta.getCursorPosition();
        if (cursorCharPosition > 0) {
            xPos = f.stringWidth(displayText.substring(0, cursorCharPosition));
        }
        int cursorX = ta.getX() + style.getPadding(1) + xPos;
        int cursorY = ta.getY() + style.getPadding(0);
        int x = 0;
        if (ta.getWidth() > f.getHeight() * 2 && cursorX >= ta.getWidth() - f.getHeight()) {
            while (x + xPos >= ta.getWidth() - f.getHeight() * 2) {
                --x;
            }
        }
        int oldColor = g.getColor();
        g.setColor(style.getFgSelectionColor());
        g.drawLine(cursorX + x, cursorY, cursorX + x, cursorY + f.getHeight());
        g.setColor(oldColor);
    }

    private int getAvaliableSpaceForText(Label l) {
        int height;
        int index;
        Style style = l.getStyle();
        int textSpaceW = l.getWidth() - style.getPadding(3) - style.getPadding(1);
        Image icon = l.getIcon();
        if (l instanceof Button) {
            icon = this.getIconFromState((Button)l);
        }
        if (icon != null && (l.getTextPosition() == 3 || l.getTextPosition() == 1)) {
            textSpaceW -= icon.getWidth();
        }
        int preserveSpaceForState = 0;
        if (l instanceof RadioButton) {
            if (this.rButtonImages != null) {
                index = ((RadioButton)l).isSelected() ? 1 : 0;
                preserveSpaceForState = this.rButtonImages[index].getWidth();
            } else {
                height = style.getFont().getHeight();
                preserveSpaceForState = height + ((RadioButton)l).getGap();
            }
        }
        if (l instanceof CheckBox) {
            if (this.chkBoxImages != null) {
                index = ((CheckBox)l).isSelected() ? 1 : 0;
                preserveSpaceForState = this.chkBoxImages[index].getWidth();
            } else {
                height = style.getFont().getHeight();
                preserveSpaceForState = height + ((CheckBox)l).getGap();
            }
        }
        return textSpaceW -= preserveSpaceForState;
    }

    public void focusGained(Component cmp) {
        int textSpaceW;
        Label l;
        Style style;
        int txtW;
        if (cmp instanceof Label && (txtW = (style = (l = (Label)cmp).getStyle()).getFont().stringWidth(l.getText())) > (textSpaceW = this.getAvaliableSpaceForText(l)) && textSpaceW > 0) {
            ((Label)cmp).startTicker(this.tickerSpeed, true);
        }
    }

    public void focusLost(Component cmp) {
        if (cmp instanceof Label && ((Label)cmp).isTickerRunning()) {
            ((Label)cmp).stopTicker();
        }
    }
}

