/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.List;
import com.sun.lwuit.Popup;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.BorderLayout;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import java.util.Vector;

public class ComboBox
extends List {
    private static String id = "ComboBox";
    private Component popupContent;
    private List contained;
    private Popup popup;

    public ComboBox(Vector items) {
        this(new DefaultListModel(items));
    }

    public ComboBox(Object[] items) {
        this(new DefaultListModel(items));
    }

    public ComboBox() {
        this(new DefaultListModel());
    }

    public ComboBox(ListModel model) {
        super(model);
        ((DefaultListCellRenderer)super.getRenderer()).setShowNumbers(false);
        this.setInputOnFocus(false);
        this.setIsScrollVisible(false);
    }

    public int getBaseline(int width, int height) {
        if (this.getRenderingPrototype() != null) {
            Component component = this.getRenderer().getListCellRendererComponent(this, this.getRenderingPrototype(), 0, true);
        }
        Component selected = this.getModel().getSize() > 0 ? this.getRenderer().getListCellRendererComponent(this, this.getModel().getItemAt(0), 0, true) : this.getRenderer().getListCellRendererComponent(this, "XXXXXXXXXXX", 0, true);
        return this.getHeight() - this.getStyle().getPadding(2) - selected.getStyle().getPadding(2);
    }

    protected String getUIID() {
        return id;
    }

    public void setSelectedIndex(int selection) {
        super.setSelectedIndex(selection, false);
    }

    public void setSelectedIndex(int selection, boolean scroll) {
        super.setSelectedIndex(selection, false);
    }

    public void setModel(ListModel m) {
        super.setModel(m);
        if (this.contained != null) {
            this.contained.setModel(m);
        }
    }

    public void setHandlesInput(boolean handlesInput) {
        super.setHandlesInput(handlesInput);
        this.getPopup().setVisible(handlesInput);
        if (this.isSmoothScrolling()) {
            if (handlesInput) {
                this.getComponentForm().registerAnimated(((Container)this.popupContent).getComponentAt(0));
            } else {
                this.getComponentForm().deregisterAnimated(((Container)this.popupContent).getComponentAt(0));
            }
        }
    }

    public void setSmoothScrolling(boolean smoothScrolling) {
        super.setSmoothScrolling(smoothScrolling);
        if (this.contained != null) {
            this.contained.setSmoothScrolling(smoothScrolling);
        }
    }

    private Component getPopupContent() {
        this.contained = new List(this.getModel());
        this.contained.setSmoothScrolling(this.isSmoothScrolling());
        this.contained.setFixedSelection(1);
        this.contained.setListCellRenderer(this.getRenderer());
        this.contained.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ComboBox.this.setHandlesInput(!ComboBox.this.handlesInput());
                ComboBox.this.fireActionEvent();
            }
        });
        Container cnt = new Container(new BorderLayout());
        cnt.addComponent("Center", (Component)this.contained);
        this.contained.setStyle(UIManager.getInstance().getComponentStyle("ComboBoxPopup"));
        this.popupContent = cnt;
        return this.popupContent;
    }

    private Popup getPopup() {
        if (this.popup == null) {
            this.popup = new Popup(this.getComponentForm(), this.getPopupContent());
        } else {
            this.contained.setListCellRenderer(this.getRenderer());
            this.contained.setModel(this.getModel());
        }
        int y = this.getAbsoluteY() + this.getHeight();
        int height = Math.min(this.getComponentForm().getHeight() - y, this.popupContent.getPreferredSize().getHeight());
        if (this.getComponentForm().getHeight() - y < this.contained.getElementSize(true).getHeight() * 3) {
            height = this.contained.getElementSize(true).getHeight() * 3;
            y = this.getAbsoluteY() - height;
        }
        this.popupContent.setHeight(height);
        this.popupContent.setX(this.getAbsoluteX());
        this.popupContent.setY(y);
        this.popupContent.setWidth(this.getWidth());
        this.popupContent.setFixedPosition(true);
        Style s = this.popupContent.getStyle();
        s.merge(this.getStyle());
        s.setBgTransparency(255);
        s.setBorder(null);
        s.setMargin(0, 0, 0, 0);
        s.setPadding(0, 0, 0, 0);
        return this.popup;
    }

    protected void modelChanged(int status) {
        this.popup = null;
        this.popupContent = null;
    }

    void selectElement(int selectedIndex) {
    }

    public void pointerReleased(int x, int y) {
        this.setHandlesInput(true);
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawComboBox(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getComboBoxPreferredSize(this);
    }
}

