/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.lang.ref.WeakReference;
import java.util.Hashtable;

class CustomFont
extends Font {
    private static final int COLOR_CACHE_SIZE = 20;
    private Hashtable colorCache = new Hashtable();
    private String charsets;
    private int color;
    Image cache;
    int[] cutOffsets;
    int[] charWidth;
    private int imageWidth;
    private int imageHeight;
    private WeakReference imageArrayRef;

    private int[] getImageArray() {
        int[] a;
        if (this.imageArrayRef != null && (a = (int[])this.imageArrayRef.get()) != null) {
            return a;
        }
        a = this.cache.getRGB();
        this.imageArrayRef = new WeakReference<int[]>(a);
        return a;
    }

    public CustomFont(Image bitmap, int[] cutOffsets, int[] charWidth, String charsets) {
        this.cutOffsets = cutOffsets;
        this.charWidth = charWidth;
        this.charsets = charsets;
        this.imageWidth = bitmap.getWidth();
        this.imageHeight = bitmap.getHeight();
        int[] imageArray = new int[this.imageWidth * this.imageHeight];
        bitmap.getRGB(imageArray, 0, 0, 0, this.imageWidth, this.imageHeight);
        for (int iter = 0; iter < imageArray.length; ++iter) {
            imageArray[iter] = (imageArray[iter] & 0xFF0000) << 8;
        }
        this.cache = Image.createImage(imageArray, this.imageWidth, this.imageHeight);
        this.imageArrayRef = new WeakReference<int[]>(imageArray);
    }

    public int charWidth(char ch) {
        int i = this.charsets.indexOf(ch);
        if (i < 0) {
            return 0;
        }
        return this.charWidth[i];
    }

    public int getHeight() {
        return this.imageHeight;
    }

    private boolean checkCacheCurrentColor(int newColor) {
        Image i;
        this.colorCache.put(new Integer(this.color), new WeakReference<Image>(this.cache));
        this.color = newColor;
        WeakReference newCache = (WeakReference)this.colorCache.get(new Integer(newColor));
        if (newCache != null && (i = (Image)newCache.get()) != null) {
            this.cache = i;
            if (this.colorCache.size() > 20) {
                this.colorCache.remove(this.colorCache.keys().nextElement());
            }
            return true;
        }
        if (this.colorCache.size() > 20) {
            this.colorCache.remove(this.colorCache.keys().nextElement());
        }
        return false;
    }

    private void initColor(Graphics g) {
        int newColor = g.getColor();
        if (newColor != this.color && !this.checkCacheCurrentColor(newColor)) {
            this.color = newColor & 0xFFFFFF;
            int[] imageArray = this.getImageArray();
            for (int iter = 0; iter < imageArray.length; ++iter) {
                imageArray[iter] = this.color | imageArray[iter] & 0xFF000000;
            }
            this.cache = Image.createImage(imageArray, this.imageWidth, this.imageHeight);
        }
    }

    void drawChar(Graphics g, char character, int x, int y) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        int i = this.charsets.indexOf(character);
        if (i > -1) {
            this.initColor(g);
            g.clipRect(x, y, this.charWidth[i], this.imageHeight);
            g.drawImage(this.cache, x - this.cutOffsets[i], y);
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public void addContrast(byte value) {
        int[] imageArray = this.getImageArray();
        for (int iter = 0; iter < imageArray.length; ++iter) {
            int alpha = imageArray[iter] >> 24 & 0xFF;
            if (alpha == 0) continue;
            alpha = Math.min(alpha + value, 255);
            imageArray[iter] = alpha << 24 & 0xFF000000 | this.color;
        }
    }

    void drawChars(Graphics g, char[] data, int offset, int length, int x, int y) {
        this.initColor(g);
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (clipY <= y + this.getHeight() && clipY + clipHeight >= y) {
            for (int i = 0; i < length; ++i) {
                char c = data[offset + i];
                int position = this.charsets.indexOf(c);
                if (position < 0) continue;
                g.clipRect(x, y, this.charWidth[position], this.imageHeight);
                if (g.getClipWidth() > 0 && g.getClipHeight() > 0) {
                    g.drawImage(this.cache, x - this.cutOffsets[position], y);
                }
                x += this.charWidth[position];
                g.setClip(clipX, clipY, clipWidth, clipHeight);
            }
        }
    }

    public String getCharset() {
        return this.charsets;
    }
}

