/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.CustomFont;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.SystemFont;
import com.sun.lwuit.impl.LWUITImplementation;

public final class Graphics {
    private int xTranslate;
    private int yTranslate;
    private Font current = Font.getDefaultFont();
    private LWUITImplementation impl;
    private Object nativeGraphics;

    Graphics(Object nativeGraphics) {
        this.setGraphics(nativeGraphics);
        this.impl = Display.getInstance().getImplementation();
    }

    void setGraphics(Object g) {
        this.nativeGraphics = g;
    }

    Object getGraphics() {
        return this.nativeGraphics;
    }

    public void translate(int x, int y) {
        if (this.impl.isTranslationSupported()) {
            this.impl.translate(this.nativeGraphics, x, y);
        } else {
            this.xTranslate += x;
            this.yTranslate += y;
        }
    }

    public int getTranslateX() {
        if (this.impl.isTranslationSupported()) {
            return this.impl.getTranslateX(this.nativeGraphics);
        }
        return this.xTranslate;
    }

    public int getTranslateY() {
        if (this.impl.isTranslationSupported()) {
            return this.impl.getTranslateY(this.nativeGraphics);
        }
        return this.yTranslate;
    }

    public int getColor() {
        return this.impl.getColor(this.nativeGraphics);
    }

    public void setColor(int RGB) {
        this.impl.setColor(this.nativeGraphics, RGB);
    }

    public Font getFont() {
        return this.current;
    }

    public void setFont(Font font) {
        this.current = font;
        if (font instanceof SystemFont) {
            this.impl.setNativeFont(this.nativeGraphics, ((SystemFont)font).getNativeFont());
        }
    }

    public int getClipX() {
        return this.impl.getClipX(this.nativeGraphics) - this.xTranslate;
    }

    public int getClipY() {
        return this.impl.getClipY(this.nativeGraphics) - this.yTranslate;
    }

    public int getClipWidth() {
        return this.impl.getClipWidth(this.nativeGraphics);
    }

    public int getClipHeight() {
        return this.impl.getClipHeight(this.nativeGraphics);
    }

    public void clipRect(int x, int y, int width, int height) {
        this.impl.clipRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.impl.setClip(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.impl.drawLine(this.nativeGraphics, this.xTranslate + x1, this.yTranslate + y1, this.xTranslate + x2, this.yTranslate + y2);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.impl.fillRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.impl.drawRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.impl.drawRoundRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, arcWidth, arcHeight);
    }

    public void lighterColor(int factor) {
        int color = this.getColor();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.min(255, r + factor);
        g = Math.min(255, g + factor);
        g = Math.min(255, b + factor);
        this.setColor(r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF);
    }

    public void darkerColor(int factor) {
        int color = this.getColor();
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        r = Math.max(0, r - factor);
        g = Math.max(0, g - factor);
        g = Math.max(0, b - factor);
        this.setColor(r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.impl.fillRoundRect(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, arcWidth, arcHeight);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.impl.fillArc(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, startAngle, arcAngle);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.impl.drawArc(this.nativeGraphics, this.xTranslate + x, this.yTranslate + y, width, height, startAngle, arcAngle);
    }

    public void drawString(String str, int x, int y) {
        if (this.current instanceof SystemFont) {
            this.impl.drawString(this.nativeGraphics, str, x + this.xTranslate, y + this.yTranslate);
        } else {
            char[] data = str.toCharArray();
            this.current.drawChars(this, data, 0, data.length, x, y);
        }
    }

    public void drawChar(char character, int x, int y) {
        this.impl.drawString(this.nativeGraphics, "" + character, x, y);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        if (this.current instanceof SystemFont) {
            this.drawString(new String(data, offset, length), x, y);
        } else {
            CustomFont f = (CustomFont)this.current;
            f.drawChars(this, data, 0, data.length, x, y);
        }
    }

    public void drawImage(Image img, int x, int y) {
        img.drawImage(this, x, y);
    }

    void drawImage(Object img, int x, int y) {
        this.impl.drawImage(this.nativeGraphics, img, x + this.xTranslate, y + this.yTranslate);
    }

    void drawImage(Object img, int x, int y, int transform) {
        if (transform != 0) {
            this.impl.drawImageRotated(this.nativeGraphics, img, x + this.xTranslate, y + this.yTranslate, transform);
        } else {
            this.drawImage(img, x, y);
        }
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.impl.fillTriangle(this.nativeGraphics, this.xTranslate + x1, this.yTranslate + y1, this.xTranslate + x2, this.yTranslate + y2, this.xTranslate + x3, this.yTranslate + y3);
    }

    void drawRGB(int[] rgbData, int offset, int x, int y, int w, int h, boolean processAlpha) {
        this.impl.drawRGB(this.nativeGraphics, rgbData, offset, x + this.xTranslate, y + this.yTranslate, w, h, processAlpha);
    }

    public void fillRadialGradient(int startColor, int endColor, int x, int y, int width, int height) {
        this.impl.fillRadialGradient(this.nativeGraphics, startColor, endColor, x + this.xTranslate, y + this.yTranslate, width, height);
    }

    public void fillLinearGradient(int startColor, int endColor, int x, int y, int width, int height, boolean horizontal) {
        this.impl.fillLinearGradient(this.nativeGraphics, startColor, endColor, x + this.xTranslate, y + this.yTranslate, width, height, horizontal);
    }

    public void fillRect(int x, int y, int w, int h, byte alpha) {
        int oldAlpha = this.impl.getAlpha(this.nativeGraphics);
        this.impl.setAlpha(this.nativeGraphics, alpha & 0xFF);
        this.impl.fillRect(this.nativeGraphics, x + this.xTranslate, y + this.yTranslate, w, h);
        this.impl.setAlpha(this.nativeGraphics, oldAlpha);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] cX = xPoints;
        int[] cY = yPoints;
        if (this.impl.isTranslationSupported() && (this.xTranslate != 0 || this.yTranslate != 0)) {
            cX = new int[nPoints];
            cY = new int[nPoints];
            System.arraycopy(xPoints, 0, cX, 0, nPoints);
            System.arraycopy(yPoints, 0, cY, 0, nPoints);
            int iter = 0;
            while (iter < nPoints) {
                int n = iter;
                cX[n] = cX[n] + this.xTranslate;
                int n2 = iter++;
                cY[n2] = cY[n2] + this.yTranslate;
            }
        }
        this.impl.fillPolygon(this.nativeGraphics, cX, cY, nPoints);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] cX = xPoints;
        int[] cY = yPoints;
        if (this.impl.isTranslationSupported() && (this.xTranslate != 0 || this.yTranslate != 0)) {
            cX = new int[nPoints];
            cY = new int[nPoints];
            System.arraycopy(xPoints, 0, cX, 0, nPoints);
            System.arraycopy(yPoints, 0, cY, 0, nPoints);
            int iter = 0;
            while (iter < nPoints) {
                int n = iter;
                cX[n] = cX[n] + this.xTranslate;
                int n2 = iter++;
                cY[n2] = cY[n2] + this.yTranslate;
            }
        }
        this.impl.drawPolygon(this.nativeGraphics, cX, cY, nPoints);
    }

    public boolean isAlphaSupported() {
        return this.impl.isAlphaGlobal();
    }

    public void setAlpha(int a) {
        this.impl.setAlpha(this.nativeGraphics, a);
    }

    public int getAlpha() {
        return this.impl.getAlpha(this.nativeGraphics);
    }

    public boolean isAntiAliasingSupported() {
        return this.impl.isAntiAliasingSupported();
    }

    public boolean isAntiAliasedTextSupported() {
        return this.impl.isAntiAliasedTextSupported();
    }

    public boolean isAntiAliased() {
        return this.impl.isAntiAliased(this.nativeGraphics);
    }

    public void setAntiAliased(boolean a) {
        this.impl.setAntiAliased(this.nativeGraphics, a);
    }

    public void setAntiAliasedText(boolean a) {
        this.impl.setAntiAliasedText(this.nativeGraphics, a);
    }

    public boolean isAntiAliasedText(boolean a) {
        return this.impl.isAntiAliasedText(this.nativeGraphics);
    }
}

