/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.automation;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.automation.DebugController;
import com.sun.lwuit.impl.LWUITImplementation;
import com.sun.lwuit.impl.LWUITImplementationDecorator;
import com.sun.lwuit.util.Log;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

class DebugImplementation
extends LWUITImplementationDecorator {
    static final int POINTER_PRESSED = 1;
    static final int POINTER_RELEASED = 2;
    static final int POINTER_DRAGGED = 3;
    static final int KEY_PRESSED = 4;
    static final int KEY_RELEASED = 5;
    static final int KEY_LONG_PRESSED = 6;
    private Throwable edtException;
    private DebugController.Script recording;
    private DebugController.Script pausedRecording;
    private long startTime;
    static DebugImplementation instance;
    private int edtMode;
    private Hashtable longClickKeyCodeMap = new Hashtable();
    private Hashtable keyCodeMap = new Hashtable();
    private int lastKeyCode;
    private long pressTime;
    private float ratio = 1.0f;
    private Hashtable gameKeyMap;
    private boolean drawRecordingText = true;
    private boolean dontRecordNextRelease;
    private boolean pressCharged;
    private long pauseDuration;

    public DebugImplementation(LWUITImplementation underlying) {
        super(underlying);
        instance = this;
        Timer t = new Timer();
        t.schedule(new TimerTask(){
            private int counter;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (DebugImplementation.this.recording != null || DebugImplementation.this.pausedRecording != null) {
                    ++this.counter;
                    if (this.counter % 5 == 0) {
                        DebugImplementation.this.drawRecordingText = false;
                        Display.getInstance().getCurrent().repaint(10, 10, 100, 20);
                    } else {
                        DebugImplementation.this.drawRecordingText = true;
                        if ((this.counter - 1) % 5 == 0) {
                            Display.getInstance().getCurrent().repaint(10, 10, 100, 20);
                        }
                    }
                }
                Hashtable hashtable = DebugImplementation.this.longClickKeyCodeMap;
                synchronized (hashtable) {
                    if (DebugImplementation.this.pressCharged && System.currentTimeMillis() - DebugImplementation.this.pressTime >= 1000L) {
                        DebugImplementation.this.dontRecordNextRelease = true;
                        DebugImplementation.this.pressCharged = false;
                        Runnable target = (Runnable)DebugImplementation.this.longClickKeyCodeMap.get(new Integer(DebugImplementation.this.lastKeyCode));
                        if (target != null) {
                            DebugImplementation.this.revertLastPressFromScript();
                            Display.getInstance().callSerially(target);
                        }
                    }
                }
            }
        }, 300L, 300L);
    }

    public int getGameAction(int key) {
        Integer i;
        if (this.gameKeyMap != null && (i = (Integer)this.gameKeyMap.get(new Integer(key))) != null) {
            return i;
        }
        int g = super.getGameAction(key);
        return g;
    }

    void setPlaybackSpeed(float ratio) {
        this.ratio = ratio;
    }

    Throwable fetchEDTException() {
        Throwable ex = this.edtException;
        this.edtException = null;
        return ex;
    }

    void startRecording() {
        this.recording = new DebugController.Script();
        Display.getInstance().getCurrent().repaint();
        this.startTime = System.currentTimeMillis();
    }

    void bindShortcut(int keyCode, boolean longClick, Runnable callback) {
        if (longClick) {
            this.longClickKeyCodeMap.put(new Integer(keyCode), callback);
        } else {
            this.keyCodeMap.put(new Integer(keyCode), callback);
        }
    }

    DebugController.Script finishRecording() {
        DebugController.Script s = this.recording;
        this.recording = null;
        Display.getInstance().getCurrent().repaint();
        return s;
    }

    void playScript(DebugController.Script script) {
        this.gameKeyMap = script.startScript();
        script.execute(this.ratio);
        this.gameKeyMap = null;
    }

    DebugController.Script getCurrentRecording() {
        return this.recording;
    }

    public boolean handleEDTException(Throwable err) {
        this.edtException = err;
        return true;
    }

    protected void keyPressed(int keyCode) {
        this.lastKeyCode = keyCode;
        this.pressTime = System.currentTimeMillis();
        this.pressCharged = true;
        if (this.recording != null) {
            this.recording.pushKeyEvent((int)(System.currentTimeMillis() - this.startTime), 4, keyCode);
        }
        super.keyPressed(keyCode);
    }

    void pauseScript() {
        this.pausedRecording = this.recording;
        this.recording = null;
        this.pauseDuration = System.currentTimeMillis();
    }

    void resumeScript() {
        this.recording = this.pausedRecording;
        this.pausedRecording = null;
        this.startTime += System.currentTimeMillis() - this.pauseDuration;
    }

    private void revertLastPressFromScript() {
        if (this.recording != null) {
            this.recording.popKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keyReleased(int keyCode) {
        Hashtable hashtable = this.longClickKeyCodeMap;
        synchronized (hashtable) {
            this.pressCharged = false;
        }
        if (!this.dontRecordNextRelease) {
            Runnable target;
            if (this.lastKeyCode == keyCode && (target = (Runnable)this.keyCodeMap.get(new Integer(keyCode))) != null) {
                this.revertLastPressFromScript();
                super.keyReleased(keyCode);
                Display.getInstance().callSerially(target);
                return;
            }
            if (this.recording != null) {
                this.recording.pushKeyEvent((int)(System.currentTimeMillis() - this.startTime), 5, keyCode);
            }
        }
        this.dontRecordNextRelease = false;
        super.keyReleased(keyCode);
    }

    protected void pointerDragged(int x, int y) {
        if (this.recording != null) {
            this.recording.pushPointerEvent((int)(System.currentTimeMillis() - this.startTime), 3, x, y);
        }
        super.pointerDragged(x, y);
    }

    protected void pointerPressed(int x, int y) {
        if (this.recording != null) {
            this.recording.pushPointerEvent((int)(System.currentTimeMillis() - this.startTime), 3, x, y);
        }
        super.pointerPressed(x, y);
    }

    protected void pointerReleased(int x, int y) {
        if (this.recording != null) {
            this.recording.pushPointerEvent((int)(System.currentTimeMillis() - this.startTime), 3, x, y);
        }
        super.pointerReleased(x, y);
    }

    int getEdtMode() {
        return this.edtMode;
    }

    void setEdtMode(int edtMode) {
        this.edtMode = edtMode;
    }

    public void repaint(Animation cmp) {
        if (this.edtMode != 0 && !Display.getInstance().isEdt()) {
            if (this.edtMode == 2) {
                throw new RuntimeException("EDT Violation Detected In Repaint Call For Component: " + cmp);
            }
            if (this.edtMode == 1) {
                Log.p("EDT Violation Detected In Repaint Call For Component: " + cmp);
            }
        }
        super.repaint(cmp);
    }

    protected void paintOverlay(Graphics g) {
        if (this.drawRecordingText) {
            if (this.recording != null) {
                g.translate(-g.getTranslateX(), -g.getTranslateY());
                g.setColor(0xFF0000);
                g.fillArc(10, 10, 10, 10, 0, 360);
                g.setFont(Font.getDefaultFont());
                g.drawString("Recording", 23, 15 - Font.getDefaultFont().getHeight() / 2);
            } else if (this.pausedRecording != null) {
                g.translate(-g.getTranslateX(), -g.getTranslateY());
                g.setColor(0xFF0000);
                g.fillRect(10, 10, 3, 10);
                g.fillRect(15, 10, 3, 10);
                g.setFont(Font.getDefaultFont());
                g.drawString("Paused", 23, 15 - Font.getDefaultFont().getHeight() / 2);
            }
        }
    }
}

