// ==UserScript==
// @name        Webshots.com image downloader for Opera 8 - 9
// @version     1.01
// @date        2007-11-30
// @author      Mike Samokhvalov <mikivanch@gmail.com>
// @download    http://www.puzzleclub.ru/files/webshots_com.js
// @include     http://webshots.com/*
// @include     http://*.webshots.com/*
// @include     http://p.webshots.com/sym-cache/ProInternalUse/*
// ==/UserScript==

(function(){
  if(window.location.href.toLowerCase().indexOf('http://p.webshots.com/sym-cache/prointernaluse/') != -1)
  {
    var onLoad = function()
    {
      var d = window.location.hash;
      if(d)
      {
        d = d.substring(1);
        d = unescape(d);
        
        document.body.style.display = 'block !important';
        
        var e = document.createElement('div');
        e.setAttribute('style', 'display: block !important; text-align: center; padding: 5px;', false);
        e.innerHTML = d + '.jpg';
        document.body.insertBefore(e, document.body.firstChild);
      }
    };
    
    if(typeof(window.opera.version) == 'function' && window.opera.version() >= 9)
      document.addEventListener('DOMContentLoaded', onLoad, false);  
    else
      document.addEventListener('load', onLoad, false);

    return;
  }

  var changeHref = function(anchor)
  {
    var href = anchor.href;
    if(href && href.search(/webshots\.com\/g\//i) != -1)
    {
      var a = href.match(/\/(\d\d\d+)\.html/i);
      if(a && a.length > 1)
      {
        a = parseInt(a[1]);
        if(!isNaN(a))
        {
          a = a.toString();
          var b = a.substring(a.length - 2);
          if(b.charAt(0) == '0')
          {
            b = b.substring(1);
          }
          href = 'http://p.webshots.com/sym-cache/ProInternalUse/' + b + '/' + a + '_poster2000.jpg';                    
          if(href)
          {            
            var img = anchor.getElementsByTagName('img');
            if(img && img.length > 0)  
            {
              img = img[0];
              if(img && img.getAttribute('alt', false))
              {
                var d = img.getAttribute('alt', false);
                d = d.replace(/[\x2F\x5C\x3A\x7C]/g, '-');
                d = d.replace(/[\x2A\x3F\x22]/g, '');
                d = d.replace(/\xA9/g, '-');
                d = d.replace(/\x3C/g, '(');
                d = d.replace(/\x3E/g, ')');
                d = d.replace(/(?:^\s+)|(?:\s+$)/g, '');
                d = d.replace(/\.+$/g, '');
                d = a + ' - ' + d;
                href += '#' + escape(d);
              }
            }
            
            anchor.setAttribute('href', href, false);
          }
        }
      }      
    }
  };

  var onLoad = function()
  {
    document.removeEventListener('mouseover', onMouseOver, false);
    
    var a = document.getElementsByTagName('a');
    for(var i = 0; i < a.length; i++)
    {
      changeHref(a[i]);
    }
  };
  
  var onMouseOver = function(e)
  {
    var obj = e.srcElement ? e.srcElement : e.target;
    if(obj && obj.tagName == 'A')
    {
      changeHref(obj);
    }    
  };
  
  document.addEventListener('mouseover', onMouseOver, false);
  
  if(typeof(window.opera.version) == 'function' && window.opera.version() >= 9)
    document.addEventListener('DOMContentLoaded', onLoad, false);  
  else
    document.addEventListener('load', onLoad, false);
})();