/*
 * Decompiled with CFR 0.152.
 */
package fileselector;

import fileselector.FileSelectListener;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import myutil.StringTokenizer;

public class FileSelectMenu
implements CommandListener,
Runnable {
    public static final int OPEN_FILE = 0;
    public static final int OPEN_DIR = 1;
    public static final int CREATE_FILE = 2;
    private int type;
    private List list;
    private String currentDir;
    private Image folderimg;
    private Image fileimg;
    private Image upimg;
    private Image diskimg;
    private Image errimg;
    private FileSelectListener listener;
    private Display display;
    private Form fNameForm;
    private TextField tf;
    private String fileType = "";
    private Command openc;
    private Command cancelc;
    private Command createc;
    private String[] physicalAddress = new String[4];
    private String[] shortcut = new String[4];
    private boolean isRoot = false;
    private String threadFolder;

    public FileSelectMenu(String string, int n, FileSelectListener fileSelectListener) {
        this.listener = fileSelectListener;
        this.type = n > 2 || n < 0 ? 0 : n;
        if (string == null || string.equals("")) {
            string = "/";
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        if (string.charAt(string.length() - 1) != '/') {
            string = string + "/";
        }
        this.currentDir = string;
        String string2 = "Select file";
        if (n == 1) {
            string2 = "Select folder";
        }
        this.list = new List(string2, 3);
        this.cancelc = new Command("Cancel", 3, 1);
        this.openc = new Command("Open", 8, 1);
        this.createc = new Command("Create", 8, 1);
        this.list.addCommand(this.cancelc);
        if (n == 1) {
            this.list.addCommand(this.openc);
        }
        this.list.setCommandListener((CommandListener)this);
        if (n == 2) {
            this.list.addCommand(this.createc);
        }
        try {
            this.folderimg = Image.createImage((String)"/folder.png");
            this.fileimg = Image.createImage((String)"/file.png");
            this.upimg = Image.createImage((String)"/up.png");
            this.diskimg = Image.createImage((String)"/disk.png");
            this.errimg = Image.createImage((String)"/error.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < this.shortcut.length; ++i) {
            this.physicalAddress[i] = "";
            this.shortcut[i] = "";
        }
    }

    public void display(Display display) {
        this.display = display;
        this.buildList(this.currentDir);
        display.setCurrent((Displayable)this.list);
    }

    public void setFileType(String string) {
        this.fileType = string;
    }

    private void buildList(String string) {
        this.threadFolder = string;
        new Thread(this).start();
    }

    private void createErrorList() {
        this.list.setTitle("Error");
        this.list.append("Error reading filesystem", this.errimg);
        this.list.removeCommand(this.cancelc);
        this.list.removeCommand(this.openc);
        this.list.removeCommand(this.createc);
        this.list.removeCommand(List.SELECT_COMMAND);
        this.list.addCommand(new Command("Ok", 3, 0));
    }

    public void run() {
        Object object;
        String string;
        Enumeration enumeration;
        Image image = this.folderimg;
        System.out.println("Trying to access dir " + this.threadFolder);
        this.list.deleteAll();
        this.isRoot = false;
        if (this.threadFolder.equals("/") || this.threadFolder.equals("")) {
            try {
                enumeration = FileSystemRegistry.listRoots();
                image = this.diskimg;
            }
            catch (SecurityException securityException) {
                this.createErrorList();
                return;
            }
            this.isRoot = true;
            string = System.getProperty("fileconn.dir.memorycard");
            if (string != null && (object = System.getProperty("fileconn.dir.memorycard.name")) != null) {
                if (string.startsWith("file://")) {
                    string = string.substring(7);
                }
                this.physicalAddress[0] = string;
                this.shortcut[0] = object;
                this.list.append((String)object, this.folderimg);
            }
            if ((string = System.getProperty("fileconn.dir.music")) != null && (object = System.getProperty("fileconn.dir.music.name")) != null) {
                if (string.startsWith("file://")) {
                    string = string.substring(7);
                }
                this.physicalAddress[1] = string;
                this.shortcut[1] = object;
                this.list.append((String)object, this.folderimg);
            }
            if ((string = System.getProperty("fileconn.dir.photos")) != null && (object = System.getProperty("fileconn.dir.photos.name")) != null) {
                if (string.startsWith("file://")) {
                    string = string.substring(7);
                }
                this.physicalAddress[2] = string;
                this.shortcut[2] = object;
                this.list.append((String)object, this.folderimg);
            }
            if ((string = System.getProperty("fileconn.dir.videos")) != null && (object = System.getProperty("fileconn.dir.videos.name")) != null) {
                if (string.startsWith("file://")) {
                    string = string.substring(7);
                }
                this.physicalAddress[3] = string;
                this.shortcut[3] = object;
                this.list.append((String)object, this.folderimg);
            }
        } else {
            try {
                string = (FileConnection)Connector.open((String)("file://" + this.threadFolder));
                enumeration = string.list();
                this.list.append("../", this.upimg);
            }
            catch (Exception exception) {
                this.createErrorList();
                return;
            }
        }
        this.list.setTitle(FileSelectMenu.top(this.threadFolder));
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (string.charAt(string.length() - 1) == '/') {
                this.list.append(string, image);
                continue;
            }
            if (this.type != 0) continue;
            if (this.fileType == null || this.fileType.equals("")) {
                this.list.append(string, this.fileimg);
                continue;
            }
            object = new StringTokenizer(string, ".");
            String string2 = "";
            while (((StringTokenizer)object).hasMoreTokens()) {
                string2 = ((StringTokenizer)object).nextToken();
            }
            if (!string2.equalsIgnoreCase(this.fileType)) continue;
            this.list.append(string, this.fileimg);
        }
    }

    private String getPhysicalAddress(String string) {
        for (int i = 0; i < this.shortcut.length; ++i) {
            if (!this.shortcut[i].equals(string)) continue;
            return this.physicalAddress[i];
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        return string;
    }

    public static String top(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        return string2 + "/";
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.list) {
            if (command.getCommandType() == 3) {
                this.listener.fileSelectAction(null);
            } else if (command == List.SELECT_COMMAND) {
                String string = this.list.getString(this.list.getSelectedIndex());
                if (string.equals("../") || this.type != 1 && (this.isRoot || string.charAt(string.length() - 1) == '/')) {
                    this.commandAction(new Command("Open", 8, 1), displayable);
                } else if (!this.isRoot) {
                    this.listener.fileSelectAction(this.currentDir + string);
                } else {
                    this.listener.fileSelectAction(this.getPhysicalAddress(string));
                }
            } else if (command.getLabel().equals("Open")) {
                String string = this.list.getString(this.list.getSelectedIndex());
                this.currentDir = this.isRoot ? this.getPhysicalAddress(string) : this.currentDir + string;
                if (string.equals("../")) {
                    this.currentDir = FileSelectMenu.cdup(FileSelectMenu.cdup(this.currentDir));
                }
                this.buildList(this.currentDir);
            } else if (command.getLabel().equals("Create")) {
                if (this.isRoot) {
                    return;
                }
                this.fNameForm = new Form("Name file");
                this.tf = new TextField("File name", "", 256, 0);
                this.fNameForm.append((Item)this.tf);
                this.fNameForm.setCommandListener((CommandListener)this);
                this.fNameForm.addCommand(new Command("Ok", 4, 0));
                this.fNameForm.addCommand(new Command("Cancel", 3, 0));
                this.display.setCurrent((Displayable)this.fNameForm);
            }
        } else if (displayable == this.fNameForm) {
            if (command.getCommandType() == 3) {
                this.display.setCurrent((Displayable)this.list);
            } else {
                String string = this.tf.getString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                String string2 = "";
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                if (!string2.equalsIgnoreCase(this.fileType)) {
                    string = string + this.fileType;
                }
                this.listener.fileSelectAction(this.currentDir + string);
            }
        }
    }

    public static String cdup(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            string2 = string2 + "/" + string3;
        }
        return string2 + "/";
    }
}

