// ==UserScript==
// @description   Vkontakte Optimizer module
// @include       *vkontakte.ru*
// @include       *vkadre.ru*
// @include       *vk.com*
// ==/UserScript==
//
// (c) All Rights Reserved. VkOpt.
//

// for convert sounds to wav you can use http://audio.online-convert.com/convert-to-wav
// for convert to base64: http://www.opinionatedgeek.com/dotnet/tools/Base64Encode/




if (!window.Audio){
  Audio= function(url){
    this.notification    = function(){this.play  = function(){};};
    this.play  = function(){};
  }
}


var vkSoundsRes={
  On:'data:audio/wav;base64,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',
  New:'data:audio/wav;base64,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',
  Msg:'data:audio/wav;base64,UklGRhB1AABXQVZFZm10IBAAAAABAAEAESsAACJWAAACABAAZGF0Yex0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD//wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP////8AAAEAAAAAAAAAAAAAAAAAAAAAAAAA//8AAAAAAAD//wAAAAD///3//f8AAAEAAgABAAEAAgAAAP7///////////8AAAEAAQABAP/////+//7/JQBrAJkAqwCeAGwAFACb/wf/Yv64/Rj9jfwm/PD78vs0/Lr8hP2K/sT/HwGNAvoDUQV7BmAH8AcgCOMHNQcZBpQEugKfAF3+DfzQ+cn3F/bT9BX06fNd9Hb1Jfdd+Qf8Av8sAlgFXQgUC1UNAQ/4DyEQdw8BDskL4ghtBZcBjv2C+aj1MvJa70rtF+zi67Tsg+5E8dj0FfnM/b4CrAdYDIMQ+BN+Fu8XOxhLFyEV3RGiDZsIBwMx/Vr30PHd7Mjo5+Vj5D3kduUC6MTrk/Av9lH8sQIDCfEOKBRmGH0bOR1tHR4cbBl2FW4QlAo3BKP9KPck8ePrpeea5ObioOLQ42zmVOpR7yH1e/sKAnwIhw7jEz8YZRsvHYYdaRzdGQkWIhFiCxYFiP4D+Ojxg+wL6Mrk6uJ64oLj+OW46ZDuQ/SH+g8BjQepDRYTlhfpGuMcax18HCcaiRbLESUM5QVa/9T4p/Ir7Z7oO+U045TiY+Ol5TPp3O1y87L5QADKBgENlBI3F7Ia2ByMHcUcjxoJF2IS0QydBhIAh/lT88LtF+mN5VDjfuIm40LlsuhH7dDyBfmT/yUGbQwVEtIWbBqzHIkd6BzbGnkX7BJuDUcHxQA5+vrzWe6Y6fblouOz4jXjJOVj6MjsIvIv+J3+GwVaCwkR5BWrGSocRB3qHCIb/hekE1AORgjTAUr7+/Q470vqcObe47PiAOPB5N3nL+x88YH38/1/BNEKmhCPFXAZDhxIHQ0dYxtbGB8U4w7pCIEC+vui9czvwurG5gzks+LN4lrkRudu65/wlfYG/Z8DDQoAECcVQRkZHI0diR0NHCsZCRXcD+UJbgPM/FT2WPAi6/XmCOSA4nHi2uOr5r/q4u/T9Ub85wJlCW0PqxThGNwbdB2VHT8cgRl+FWoQhQoZBHf99fbp8J3rVOdF5JXiXOKa4z7mKuor7//0Yfv+AYIImg75E1oYhRtSHaodjBwEGjQWShGCCykFkf4J+OfxeewD6MDk2eJn4nHj6uWy6ZnuX/S5+lQB2Qf4DWMT1RcXG/8ccx1wHAIaSxZ7Ec0LiwUE/4z4dvIJ7Y7oPuVA47DilOPe5XDpIe618+L5XADRBu8MahL9Fm0ajxxHHYscYhrqFkwSwwyUBg8AiPlU88DtFOmM5VPjieI141DlwOha7eLyE/md/yoGagwPEs8WbBq7HJodAB31GpUXDBOTDW0H6wBe+hf0aO6X6eLld+N24u7i2eQe6JTsAfIg+KT+NwWGC0MRJRbsGWgcfB0ZHUIbERivE1MOQgjIATj74/Qc7yzqUea+45Pi3eKZ5K/n/OtH8Uz3wf1TBK0KgBCAFW0ZFhxaHSgdhBuDGEoUEQ8aCbICKPzN9fPv5urm5iXkx+Le4mjkUed166DwkPb5/IgD6gnOD+gU9xjJGzodNh2+G+QYyhSmD7oJUwPC/Fn2bfBG6yjnRuTG4rviIuTt5vfqC/Dp9Un81gI+CTIPYxSRGIYbHh1EHfYbRRlVFVYQhQowBKX9Nvc28fLrrOea5OPioOLS42rmSOo77wX1W/vtAWgIeQ7TEzEYWxspHYQdZhzfGQ4WJBFgCwwFeP7599/xeuwN6NHk7+KA4ojj++W56ZPuS/SX+icBqAfHDTkTtRcDG/ocgB2NHC8ahha+ERMM0AVD/8D4mPIb7Y7oLOUf44LiW+Oi5Tjp7u2K88X5UADWBgUNkBIvF6YayhyAHb0cjhoOF2gS1wyjBhsAkvla88PtFOmI5U3jgOIq40TlsuhI7czy+fh//woGSAzpEaUWQBqOHHEd3RzZGoAX/hKKDWoH7QBj+iL0d+6q6fnllOOY4hHj/OQ96KzsEfIo+KP+LgV4CzIRERbXGVUcah0KHTgbDBitE1QORAjKATn75fQd7yvqUOa7447i2OKW5LHnA+xS8V331f1pBMUKmBCXFYMZKxxsHTcdjRuFGEYUBA8DCZAC/Pua9bzvrOqt5vDjl+K04kfkOudo65vwkvYB/ZUD/QnlDwQVGRnuG2AdXB3lGwoZ8BTLD94JcgPb/Gv2dfBF6xznMOSl4pDi8uO45sHq2O+89SP8uwIwCTAPbxSpGKobSx13HSwcehmFFX0QpApEBK79Nfcs8eDrlOd/5MjihOK441PmNeos7/n0UvvnAWMIdA7OEy0YVxslHYEdZRzfGREWKhFpCxcFg/4D+OnxgewS6NPk7+J74oDj7uWp6YHuN/SC+hMBlge5DS0TrRcAG/wchx2aHEAamRbTESkM5AVW/8/4pPIi7ZHoK+UZ43fiTeOR5STp2u1387P5QADJBvwMihItF6ga0ByKHcscnhofF3oS6Qy0BisAoPlk88rtF+mH5Ujjd+Ie4zPlnugy7bXy4vho//YFOAzfEaIWRRqaHIQd9hz2GqEXHxOpDYUHAwF0+ir0d+6k6ezlgeN/4vbi3uQf6JDs+PET+JT+JQV1CzURGRbkGWUcfB0dHUobHRi9E2IOTwjUAUH76/Qi7y/qUea744zi1eKQ5Kjn9etC8Ur3wP1TBLAKhBCHFXcZJBxrHTsdlxuUGFkUGg8bCakCFfyy9dLvweq95vrjnOK14kLkL+da64vwgfbu/IQD7AnWD/cUDhnlG1kdWR3jGwoZ8xTRD+UJfQPo/Hn2hPBU6yvnPuSx4pri+eO85sHq0++09Rn8rgIhCSEPYBSbGJ4bQh1wHSgcexmIFYQQrgpPBLr9Qvc58ezrn+eI5M7iiOK541HmL+ok7+/0R/vbAVcIaQ7FEyUYURsiHYAdZhzjGRcWMhFyCyEFj/4P+PTxjOwa6Nnk8uJ84n3j6eWi6XfuK/R2+gcBiwevDSUTpxf8GvsciB2dHEYaoRbdETQM8AVi/9v4rvIr7ZjoL+Ua43biSeOK5Rvp0O1s86j5NgDABvQMhBIpF6Ya0RyMHdAcpRooF4QS9Ay/BjUAqPlr88/tGemH5Ufjc+IY4yzllugq7azy2fhh//AFNAzcEaEWRxqeHIgd+xz9GqcXJhOwDYwHCAF2+iz0d+6i6enlfeN74vHi2OQZ6Ivs8/EO+I/+IgVzCzMRGRblGWccgB0hHVAbIxjEE2kOVgjZAUb77/Qj7y/qUOa344fizuKH5J/n7es68UP3u/1QBK4KhBCIFXoZKRxwHUAdnRuaGF4UIA8gCa0CGPy09dLvwOq75vfjmeKx4j7kLOdV64fwfPbr/IED6QnUD/YUDhnmG1wdXB3mGw4Z9hTUD+kJfwPp/Hr2hPBU6yrnPOSw4pji9uO65r/q0u+y9Rb8rAIgCSAPXxSbGJ4bQh1yHSocfBmKFYYQrwpRBLz9RPc78e7roOeJ5M7iiOK441DmLuoj7+70RvvbAVYIaQ7EEyQYUBshHYAdZxzkGRgWNBFzCyIFkP4Q+PTxi+wa6Njk8OJ64nvj6OWg6XbuKfR0+gYBiQetDSMTphf7Gvochx2dHEcaohbeETYM8gVk/934sPIt7ZnoMOUb43biSeOJ5Rrpzu1p86X5MgC8BvEMgRImF6Ua0ByMHdEcpxopF4US9QzABjcAqvlu89HtHOmJ5UjjdOIX4yvlk+gm7any1vhd/+wFMQzbEaAWRhqeHIkd/Rz/GqsXKROzDY4HCwF6+i70ee6k6erlfON64vDi1uQW6Ijs8PEL+Iz+HwVxCzERFxblGWgcgx0lHVQbKRjKE24OWwjeAUv78vQl7zDqT+a144PiyuKD5Jrn6Os28T/3uP1NBKwKgxCIFXsZKRxxHUMdoBueGGMUJQ8lCbECG/y39dXvweq75vfjmOKu4jvkKOdR64Hwd/bm/HwD5gnTD/UUDhnnG10dXh3qGxIZ+xTaD+4JhQPv/ID2ifBX6yvnPOSu4pXi8uO05rnqzO+s9RH8pwIbCRwPXBSZGJ0bQx1zHSwcfxmOFYsQtApWBMH9SPc/8fHroeeJ5M7ihuK1403mLOof7+n0QfvWAVMIZg7CEyMYUBsiHYEdaBzmGRoWNRF1CyMFkP4Q+PTxjOwb6Nnk8eJ74nzj6OWh6XbuKvR0+gUBiAerDSITpBf5GvcchR2bHEUaoRbdETUM8gVk/974s/Iw7Z3oNOUf43niS+OK5Rvpzu1p86T5MAC5Bu0MfRIhF58ayhyIHc0cpBooF4US9wzDBjoArvlz89ftIumQ5U7jeuIe4zDll+gp7avy1fha/+gFJwzKEYkWKBp4HF4dzhzQGn0XAROVDX4HCgGN+lb0te7y6Urm6uPy4mvjTuWF6OXsNfIz+JL+AQUtC8kQjhU+GawbuhxZHJEaeBc1EwAOGgjQAXT7UfW57/LqOee75Jrj4uOP5YzosuzL8Zf3zP0aBDIKxg+PFFEY3RoRHOEbThpsF2MTZA6vCI8CUvxF9rXw6+si6IrlQuRc5NblnOiK7G7xCvcV/UMDRQnQDp0TbhcUGmwbZxsHGlwXiRO/DjoJQwMl/S33p/Ha7ALpT+bk5NLkGuaq6GLsE/GA9mT8cgJfCOANrxKOFk4ZyhryGsMZTBevExkPxAn0A/b9E/iW8sbt4OkU54blSuVi5r/oQey+8Pz1t/ulAXwH8wzDEa8VhhgkGnUadhk0F8wTag9FCp8Ewf70+IPzs+7B6t7nL+bI5bDm2ego7HHwf/UR+94AnwYJDNgQ0BS9F3sZ9BkkGRIX3hOuD7cKOgV+/8r5Z/Sa75/rqejc5lDmCecB6R3sNPAS9Xr6JgDNBSkL9A/zE/MWzhhtGcgY6RbmE+kPIgvPBTUAnPpI9X3weuxw6Yfn1uZk5yvpFOz576n05/lw//8ETAoUDxoTLRYkGOcYbRi9FuwTHhCFC1sG4wBi+x72WPFQ7TbqMuhe58PnXekW7MvvTPRh+cj+OwR3CToORRJmFXYXXBgLGIkW6BNMEOIL4gaNASf88vYz8ibu/Orf6OnnJuiS6Rnsnu/y89z4IP55A6QIYA1wEaAUyRbRF6gXUhbhE3UQOQxiBzAC5fzD9wvz+u7C647peOiN6MvpJOx4757zYPiA/b0C1weKDJ4Q3BMbFkIXQBcXFtYTmRCKDN0HzgKe/Y343fPJ74XsOeoE6fPoB+oy7FjvUfPp9+f8CQIQB7sLzw8ZE28VsxbWFtcVwxO0ENIMTghiA07+Ufmr9JXwRe3m6pPpXulJ6kfsQO8N8333V/xdAVEG8woHD1sSxRQlFmwWlRWtE8wQFQ26CPID+f4P+nP1XvEE7pHrIurI6YvqXuwp78ryEffI+7QAlAUsCkEOnxEbFJgVABZRFZMT3BBRDR0JdwSb/8X6M/Yf8r7uOeyx6jjq1Op/7CDvlfK29kr7GADjBG4JgA3kEHATBRWOFQQVbxPkEIMNeAn1BDUAdfvw9t/yd+/i7EHrquoh66LsGe9l8l32z/qA/zYEtAjCDC0QyRJ0FBsVtRRIE+YQrw3KCWsFyAAd/Kb3mfMt8Ivt1Osf63Przewb7z7yD/Zd+vD+jwMBCAoMeQ8iEuMTpxRkFB4T5BDWDRkK3AVWAcL8WPhR9ODwMO5j7JLrxOv37BzvF/LC9e35ZP7uAlEHVgvIDn0RUxMyFBEU8BLfEPkNYQpGBt4BYP0F+QT1j/HV7vXsCOwa7CjtJu/68X71h/nh/VMCpwakChoO2xDDErwTuhO+EtQQFA6iCqoGYAL4/a35s/U+8njvhu1/7HHsW+0z79/xPvUl+WH9vAEABvYJbA01EDASQxNhE4gSwxArDt8KCgfdAo3+Uvpg9uryG/AY7vrszeyV7UfvzPEF9cn45vwpAVwFSQm+DJEPnBHIEgMTTRKuED0OFwtlB1YDH//0+gz3lvO/8Kvude0q7c/tW++68c70cPhw/JoAvAShCBYM8Q4MEU0SphISEpYQSQ5IC7gHxwOn/4/7sPc89F/xPe/w7YrtEO5577PxovQh+AL8FQAlBAAIcwtTDnwQ0hFGEtEReRBRDnMLBQgyBCoAI/xO+Nz0+fHK72ru6u1P7pfvrvF69Nf3m/uW/5MDYgfSCrcN7Q9XEeURjhFZEFQOmQtNCJcEqAC0/Or4fPWU8ljw5e5L7pPuuO+s8VX0kvc3+xr/BQPKBjcKHw1gD94QgxFJETUQUw67C48I9wQiAUD9g/kZ9i7z5/Bh76/u2u7e76/xNfRQ99n6of55AjAGmAmEDNAOXxAdEQERDRBODtgLzQhUBZgByv0a+rT2yPN38eDvF+8l7wnwt/Eb9BX3gPov/vMBngUACe0LQw7iD7YQthDhD0MO8AsGCaoFBwJN/qn6Svdc9ALyW/B872/vNfDD8Qb04PYt+sL9cwEPBWoIWgu3DWUPTxBpELIPNQ4DDDkJ+wVxAsv+NPvd9+70jPLX8OPvvO9l8NPx9fOv9t/5XP34AIcE3AfKCi8N6w7qDx0Qgw8kDhIMZwlGBtYCRP+8+2z4fPUU81HxSvAK8Jbw5fHo84P2lfn6/IIAAgROBzwKpwxwDoIPzQ9PDw8OHAyRCY0GNgO4/z/89/gK9pzzzPGx8FvwzPD88d/zW/ZR+Zv8DwCAA8UGsQkhDPcNGg99DxoP+A0kDLcJzwaSAykAvvx++ZL2IPRE8hnxq/AA8RTy2fM39hL5Q/yi/wMDPwYqCZ4Lfg2zDiwP4w7dDSYM1gkKB+UDkAA3/QH6F/eh9LvygPH+8DvxM/Lb8xz22vjx+zz/jwLABacIHgsHDUkO1Q6lDrsNIgzwCUEHNgT3AK39gvqd9yX1NvPs8VXxefFW8uDzA/ak+KL71v4XAj0FHwiZCosM3g1/DmgOmg0fDAkKdAeCBFkBH/7/+h74o/Wt81Xyq/G48Xvy6PPv9Xb4W/t7/qsBxQShBxsKFAxyDSUOIw5tDQ4MFwqfB8cEtAGO/nr7ofgm9ir0xfII8v3xpfL38+H1SfgT+xr+OAFFBBwHlgmWCwENxw3eDUQNAwwpCs8HEwUXAgH/+vsm+av2p/Q082PyP/LM8gD0zPUZ+Mr6vP3KAM0DngYbCSMLnAx0DaINIA34CzgK+AdRBWkCZP9n/MP5kPfD9XX0tvOK8/bz7vRj9kL4bvrK/DX/igGqA3oF3QbBBxkI4AcZB9AFFgQFArr/WP0A+9r4B/em9dL0oPQZ9UH2EviA+m/9xQBdBA0IqgsGD/kRWBQDFt8W2hbpFRAUWhHXDakJ9gTq/7T6iPWZ8BnsM+gQ5c7ihuFC4QbiyuN85gLqOu778hf4YP2mArsHdAytEEUUJBc7GYIa/BqvGqsZBxjdFUgTaBBbDT4KKwc4BHYB8v6x/Lb6/viB9z72MvVL9HvzufL68TrxdvCv7+7uPe6t7UztMe1w7RruRu/88DrzAvZR+Rr9SwHLBX0KOw/cEzgYJBx2HwkiuSNuJBUkoyIbIIYc+xeXEoIM7AUI/xD4P/HO6vTk49/I28TY8dZe1gzX89gA3BfgDuW66ufwYPft/VcEbAr/D+YUAhk7HIUe2x9AIMIfcx5vHNIZvhZWE7sPDQxqCOsEpAGk/vT7lvmJ98r1UPQQ8wHyF/FH8Izv4e5E7rrtSe377N3s/exr7TjucO8d8Urz9vUh+b/8wQATBZYJKw6uEvQW2BowHtkgsSKcI4YjZCIzIPsczhjEEwIOtAcLAT76gvMS7SPn6OGN3TjaBNgD1zvXqdg92+Deb+PA6KTu6fRW+7kB3weWDbgSIRe1GmYdKR/+H+4fBx9iHRcbRhgQFZUR9g1PCrwGUQMhADj9mfpL+En2j/QV89LxvfDO7/3uR+6p7SbtwuyG7H3ssuw07RDuU+8F8S7z0PXp+HD8VQCGBOkIXg3FEfYVzBkiHdMfwCHMIuMi+SEKIBsdOhl/FAsPBAmZAv77ZvUJ7xvp0ONS38jbUNn819jX4tgQ203eeuJy5wrtEPNS+Zv/ugWAC8MQXxU1GTMcTB59H8ofPh/tHe8bYBldFgcTfQ/bCz8IvQRqAVP+gvv9+ML20vQl87XxfPBv74ruyO0n7ajsTuwg7Cfsbez87OTtLO/e8ALzmPWf+A/82v/uAzMIjwzgEAMV1BgtHOwe8iAkImwivSERIGod1RlmFToQdwpFBNn9YfcS8SLrweUb4Vbdk9ro2GLYA9nE2pXdW+H15Trr/vAQ9z39VQMpCY4OXxN7F8waQx3YHowfZR92Hs8cixrGF54UMRGbDfoJZQbwAq7/qPzp+XP3RvVg873xV/Am7yfuVe2t7C/s3Ou869LrJ+zH7LrtCu+/8N3yZ/Vb+LP7Yv9WA30HuwvxDwEUxhcfG+sdCSBgIdghZCH9H6EdWxo8Fl0R3wvrBa3/VvkY8yXtreff4uHe1dvT2ezYJtl+2ufcSuCM5ITpCe/v9AP7FgH6BoEMhRHkFYYZVhxJHlwflB/8HqYdpxsaGRoWxhI6D5QL7AdYBOsAtv3B+hP4r/WV88TxNfDk7s/t7ew97L/rdOtc637r4+uQ7I3t4+6Y8LPyMvUW+Ff77P7GAtAG8woTDxITzhYmGvscLh+kIEchByHdH8UdxhrxFloSIQ1pB10BK/sC9RXvkumn5HvgMd3l2qfZg9l32nzcfd9h4wboR+318uT45f7IBGMKjQ8jFAgYJxtyHeIedx87HzseiRw9GnMXRxTTEDQNhQneBVIC9f7Q++34U/YE9P7xQPDH7o7tk+zS60nr+erm6g/rfOsz7Drtme5T8G3y6PTC9/b6ef4+AjIGPwpLDjoS7BVCGR0cYB7xH7sgqiC3H94dIxuSFz8TSA7LCPEC5vzX9vPwautn5hTilN4D3HTa9tmL2i3czt5Y4qvmo+sZ8eD2yfymAk4Ilw1cEn4W5hmDHEwePB9aH64eSx1EG7IYsBVZEsoOGwtnB8IDQQDy/N75EfeN9FPyZ/DC7mbtTex169/qh+pw6pzqD+vO69zsQO797xjyj/Ri94r6/v2xAZMFjgmJDWsRFhVsGE8boh1MHzggUyCTH/IddRsmGBQUWQ8VCmwEhv6R+LryLu0a6KTj898k3UzbfNq42v/bRd524XflKOpi7/z0yPqaAEcGpguSEOoUlBh8G5Yd3B5PH/ge4x0iHMwZ+hbHE00QpwztCDgFmgEl/uf66Pcx9cbyqPDY7lTtGewo633qGOr66STqmOpb62/s2O2a77bxLPT59hn6g/0nAfkE5gjTDKkQTRSiF4sa7BysHrcf+R9pH/4dvBupGNUUWBBLC9MFFgA/+nf07e7L6TrlXuFV3jncGtsA2+7b2N2w4F/kxOi/7Sbz0fiS/j8Ergm8DkUTLBdcGsYcYB4rHycfYx7sHNYaORgtFc0RMw55CrYGAANq/wP82Pjw9VPzBfEH71nt+uvq6ijqsumI6avpHurh6vfrY+0m70PxuPOB9pn5+vyUAFkEOQgcDOoPihPfFs8ZPhwUHjwfpB9AHwce/RslGY0VSRFzDCsHlgHb+yX2nvBy68fmxOKI3yzdxNta2/HbhN0G4GPjf+c67G7x8/ad/EQCvgfmDJcRtBUmGdobxB3gHjAfux6OHbobVhl3FjcTsA/+CzYIbgS+ADP93fnI9vvzffFQ73jt8uvB6uPpV+ke6Tbpouli6njr5uyr7sjwO/MB9hX5bfz//7kDjgdmCywPxxIcFhIZjRt3HbseRh8NHwYeMByRGTQWKRKKDXIIBgNs/cn3S/IY7VnoNOTI4DDeg9zK2w7cTd1634biVubP6szvKPW4+lUA1AUQC+UPNBTiF9waEh1/Hh8f+R4WHoYcWxqrF48UHxF3Da0J2AUQAmf+6/qq97D0A/Kp76Tt9+uj6qfpA+m36MLoJunh6fTqYewm7kTwtvJ79Yr43fto/xsD6Qa6CnsOFBJrFWcY7hrrHEke9B7hHgceYxz4GdEW/BKPDqcJYgTn/ln54/Ot7t7pm+UE4jffSd1J3EDcLN0I38PhSuWA6UTudPPl+HH+8AM6CS0OphKKFsQZQxz8HeseFB97HjAdQxvIGNYVhBLtDigLTgd2A7L/Fvyu+Ij1rfIk8PPtHOyi6oTpxOhh6Fnoruhg6W3q1uuZ7bTvJfLn9PL3QfvG/nICOQYFCsINWRGyFLYXShpaHNEdmx6vHv8dixxSGl8XvhODD8oKrgVSANz6cvU88GDrBOdJ40vgIt7d3IncJ92z3iDhXORP6Njs1/Em9578FwJpB3MMEREnFZsYXBtfHZoeDh/BHrwdDhzKGQQX1BNVEJsMwQjdBAUBTP3A+XL2a/O18FfuVOyx6m/pj+gQ6PbnQejq6PLpWOsY7THvnvFb9GD3pPoc/rwBcwUvCd0MZxC3E7UWSxlkG+sczx0EHn4dOxw8GoYXKBQxELsL3wa9AXv8O/ck8lvtAuk75SXi1N9d3srdH95a33PhV+Tx5ybs1vDc9Rb7WwCGBXcKCQ8gE6MWfxmlGw4duB2kHdwcbhtpGeIW7ROkEB4NcQm2BQACZv70+rv3xvQe8svv0O0w7O7qCuqE6Vrpjeka6v/qPezQ7bXv6fFo9Cv3K/pe/bcAKwSoBxwLdg6fEYMUChckGbsavhsgHNgb3xo1Gd4W5RNXEEoM1gcYAy/+P/lp9NHvmevh58XkXeK84O/f+9/g4JniGOVJ6BTsXfAD9eP52/7FA4II7wzwEG0UUReNGRcb7RsOHIIbVBqSGE4WnROVEEwN2glTBs0CW/8N/PL4FfaB8zvxSO+s7WnsgOvu6rTq0upE6wrsIe2I7j7wPfKC9An3yvm8/Nb/CgNLBokJtAy2D34S9hQLF6wYyBlRGjwagxklGCMWhhNZEK8MnQg8BKr/CPtz9g7y++1W6jvnxOQC4wPi0OFq4s3j7+W+6CbsDvBV9N/4iP0wArUG+grhDlESNhWCFygZJBp2GiIaMRmvF64VPxN4EG0NNArjBowDRQAb/R/6WffW9J3ysfAZ79Tt4+xI7ADsCuxl7A7tBe5G79Dwn/Kw9P/2hPk6/Bb/DgIVBR4IGAvxDZkQ/hILFbAW3ReGGJ4YHxgGF1IVCxM6EO4MOgk1BfkAo/xR+CP0NvCo7JTpEec05Qzkn+P14wrl0+ZH6VDs2e/I8/33W/zCABEFLAn4DFkQPhOWFVQXchjwGM0YExjOFgsV2hJPEH4NfApdBzMEEwEM/iv7ffgM9t/z/PFn8CHvLO6I7TLtK+1w7f/t2O7371rx/vLh9P32TvnM+3H+MgEDBNoGpwlaDOQOMxE1E9wUFxbaFhgXzBbwFYMUiRILEBUNuAkIBhwCEf7/+QX2QPLM7sLrOulI5/zlXuV25ULmvefc6Y3svu9X8zz3UPt2/5ADgQcuC38OYBG/E5EVzRZxF30X9xbpFWAUaRIZEIANswrGB8gEzgHp/ib8j/kw9xD1NvOm8WHwae+97lzuR+567vLur++v8O7xavMh9Q33K/l1++T9bwAMA7MFUwjeCkgNfw91ERkTXRQ1FZQVcxXNFKAT7hG+DxsNEQq0BhcDVP+E+8L3J/TQ8NbtT+tO6eXnHuf/5ornu+iL6unsxu8M86L2bfpR/jMC9wWDCcAMmA/7EdwTMhX3FS4W2RX/FK0T8BHYD3YN3QofCE4FewK4/xD9kPpD+DD2XvTS8o3xkfDd73LvTu9u79LvdvBY8Xjy0PNg9SL3E/ku+239yf83Aq8EJgeOCdkL+g3hD4ERyhKyEysUMBS6E8USUxFpDw4NUQo+B+sDbQDb/E353fWl8rzvOe0v667pw+h26Mfot+k+61Lt4e/a8iX2rPlS/f4AlgQACCcL9A1YEEQSrhOQFOwUwRQWFPYSbRGID1kN8QphCLkFCwNoANz9dPs6+Tb3bvXn86Xyp/Hv8HzwTPBd8K/wPvEH8gnzQfSt9Uj3D/n9+g/9PP98AckDFgZZCIUKjQxkDvsPRhE6EskS7hKhEt8RqBD+DukMcgqoB5sEYAEK/rH6bfdW9ILxCO/67GnrYOrq6QnqveoC7M/tFvDF8sn1C/l1/Ov/VAObBqkJaAzIDroQNBIxE60TqRMrEzwS4xAxDzQN+gqXCBkGkQMPAaD+T/wn+jH4c/by9LDzsvL18XnxPfE/8X/x+vGr8pLzrPT29Wz3DfnV+r38v/7WAPoCIQVBB1AJQQsGDZQO3g/aEHsRvBGTEf0Q+g+KDrMMfwr5By4FMgIY//P72/jm9SnzuvCs7g7t7etS60TrwuvL7FbuWPDC8oL1g/iw+/H+LQJQBUMI8wpMDUIPyxDfEXgSmRJDEn8RVxDVDgYN/ArDCG0GCgSnAVL/F/0B+xn5ZPfo9an0qPPm8mHyG/IS8kHyqPJF8xT0E/VA9pb3Fvm4+nr8V/5HAEUCRwRGBjgIDwrDC0cNjg6ODz4QlBCKEB0QSA8NDnEMegozCKgF6AIHABb9KvpY97X0VPJI8KHubO207H3syuyb7ejuqvDS8lD1E/gG+xH+IQEeBPUGkgniC9oNbQ+SEEYRhxFYEb4Qwg9tDswM7grgCLIGcgQuAvb/0/3Q+/X5S/jV9pj1l/TR80bz9vLg8gLzWPPg85j0fvWP9sj3J/mo+kb8/v3L/6QBhANjBTcH9giWCgwMTg1RDgsPdA+EDzkPjw6EDR4MYQpVCAUGgAPVABf+V/uq+CH20vPN8SLw3e4L7rHt1O1y7ofvDfH38jf1vfd3+lD9MgAKA8MFTAiSCogMIg5XDyEQfxByEP8PKw8BDosM1grxCOgGygSlAocAe/6K/L36Hfmv93X2c/Wr9Bv0xPOk87jz/vN19Br16fXh9v/3Qfmj+iD8t/1g/xgB1wKYBFAG+AeGCe8KKQwsDe4NZw6PDmIO3Q39DMYLPAplCEwG/AOEAfP+XfzR+WP3JvUp83zxLPBG79Duze5A7ybwePEr8zX1h/cN+rf8b/8jAsAEMwdsCVwL+Aw2DhEPhg+VD0APjg6JDTgMqArnCAIHBQX+AvoABf8n/Wv71/lx+D33PvZ19eL0hvRe9Gj0o/QM9aD1XvZC90n4cfm3+hj8kP0a/7EATwLvA4gFEweJCN4JCgsGDMcMRg19DWcNAA1HDD0L5glGCGcGUgQUArv/WP35+rD4jfai9P3yqfGy8CHw+u9B8PLwCfJ/80r1XPen+Rj8nv4oAaED+gUjCA0KrAv1DOQNcg6hDnIO5w0LDeULfwrmCCYHTAVkA3sBnP/S/SX8nPo++Q74D/dF9q71S/Ua9Rr1R/Wf9SH2yvaW94T4kfm6+v37Vf2//jgAuAE8A70ENAaYB+IICAoCC8kLVQyfDKIMWgzGC+QKuAlGCJUGrwSdAm8AMf7y+8P5tPfT9S/01vLS8Srx5fAH8Y7xePK981X1NfdN+ZD77f1SAK4C8QQLB+4IjwriC+EMhw3TDcUNYA2qDKsLbQr6CF4HowXYAwcCOwCA/t78Wvv9+cz4yff29lX25vWn9Zn1t/UA9nL2CvfE95/4mPms+tn7Gv1t/s7/NgGkAhAEcwXIBgUIIwkcCuYKegvTC+sLvgtJC4wKiAlBCLwGAgUdAxYB/P7e/Mn6zfj49lj1+vPq8jDy0vHU8TXy9fIP9Hr1K/cY+TH7Zv2o/+YBEAQYBu8HiQncCuELlAzxDPgMrQwTDDMLFArBCEUHqgX8A0cClQDw/mH97/ug+nr5f/iw9xH3oPZe9kj2XPaZ9v72hfct+PT42PnU+un7Ev1L/pL/4gA3AowD2QQaBkcHWAhHCQwKoQr/CiILBQulCgIKHQn4B5kGBgVIA2oBd/99/Yj7p/nn91f2AfXx8y/zwvKu8vPykvOF9Mb1TfcN+fr6Bv0j/z8BTgNABQgHmgjtCfgKtgskDEIMEAyUC9MK1QmiCEUHyQU4BJwCAAFu/+79h/xA+x76JPlW+LP3Pffy9tL23PYM92L32fdw+CX59fnd+tz77/wR/kD/eQC3AfYCMARgBYAGhwdxCDYJ0Qk5CmwKZQogCp0J2gjbB6QGOgWkA+wBHgBF/mv8n/rv+Gf3Efb69Cn0pvN385vzEvTc9PH1TPfg+KP6ifyD/oIAeQJaBBkGqAf9CBEK3gpfC5YLfwsgC34KnwmMCE0H7AV1BO8CZgHl/3P+Fv3W+7j6wPnw+Ev4z/d+91f3V/d898X3L/i3+Fz5Gvrw+tr72Pzk/f7+IABIAXMCnAO7BMwFywavB3MIEQmBCcEJywmcCTQJjwixB5wGVgXlA08CogDm/ib9cPvQ+VL4Affo9Q/1fvQ69EX0ofRJ9Tv2cPfe+H36PvwW/vf/0wGeA0sFzgYeCDMJBQqSCtcK1AqNCgQKQQlLCCgH5QWIBB0DrQFAAOD+k/1g/Ev7WPqM+ej4avgV+Of33/f79zj4lfgQ+ab5VPoY++/72fzS/df+5P/4AA4CIgMvBDEFIQb7BrgHUgjFCAwJIgkECbAIJQhlB3IGTwUCBJICCAFt/839Mfym+jb57ffV9vf1WfUC9fT0MPW29YP2kffY+FD67fuk/Wj/LAHkAoQEAAZOB2gIRAnfCTcKSgobCq0JBAkoCCEH9gWwBFsD/AGgAE3/Cv7d/M773voS+mv56/iR+Fz4Tfhf+JP45fhT+dv5e/ov+/f7z/y0/ab+ov+jAKYBqQKnA5sEgQVUBg0HpwceCG4IkAiDCEUI1AcvB1kGVQUoBNgCbQHv/2j+4vxo+wX6xPis98n2Ifa69Zf1uvUk9tD2vPfg+DX6sPtI/e/+mgA+As4DQAWJBqIHhAgpCY8JtQmcCUUJtgj0BwYH9AXHBIcDPQLzAK7/d/5V/Uz8YfuW+u/5bPkO+dT4vfjI+PL4Ofmb+Rf6qPpO+wb8zvyj/YT+bf9cAE4BQQIvAxYE8AS5BW0GBQd+B9MH/wcACNMHdwfrBjEGSgU7BAoDvQFcAPD+gv0b/Mf6j/l8+Jf36PZ09j72S/aZ9ij38vf1+Cn6gvv6/IT+FgCjASIDiQTMBeQGyQd2COkIHwkZCdkIYgi5B+QG6wXWBKwDdwI9AQgA3/7H/cT83fsV+2766vmI+Uj5Kvks+Uz5ivnh+VD61fpu+xf80PyW/Wb+P/8eAAAB4wHDApwDawQsBdkFbgbnBkAHdAeBB2MHGQejBgEGNQVDBC4D/gG4AGX/Dv67/Hb7SPo7+Vf4ovcj99/21/YO94L3MPgU+Sf6Yvu8/Cv+pP8cAYsC5AMfBTMGGgfOB0wIkAibCG8IDQh7B74G3AXdBMkDpwJ/AVkAPP8u/jP9UvyM++b6YPr6+bb5kvmN+ab52fkm+or6A/uO+yn81fyM/U3+F//m/7kAjgFgAi4D8gOqBFAF4gVbBrYG8QYHB/YGvQZbBs8FHAVDBEkDMwIHAc3/jP5M/Rb89Pru+Qv5U/jN93z3Y/eE9+D3c/g6+TD6TvuL/N79P/+iAP8BSwN9BI0FdAYtB7MHAwgeCAMItgc6B5IGxwXdBN0DzwK4AaAAkP+N/pr9vvz7+1b7zvpm+h769Pno+fj5JPpo+sH6MPuw+0D83vyH/Tz++P66/34ARQELAswChgM1BNUEYgXYBTUGdAaSBowGYQYQBpgF+wQ6BFkDXAJIASYA+v7O/an8k/uU+rX5/Phv+BP47Pf790H4u/hn+UH6Qvtk/J395v40AH4BvALlA+8E1QWRBh8HewekB5kHXwf2BmQGrgXZBO0D8QLrAeIA3//l/vr9JP1l/MD7OfvP+oL6VPpB+kv6bvqo+vj6XPvR+1b86PyG/S3+3P6Q/0gAAgG8AXICIAPGA18E6ARdBbsF/QUhBiYGBwbFBWAF1wQsBGIDfQKBAXUAXv9E/i/9Jvwv+1T6nPkL+ab4cfhv+KD4BPmX+Vf6PvtF/Gb9mP7R/woBOgJYA1wEQAX/BZIG9gYsBzEHCAeyBjMGkQXQBPcDDAMWAhwBJQA2/1P+g/3H/CX8nfsx++L6rvqW+pn6tfrn+i77iPvz+2789fyG/SL+xf5t/xkAxwB1AR8CxQJiA/QDeATqBEcFjAW2BcMFrwV7BSYFrwQYBGQDlAKuAbgAtf+u/qj9q/y/++n6Mfqd+TH58vjh+AD5T/nN+XX6Q/sy/Dv9V/58/6QAxQHYAtUDtgR0BQsGdwa3BsoGrwZqBv4FbgXABPkDHwM6Ak4BZAB//6X+2/0k/YT8/fuP+zz7Bfvo+uT6+fok+2P7tPsV/Ib8Av2K/Rv+sv5Q//H/kwA2AdcBcwIHA5MDEgSABN0EIwVRBWUFWwUzBewEhQQABF4DpALTAe8AAAAL/xX+JP1B/HL7vfon+rb5bvlQ+WH5nfkG+pj6T/sm/Bn9Hv4w/0UAWAFgAlUDMgTvBIkF/AVFBmMGVwYiBscFSgWuBPgDMANbAn4BnwDE//P+L/59/d/8WPzq+5X7Wfs4+y77O/te+5T73vs2/J38Ef2O/RX+of40/8v/YgD7AJIBJQKzAjgDsQMdBHkEwATwBAkFCAXqBLAEWQTlA1UDrgLwASABQwBe/3j+lP28/PT7Qfus+jj65/m/+cL57flD+sD6Yfsi/P/87/3t/vL/9QDxAd4CtQNwBAsFgwXUBf0F/gXYBY0FIAWWBPIDOgN0AqUB0gADADr/fv7Q/TX9r/xA/On7qvuD+3T7e/uX+8f7CPxY/Lf8If2W/RL+lf4f/6v/OgDIAFYB4QFmAuQCWAPAAxgEYASUBLEEtgShBHIEKATEA0QDrgIDAkUBegCn/9D++v0t/W38wPss+7X6YPou+iT6QfqF+u76e/sn/O78yv21/qj/nACLAW4CPwP5A5UEEAVoBZsFpwWPBVMF9wR8BOkDQAOJAscBAAE6AHr/w/4a/oH9/PyN/DP88fvH+7P7tPvL+/X7L/x5/ND8NP2g/RX+kf4S/5b/HQCiACgBqgEoAp8CDQNvA8UDCgQ+BF4EaARbBDUE9gOfAy8DqQIOAmIBpwDj/xz/Uv6Q/dj8MPye+yb7y/qS+n76jfrB+hn7lPst/OH8qv2D/mj/TwAyAQ0C2QKPAywEqwQIBUMFWwVOBR4FzwRjBN0DQgOYAuEBJgFpALD/AP9c/sb9Q/3U/Hr8N/wK/PL78PsB/CT8WPyc/Ov8R/2s/Rj+i/4D/3///P95APYAcQHnAVgCwQIgA3MDuAPuAxEEIAQZBPwDyAN+AxsDogIXAnsBzwAaAGD/o/7r/Tv9mvwL/JP7N/v4+tn63/oG+077t/s//OD8l/1f/jL/CQDfAK4BcgIiA7wDPAScBN0E/gT8BNoEmgQ9BMcDPAOhAvkBSwGaAOv/Q/+l/hT+k/0k/cr8hfxS/DX8Lfw3/FP8gfy8/AP9V/20/Rj+g/7z/mf/3P9SAMgAPAGsARgCewLXAikDbQOiA8gD2wPaA8YDmwNaAwQDmgIcAo4B8QBJAJz/7P4+/pb9+vxu/Pb7l/tT+y77KPtD+3771/tO/N/8hf09/gH/y/+WAF0BGgLGAl4D4ANFBIwEswS7BKUEcAQfBLYDOAOpAg0CaQHAABkAd//d/k/+0P1i/Qb9v/yL/Gv8Xvxk/Hz8pPza/Bv9af3A/R/+g/7s/ln/yP83AKYAEgF8AeIBQQKYAuUCJwNcA4MDmQOdA44DawM0A+oCiwIaApoBCwFxAND/LP+I/uj9Uv3K/FT88/us+4D7cvuB+7D7/Ptk/OX8fP0l/tr+mP9ZABUBygFyAgcDiAPvAzoEZwR3BGoEPwT5A5wDKgOmAhYCfQHeAEAApv8T/4v+EP6k/Un9Af3M/Kn8mfyb/K38z/z9/Dj9fv3N/ST+gP7h/kb/rf8VAHsA4gBGAaUBAAJUAp8C4gIYA0ADWgNjA1wDQgMVA9UCgwIfAqsBKgGcAAcAbf/S/jv+qv0m/bH8T/wD/NL7u/vA++P7Ifx6/Ov8cv0M/rP+Y/8WAMkAdgEYAqoCKQOSA+EDFQQuBCoECgTSA4EDGwOmAiEClAEBAWwA2v9O/8r+Uv7o/Y/9Rv0N/ef80/zP/Nv89vwe/VP9kv3Z/Sj+fv7Y/jb/lv/4/1gAuAAXAXIByAEZAmMCogLYAgIDHgMrAygDFAPvArgCbwIWAq4BOAG2AC0Anv8O/3/+9f12/QT9pPxY/CL8BfwD/Bv8TfyZ/P38dv0B/pr+Pf/k/4wAMQHMAVoC1wJAA5IDywPpA+0D2QOsA2kDEgOpAjICsQEoAZwAEACJ/wj/j/4j/sX9df02/Qf96fzb/N788PwP/T39df23/QL+VP6t/gv/a//O/zEAlAD1AFMBrQEBAk4CkgLLAvoCGwMsAy8DIQMBA9ACjgI7AtkBagHuAGkA3/9R/8L+OP62/UD92fyE/EP8G/wK/BT8OPx2/Mv8Nv21/UT+3v6A/yYAywBpAf4BhAL4AlgDoQPQA+YD4QPDA44DQgPjAnQC+AFzAekAXQDT/07/0v5i/v79qf1l/TL9D/3//P/8Dv0r/Vb9jP3M/RT+Y/63/g//aP/E/x8AeQDQACUBdQG+AQECPQJuApYCswLDAsYCuwKhAngCQAL6AaYBRgHcAGkA8f92//r+gv4R/qn9Tv0F/c38qfyc/Kb8x/z//Ez9q/0c/pr+Iv+w/0AAzQBUAdEBQAKfAuoCHgM9A0YDNwMSA9sCkQI2AtEBYwHvAHkABACU/yv/yv52/i/+9P3I/az9nf2c/af9vf3e/Qj+N/5u/qn+5/4n/2v/rf/x/zIAcwC1APIALgFnAZoBygH0ARcCMAJCAkkCRQI0AhcC7gG3AXMBJAHLAGgAAACU/yb/uf5R/u/9mv1R/Rn98vzf/OH8+Pwk/WP9tf0Y/or+Bf+I/w4AlAAWAZIBAwJmArgC+QIlAzsDPQMqAwMDygJ/AiUCvgFPAdsAZQDw/4D/Fv+1/l/+Ff7Y/ar9i/16/Xf9gP2W/bb94f0U/k/+j/7U/h3/aP+z/wAASwCWAN4AIwFkAaEB1wEHAi4CTAJgAmoCZwJYAjwCEwLeAZsBTQH1AJMALADB/1T/5/59/hr+wv12/Tn9C/3x/Oz8+fwc/VT9nf33/WD+1P5R/9P/VQDWAFEBwgEnAnwCwALxAg4DFgMKA+kCtQJxAh8CwgFbAe4AfgAPAKT/Pf/e/on+QP4D/tT9sv2f/Zn9n/2x/c399P0j/ln+lv7W/hn/YP+o//D/NwB9AMEAAgFAAXoBrgHbAQICIQI2AkICQwI4AiEC/wHQAZUBTwEAAagASADl/3//GP+1/lb+AP60/Xb9R/0p/Rz9I/09/Wr9qf35/Vb+wP4y/6v/JQCeABQBgwHmATwCggK2AtcC5gLhAsgCnQJjAhoCxQFnAQIBmgAwAMr/Z/8L/7j+b/4z/gL+3v3H/b39v/3O/eb9CP4y/mP+mf7V/hX/Vv+Y/93/IABhAKIA4AAbAVMBhQGyAdgB9wEOAhwCIAIaAgkC7AHDAZABUwELAboAYwAGAKf/Rf/m/ov+N/7r/az9e/1Z/Uj9Sf1b/YD9tv39/VL+sv4c/43/AQB1AOYAUQGyAQcCTQKDAqkCvAK8AqoChQJSAhECwwFtAQ8BrABIAOf/if8w/9/+l/5b/ir+BP7s/eD93/3p/f79HP5C/m/+of7Y/hT/UP+P/9D/DwBNAIsAxgD9ADIBZAGPAbQB0gHqAfgB/gH7Ae0B1AGxAYMBSwEKAcAAbwAZAMH/Zv8M/7X+Zf4c/t39rP2K/XX9cP1+/Zz9y/0K/lb+rv4P/3f/5P9RAL0AIwGBAdQBGwJTAnsCkQKXAooCbQJBAggCwQFxARoBvgBgAAIAqP9S/wP/vP5//k3+Jv4M/v39+f0A/hH+LP5O/nf+pv7a/hH/S/+G/8P///86AHUArgDjABUBRAFuAZIBsAHHAdgB3wHdAdMBvgGgAXkBSAENAcoAgQAyAN//i/82/+T+lv5Q/hH+3v25/aH9mf2g/bb93f0T/lb+pf7+/l//xP8rAJAA8gBOAaAB5wEgAksCZgJwAmoCVAIwAv0BvQF0ASQBzgB1ABwAxf9y/yX/3/6j/nD+Sf4t/hz+Ff4a/ij+P/5e/oP+rv7f/hP/Sv+C/7v/9P8sAGMAmADKAPoAJwFOAXEBjwGlAbUBvwG/AbcBpwGNAWsBPwEKAc4AjABCAPb/qP9Z/wv/wP58/kD+Df7l/cv9v/3C/dP98/0h/l7+pf72/k//rf8OAG0AywAkAXQBugHzAR8CPQJMAksCOgIaAu4BtgF0ASkB2QCGADEA3/+Q/0X/Av/G/pP+a/5O/jr+Mf4z/j7+Uv5t/o/+t/7j/hT/Rv96/7H/5/8bAE8AggCzAOAACgExAVMBcAGHAZgBoQGkAZ8BkQF8AV4BNwEIAdEAlABSAAwAw/95/y//6f6n/mz+Ov4R/vX95P3i/e79CP4w/mT+o/7t/j7/lf/v/0oAowD3AEYBjAHFAfMBFAImAioCHwIGAuABrgFzAS8B5QCXAEgA+f+u/2X/Iv/o/rX+jP5u/ln+Tv5N/lX+Zf58/pv+wP7p/hX/Rf92/6n/3P8OAD4AbgCcAMgA8AAUATUBUQFoAXkBhAGIAYUBewFpAU8BLQEDAdIAnABgAB4A3P+X/1L/D//Q/pf+Zf49/h7+C/4F/gz+IP5B/m7+pv7n/jL/gv/W/yoAfgDQABsBXwGZAcgB6wEBAggCAwLvAc8BpAFvATEB7QClAFoADwDH/4H/QP8H/9T+q/6K/nT+Z/5k/mn+dv6L/qf+yP7u/hn/Rf9z/6P/0/8DADEAXgCKALMA2QD7ABsBNgFMAV0BaAFtAWwBZAFVAT8BIgH8ANEAoABpAC0A8P+x/3D/MP/1/r3+jP5k/kX+MP4n/in+OP5U/nr+q/7n/ir/c//C/xAAXwCtAPYAOAFyAaEBxQHdAekB5wHYAb0BmAFpATEB8gCvAGkAIwDe/5v/Xf8l//T+yv6p/pH+gf57/n3+iP6a/rL+0f7z/hn/Qv9t/5r/yP/1/yAASwB1AJ4AwgDiAAIBHAEyAUQBUAFXAVgBUgFGATMBGQH4ANEApAByADwAAgDG/4r/Tv8V/+D+r/6G/mf+UP5F/kP+Tv5l/oX+sP7m/iP/Zv+v//n/QwCOANQAEwFNAXwBoQG8AcoBzAHBAasBiwFhAS4B9QC3AHYAMwDy/7P/dv8//w//5v7F/qv+m/6U/pT+m/6r/sH+3P77/h//Rf9t/5f/wv/t/xYAPgBmAIwArwDOAOwABQEaASwBOAFAAUIBPgE0ASMBDAHwAM0ApQB3AEUAEADZ/6H/af8z/wD/0f6o/oj+cf5j/l7+Zf52/pL+uP7o/h//Xf+g/+X/KwBxALUA8wAqAVoBgAGbAawBsQGqAZkBfgFZASsB9gC+AIAAQQADAMf/jf9X/yj/AP/d/sT+s/6p/qf+rf66/s3+5v4D/yP/Rv9s/5P/u//l/wsAMQBWAHoAnAC7ANYA7gAEARUBIgEqAS0BKwEjARUBAgHoAMkApQB8AE4AHQDq/7b/gf9N/xz/8P7J/qj+j/5//nj+fP6J/qH+wf7r/h3/Vf+S/9P/FABWAJcA0gAIATgBXwF9AZABlwGVAYgBcQFRASkB+QDFAI0AUQAVAN3/pf9w/0H/Gf/2/tv+x/68/rj+u/7F/tb+6/4G/yT/Rv9p/47/tf/b/wEAJQBJAGwAjACqAMUA3ADxAAIBDwEXARsBGgEUAQgB9wDhAMYApQCAAFYAKQD6/8r/mP9n/zn/Dv/n/sf+rP6a/pH+kf6a/q3+yf7u/hr/Tf+F/8H///89AHoAtADpABgBQAFeAXQBgAGAAXcBZAFIASQB+QDJAJQAXQAlAO7/uf+G/1j/L/8O//L+3f7R/sv+zP7U/uL+9f4M/yn/SP9p/4z/sP/V//n/GwA9AF4AfQCaALQAygDeAO4A+wAEAQkBCQEEAfoA6wDXAL8AogCAAFoAMQAFANn/q/99/1H/KP8D/+P+yf62/qr+qP6u/r3+1v71/h3/S/99/7X/7/8oAGIAmgDNAPoAIgFCAVgBZgFqAWQBVAE9AR0B9gDLAJsAZwAxAP3/yv+a/23/Rf8j/wj/8/7l/t3+3P7i/u/+AP8W/zD/TP9r/4z/r//R//P/FAA0AFMAcACLAKMAugDNANsA6ADwAPUA9gDzAOsA3gDMALgAngB/AF0ANwAPAOf/vP+R/2j/QP8d//7+4/7Q/sP+vv7C/s3+4f79/iD/Sf93/6r/4P8WAEwAgQCzAOAABgEnAT8BTgFUAVIBRgEyARYB9ADMAJ8AbwA9AAsA2/+t/4H/Wv84/x3/B//4/u/+7f7x/vr+Cf8c/zP/Tv9r/4n/qf/L/+z/CgAoAEYAYgB8AJQAqQC8AMsA1wDhAOYA6ADmAN8A1ADFALMAnACAAGEAPwAZAPT/zP+k/33/V/80/xb//P7n/tn+0v7T/tz+7P4E/yL/Rv9w/5//0f8EADcAaQCaAMUA6wAMASUBNgE/AT8BNwEnAQ8B8ADMAKQAdwBIABoA7P+//5X/bv9M/zD/Gv8K/wD//P7+/gX/Ev8j/zj/UP9r/4j/pv/F/+T/AgAfADsAVgBvAIYAmwCtAL0AyADSANgA2wDZANQAywC+AK0AmACAAGMAQwAhAP7/2v+0/4//a/9J/yv/Ef/9/u7+5v7l/ur+9/4M/yf/R/9t/5j/x//2/yYAVQCEAK4A0wD0AA4BIAErAS4BKAEbAQYB6wDLAKYAfQBSACUA+f/P/6b/gf9g/0P/Lf8c/xH/DP8M/xH/HP8r/z7/VP9t/4j/pP/B/9//+v8VADEASgBiAHgAjACeAK0AugDDAMkAywDLAMcAwQC1AKcAlAB+AGUASAApAAgA5//E/6H/f/9f/0H/KP8U/wT/+v73/vr+BP8V/y3/Sf9s/5L/vf/q/xYAQwBvAJgAvQDdAPYACgEWARoBGAEOAfwA5QDIAKYAgABYAC4ABQDd/7b/kv9x/1X/Pv8t/yH/G/8a/x7/J/80/0T/Wf9w/4n/o/++/9n/9f8OACcAPwBWAGwAfwCQAJ4AqgC0ALsAvgC/AL0AtwCuAKAAjwB7AGUASwAuABAA8P/R/7D/j/9x/1T/O/8m/xf/DP8H/wj/EP8e/zL/S/9q/47/tf/f/wkAMwBdAIQAqADIAOEA9QADAQkBCQEBAfIA3gDEAKUAgwBeADcAEADq/8X/ov+C/2f/Uf8+/zL/K/8n/yr/Mf89/0v/Xf9y/4j/oP+6/9T/7f8FAB0ANABKAF4AcACAAI8AmwClAKwAsQCyALIArQClAJsAjAB7AGcATwA2ABoA/P/f/8H/o/+F/2n/Uf88/yv/IP8Z/xj/Hf8o/zj/Tv9p/4n/rP/S//n/IABHAG0AkACvAMkA3QDtAPYA9wDzAOgA1wDBAKYAhwBmAEIAHQD5/9b/tf+W/3r/Y/9Q/0L/Of81/zb/O/9D/1D/YP9z/4j/nv+2/87/5v/+/xUAKwBAAFQAZgB3AIUAkQCbAKIApgCoAKcAowCcAJIAhQB1AGIATQA1ABwAAQDm/8r/rf+R/3j/Yf9M/z3/Mf8q/yn/LP81/0P/V/9w/4z/rf/Q//T/GAA9AGEAgQCeALgAzADbAOQA5wDkANoAzAC4AJ8AgwBkAEIAIAD+/93/vf+g/4X/b/9d/07/Rv9B/0D/RP9N/1n/aP95/43/o/+5/9D/5//9/xIAKAA7AE4AXwBuAHsAhwCQAJcAmwCcAJwAmQCSAIkAfgBwAF4ASwA2AB4ABQDs/9P/uP+e/4b/cP9c/0z/QP85/zb/OP8//0r/W/9x/4v/qP/I/+r/DAAuAFAAcACNAKYAvADLANUA2gDYANEAxQC1AJ8AhQBoAEoAKAAIAOn/yv+t/5P/ff9r/1z/Uf9M/0v/Tf9U/2D/bf98/47/o/+3/83/4//5/wwAIAAzAEUAVQBkAHAAewCEAIsAjwCRAJEAjwCKAIIAeABrAFwASgA3ACEACwD0/9z/w/+s/5X/f/9s/1z/UP9H/0P/RP9J/1P/Yv91/4z/p//E/+T/AwAjAEMAYQB+AJcArAC8AMcAzADNAMgAvgCwAJwAhABqAE0ALgAPAPL/1f+4/5//if92/2f/XP9V/1P/Vf9a/2P/b/9//4//of+2/8r/3//0/wcAGgAtAD0ATQBcAGgAcwB8AIIAhwCKAIsAiQCFAH4AdQBqAFwATAA7ACcAEQD8/+b/zv+4/6L/jf96/2r/Xf9U/07/TP9Q/1j/ZP90/4n/of+8/9n/9/8VADQAUQBtAIYAmwCtALkAwQDEAMEAuACsAJsAhgBuAFMANwAZAP3/4v/G/63/l/+E/3T/af9h/13/Xf9h/2n/c/+A/4//oP+z/8b/2v/u/wAAEgAkADUARQBSAF4AaQByAHkAfgCBAIIAggB/AHkAcQBoAFsATAA9ACsAFwADAO//2f/D/67/mv+I/3j/av9f/1n/V/9Y/1//af93/4n/n/+4/9P/7/8LACgARABfAHcAjQCeAKwAtAC4ALgAsgCnAJgAhQBvAFYAPAAhAAYA6//R/7n/o/+Q/4D/c/9r/2b/Zf9o/2//d/+D/5H/of+y/8T/1//q//z/DQAdAC4APABJAFYAYQBpAHAAdQB5AHoAegB4AHMAbQBjAFgATAA9AC0AGgAHAPX/4v/M/7j/pv+U/4T/d/9t/2b/Yv9i/2b/b/98/4z/n/+1/87/6P8DABwANwBSAGkAfgCPAJ0ApwCtAK0AqACgAJMAgwBvAFkAQAAmAAwA8//c/8T/rv+b/4v/f/92/3H/b/9x/3b/fv+I/5T/ov+y/8P/1f/m//j/CAAXACcANQBCAE4AWABhAGgAbQBwAHIAcgBwAGwAZgBfAFUASQA8AC4AHgAMAPv/6f/W/8P/sf+g/5D/g/95/3L/bf9s/3D/dv+A/47/n/+0/8r/4v/7/xQALQBFAFwAcQCCAJAAmwChAKMAoACZAI4AfwBtAFkAQwAsABMA+v/j/83/uP+m/5b/if+A/3r/d/94/3z/gv+L/5f/pP+z/8P/0//k//X/BAATACIALwA8AEgAUgBZAGAAZgBpAGsAbABqAGYAYQBaAFEARwA7AC4AHwAQAP//7//d/8v/uv+q/5v/jv+D/3z/d/91/3f/fP+F/5H/oP+y/8f/3f/1/wwAIwA7AFAAZAB1AIQAjwCWAJkAlwCSAIkAfABtAFsARgAwABkAAgDs/9f/wv+w/6D/lP+K/4P/gP+A/4L/h/+Q/5r/pf+z/8L/0v/h//D/AAANABsAKQA1AEAASgBTAFkAXgBiAGQAZABkAGEAXQBXAFAARgA7AC8AIQATAAMA9P/k/9P/w/+0/6X/mf+O/4b/gf9+/3//g/+L/5T/ov+z/8X/2f/v/wQAGgAwAEUAWQBqAHgAhACMAJAAjwCLAIQAeQBrAFoARwAzAB0ABwDz/9//y/+5/6r/nf+S/4v/iP+G/4j/jf+U/53/qP+1/8L/0P/f/+7//P8JABcAJAAvADoAQwBLAFIAWABbAF0AXgBeAFwAWABTAEwARAA6AC8AIgAVAAcA+f/q/9v/y/+8/6//o/+Z/5D/iv+H/4f/if+P/5j/pP+z/8P/1f/q//7/EgAnADsATgBfAG0AeQCBAIYAhwCEAH8AdgBpAFoASQA2ACIADQD6/+f/1P/D/7P/pv+c/5T/j/+O/4//kv+X/6D/qf+1/8H/z//d/+v/+f8FABEAHgAqADQAPQBFAEsAUQBVAFcAWABYAFcAVABPAEkAQgA5AC8AJAAXAAoA/f/v/+H/0v/F/7j/rP+i/5n/k/+P/4//kP+U/5z/pv+z/8H/0v/l//j/CwAeADIARABVAGMAbwB4AHwAfgB+AHkAcQBnAFkASQA4ACYAEgD//+7/3P/L/7z/r/+k/5z/l/+U/5T/lv+b/6P/rP+2/8H/zv/b/+n/9v8CAA4AGgAkAC4AOAA/AEYASwBPAFIAUwBTAFEATwBLAEYAPwA4AC8AJAAZAAwAAAD0/+f/2f/N/8D/tf+r/6L/nP+X/5b/lv+a/6D/qf+0/8H/0f/i//P/BQAXACkAOwBLAFkAZABuAHQAdwB2AHQAbQBkAFgASgA6ACkAFwAFAPT/4//S/8T/tv+s/6T/nv+b/5r/nP+g/6b/rf+3/8L/zv/a/+f/8////woAFQAgACkAMwA6AEAARgBKAE0ATgBOAE4ASwBIAEMAPQA2AC4AJAAaAA8AAwD4/+z/3//T/8f/vP+y/6r/o/+f/53/nf+f/6T/rP+1/8H/0P/f/+//AAAQACEAMgBCAFAAXABkAGsAbwBwAG4AaABhAFYASQA7ACwAGgAJAPn/6f/a/8v/vv+z/6v/pP+h/6D/oP+k/6n/r/+5/8P/zf/Z/+X/8f/9/wcAEQAcACUALgA1ADsAQABEAEcASQBKAEkARwBEAEAAOgA0ACwAJAAbABEABgD8//D/5P/Z/87/w/+6/7H/q/+m/6P/o/+k/6j/rv+3/8L/zv/c/+z/+/8KABsAKwA5AEcAUwBcAGMAaABpAGgAZABdAFUASQA8AC4AHgANAP7/7//g/9L/xf+6/7L/rP+n/6X/pv+o/63/s/+6/8P/zf/Z/+P/7v/6/wQADgAXACAAKAAwADcAOwA/AEMARQBFAEUARABBAD0AOAAyACwAJAAcABIACAD+//T/6f/e/9T/yf/A/7n/sv+s/6r/qf+p/6z/sv+5/8P/zv/b/+n/9/8GABQAIwAyAD8ASgBUAFsAYABiAGIAXwBZAFIASAA8AC4AIAARAAIA9P/m/9j/zf/B/7j/sv+u/6v/qv+s/7D/tv+8/8X/zv/X/+L/7f/4/wIACgAUAB0AJAArADEANwA6AD0AQABAAEAAQAA+ADoANgAxACoAIwAcABQACQAAAPf/7f/j/9n/0P/H/7//uf+0/7D/rv+v/7H/tf+8/8T/zv/a/+f/9P8BAA8AHQArADgAQwBMAFMAWQBcAFwAWgBWAE8ARgA8AC8AIgAUAAUA+P/r/97/0v/I/7//uP+z/7H/sP+w/7P/uP++/8X/zv/X/+H/6//2////CAARABkAIAAnAC0AMgA2ADkAPAA9AD0APAA6ADcAMwAvACkAIgAbABQACwACAPr/8f/n/9//1f/N/8X/v/+6/7b/tP+0/7X/uf++/8X/z//Z/+T/8f/+/woAFwAkADEAPABFAE0AUgBWAFcAVQBSAEwARQA7ADAAJAAXAAkA/f/x/+T/2P/O/8X/vv+4/7X/tP+0/7f/u//A/8f/z//X/+H/6v/0//3/BQANABUAHQAjACkALwAyADYAOAA5ADkAOAA3ADUAMQAtACgAIgAcABQADAAEAP3/9f/r/+P/2v/S/8v/xf+//7v/uf+4/7n/vP/B/8f/zv/Y/+P/7v/6/wYAEgAeACoANQA+AEYATABPAFEAUQBOAEoAQwA6ADAAJQAaAAwAAAD1/+n/3f/U/8v/w/++/7r/uP+4/7r/vv/C/8j/0P/Y/+D/6P/y//v/AwAKABIAGgAgACYAKwAvADIANAA1ADYANQA0ADIALwArACYAIQAbABUADgAGAP//+P/v/+b/3v/X/9D/yv/E/8H/vv+9/73/wP/D/8n/0P/Y/+H/7P/4/wIADQAZACQALwA4AEAARgBKAEwATABLAEcAQQA6ADEAJwAcABAAAwD5/+7/4//Z/9D/yf/D/7//vP+8/73/wP/E/8r/0P/X/+D/6P/w//n/AQAIAA8AFgAdACIAJwArAC4AMQAyADMAMgAxAC8ALQApACUAIAAbABUADgAHAAEA+v/y/+r/4//c/9X/z//K/8b/w//B/8H/w//G/8v/0P/Y/+H/6v/1////CQAUAB8AKQAyADoAQABEAEYASABHAEQAPgA5ADEAJwAdABIABgD8//L/5//e/9X/zv/J/8T/wf/A/8H/w//G/8v/0v/Y/9//5//u//f///8FAA0AFAAaAB8AJAAoACsALQAuADAALwAuAC0AKgAnACMAHwAbABUADwAIAAIA/P/1/+7/5//g/9r/1P/P/8v/yP/G/8X/x//J/83/0v/Y/+H/6f/z//3/BgAPABoAIwAsADQAOgA+AEIARABDAEEAPQA2ADAAJwAeABQACQD///b/7P/j/9v/0//O/8n/xf/E/8T/xv/J/83/0v/Y/9//5v/u//b//f8DAAoAEQAXABwAIQAkACcAKQArAC0ALQAsACsAKQAmACIAHgAaABUADwAJAAMA/f/4//H/6//k/97/2P/T/8//zP/K/8n/yv/M/8//0//Z/+D/6P/x//r/AwAMABUAHwAoAC4ANAA6AD0APwA/AD4AOgA1AC8AJwAfABYADAACAPn/8P/n/97/1//S/83/yf/I/8j/yf/L/87/0//Z/9//5v/t//T/+/8BAAgADgAUABkAHQAhACUAJwAoACkAKgAqACgAJwAkACEAHQAaABUADwAKAAUA///6//T/7f/n/+H/3P/Y/9P/0P/O/83/zf/P/9H/1f/a/+H/6P/w//j/AAAIABEAGgAiACkAMAA0ADgAOgA7ADoAOAA0AC4AJwAfABcADgAFAPz/9P/q/+P/3P/W/9H/zv/L/8r/y//N/9D/1P/Z/9//5f/s//P/+v8AAAUACwARABYAGwAfACIAJAAmACcAJwAnACYAJQAiACAAHQAYABQAEAALAAUAAAD7//b/8f/q/+X/4P/b/9f/1P/S/9D/0f/R/9P/1v/b/+D/5//u//b//v8FAA4AFgAeACUALAAxADQANwA4ADcANQAyAC0AJwAgABgAEAAHAP//9//v/+f/4P/a/9X/0f/P/87/zv/Q/9L/1v/a/9//5v/r//H/+f///wMACQAPABQAGAAcAB8AIgAkACUAJQAkACQAIwAhAB4AGwAYABQAEAALAAYAAQD9//j/8//t/+j/4//e/9v/1//V/9T/0//T/9X/2f/c/+H/5//t//T//P8DAAoAEgAaACEAJwAtADAAMwA0ADQAMwAwACwAJgAgABkAEQAJAAEA+v/z/+v/5P/e/9n/1f/T/9L/0f/R/9T/1//b/+D/5f/r//H/+P/+/wIABwANABEAFgAZABwAHwAhACIAIwAjACIAIQAfAB0AGgAXABQAEAAMAAcAAwD+//r/9P/v/+v/5v/i/97/2//Z/9f/1//X/9j/2v/d/+H/5//t//P/+v8BAAgADwAWAB0AIwAoACwALwAwADEAMAAuACoAJgAgABkAEgALAAMA/P/1/+3/5//i/93/2f/V/9T/1P/U/9X/2P/c/+H/5f/q//D/9v/8/wEABQAKAA8AEwAXABoAHQAfACAAIQAgACAAIAAeABsAGQAXABMAEAAMAAgAAwD///z/9//y/+7/6f/l/+H/3v/c/9r/2f/Z/9r/3P/e/+L/5v/s//L/+f///wUADAATABkAHwAkACgAKwAtAC4ALgArACkAJAAfABoAEwAMAAUA/v/4//H/6//l/+D/3P/Z/9f/1v/W/9j/2v/d/+H/5v/q//D/9f/6////AwAJAA0AEQAVABgAGgAcAB0AHgAeAB4AHgAcABoAGQAWABMAEAAMAAgABAAAAPz/+f/0/+//6//o/+T/4P/e/93/3P/c/9z/3f/f/+P/5//s//H/+P/9/wIACQAPABYAHAAgACUAKAAqACsAKwAqACcAIwAfABoAFAANAAYAAAD7//T/7v/o/+P/3//c/9r/2f/Y/9r/2//e/+H/5v/r/+//9P/6//7/AgAHAAsADwATABYAGAAaABsAHAAdABwAHAAbABoAGAAVABMAEAAMAAkABQABAP7/+//3//L/7v/q/+f/5P/h/9//3v/e/97/3//h/+T/5//s//H/9v/8/wEABwANABMAGAAeACEAJAAnACgAKAAoACYAIwAfABoAFAAOAAgAAQD8//f/8P/r/+b/4v/f/93/2//b/9z/3f/g/+P/5v/q/+//9P/5//7/AQAGAAoADQARABQAFgAYABoAGwAbABoAGgAaABgAFwAVABIADwAMAAgABQACAP7//P/4//T/8P/t/+n/5//k/+L/4P/g/+D/4f/j/+X/6P/s//D/9f/7/wAABQAKABAAFQAaAB4AIQAjACUAJgAlACQAIgAeABoAFQAPAAkAAwD+//n/8//u/+n/5f/h/9//3v/d/93/3//h/+P/5//q/+//8//4//z/AAADAAgADAAPABIAFAAWABgAGQAZABoAGQAYABcAFQATABIADwAMAAkABgADAP///f/6//b/8v/v/+v/6P/m/+T/4//i/+P/4//k/+b/6f/s//D/9P/6//7/AgAIAA4AEgAXABsAHgAhACMAIwAjACIAIAAdABkAFQAQAAoABQD///r/9f/w/+v/6P/k/+L/4P/g/+D/4P/i/+T/5//q/+7/8//3//v///8CAAYACgANABAAEgAUABYAFwAYABgAGAAXABYAFAATABEADgAMAAkABgADAAAA/f/7//f/9P/x/+7/6//p/+f/5v/k/+T/5f/m/+f/6f/t//D/9P/5//7/AgAFAAsAEAAUABgAHAAeACAAIQAhACAAHwAcABkAFQAQAAsABgAAAPz/+P/z/+7/6v/n/+T/4v/i/+H/4v/j/+X/6P/r/+7/8v/2//v///8BAAQACAAMAA8AEQATABQAFQAWABYAFgAWABUAEwASABAADgAMAAkABgAEAAAA/v/8//n/9v/z/+//7f/q/+j/5//n/+b/5v/n/+j/6v/t//D/9P/4//3/AQAEAAkADgASABUAGQAcAB4AHgAeAB4AHgAcABgAFAAQAAwABwACAP3/+v/0//D/7f/p/+b/5f/j/+L/4//l/+f/6f/r/+//8v/1//r//v8AAAMABwAKAAwADwARABMAFQAVABUAFQAVABQAEwARAA8ADgAMAAkABgAEAAEA/v/9//r/9//0//H/7//t/+r/6f/o/+j/6P/p/+n/6//u//D/9P/4//v///8DAAcACwAPABMAFgAZABsAHAAdAB0AHAAaABgAFAARAA0ACAADAP//+//3//L/7//s/+n/5v/l/+T/5P/l/+f/6f/r/+//8v/2//n//f8AAAIABQAIAAsADgAQABEAEgATABQAFQAUABMAEgARAA8ADgALAAgABwAEAAEA///+//v/+P/2//P/8P/u/+z/6//q/+n/6f/q/+v/7P/u//D/8//3//v///8BAAUACQANABEAFAAXABkAGwAbABsAGgAYABcAFAARAA0ACQAEAAAA/f/5//T/8f/u/+v/6f/n/+b/5v/m/+j/6v/s/+//8v/1//n//f///wEABAAHAAoADQAPABAAEQASABMAEwATABIAEQAQAA4ADAALAAkABgAFAAIAAAD///z/+f/3//X/8v/x/+7/7f/s/+v/6v/r/+v/7f/v//H/8//2//r//v8AAAQABwALAA8AEgAUABcAGAAZABoAGQAYABYAFAARAA0ACQAFAAEA/v/7//f/8//w/+3/6//p/+j/6P/o/+n/6//t/+//8v/1//j/+////wEAAwAHAAkACwANAA4ADwARABEAEgASABEAEAAPAA4ADAALAAkABwAFAAMAAAD///3/+//4//b/9P/y//D/7//t/+z/7P/t/+z/7f/v//H/9P/2//n//f8AAAIABgAKAAwADwASABUAFgAYABgAGAAXABUAEwARAA0ACgAGAAIA///8//j/9P/x/+//7f/r/+r/6f/p/+v/6//t/+//8v/1//j/+//+/wAAAgAFAAgACgAMAA4ADwAQABAAEAAQABAADwAOAA0ADAAKAAkABwAFAAMAAQD///7//P/6//f/9f/z//L/8P/v/+7/7f/t/+//7//w//L/9P/2//n//P///wEABAAHAAoADQARABMAFQAWABYAFgAWABQAEwAQAA4ACgAHAAMAAAD9//r/9v/z//H/7v/s/+v/6v/q/+v/7P/u//D/8v/1//j/+v/9////AQAEAAYACAAKAAwADgAPAA8AEAAQAA8ADgAOAA0ADAAKAAgABwAFAAIAAQD///7//P/7//n/9//1//P/8f/w/+//7v/u/+//8P/x//L/9P/2//j/+//+/wEAAwAGAAkADAAPABEAEwAUABQAFQAUABMAEgAQAA4ACwAHAAMAAAD+//v/+P/1//L/8P/u/+3/7P/s/+z/7f/u//D/8v/0//f/+v/9////AQADAAUACAAJAAsADQAOAA4ADwAPAA4ADgANAAwACwAKAAgABwAFAAMAAQAAAP7//f/8//n/9//1//T/8//x//D/8P/w//D/8P/x//L/9P/2//j/+//+/wAAAgAFAAgACgANAA8AEQATABMAFAAUABMAEgAQAA4ACwAIAAQAAQD///z/+f/2//T/8f/w/+7/7f/s/+3/7v/v//D/8v/1//f/+v/8//7/AAACAAUABwAJAAoADAAMAA0ADgAOAA0ADAAMAAwACwAKAAgABwAFAAMAAgAAAP///v/8//r/+P/3//X/9P/z//L/8f/x//H/8f/y//T/9P/2//j/+v/9////AQAEAAYACQAMAA4ADwARABIAEgASABIAEQAPAA0ACwAIAAUAAgAAAP3/+//4//X/8v/x//D/7v/u/+7/7v/v//H/8//1//f/+f/8//7/AAABAAMABQAIAAkACgAMAA0ADQAMAA0ADAAMAAsACgAJAAgABwAFAAMAAgAAAP///v/9//v/+v/4//b/9f/0//L/8v/y//L/8v/z//T/9f/2//j/+v/9////AAACAAUABwAKAAwADgAPABAAEQARABEAEAAOAA0ACwAJAAYAAwAAAP7//P/5//f/9P/z//H/8P/w//D/8P/w//L/8//0//b/+f/8//7///8BAAIABQAHAAgACQAKAAsACwAMAAwADAAMAAoACQAJAAgABwAFAAMAAgABAAAA///9//z/+v/5//f/9v/1//T/9P/z//P/8//0//X/9f/2//j/+v/8////AAACAAUABwAJAAoADAAOAA8AEAAQABAADwAOAA0ACwAIAAYAAwAAAP///f/6//j/9v/0//L/8v/x//D/8P/x//L/9P/1//f/+f/7//3///8AAAIABAAGAAcACAAJAAoACwALAAsACgAKAAoACQAIAAcABgAFAAQAAgABAAAA///+//z/+//6//j/9//2//X/9P/0//T/9P/1//X/9v/3//j/+v/8//7///8BAAMABQAIAAkACwAMAA0ADgAPAA4ADgAOAAwACgAIAAYABAABAP///f/7//n/9//1//T/8v/y//H/8f/y//P/9P/2//f/+f/7//3///8AAAEAAwAFAAYACAAJAAkACgALAAoACgAKAAoACAAIAAcABgAFAAMAAgABAAAA///+//7//P/6//n/+P/3//b/9f/0//T/9f/0//X/9//3//j/+v/8//7///8AAAIABAAGAAkACgALAAwADgAOAA4ADgAMAAwACgAIAAcABAACAAAA/v/8//v/+P/2//X/9P/y//L/8//y//P/9P/1//f/+f/7//3//v8AAAEAAgAEAAYABgAIAAkACQAKAAsACgAKAAkACQAIAAcABgAFAAQAAgABAAAA///+//7//f/7//r/+f/4//f/9v/2//b/9f/2//f/9//3//n/+v/8//3///8AAAEABAAFAAcACQAKAAwADAAMAA0ADAAMAAsACgAIAAYABAACAAAA///9//z/+f/3//b/9f/0//T/8//z//T/9f/2//f/+P/6//z//v8AAAAAAgADAAQABgAHAAgACAAJAAkACQAJAAgACAAIAAcABgAFAAQAAwABAAAA//////7//f/8//v/+v/4//j/9//2//b/9v/2//b/9//4//n/+v/8//3///8AAAEAAgAEAAYABwAJAAoACwAMAAwADAAMAAsACQAIAAcABQADAAEAAAD+//z/+v/5//f/9f/0//T/9P/0//T/9f/2//f/+P/6//z//v///wAAAQADAAQABgAHAAcACAAIAAgACAAIAAgACAAHAAYABgAFAAQAAwABAAAA/////////v/9//v/+v/5//j/+P/4//b/9v/3//f/+P/4//n/+v/8//3//v8AAAAAAgAEAAUABwAIAAoACgAKAAsACwAKAAoACgAIAAcABQADAAEAAAD+//3/+//5//j/9//2//X/9P/0//T/9f/2//f/+f/6//z//f///wAAAQACAAMABQAGAAYABwAIAAgACAAIAAgABwAGAAYABQAEAAQAAwABAAEAAAD//////v/9//z/+//6//n/+P/4//j/+P/4//j/+P/5//n/+v/8//3//v///wAAAQADAAQABgAHAAgACQAKAAoACgAKAAoACAAIAAcABQAEAAIAAAD///7//P/6//n/+P/3//b/9v/1//X/9v/2//f/+f/6//v//f/+/wAAAAABAAMABAAFAAYABgAHAAcACAAHAAcABwAGAAYABQAEAAMAAgACAAAAAAD//////v/9//z//P/7//r/+f/4//n/+P/4//j/+f/5//r/+//8//3//v///wAAAQACAAQABQAGAAcACAAJAAkACgAKAAkACQAIAAYABQAEAAIAAAD///7//f/7//r/+f/3//f/9v/2//b/9v/3//j/+f/6//v//f/+////AAABAAIAAwAFAAUABgAGAAYABgAHAAYABgAGAAYABQAEAAQAAgACAAEAAAD//////v/+//3//P/8//r/+v/6//n/+P/5//n/+P/5//r/+v/8//3//v//////AAACAAMABAAGAAcACAAJAAgACQAJAAgACAAIAAcABQAEAAIAAAD//////f/8//v/+f/4//j/9//2//b/9v/3//j/+f/6//z//f/+////AAAAAAIAAwAEAAUABgAHAAYABgAHAAYABgAHAAYABAAEAAMAAgABAAAAAAAAAP///v/+//3//f/8//v/+v/6//r/+f/5//n/+f/6//v/+//8//3//f//////AAABAAIAAwAEAAYABwAIAAgACAAJAAgACAAHAAYABQAEAAIAAQAAAP///v/9//z/+v/5//j/+P/3//f/9//4//j/+v/7//v//P/+////AAAAAAEAAgADAAQABAAFAAYABgAGAAYABgAGAAUABAAEAAQAAgACAAEAAAAAAP/////+//7//f/8//z/+//6//r/+//6//r/+v/7//r/+//8//3//f/+////AAABAAIAAwAEAAUABQAHAAgACAAIAAgACAAHAAYABgAEAAIAAQAAAP///v/9//z/+//6//n/+P/4//j/+P/4//j/+f/6//v//f/9//7///8AAAEAAgADAAQABQAFAAUABgAGAAYABgAFAAQABAAEAAMAAgACAAEAAAAAAP/////+//7//v/8//z//P/7//r/+v/6//r/+//6//r/+//8//z//f////////8AAAEAAwAEAAQABQAGAAYABwAIAAcABwAGAAYABQAEAAMAAQAAAP/////+//3/+//6//n/+P/4//j/+P/4//n/+f/6//v//P/9////AAAAAAAAAQACAAMABAAFAAUABQAGAAYABQAFAAUABAAEAAMAAgACAAEAAAAAAP////////7//v/9//z//P/8//z/+v/6//v/+v/6//v/+//9//3//f////////8AAAAAAgADAAQABAAFAAcABgAGAAYABgAGAAYABQAEAAMAAgABAAAA///+//3//P/8//r/+f/5//j/+P/5//n/+v/6//v//P/9//7///8AAAAAAQACAAMABAAFAAQABAAFAAUABQAEAAQABAAEAAMAAgACAAEAAAAAAAAA//////7//v/9//z//P/8//v/+//6//v/+//7//v/+//8//z//f/+//////8AAAAAAgADAAMABAAGAAYABgAGAAYABgAGAAYABgAEAAMAAgABAAAA//////3//P/8//r/+v/6//n/+P/4//n/+v/6//v//P/9//7///8AAAAAAQACAAIAAwAEAAQABAAEAAUABQAFAAQABAAFAAQAAgADAAIAAAAAAAAA//////7//v////7//P/8//z/+//7//r/+v/6//v/+//8//3//f/+//////8AAAAAAQACAAMABAAEAAUABwAGAAYABgAGAAYABQAEAAMAAgABAAAA//////7//f/8//r/+v/6//n/+f/4//j/+v/6//v//P/9//7//////wAAAAABAAMAAwAEAAQABAAFAAQABAAFAAQABAAEAAMAAgACAAIAAAAAAAAA/////////v/+//7//P/8//z//P/7//r/+v/7//v/+//8//z//f/+//7//////wAAAQACAAIABAAEAAUABgAGAAYABgAHAAYABgAEAAQAAwABAAAA//////7//f/8//v/+v/6//n/+P/5//n/+v/6//r//P/9//7//////wAAAQABAAIAAgAEAAUABQAEAAQABAAEAAQABQAEAAMAAgACAAIAAAAAAAAAAAD//////v/+//7//f/8//z//P/8//z/+//7//v/+//8//z//f/+/////////wAAAAABAAIAAwAEAAQABQAGAAYABgAHAAYABQAEAAQAAwACAAEAAAD//////f/8//z/+//6//r/+f/5//n/+v/7//v/+//8//3//v//////AAABAAIAAgADAAQABAAEAAQABQAEAAQABAAEAAMAAwACAAIAAQAAAAAAAAD//////v/+//7//f/8//z//P/8//v/+//7//z/+//8//z//f/9//7/////////AAABAAIAAwAEAAQABQAGAAYABgAGAAYABgAFAAQAAwACAAEAAAD//////v/9//z/+//6//r/+v/5//n/+v/6//r/+//9//3//v///wAAAAAAAAEAAwADAAQABAAEAAUABAAEAAQABAAEAAQAAwACAAIAAQAAAAAAAAD//////v/+//7//f/8//z//P/8//v/+//7//v//P/8//3//f/9//7/////////AAABAAIAAgAEAAUABAAFAAcABgAGAAYABgAFAAQAAwACAAIAAAAAAP///v/9//z/+//6//r/+v/6//n/+v/6//r/+//8//3//v////////8AAAEAAgACAAMABAAEAAQABQAEAAQABAAEAAQAAgACAAIAAQAAAAAAAAD////////+//7//v/8//z//P/8//z//P/8//z//P/8//3//f/9/////////wAAAAAAAAEAAgADAAQABAAFAAYABgAGAAYABgAEAAQABAACAAEAAQAAAP///v/+//3//P/7//r/+v/6//n/+f/6//r/+//8//3//v////////8AAAEAAgADAAIAAwAEAAQABAAEAAQABAAFAAQAAgACAAIAAgAAAAAAAAD////////+//7//v/9//z//P/8//z//P/7//z//P/8//z//P/9//7//v//////AAAAAAEAAgADAAQABAAFAAYABgAGAAYABQAEAAQABAADAAIAAAD////////+//3//P/8//r/+v/6//r/+v/6//r/+v/7//z//f/+////AAAAAAEAAgACAAIABAAEAAQABAAEAAQABAAEAAQAAwACAAIAAgABAAAAAAD////////+//7//v/9//3//P/8//z//f/8//z//P/8//z//P/9//7//v////////8AAAEAAgACAAMABAAEAAUABgAGAAYABgAFAAQABAADAAIAAQAAAAAA//////3//P/8//v/+v/6//r/+v/7//r/+//8//z//f/+////////////AAAAAAAA////////////////AAAAAAAAAAAAAAAA//8AAAAA////////AAAAAP///////wAAAAAAAAAA/////wAAAAAAAP//AAAAAP////////////8AAAAA////////AAAAAP//AAD/////AAAAAP//AAAAAAAAAAAAAAAAAAD//wAAAAAAAP//AAAAAAAAAAAAAAAA//8AAAAAAAAAAP//AAAAAP//AAAAAP////8AAP////8AAAAAAAAAAAAAAAD//wAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD//wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//8AAAAA//8AAAAA//8AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA',  
  On_mp3:'data:audio/mp3;base64,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=',  
  New_mp3:'data:audio/mp3;base64,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',
  Msg_mp3:'data:audio/mp3;base64,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'
}

function vkSound(sound){
    if (vkbrowser.safari || vkbrowser.chrome) sound+='_mp3';
    var snd='';
    if (vkLocalStoreReady() && vkGetVal('sound_'+sound)) snd=vkGetVal('sound_'+sound);
    if (!snd || snd=='') snd=vkSoundsRes[sound];
    
    var notification = new window.Audio(snd);
    notification.play();
}
 
function vkSideImg(img){
if (img=='vkoptid' || img=='profile') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACeklEQVR4nGJgoBAAAAAA//+iGAEAAAD//2KMq5g6X11OOEGQj4ckje8/fWG4+ejtAgAAAAD//2IRF+BISIvwZODm4mRgYmRkYGAkoPM/A8O///8Zvn77ztA1a00CAAAA//9i+ffvLwM7GxvD379/Gf4xEtINNeP/fwY2VlaGf//+MgAAAAD//2L59+8fw99//xgYGBgYDpy5haLQ0VSdYf/pmxgGOJioMTAwMDD8+/ePAQAAAP//Yvn79x/Dn7//GP79+8/w7tNXFIW/fv9hsDZQxjDg95+/DIyMjAx///5jAAAAAP//Yvn37y/Dnz9/Gf78/cfw/iOqAT9//WFYufM0nB/ubgpnszAzMfz795cBAAAA//+Cu+DHr98YLvjx6zeDv6MBCh8GONhYGf7+/ccAAAAA//9i+fv7F8Ov338Yvn3/yRDhboJiwPcfPzGcz8DAwPD/PwMDEyMjw9/fvxgAAAAA//9czjEOgDAMBMHFshQh/v/UCPsMDl0K6mnGS0FKSOI6B4cZq5t5J8/bu/u3dKMUfAAAAP//Yvn9+yfDr5+/GJiZGBkuXb3OcOnGg896Ggq8airKDB8+fWNgYGBgEBbgxZD79fMXw+/fPxkAAAAA//9UybENwCAMBMAXA2RMVmCDTBdRICrEFKGz3w81116iGxjE3kLtY70lP1+bvxSgG+h2Xe1jSQEGQTccAAAA//9i+f3zJwMzwz8GFhY2BkNNJd7A5LIPxtoKfOysLAwyEiJwfxtqKvEGJ5d+NNRU4uVgY2X4/esnw++fPxkAAAAA//9i9EqqXsX6820o1tAiAH6zC68GAAAA//8iRx8KAAAAAP//AwBF+P2MaQwKSwAAAABJRU5ErkJggk==";
if (img=='friends') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAADDklEQVQ4y2WQW2yTZRjHf9+hhx38OqDtqlQjonRFk6FSs0yNXJjaQGoICYlIuDC7gMxE44XRofeLXogXaoxXRi4MMTrZYtIhkZmRLtBOhSAHswNbobRjuB5cv379Dq8XS2cdz9Xz/vN7f8/7vAAkk0kBwA8jp9caAGnoo69Eodz4hSZz9dp1ASAB6skfz5nLlTqLt26v8bFYbETTtN51QalcFsc/+HDNmBg80T3x66Q4f2FaAKi7I6HCn3mDldISe19/sy41r8VisZFQKLS/eR4bG5MA5GaQy+W+PnpskEOHjxAMBv97MMCpnybFQ6EAhTu3KZcryK42urYE+Hb07KikKEr4+fiBOb8/4GrI7di2zfaHg0xnpuCBrUPrKk3TepPJpIjFYiO0lNJs4vF4AaCzs7PH5/Ptyufzp1pBhoeHRbG4JM78fFas/2/rFgsLi5xPp7Esm0wms/9/I944/tnokYOvRvRaFZ/Px6Ztz7zWvv2lL2cy46vy4Xc/PXn00N7kSrVGtSEzX6yws2cHB/dECwCqo5denvrjL7xuF6blpl436DDuMX35OoCq5u4sf7L03Tcf74g+Ra5wD8Mw8HfIzM7MWIqihCU2lKZpvf39/RMul6urNTdNs5ROp/dUKpVLrfl9gkQiseJyuboGBgaIRCKUyxWy2Szj4ylM0yylUqlNrby8UaDr+s333h8iEumhbjRY1XW2+APEX0mg6/rNjbyyMYgmjk3/fmHyObNe8yuKIiuKQqFYtCamsnOie9dbM7+dm79vhcTgie7Hg97sC8/uDLtkiyce3Uq714Pt2CDA7XFTrq5y5cY8tuzl4qUbt2aX6rtTX7xTVAHCGldf7Ht6s6yoSLLMbFEHdIQQmJaNbdsYDRPd8lCr1Yg8Fg7fzacXAK+qqmp0cfaa/v3fBdq6HmRzm40/9Ailyj84joNt25iWRWebB6de5spcEaN6l4ZeW1FVNSoBKIqyre/A20869co+26j2SY4ZQpKF01gNCCGQPR3LOAJkpah4fVOSu+PMxdOfX7Ysa/5fWIFXrL1OjloAAAAASUVORK5CYIJ=";
if (img=='photos') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACKElEQVR4nGJgoBAAAAAA//+iGAEAAAD//2JkYGBgSK+bcZWZmUmLVM1///67BgAAAP//YmFgYGBQlBTSKkoOJNn2tukrtQAAAAD//2KBueM/AwPDgTM3idZsb6LO8O/fPwYAAAAA//9iYWBgYPj1+zfD33//GawNVBj+o6v8/x8r99/ffwz//v1jAAAAAP//YmFgYGD4/fs3w99//xjmrj9CtAuSA6wZ/v39xwAAAAD//4IY8OsPw9+//xjeffzKkBvhhLCN4T/DlBX7GXIiHFFsn7pyP8MfqAsAAAAA//9Uz7ENACAMA8Hff9hIkVIFO1DQwASnu4Vulkxk0dInRRa9zH4qkYU8eMwBAAD//2JhYGBg+Pn7N8Pv338Y3nz4wlDcuwrDuSV9mGK/f/9h+Pf3LwMAAAD//zzOsQ1AQAAAwCusyQYSLQtQswHroUCQ/H+ouAkug2PfhJjMy2poiu8PynbU1/nff1B1kxCT+zq9AAAA//9Ez7kNADAIALErsv+y4ZMgkJLWnQ+A6aWqCBMqtzAMYUJmrg2ECd0Pd+UDAAD//2JhYGBg+P71C8O/f/8Yfv/4ypBS2Y/h3LSqiRhiHOysDN+/fWUAAAAA//9iYWBgYPjx/SsDBzsLw7ppNQwMDAwMTEyMDIyMSJiBgYERSkAoiPjP718ZAAAAAP//YmRgYGCw9Ut4+ffnFzEMawgAZnaeVwAAAAD//yJVDwYAAAAA//8DAE2dyNgzG1cDAAAAAElFTkSuQmCC";
if (img=='video') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACuklEQVR4nGJkYGBgiCyZMF9SgD2BjZWVgRjw6/dvhucffi5Y3lOQCAAAAP//YnHN6OMX52NN4BMSY/j5B6LAzVKb4f2nbxgaT1+9z8DAwMDAx8vA8O/fiwQGBoZEAAAAAP//ZMqxDYBADAQwcyuyB2uw8BcR+UgUlBTuHEhi1biv8+g9oJ7+6f2dVSMJeAEAAP//YmRgYGDIb5z6n4FTCG6Tj50+w79//xh+//nL8Ov3X4Y/f/8x/P7zh+HUlfsI53x/xzCxPpsRAAAA//9iYWBgYPj39w/Dnz9/GaZXxTBmti35v27fOZz+h6lh+QvxLwAAAP//YmFgYGD4++8fw+/ffxlSGhf+//37L0NWmAPDn7//MDTPWnsIrobxH0QeAAAA//9iYmBgYPj75w/D7z9/GebUxzP+/vOX4d///ww/f/3BwMhq/v6BuAAAAAD//2TRsREAEBBE0T9DkyrRik6xe+aEAvnLXgWwjFK0PlISEYe59t+nZ4oNwAUAAP//YoFI/GT48fc7w4/fDO4crAw7//3DbsCPHwg1zH8h8gAAAAD//0TQuwkAIBAE0RERDAT7L8XObs9vcIH58IIJQIaySDAkcJ/0VvEZc/e5+FpIvynbAHgAAAD//2JhYGBg+PnrJ8NPxh8Mexc0MDonNPyfuXIX1hj4+QOhhvU/xAUAAAAA//+CuuAnww+G7wzWEeX/f/z4zpARHsIAS1DIoH7SMrgaNgaIAQAAAAD//2KCBOJPhj+/fzEcXdHJ+Of3L4a/f/8wfP/+HQMjq/n9C2IAAAAA//+CxMKf3wxMDF8ZTPxz/v/985vh37//DD9+/sJwwd8/vxlM/HP+M/3+yvCbARILAAAAAP//YmFgYGBg5BJbwfThaQQ7zKnNnVjDgB2JzSggvYKBgYEBAAAA//+iGAEAAAD//wMAWN5cTBRgKpQAAAAASUVORK5CYIJ=";
if (img=='audio') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACh0lEQVQ4y4WPTUhUYRSG3+/O373jHX9GUxP/kBIzs5JIAzcxEBSR0S4DQRKhQEWNUCkhSzc1hGGhWJugNumuIM2NC0sqoiBHJofKFHWsGWWc8bu/87VpZryi9C7Pec7DeYEd09g9+MHU2OlmkqKGCAC03HrIjh8pxfSnGYkDgPJDB3Gp5iTJyUzjSeyuprnftS/bPmECgLef59hG0F9HJQkcADwbfYXb7fWEShLIxZbeBQvTcoMbmz6JUinuqO8amM5MESoL83KQ5kyHXbBicuo9zDFAMOmViiLjSu1pAgD1Hf2zggUlXAyQKEU4HAEA1LX10WOHS0v++JdAAKCm4Ya3rLS42DvzRR554ubxv9ReH7jf3jdMASR+aL0zRDOcyXxBfh4sFhtsZgL3ViDDmcpXHT0Ar+8nvs4tBO1JgtNgCK6H4DpRHq/d1DPIACDRQlYMf8iyCoNB+jcAgMcjb9iyP5gAhp6/ZMGIHgeW5n9AojQBsKgGK5PjQHd7Y/wXgl1yrrnfJdpMZ0XBVO3gzWV23sqLYhKSk0UINh4zXh/udjQQ8/bD1juDLMOZhsKCfBCOg523ws5bIQpWsKiO5dUAfq+FoGmasWQsqqoivEnh8Xiwuh5ZpCr7GFHYBFXYyOtHrf7LnQ9mHSJfoqnqzgJN0xDZlABdwXBvc972va7rkGUVTNd2FzCigERVw/x8072bWQ6uK9Vh5wMhCo2GjYIzV92uPTb5haaqiMIEohsFuY5oT9H+Ynxf9KMofy/eTfmMglQuNFFRUYVfK0EoigJlbdEg+Bbgsr3zk6NRleZ4iGWFSym4YBAEFOHU2PjY03TRlh1YC22oQlbbVsH40DU/gOrtlf8CCPsPoKw6eH0AAAAASUVORK5CYIJ=";
if (img=='mail') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAACwklEQVR4nGJgoBAAAAAA//+iGAEAAAD//2LMb57xnZeLg+Pb9x8ka/77n+EHAAAA//9i+fPzO4eDixXD778MDH/+/oNL/v//HyubgYGBgY2VhYGNmYFh3da9HAAAAAD//2L5++8vw8lLdxj01eQY/jEwMXz/8Qunxv8MDAxcHGwMTP//MJy4+IDh77+/DAAAAAD//1TDMQqAMBBFwYcBkxXvfwc7K6u0gifa5G8wWDswy1BgJXPWh8TLZivehXfRFL+7ZRKT47qZwFDwAQAA//9Uw0kKgDAQRcFHEweCxvufQNybvXgpJf07uLagTHIigq0UjnrT1VjzzPO23yVP0J39vLA0MCZDcj4AAAD//zzOMQ6AIAAEwQURrGgoeL+JtaE3Poy7RO2cF0y0J5KwTS4bx7gJr+mt/pPeKik87OdFXFZKTkjGnnwAAAD//wTBMQqAMBBFwUdWPEKqdLk/CBYWVoJHWiLJTxZnkjQZQ3j7iAhs2znvl6VOLZlaMkud43oIDEsJ98aQkCY/AAAA//8kzsEJgDAMQNGPglJEL3py+g7QAbpWQ5pCmoMH3wRvmeH4DLQbTYT7SrDu5FIxU4Z1cqls6eB9TkQEtfEPwvkAAAD//wTBwQpAQBRA0as0ZHpFbFj4dWsf4INsbCyGEr1pPM7JLRmqyhEC49DxfhmPRpwrmOYFgMoL53VTi6eRknXbiX2LJeMHAAD//zTSQQqAIBBA0T9kuwhbCHb/y0UQLRIb0dFWvTM8163x5kQMnmrCeV//MSY3MwYggmrh0IJfF/awkdNDt8YHAAD//2L59/8fg6SoIAMXFxfD63efGCRE+AmmQAE+boY/v38xPL5/kwEAAAD//2L58e3Lr/17trORlIahgImJ7RcAAAD//2JkZGRkZ2BgYCLHAAYGhj8AAAAA//8iUx8CAAAAAP//AwC1JxFGOQmoBwAAAABJRU5ErkJggk==";
if (img=='notes') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACDklEQVQ4y4WST0gUYRjGf9/ORJsEHbxEeOhohwRh61BetqKDpyLFQ7eCoHu5BkbdMomEDp1SEMLF9FQUgUH/jgaLh0AoSqTIdXd2bGZ2Z3T3m7fD5rdOrfXA8M68/Ob5Hp4Z2KkNvybmwRIRKcedtxWAiAjAtTuPSG0jZdfj66dl/tbNiWkREamGmwJg+17AzyA0gL268oV6vW4W6rd7mEqp9E6rINLLD29dOWIDWCnSY8OXCMJNA4zem+oGsAEcxwFgc6tlXQ18DPD5Y4Ge0xcTaTv3xa0MALNz86aIocEBs1cAw3cnpfBq1rzde2aI8dxlZY7InjxO+H3JAPsPdCbbmV/4IH4tEr8WiVcNZWTiiTnOBihWfLRuhhIRSq5HAlgruzS0NkCx7CaBKPCQOG616JZagFIqXfqxyqmBq61lSlBKpUUkop1yIzek3fynRu9Py9zCojx7U5BMJiPP3y8157vmnFtYlAePX8r1scmEmb19IxLTkd5Lf99Rarkc2Uw3QS5H9lhz9vf1MD71gkajQVuDKNqivBE0S/AD8vkZAPL5GZRSaB3jegHSqCcMzE8ehhFFp9m//HHpOKahY0quR72+S4IN16FSqQAQ7/gk29Ja45TWUR2yi0F5nYOHugA4d/4CSBIUial6DnYtmUBZlnXYsqyu3hNnX0Ns8z/t6VgrvH06qLX+prVe+QX8+BlLEqiqdgAAAC56VFh0Y3JlYXRlLWRhdGUAAHjaMzIwNNA1MNE1MgwxNLMyMLIyNNY1MLcyMAAAQP4FCAiQEGAAAAAuelRYdG1vZGlmeS1kYXRlAAB42jMyMDTQNTDRNTIMMTSzMjCyMjTWNTC3MjAAAED+BQhqqOefAAAAAElFTkSuQmCC";
if (img=='groups') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAABNElEQVQ4y2NgQAZtbW1n4BxGFB4DAwODf8Hk/wwMDAwsDAwMDBmVvf+NDdUZJDh7/zNgBY0TF/3PrOpHaGH9+uSsLA9UNr0SoS+jsvc/I7LW3OZZjzlYmWV+/P77ZHJtmizcCBi4eeUii44cH8PNR59YGHCB6OjoMwy0A6Udc/+XdsxF8T2KY1zszBkYGf8zdONS0Nvbh2EqI0ZEIIGqqioTnF5DEZu9atd/WDBnQIMaJkZ7wIhLonP6iv+2lsZQRf8ZVm7exzChNgNDPc5IffXyOcOZy7cZXrz5wCApws/w/OlD8pw4a9YsvImDCZlTUFCAofjatWsYmpDVwf2U3TjzMScbs8z3X3+fTK1Pl8UnJvj/rcx7RuEnU+vTZeFhcPfWNRaGX18ZGNi4iRR7iTtTkAIAOFiGjzdq3lcAAAAuelRYdGNyZWF0ZS1kYXRlAAB42jMyMDTQNTDRNTIMMTSzMjCyMrXQNTC3MjAAAEFBBRGIhD+aAAAALnpUWHRtb2RpZnktZGF0ZQAAeNozMjA00DUw0TUyDDE0szIwsjK10DUwtzIwAABBQQUR6rzIZQAAAABJRU5ErkJggk==";
if (img=='events') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAADj0lEQVQ4yzWQW0wcZQCFv5nZy8wCy1IXSqFludXQUkhpEcRAa0II1MRIfDA+WEmM2niJiS+aGk188RaEphG1Ihib2niJGBuoiW0aS2NSAUm1Ecr9Il3KZWF32WFnd2Z3fx8q5+mcl5NzPgB+vjQgFABd19+VLlz8VgDIDptMwowDwOj4ghBCiNHxBWED+L7/Ggt3PAzNhJDqGxraXC6Xx+VK8/y7uPgXb7X3hFcCYbESCIvT7T1hubrqsFu1wdun36D2aJVb0VPa676CArXySA1d3efDEsDA5V/E6Gxg65Hqw+68nCyW14LcHL29VfKA4gag78pNMbmwIlKplHj+hVPCsiwxNrMkLl0buT9rYzPI9JxMtttJZ0c78bjJvbVNVtfXkQCaWp81D5SV2j2eLPLz8/H7/YRCQf6+PX7/aeeZs/OdZ87O87/OdfcEd7L0/gcfBd27vAlnZp63puogAMO3xrEiK4Gl+RndFoub6tHyI6qquah8sACAkB7D2M7xTkxMJuW7cfdCaDtBQ9V+hBAkk0nqKooIGyl0x56gbJeSZSNj82xvbxMMhnjmZBv9/ZcZGZvHLiXL5M1gZEpKmpimiaIofNl9jpaWZqSkyWYwMiWHU2nHfF6N197rJS3NhaZpvPhOF75slXAq7ZgE8MWFn8TQ0DC1tTUA7PhTJ5+UJIDah+vaXnr5la+bmxqJGrHY1RvDK8sbEdWwyC3bbWdi1UKzs5KpKbHG+upcj9utXh+8QWfHx60SQNdnn4vMXdmBfxY2MloerXPu2e3FSqQw4tYOWzSnHbtNxn9vnSuDf8TL9mVG5qYnvTLA8Kz+Qzhu97aeaHRGYimK8rM5VJrPQ+WFbPinqT7oo7wkj8I8L3o8xRMnGp0GLu+cnn5eBkjT7E8VFhbw25+TPFZ/CFkCy7IwTZPenl4Mw0DXt4kZBvWVPq6PTlLk8+HWlDYbQMyIEtGjTM0vEwhsIIQAQJLg065PiEYNZFlGliUURWFiZpGi3ExiRhQFYG/Fca9iRWoO7PdxceB3GusqcWeko2kqqqqiqk4cDidxK8mbHd9QU1HM7NQkc6v6h9IOpKanX51tPl5b7M70ABITc0ss+tcwTQuHw44vP4ey4n2AYCsc4tfBobmr33WV2HYKoluhjB/7+lAc6euOrL1fJfTA4wkjVCpSCYck28y1Zc/MrTuL/Wbw7nNJU89WHOkZAP8BY5CdFhOfc74AAAAASUVORK5CYIJ=";
if (img=='news' || img=='newsfeed') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACbElEQVQ4y42STUhUURTH/2/mzYwfzaDlB/mBkYlQ2SIwWrQoiBB31a5aGX0gCEHaolq0iDRBbRuDK9u5LKRFi4KgoFWIYAh+jKbjc96bd+d933vH02KclwMK/uF/4RzOPffe37nAnpTHL955dU3tVQgz61mDVjd1KABguT59/fUHAKDeGnhKy2tb2MnlcKAUAPj47TcBwNXebkQn0rO0uJ7Hha42VMVjULs6O1Cft7C0kkGqWi3t6xucanZ9TlxIEnvmQpLrc1LKzXOmRdu6VXFg84kk1Psjb+nlkwHsGBYWV7YqCiIKED3e2PJK13VcutiDloZU6NbGFOY+f8HRNDI2TQEX4QWFkBRwQSNj06QCQFFKcFlEmVcZQlFKqAAgpITnc5xuawwLXI9DSInIRHqWpJRgtoeZTz+QiKswmIOC40FKicjdmzfAAx8Gc9B77hR004ZmFGAwBzzwoWY2NeR1DbZtgzETjJkAgLraGPK6BvXN+CSGhx6grbUJne1NFWMrOGI+RN03ONV8vj25Wp+srYpGo1Aiyr7Ssqi07u6iWNxF3nL8Cl7Do2lyvYBcn5MfiEPt+pxcL6Dh0TSp+xsIUeJJRJj7Pn/oYPqv9EBRFAixx7ksKSX8QEDIIjJZI8zf67+MD3M/w9h2A8TUaAnzo+eTZDkeWY5HUgo4PodpuchkjdAHxY7PIaWAajGGbZ3BLLiwGIPtuMjlLSyvrP9nMz5T8QRNN9FQn4TFGFSma1hYXMLfbA4dJ+tQk1CRqonj9dDtQxkk4jFUJ6Jgugbl2p1n74Pc8sOz3WeO+LeBtY0NcOXYQqzh9PV/LEuG35HNsX8AAAAuelRYdGNyZWF0ZS1kYXRlAAB42jMyMDTQNTDRNTIMMTSzMjCyMjTUNTC3MjAAAEDwBQYJjY7yAAAALnpUWHRtb2RpZnktZGF0ZQAAeNozMjA00DUw0TUyDDE0szIwsjI01DUwtzIwAABA8AUGa7V5DQAAAABJRU5ErkJggk==";
if (img=='fave') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACSElEQVQ4y42QXUhTcRiHn3M8060tP5pNk0qlgqkViYRJCFL0cdlFddldhXbTRQlBkBFdCEE3kRVIN11EN95ag8y+ZmoQw+kmprMpbTR17HzsODdPF3IOm5H4XL28PP/f/31fALp7+w0RYH52BqHr/oup2bjaIVVVV3vXM7MxAeD121Hjq/8bYpENCeDT8Eemp4L4Bl4KmCndvf0GgAjgLHPjn5jHaoz9mKRp/y4szlzujJm1YBZDo5NGbEkmEpljZDzAoYP1PLpzVZBMYXIuxnggjKAn0WyV6PoqAJYQW0pRV+Pmuz+I79UTwccmTl+5ewvg5LlLRn5fADjf9bjqaG2pNZii50JP711rsNY4vM8Va205xtmONsbGRnFJWa8piwCZVZ2JmSiJpIKasyPay6wvJABFVpDXflNZUUrJjlJsDmehoCopVNUgkVRoqnPzZzFSKKRVmeNtzWRz6zx7eFPI30LcEFQ+Dw/FlxdmNm+/IWiagu9NX3VoIXl7s1AQ19nzfKqlsd57pOEAhrFxr2D4J9PTYTKraxTbHaQyRaG+nusNBTOaOCS8Ho8Hf2AOURSor3ETDEd4/yWAc2c5bc1eHLacN/9NQYCqKSSSCvOLcQBcjhJUTcFZvhu7q4ISVwXycpz/BmhyikRSIRJdBGCPx40mpzjV3mo52Wx2iwBFRtZ0avfWACBrOpoi86DrQsGt/rmySVpTkQSDlWiIlWgISTBIaypbUTBBWpX5MDiQkTyNJwB+DQ6MkMsWs13aL954t51ePn8Bgenyiyla98gAAAAldEVYdGNyZWF0ZS1kYXRlADIwMTAtMDQtMjFUMTY6MDM6MjItMDc6MDDClwDmAAAAJXRFWHRtb2RpZnktZGF0ZQAyMDEwLTA0LTIxVDE2OjAzOjIyLTA3OjAwnSZ20gAAAABJRU5ErkJggk==";
if (img=='gifts') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQEAYAAAE4ZBO0AAAABmJLR0T///////8JWPfcAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAADs0lEQVRIx6VUS2gTURQ9b+ZNZiZk2kGLNMFihNjWVlFJLQoiKKILIY1FdKmgUXBV7EZFxE1TrKi4cCPiVtCVoiIapIvGD3VRY3VaS7WalmLDJJ1MmqZpZ8ZFiIn5GMWzmXnv3XPfuZ93gVL4fKdOXb48PHzv3v37jx5ZVpkB6e4OBM6fL5yQkycvXLh5Mxp1uRoaJGnt2jJG/sfvP3MmGKzgsxbIpUvXr9+9W51JR0cVZWICyGQWFnQd4HlBsNsBQliWZQFmwwaPx+MBbDZZdrkAyxIEWQZsNmBlpUhkHn19/f0DA5bl93d1+XzlV7a3t7W1tpJfPHLs2NmzwaBlbdq0ZYvXCywtZbPLy4Cua1oiAdhsLEsIQKkoOhwAy7IspUBTU2PjqlVFCm7ffvAgFLKsxcVs1jRrZ2diQlFGRwGa33j37s2bcBgwTYBhajv49m1ycnz8n6tSoU6lGx8/fvo0NlZet6GhcDgcBk6fDgROnChK4sWLV6/euWNZDMOyfyM9j0QimUynMxnG7Xa7168HbDZJWrOm8DUMgOOATMYwKK10vry8tCQI9OnT589DofIbDh7cvbujA3j2bHDw9WvAMBiG4363Ydl4nAoCz/M80Nm5Y8fOnQAhhBACpFI5o1279u7dv79AcjobGmQZOHLkwIHOztWr6fy8qs7NAS9fDg0NDwMMwzB/ykVbm8fT1FRY00QiFpudBdrbXS6nM7dpGNUdzM3NzExN5ZUKAkENHDrU3X348I0bPl9Xl9/f08NxHEdpLRYQibx/H4mMjAwMXLkSDG7bVs2upquWltbWjRt7eurqJMnhAMbGxsc/fwZ0Xdd1vdx++/aODq8XqK+XZVneurWWfxIInDt37ZplHT3q8+3bBwiCKNrt1QmmaZqmCRiGYayslDgjAMdxXGm3VMLDh0+evHgB0FQqF8ng4Nu3kQjAspTyfHWirmtaPA7s2eP1bt4MiKIgCALw6tWHD4oCZLOmSUhu6vxJSCymqvF40VM+fry3t7/fspqb161zOguR5Jq6gIWFVErXyzOQb3+HQ5Lq6nLr4m6ur3c4RBEYGVGUr1+BW7f6+np7CfnVA8nk/Hw8DrBsS0tzMzA9raq6DjBMqQRAFCvFlJs/yaSm5cdp8VjleUmy24F0Op3Ov1GgqAk1TVVjMeD792g0GgUU5cuX2dlCZP+LxcVUStMAVY3FfvwoEpB7+I2NmpZMatrUVDgcCj1+7Hb//5W/Q1UnJ3OlopTSdJpSSin1eH4CYgh1iH29mdIAAAAuelRYdGNyZWF0ZS1kYXRlAAB42jMyMDTQNTDXNbAMMTCyMjGxMjLWNTC3MjAAAEGbBRO8H/ILAAAALnpUWHRtb2RpZnktZGF0ZQAAeNozMjA00DUw1zWwDDEwsjIxsTIy1jUwtzIwAABBmwUT3icF9AAAAABJRU5ErkJggg==";
if (img=='settings') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAADL0lEQVQ4y4WQS2hcZQCFv//eO7mZpp3pxHQySU0kNLFajKRChUaUdKxYaCnWIvggtYIPfGCroAYtupBgtUUDggs3LfiI4ErQVgWJ9RGwBG0TbZM+UmMSJzOZzJ0kcx9zH//vwqgLF/22h3PgfLCC2PdcvwqCkP/Y3tunrkxNK/HEy2+r/ucf5tOhMYpWBbGr91k1W7SpSzUio4j/83jfEfXH9Kza9eir6sixE0qrSTYx8Ml3HD98gPJyBePcxCWiMOTOB7/iju4tiN4XBr7Z3Lkxa5ommtBQKKJIUg1CSoVZtBrhZ38a/oENKUWjaVNedvji6yFKizarkmmMpXIJPbGe19//jNa2DqYvjHLo6fup2C4/jhcR23tf/HzDtemdWiwOgFIKAQgVMvP7Ra6KeOXoMZVubiFm6CsLEEYRftXj518vHdfWZZrZ23MT923r5OJvvwDQmrmGvOWSMOV+I4jgzNlRdE1Qshaxlh1Sa+L4QUAQBGhV3+fUeYucY5Jafz37dmzmri3tnDtzGte2MRzbIVco0piqI1cocnZ0FEPXKS0ssNrUMDy3Qm5unpZ0kj/nChz+YI7uro2Ya5tw3UXEnv0HVfN17UglVl5IUBD5FSZnrUGx46l3GtOrtY+Tq4zs1a3wj0yv7EZffvjWgT3iyUMDqr2jAz9QzBdy1Bg6uiZACOobMmi6TiQlUir8MMLzfGIxnVoDrlye9LQwDFHCYHxshEd2d3NPz83svG0T927rYmJsBE0T6JrGqe+HubEtQ03MYNn2iNCJZFhrhGFIGEpq12Z4471BxicukL39VmbyFg2ZFnKFElYxj1WcY2J8gsmpOYx4grraGFXXxfBcB8/zCKROsqmdNSWXthu6WGQKTyomR4Z5s+8x7N1bkVHE3Vs38cxr71Lfk8WxbQzXcbBtm/kFC00TuI7DQqlMLj+PlBInitF7sJ/lcpFbujo5f3mGeKIBx3ZwHRvDc72qV7HMGl1RWLAw4glOfnsaUP9aj6eaqU01M11WJNOtrKtPoqpLVH1/UQBkH3rpI1nJ71VSmiiJAsRKWaJWthQo9XdmmEtGXcOJocGjD/wFYNaRFqwDACkAAAAASUVORK5CYIJ=";
/* --- */ 
if (img=='matches') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACb0lEQVQ4y5VSW0iTYRh+vn//1j9deCiRpYGU2Im8MArpgCwNK9dFWNZNF50sWmJTgjIa1IWkhr/ZASpGdvImyTwkYmaJYpaxtKMHZjPxsMUs5+b/u83/60LURbPyuXvf532fl4f3AXyhzy+ls9WujMJ9AECmG2fyjFSY8Ihkx/GCJKdr7NliJTGV37qwDnOiydRDAYA5lsMLlQ1tlL9bZQAAaA/n0C0HDDP3iL/17Nzbwt6dCdyjmkbxNyL9XHF/TfMHaigsmVU4dLpA0CRs5hw/7Oi1ueC0D+BmbtaMsqyj9bnxuztwsKu9NXnY0omhUW+qzdweTghhAUiYN/ZkXdU9rHhBy2qbp3z6kqn6K7qM/ZprIAzuPX2b9IfNO2V11O6S0P6p68mD/MzdAMBqdXxiRBCqAcDhZtBv6cE0CQBscnx0vVIVjCClHOUvO+ARhBJfVbaxqUW0CnIOAEIUXlQacw/6Dsi6O1orli1dclQm2GXucYdnsK+7iWGYYEIISyl1+P2FP2w/wYdHhHKlIYHyjQxDOEmi4uWzR5TsvxbTsovPR6sXXkzRxEOlCkS3uQ8tpi+i2SZo50wDAKTo+LUx6oA32q3x3CRh0WMZgMXSB7N1/OTjoszrf41Tmr6IXxMVemrThji0ff4Gt+DA8LBV/DoiRdXe0Ft9Z4lWV5ioVtHquNiVHAC8+9iJmKhIhKkj8ep9LxR0Aq6x0RFjfvYif8fYIJmzesXyVVyDqReSRKFZHwvP5CTK6l5DQbwIICJsHtXquawSAEhOz9umEIeqhAnvgp/CVEIZAoQFSHDLQ/j6+5cMlFLn/35sXvgFSTH+GdQ2EcUAAAAldEVYdGNyZWF0ZS1kYXRlADIwMTAtMDQtMjFUMTY6MDE6MDQtMDc6MDDnl+KcAAAAJXRFWHRtb2RpZnktZGF0ZQAyMDEwLTA0LTIxVDE2OjAxOjA0LTA3OjAwuCaUqAAAAABJRU5ErkJggk==";
if (img=='opinions') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAAC5klEQVQ4y4WRXYiUdRTGf//X19lxcnRnRltddxfZlJbNUMQ7+4A+QJJQ6CpyYQtaL5QKEbwKgwjBuzAk8mK96yIIgyCiz7vSimxh29103dl0dtaZd75n5+v9/8/pYkaDpHpunnMOD5znOQeA0+cuqZl44x1teXHM6XOXFMAPaiG5fAFz8uwFHRsdotUJ6U9txwA8c2RCH3l0nPmZXzFvvvtRYb1vkgB3y+3L5rPvr+vSrUXanZDhkZ34n397jUazxVqjQb68hndr9qdqZv4aqRj8cn32E3Py7MXC66+8mASw1hE6wVqHKmRWc/jWtpPfXJ0je+dPrLOE1mGtI57YwrbUZvzsSqYcVNv9d1bzqHOoKqqCyjwHxnfyAJ586cSnx6beUmNMH4CZOPPB9EB/3+Q/haHV4vtvT6X8Q0/sndw3PkondN39zmGtACRVLjb99X0b+GM5x+3lJazrikSU1MAgIi7ql6prVOtNVrMBtpcgtCH5uqNeKeHngiLpTI5Op0NoLWFou/Xdm8S0gl/IrTC3kMY514snqDq2b01Qr9Y76+JDj4/5zdU9vqsxmIyRSCRoFZdprdVq3125/NADdzj4/FE98NQLeq83x85cmN41mJjcNTrCjoEUgve3Wu+RogqqioeSL1W4sZhmcaV0xU/GvMn9ex8juXkjTgREEVGcCKLdWkR6M0VViUSi7NszRlD88ahvraVca1KoNBBVXjtykP/C+ekvcCJsTcRpNRv4nXaboFQlKNdwTvg/zN1MI87RGX6YWrmEX6sUCYKA3xczOHEcPv5e17JzOBGcc0iPVRXtRdvUp9SrZfxKZ93H6YWZlwe3DKAmiuj9y9Fqt8nmigSVMuO7R4hGIhijGAlZWVqgodEvzb9ZfW7q/LZmdvbqxogZ2TE0jHgR5mZ+ZtPup/u/+vBU5f4be+wZY3zAN8ZEgYjneXFjTMwYs2H/oVcP2/LtU8Zgfvvh62dFpCAiORGp/QXcJr2HRs0cNwAAACV0RVh0Y3JlYXRlLWRhdGUAMjAxMC0wNC0yMVQxNjowMToxMS0wNzowMHkFzaUAAAAldEVYdG1vZGlmeS1kYXRlADIwMTAtMDQtMjFUMTY6MDE6MTEtMDc6MDAmtLuRAAAAAElFTkSuQmCC";
if (img=='apps') return "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAAB6klEQVQ4y6WSPYgTURDHf7P7Nh8GG3M5LU7xBHsFFbHwsFAUBIvrLK6xEUEs/KjsBNFSS4+rBC0FsVMbUbhO4cAUfhTKIVwu2WySS7L7dncsNtmoENBzmmHm8Wbm/5uBsV25/UDXN3zNE/Kj0dYkVeT63WXdt38eR4RUFS4sXdNGK9Cm39F2pzf5k/99+OS1IllwcO8sslb/pNWZGqrKuw+fMcYBzxWM69Jp+8jVO4++lwvuHFPMSBrPXVo8TZIkqCqqoGTN69/amG7Qprc1oDpTQ4E0TRERVCGyDeTU4uWvadiZZ7smt+6v6LTHNNWhOXH0EF/Wm3iui4wAKBDHCWGvVTKtoMe5YwdQzQqNVZQLHo+fv8EMQsuuakZKIZe6s1IitjFmGIYMwwjN+2Yyk8SjP+hj+t2ASrmQTSyCI4I4mQ/8TWTh/MWpKkRMtG0+eZGb91b05PHDFAsenjE4juQ4ZHwYjPFkAtNUiWzM+7U6Jo4t3X7Is5erDIZ/P9HZhSNEUYSx1tLrD7mxdIba7G745VpG6PN47Co7irxa/Yi1NisQ2YTQxoRRnC+M0U4m409ypaLHILTE1mKC1ia9boC1exiG4WiRv4P/IyQuFxj0twjaLYzf3KAb+Dx98faf6DuuQ+C3/nuL/ASi9wxssguIpgAAAABJRU5ErkJggk==";
if (img=='questions') return "data:image/png;base64,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";
if (img=='market') return "data:image/gif;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAFo9M/3AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAABIAAAASABGyWs+AAAACXZwQWcAAAAQAAAAEABcxq3DAAACaElEQVQ4y5WSXUiTURjHf++7d28bNt1Sm6Ur3RpZlEYkdFFRaGj0gRcVjQTpplCaYd0IRVR6IVpIJEoGFXTRB5EXahmCfRBUIEpqaWUX4bQNW1+bbm7zfbvQRppW/m8O5/n4nf9zzoEpCftKqm4Ew0oB0cjuokpV1mouCYVltY1bs1bmp1mS6ezum0w7nBUu5pJQefmOmpFuIy7WQPmVliTJZDRRf6uNyMQErQ0nPeLjZy+HmurLBIOsTLbMxskrrjHnZqW5rcuTkZxnatXMjEy++ceiBTpZS1f36/7SQ/mrBADH4RPqTMrNhgsCgAQwGsKjitqRpquVawF2HChS+V/NatJZ3jCYuyUr5cnzToRT56+ry1IWI8taEuMXkWCKIzAe4XZzu6v+bLFFuP+0S73b2DSNsD1nG46dmydN9vT20dM/EE2qqorNmhrdSy+63z1cYUnM/Z3Q2/Nquqn9R8ujYzmcFa6DJRVfogQA3+fhaLF/1P9VUMLSX8ecS3nFNWb7kpgOvaxJAVAUNSgB7HFezBZFEvSyuFEjCkaNKBj1siYdQK8VU0VR0AFYLUnYbcvp7R9gyO1FUVSEY+fq1F05m4g1LCQyMfVFBBgNhAAIhSMEgiEUFcymGO49eMRb93hSa12pB0D64Q/1Dw6508PINLc0Y1u9ng9vOv9Y7Ws2YDPH4PWF2n81A2iWZmQPjHoHCyxJ8dhtVhLjdMTGGdFLIGgWEBkPMBZSGHZ9JBz4jsfH6fcdbd3zuTsA9pZUXys8XuWdGZcAco9Ur9OFR7o8PgWzQUQnTX+cYETF9cmD2SDO++B/6icxD+BUEv4mFgAAACV0RVh0Y3JlYXRlLWRhdGUAMjAxMC0wNC0yMVQxNjowMDo1OS0wNzowMCFi5gYAAAAldEVYdG1vZGlmeS1kYXRlADIwMTAtMDQtMjFUMTY6MDA6NTktMDc6MDB+05AyAAAAAElFTkSuQmCC";
/* urlImg['']="";
*/
return '';
}

var vkSmilesLinks={
"yes":"http://img-fotki.yandex.ru/get/5800/kiberinfinity.1/0_4b4f2_569b36e1_XS",
"wink":"http://img-fotki.yandex.ru/get/4605/kiberinfinity.0/0_4b4f1_34add13_XS",
"wacko1":"http://img-fotki.yandex.ru/get/4601/kiberinfinity.0/0_4b4f0_eb336f65_XS",
"cray":"http://img-fotki.yandex.ru/get/5902/kiberinfinity.0/0_4b4c1_734f12ce_XS",
"acute":"http://img-fotki.yandex.ru/get/5300/kiberinfinity.0/0_4b4c2_4337cb95_XS",
"air_kiss":"http://img-fotki.yandex.ru/get/5405/kiberinfinity.0/0_4b4c3_aaabfeac_XS",
"bad":"http://img-fotki.yandex.ru/get/4906/kiberinfinity.0/0_4b4c4_cac918b6_XS",
"biggrin":"http://img-fotki.yandex.ru/get/5702/kiberinfinity.0/0_4b4c5_c0227d6c_XS",
"blum1":"http://img-fotki.yandex.ru/get/4600/kiberinfinity.0/0_4b4c6_29cf5ad3_XS",
"blush":"http://img-fotki.yandex.ru/get/5405/kiberinfinity.0/0_4b4c7_b950f88e_XS",
"bomb":"http://img-fotki.yandex.ru/get/5702/kiberinfinity.0/0_4b4c8_82b5bdc6_XS",
"bye2":"http://img-fotki.yandex.ru/get/5500/kiberinfinity.0/0_4b4c9_41d71c6a_XS",
"cool":"http://img-fotki.yandex.ru/get/5106/kiberinfinity.0/0_4b4ca_7d0f85e7_XS",
"crazy":"http://img-fotki.yandex.ru/get/5000/kiberinfinity.0/0_4b4cb_fe5f7b7a_XS",
"dance":"http://img-fotki.yandex.ru/get/5502/kiberinfinity.0/0_4b4cc_12e0ee40_XS",
"dash1":"http://img-fotki.yandex.ru/get/5405/kiberinfinity.0/0_4b4cd_4b8735bb_XS",
"diablo":"http://img-fotki.yandex.ru/get/5106/kiberinfinity.0/0_4b4ce_5472ae0c_XS",
"drinks":"http://img-fotki.yandex.ru/get/5301/kiberinfinity.0/0_4b4cf_1a6f6049_XS",
"facepalm":"http://img-fotki.yandex.ru/get/5802/kiberinfinity.0/0_4b4d0_5abf5d2d_XS",
"flood":"http://img-fotki.yandex.ru/get/4806/kiberinfinity.0/0_4b4d1_d08593ae_XS",
"fool":"http://img-fotki.yandex.ru/get/4603/kiberinfinity.0/0_4b4d2_d384cdd9_XS",
"girl_angel":"http://img-fotki.yandex.ru/get/5901/kiberinfinity.0/0_4b4d3_b221dac_XS",
"girl_devil":"http://img-fotki.yandex.ru/get/5001/kiberinfinity.0/0_4b4d4_ba8fc51a_XS",
"give_rose":"http://img-fotki.yandex.ru/get/4806/kiberinfinity.0/0_4b4d5_df29d34e_XS",
"good":"http://img-fotki.yandex.ru/get/5106/kiberinfinity.0/0_4b4d6_5674780c_XS",
"greeting":"http://img-fotki.yandex.ru/get/5206/kiberinfinity.0/0_4b4d7_1456f739_XS",
"hang1":"http://img-fotki.yandex.ru/get/4400/kiberinfinity.0/0_4b4d8_a1f0ba9d_XS",
"heart":"http://img-fotki.yandex.ru/get/4603/kiberinfinity.0/0_4b4d9_9b99fd3_XS",
"help":"http://img-fotki.yandex.ru/get/5802/kiberinfinity.0/0_4b4da_f2fbb58f_XS",
"i_am_so_happy":"http://img-fotki.yandex.ru/get/5801/kiberinfinity.0/0_4b4db_15632254_XS",
"kiss":"http://img-fotki.yandex.ru/get/4701/kiberinfinity.0/0_4b4dc_4aa1d66e_XS",
"lol":"http://img-fotki.yandex.ru/get/5206/kiberinfinity.0/0_4b4dd_26a96f4c_XS",
"mad":"http://img-fotki.yandex.ru/get/4701/kiberinfinity.0/0_4b4de_18f3958d_XS",
"mamba":"http://img-fotki.yandex.ru/get/4605/kiberinfinity.0/0_4b4df_9aab63e4_XS",
"mocking":"http://img-fotki.yandex.ru/get/5301/kiberinfinity.0/0_4b4e0_b975eab7_XS",
"music":"http://img-fotki.yandex.ru/get/4701/kiberinfinity.0/0_4b4e1_7b2ef2e5_XS",
"nea":"http://img-fotki.yandex.ru/get/5600/kiberinfinity.0/0_4b4e2_2f728d41_XS",
"new_russian":"http://img-fotki.yandex.ru/get/5701/kiberinfinity.0/0_4b4e3_cd920601_XS",
"ok":"http://img-fotki.yandex.ru/get/4605/kiberinfinity.0/0_4b4e4_733374b2_XS",
"pardon":"http://img-fotki.yandex.ru/get/4701/kiberinfinity.0/0_4b4e5_938e9867_XS",
"rofl":"http://img-fotki.yandex.ru/get/5801/kiberinfinity.0/0_4b4e6_5e876bde_XS",
"sad":"http://img-fotki.yandex.ru/get/4511/kiberinfinity.0/0_4b4e7_a0ef7095_XS",
"scare3":"http://img-fotki.yandex.ru/get/5801/kiberinfinity.0/0_4b4e8_7e655108_XS",
"scratch_one-s_head":"http://img-fotki.yandex.ru/get/6001/kiberinfinity.0/0_4b4e9_f3bfbdec_XS",
"secret":"http://img-fotki.yandex.ru/get/4401/kiberinfinity.0/0_4b4ea_addb0e71_XS",
"shok":"http://img-fotki.yandex.ru/get/4600/kiberinfinity.0/0_4b4eb_284e6cba_XS",
"smile":"http://img-fotki.yandex.ru/get/4604/kiberinfinity.0/0_4b4ec_4b007e83_XS",
"sorry":"http://img-fotki.yandex.ru/get/4401/kiberinfinity.0/0_4b4ed_93f046f0_XS",
"spam":"http://img-fotki.yandex.ru/get/4701/kiberinfinity.0/0_4b4ee_a18e6891_M",
"unknown":"http://img-fotki.yandex.ru/get/4602/kiberinfinity.0/0_4b4ef_73767cbe_XS"
}

if (!window.vkscripts_ok) vkscripts_ok=1; else vkscripts_ok++;