/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Pathfinding {
    public static int MAP_WIDTH = WCanvas.LEVEL_WIDTH;
    public static int MAP_HEIGHT = 12;
    public static Vector openList = new Vector();
    public static Vector closedList = new Vector();
    public static Vector finalPathInverted = new Vector();
    public static int[] finalPath;
    public static int BEG;
    public static int END;
    public static int[] LEVEL_MAP;
    static boolean find;
    public static boolean reallyFind;
    static int[] dirOf;

    public static void initPathfinding(int _beg, int _end, int[] _levMap, int _mapW, int _mapH) {
        BEG = _beg;
        END = _end;
        MAP_WIDTH = _mapW;
        MAP_HEIGHT = _mapH;
        LEVEL_MAP = _levMap;
        openList.removeAllElements();
        closedList.removeAllElements();
        finalPathInverted.removeAllElements();
        Pathfinding.dirOf[0] = -MAP_WIDTH;
        Pathfinding.dirOf[1] = 1;
        Pathfinding.dirOf[2] = MAP_WIDTH;
        Pathfinding.dirOf[3] = -1;
        find = false;
        reallyFind = false;
        Pathfinding.findPath();
    }

    public static void findPath() {
        Pathfinding.addToClosed(new Node(BEG, 0, null));
        while (!find) {
            Pathfinding.addAllOpensForNode((Node)closedList.elementAt(closedList.size() - 1));
            int tmp = Pathfinding.getLowestCostOpen();
            if (tmp != -100) {
                Pathfinding.addToClosed((Node)openList.elementAt(tmp));
                openList.removeElementAt(tmp);
                continue;
            }
            find = true;
        }
    }

    public static int getNodeCost(int _node) {
        int begX = BEG % MAP_WIDTH;
        int begY = BEG / MAP_WIDTH;
        int endX = END % MAP_WIDTH;
        int endY = END / MAP_WIDTH;
        int nodeX = _node % MAP_WIDTH;
        int nodeY = _node / MAP_WIDTH;
        int cost = 1;
        int costFromBeg = Math.abs(nodeX - begX) + Math.abs(nodeY - begY);
        int costFromEnd = Math.abs(nodeX - endX) + Math.abs(nodeY - endY);
        return cost + costFromBeg + costFromEnd;
    }

    public static int getLowestCostOpen() {
        if (openList.size() > 0) {
            int tmpLow = ((Node)Pathfinding.openList.elementAt((int)0)).cost;
            for (int i = 0; i < openList.size(); ++i) {
                if (((Node)Pathfinding.openList.elementAt((int)tmpLow)).cost >= ((Node)Pathfinding.openList.elementAt((int)0)).cost) continue;
                tmpLow = i;
            }
            return tmpLow;
        }
        return -100;
    }

    public static void addOpen(int _num, Node _parent) {
        if (Pathfinding.notInOpen(_num)) {
            openList.addElement(new Node(_num, Pathfinding.getNodeCost(_num), _parent));
        }
    }

    public static void addAllOpensForNode(Node _node) {
        for (int i = 0; i < dirOf.length; ++i) {
            int newNode = _node.num + dirOf[i];
            int curNX = _node.num % MAP_WIDTH;
            int newNX = newNode % MAP_WIDTH;
            if (newNode < 0 || newNode >= LEVEL_MAP.length || Math.abs(curNX - newNX) >= 2 || !Pathfinding.notInClosed(newNode) || !Pathfinding.isWalkable(_node, newNode, i) && newNode != END) continue;
            Pathfinding.addOpen(newNode, _node);
            if (newNode != END) continue;
            find = true;
            reallyFind = true;
            System.out.println("FIND!!!!!!!!!!!!!!");
            Pathfinding.makePath((Node)openList.elementAt(openList.size() - 1));
        }
    }

    public static void makePath(Node _node) {
        System.out.println("MAKE PATH");
        Node curNode = _node;
        finalPathInverted.addElement(new Integer(curNode.num));
        do {
            curNode = curNode.parent;
            finalPathInverted.addElement(new Integer(curNode.num));
        } while (curNode.num != BEG);
        int pathLength = finalPathInverted.size();
        finalPath = new int[pathLength];
        for (int i = 0; i < pathLength; ++i) {
            int node;
            Pathfinding.finalPath[i] = node = ((Integer)finalPathInverted.elementAt(pathLength - 1 - i)).intValue();
        }
    }

    public static void addToClosed(Node _node) {
        closedList.addElement(_node);
    }

    public static boolean notInClosed(int _num) {
        for (int i = 0; i < closedList.size(); ++i) {
            if (_num != ((Node)Pathfinding.closedList.elementAt((int)i)).num) continue;
            return false;
        }
        return true;
    }

    public static boolean notInOpen(int _num) {
        for (int i = 0; i < openList.size(); ++i) {
            if (_num != ((Node)Pathfinding.openList.elementAt((int)i)).num) continue;
            return false;
        }
        return true;
    }

    public static boolean isWalkable(Node _node, int _newNode, int _dir) {
        int nodNum = WCanvas.LEVEL_DATA[_node.num];
        int newNodNum = WCanvas.LEVEL_DATA[_newNode];
        switch (nodNum) {
            case 0: {
                if (_dir == 0) {
                    return newNodNum == 3 || newNodNum == 4 || newNodNum == 0 || newNodNum == 6;
                }
                return _dir == 2 && (newNodNum == 2 || newNodNum == 5 || newNodNum == 0 || newNodNum == 6);
            }
            case 1: {
                if (_dir == 1) {
                    return newNodNum == 4 || newNodNum == 5 || newNodNum == 1 || newNodNum == 6;
                }
                return _dir == 3 && (newNodNum == 2 || newNodNum == 3 || newNodNum == 1 || newNodNum == 6);
            }
            case 2: {
                if (_dir == 0) {
                    return newNodNum == 3 || newNodNum == 4 || newNodNum == 0 || newNodNum == 6;
                }
                return _dir == 1 && (newNodNum == 4 || newNodNum == 5 || newNodNum == 1 || newNodNum == 6);
            }
            case 3: {
                if (_dir == 1) {
                    return newNodNum == 4 || newNodNum == 5 || newNodNum == 1 || newNodNum == 6;
                }
                return _dir == 2 && (newNodNum == 0 || newNodNum == 5 || newNodNum == 2 || newNodNum == 6);
            }
            case 4: {
                if (_dir == 2) {
                    return newNodNum == 0 || newNodNum == 5 || newNodNum == 2 || newNodNum == 6;
                }
                return _dir == 3 && (newNodNum == 0 || newNodNum == 3 || newNodNum == 2 || newNodNum == 6);
            }
            case 5: {
                if (_dir == 0) {
                    return newNodNum == 0 || newNodNum == 3 || newNodNum == 4 || newNodNum == 6;
                }
                return _dir == 3 && (newNodNum == 1 || newNodNum == 3 || newNodNum == 2 || newNodNum == 6);
            }
            case 6: {
                if (_dir == 0) {
                    return newNodNum == 0 || newNodNum == 3 || newNodNum == 4 || newNodNum == 6;
                }
                if (_dir == 1) {
                    return newNodNum == 4 || newNodNum == 5 || newNodNum == 1 || newNodNum == 6;
                }
                if (_dir == 2) {
                    return newNodNum == 0 || newNodNum == 5 || newNodNum == 2 || newNodNum == 6;
                }
                if (_dir == 3) {
                    return newNodNum == 0 || newNodNum == 3 || newNodNum == 2 || newNodNum == 6;
                }
                return true;
            }
        }
        return false;
    }

    static {
        find = false;
        reallyFind = false;
        dirOf = new int[]{-MAP_WIDTH, 1, MAP_WIDTH, -1};
    }
}

