/*
 * Decompiled with CFR 0.152.
 */
import font.FontMapper;
import font.VectorFont;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class GameScreen
extends Canvas {
    private static int KEY_SOFTKEY1;
    private static int KEY_SOFTKEY2;
    private static int KEY_SOFTKEY3;
    private static final int SCREEN_LOGO = 1;
    private static final int SCREEN_MENU_MAIN = 3;
    private static final int SCREEN_MENU_ABOUT = 4;
    private static final int SCREEN_MENU_HELP = 5;
    private static final int SCREEN_MENU_OPTIONS = 6;
    private static final int SCREEN_GAME_DIALOG = 10;
    private static final int SCREEN_FINISH_GAME = 89;
    private static final int SCREEN_ERROR = 99;
    private static final int NUMBER_OF_CLOTHES_PARTS = 4;
    private static final int[] CLOTHES_PARTS_POSITIONS_X;
    private static final int[] CLOTHES_PARTS_POSITIONS_Y;
    private static final int SCREEN_WIDTH = 128;
    private static final int SCREEN_HEIGHT = 160;
    private static int COLOR_WHITE;
    private static int COLOR_BLACK;
    private static int COLOR_HUD_ACTIVE;
    public static boolean gameStarted;
    public static boolean gamePaused;
    public Random rnd = new Random();
    private Image imgIconsMain = null;
    private Image imgFaces = null;
    private Image imgArrows = null;
    private Image imgHud = null;
    private Image imgFilmFrame = null;
    private Image imgTransparent = null;
    private Image[] imgClothesParts = new Image[4];
    private static int currentScreen;
    private Stack previousScreenStack = new Stack();
    Hashtable conf = new Hashtable();
    private Vector scenario = null;
    private int[] framesStates;
    public static boolean isSleeping;
    public static int FLASH_INTERVAL;
    public static boolean flashState;
    public static boolean isFlashing;
    public static boolean stopFlashing;
    public int menuFieldHeightCurrentMax = -1;
    public int menuFieldHeightRequested = -1;
    public long previousBeginTime = 0L;
    private VectorFont fontHelpPlain;
    private VectorFont fontHelpBold;
    private VectorFont fontMenu;
    private VectorFont fontDialog;
    private FontMapper fontMapper;
    private int SPECIAL_CHAR_BOLD;
    private int BREAK_LINE_CHAR_INT;
    private int SPLIT_CHAR_INT;
    private boolean keysBlocked = false;
    public static int VOLUME_MAX;
    public static int volumeMusic;
    public static boolean isContinueIconEnabled;
    public static int continueFrameId;
    private int loadingProgress = 0;
    private boolean requestSecondLogoDisplayed = false;
    private Image imgLogoBrand = null;
    private Image imgLogoGame = null;
    private static int BRAND_LOGO_DISPLAY_TIME;
    public static boolean isEnabledMusic;
    public static Player playerMusic;
    private static int[] LOGO_TEXT_LOADING;
    private static int[] LOGO_TEXT_PRESS;
    private static int[] LOGO_TEXT_PRESS_2;
    private static int LOGO_BAR_POS;
    private static int LOGO_BAR_COLOR;
    private static int LOGO_TEXT_POS;
    private static int LOGO_BAR_WIDTH;
    private static int LOGO_BAR_HEIGHT;
    private static int MENU_FIELD_HEIGHT;
    private static int MENU_FIELD_BORDER_COLOR;
    private static int MENU_TEXT_MARGIN;
    private static int MENU_ICONS_POSITION;
    private static int MENU_ANIMATION_BASE_INTERVAL;
    private static int MENU_ANIMATION_OPENING_SPEED;
    private static int MENU_ANIMATION_CLOSING_SPEED;
    private static int MENU_ANIMATION_OPENING_MIN_SPEED;
    private static int MENU_ICONS_ON_SCREEN;
    private static int MENU_ICONS_WIDTH;
    private static int MENU_ICONS_SMALL_WIDTH;
    private static int MENU_ICONS_ANIMATION_SPEED;
    private static int MENU_ICONS_ANIMATION_MIN_SPEED;
    private static int MENU_ARROW_MOVEMENT_SIZE;
    private static int MENU_ARROW_MOVEMENT_STEP;
    private static int MENU_ARROW_SIDE_MARGIN;
    private static int[] TEXT_MENU_MAIN_START;
    private static int[] TEXT_MENU_INSTRUCTIONS;
    private static int[] TEXT_MENU_ABOUT;
    private static int[] TEXT_MENU_EXIT;
    private static int[] TEXT_MENU_CONTINUE;
    private static int[] TEXT_MENU_OPTIONS;
    private static int[] TEXT_MENU_GOTO_MAIN;
    private static int[] TEXT_MENU_ARCADE;
    private static int[] TEXT_MENU_FOTO_DEBUG;
    private static int[] TEXT_MUSIC_ON;
    private static int[] TEXT_MUSIC_OFF;
    public static final int MENU_TYPE_MAIN = 1;
    public static final int MENU_TYPE_INGAME = 2;
    public static final int MENU_TYPE_ENABLE_SOUND = 3;
    private int menuTypeCurrent = 0;
    private int menuTypeRequested = 0;
    private Image imgCurrentBackground = null;
    private Image imgCurrentImage = null;
    private int itemSelected = 0;
    private int itemDest = 0;
    private int itemSelectedRequested = -1;
    private int[][] items = null;
    private int[][] itemsNonWrap = null;
    private int[][] items2 = null;
    private int[] itemsIconIndexes = null;
    private int[][] itemsRequested = null;
    private int[] itemsIconIndexesRequested = null;
    private int menuFieldHeightCurrent = 0;
    private int menuFieldHeightCurrentBlocked = 0;
    public static boolean isAnimationFieldResizeInProgress;
    public static boolean isAnimationIconsInProgress;
    public static boolean stopMenuAnimation;
    private int interIcon;
    private int itemOffset = 0;
    private int arrowOffset = 0;
    private int arrowMovementDirection;
    private static int[][] MENU_ITEMS_MAIN;
    private static int[] MENU_ITEMS_MAIN_ICONS_INDEXES;
    private static int[][] MENU_ITEMS_MAIN_WITH_ARCADE;
    private static int[] MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES;
    private static int[][] MENU_ITEMS_INGAME;
    private static int[] MENU_ITEMS_INGAME_ICONS_INDEXES;
    private static int[][] MENU_ITEMS_ENABLE_SOUND;
    private static int[] MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES;
    private int optionItemSelected = 0;
    private static int OPTIONS_FIELD_HEIGHT;
    private static String OPTION_TEXT_MUSIC;
    private static String OPTION_TEXT_SOUND;
    private static String OPTION_TEXT_ENABLE_SOUND;
    private static String OPTION_TEXT_OK;
    private static String OPTION_TEXT_OFF;
    private static String OPTION_TEXT_YES;
    private static String OPTION_TEXT_NO;
    private static String[] OPTIONS_TEXTS;
    private int optionInterline;
    public int FRAME_COLOR_DARK = 0x202020;
    public int FRAME_COLOR_STEP = 0x101010;
    private int frameColor = this.FRAME_COLOR_DARK;
    private int frameColorChangeDirection = this.FRAME_COLOR_STEP;
    public boolean isFrameColorAnimating = false;
    public static boolean stopFrameColorAnimation;
    public static int HELP_FIELD_HEIGHT;
    private static int ABOUT_FIELD_HEIGHT;
    public static int HELP_TEXT_WIDTH;
    private static int HELP_TEXT_INTERLINE;
    private int[][] HELP_TEXT_LINES = null;
    private int[][] ABOUT_TEXT_LINES = null;
    private int[][] helpAboutTextLines = null;
    private int helpTextFirstLine = 0;
    private int helpTextLinesOnScreen = 0;
    private int HELP_TEXT_TOP_MARGIN = 1;
    private static int FINISH_FIELD_HEIGHT;
    private static int FINISH_MARGIN;
    private static int[] FINISH_END_TEXT;
    public static int COLOR_DIALOG_BKG_PLAYER_LIGHT;
    public static int COLOR_DIALOG_BKG_PLAYER_DARK;
    public static int COLOR_DIALOG_BKG_OTHER_MAN;
    public static int COLOR_DIALOG_BKG_OTHER_WOMAN;
    public static int COLOR_DIALOG_BKG_INFO;
    public static int COLOR_CHANGE_STEP;
    private static int[] ARCADE_PARAM_TEXT_1;
    private static int[] ARCADE_PARAM_TEXT_2;
    private static int ARCADE_PARAM_MARG_X;
    private static int ARCADE_PARAM_MARG_Y;
    private static int ARCADE_PARAM_COLOR;
    private static int DIALOG_ARROW_MARGIN;
    private static int DIALOG_ARROW_MOVEMENT_STEP;
    private static int DIALOG_ARROW_MOVEMENT_SIZE;
    private static int ARCADE_ARROW_OFFSET_X;
    private static int ARCADE_ARROW_OFFSET_Y;
    private static int ARCADE_ARROW_MOVEMENT_SIZE;
    private static int ARCADE_ARROW_MOVEMENT_SPEED;
    private static int ARCADE_ARROW_MOVEMENT_STEP;
    private static int WINNING_AREA_RADIUS;
    private static int ARCADE_CLOTHES_INITIAL;
    public static final int TALKING_NON = 0;
    public static final int TALKING_PLAYER = 1;
    public static final int TALKING_LADY = 2;
    public static final int TALKING_INFO = 3;
    private int arrowDialogOffset = 0;
    private int arrowDialogMovementDirection;
    public static boolean stopAnimateGame;
    private int colorDialogPlayer;
    private int colorChangeDirection;
    private boolean enableHudArrowCapture = false;
    private int arrowHudOffset = -13;
    private int arrowHudOffsetHorizontal = -13;
    private int arrowHudOffsetVertical = -13;
    private int arrowHudMovementDirection;
    private FrameOfScenario currentFrame = null;
    private int previousFrameId = 0;
    private int whosTalking = 0;
    private int playerTextSelected = 0;
    private int[][][] curentTextShownWrapped = null;
    private boolean isArcadeModeActive = false;
    private boolean isArcadeDialogDiscard = false;
    private boolean isArcadeGameWon = false;
    private Image imgLadyBlured = null;
    private int currentImageId = -1;
    private int arcadeState = -1;
    private static final int ARCADE_STATE_NONE = -1;
    private static final int ARCADE_STATE_DIALOG = 1;
    private static final int ARCADE_STATE_HORIZONTAL = 2;
    private static final int ARCADE_STATE_VERTICAL = 3;
    private static final int ARCADE_STATE_PRESENTATION = 4;
    private static final int ARCADE_STATE_PROMPT = 5;
    private boolean isImageBlured = false;
    private int currentClothes;
    private boolean currentClothesVisible = false;
    private int requestedArcadeNextFrame = -1;
    private int boxHeight = 0;
    public static final int[] POWERS;
    private int HUD_LINES_HEIGHT = 10;
    private int HUD_LINES_WIDTH = 2;
    private int HUD_LINES_SPACE = 4;
    private int HUD_CENTER_SIZE = 10;
    private int HUD_CENTER_SPACE = (this.HUD_CENTER_SIZE + this.HUD_LINES_WIDTH - this.HUD_LINES_SPACE * 2) / 2;
    private int HUD_OFFSET = -this.HUD_LINES_WIDTH / 2;
    private int prevArrowHudOffsetHorizontal = 0;
    private int prevArrowHudOffsetVertical = 0;
    private int prevArrowHX = 0;
    private int prevArrowHY = 0;
    private int prevArrowHW = 0;
    private int prevArrowHH = 0;
    private int prevArrowVX = 0;
    private int prevArrowVY = 0;
    private int prevArrowVW = 0;
    private int prevArrowVH = 0;
    private int shownHintId = -1;
    public static boolean[] hintUsed;
    private static int[][] HINTS_TEXTS;
    private int previousDiscardedArdaceSelection = -1;
    private String errorMessage = null;

    public GameScreen() {
        try {
            this.fontDialog = new VectorFont("/ls_11.font");
            this.fontMenu = new VectorFont("/ls_12_b.font");
            this.fontHelpPlain = this.fontDialog;
            this.fontHelpBold = new VectorFont("/ls_11_b.font");
            this.fontMapper = new FontMapper("/charset.txt.JUTF", true);
            FontMapper.setDefault(this.fontMapper);
            int[] specialChars = this.fontMapper.mapString(" \\*");
            this.SPLIT_CHAR_INT = specialChars[0] & 0xFF;
            this.BREAK_LINE_CHAR_INT = specialChars[0] >> 8 & 0xFF;
            this.SPECIAL_CHAR_BOLD = specialChars[0] >> 16 & 0xFF;
        }
        catch (Exception ex) {
            this.showErrorScreen("Can't load vector fonts!\\" + ex.getMessage());
            System.out.println("Can't load vector fonts!");
            return;
        }
        currentScreen = 1;
        this.setFullScreenMode(true);
    }

    public void initializeConstants() {
        MENU_FIELD_HEIGHT = this.getConfInt("MENU_FIELD_HEIGHT");
        MENU_FIELD_BORDER_COLOR = this.getConfInt("MENU_FIELD_BORDER_COLOR");
        MENU_TEXT_MARGIN = this.getConfInt("MENU_TEXT_MARGIN");
        MENU_ICONS_POSITION = this.getConfInt("MENU_ICONS_POSITION");
        MENU_ANIMATION_BASE_INTERVAL = this.getConfInt("MENU_ANIMATION_BASE_INTERVAL");
        MENU_ANIMATION_OPENING_SPEED = this.getConfInt("MENU_ANIMATION_OPENING_SPEED");
        MENU_ANIMATION_CLOSING_SPEED = this.getConfInt("MENU_ANIMATION_CLOSING_SPEED");
        MENU_ANIMATION_OPENING_MIN_SPEED = this.getConfInt("MENU_ANIMATION_OPENING_MIN_SPEED");
        MENU_ICONS_WIDTH = this.getConfInt("MENU_ICONS_WIDTH");
        MENU_ICONS_SMALL_WIDTH = this.getConfInt("MENU_ICONS_SMALL_WIDTH");
        MENU_ARROW_MOVEMENT_SIZE = this.getConfInt("MENU_ARROW_MOVEMENT_SIZE");
        MENU_ARROW_MOVEMENT_STEP = this.getConfInt("MENU_ARROW_MOVEMENT_STEP");
        TEXT_MENU_MAIN_START = this.fontMapper.mapString(this.getConfString("TEXT_MENU_MAIN_START"));
        TEXT_MENU_INSTRUCTIONS = this.fontMapper.mapString(this.getConfString("TEXT_MENU_INSTRUCTIONS"));
        TEXT_MENU_ABOUT = this.fontMapper.mapString(this.getConfString("TEXT_MENU_ABOUT"));
        TEXT_MENU_EXIT = this.fontMapper.mapString(this.getConfString("TEXT_MENU_EXIT"));
        TEXT_MENU_CONTINUE = this.fontMapper.mapString(this.getConfString("TEXT_MENU_CONTINUE"));
        TEXT_MENU_OPTIONS = this.fontMapper.mapString(this.getConfString("TEXT_MENU_OPTIONS"));
        TEXT_MENU_GOTO_MAIN = this.fontMapper.mapString(this.getConfString("TEXT_MENU_GOTO_MAIN"));
        TEXT_MENU_ARCADE = this.fontMapper.mapString(this.getConfString("TEXT_MENU_ARCADE"));
        TEXT_MENU_FOTO_DEBUG = this.fontMapper.mapString(this.getConfString("TEXT_MENU_FOTO_DEBUG"));
        TEXT_MUSIC_ON = this.fontMapper.mapString(this.getConfString("TEXT_MUSIC_ON"));
        TEXT_MUSIC_OFF = this.fontMapper.mapString(this.getConfString("TEXT_MUSIC_OFF"));
        MENU_ITEMS_MAIN = new int[][]{TEXT_MENU_MAIN_START, TEXT_MENU_OPTIONS, TEXT_MENU_INSTRUCTIONS, TEXT_MENU_ABOUT, TEXT_MENU_EXIT};
        MENU_ITEMS_MAIN_ICONS_INDEXES = new int[]{0, 3, 1, 2, 5};
        MENU_ITEMS_MAIN_WITH_ARCADE = new int[][]{TEXT_MENU_ARCADE, TEXT_MENU_MAIN_START, TEXT_MENU_OPTIONS, TEXT_MENU_INSTRUCTIONS, TEXT_MENU_ABOUT, TEXT_MENU_EXIT};
        MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES = new int[]{6, 0, 3, 1, 2, 5};
        MENU_ITEMS_INGAME = new int[][]{TEXT_MENU_CONTINUE, TEXT_MENU_OPTIONS, TEXT_MENU_INSTRUCTIONS, TEXT_MENU_ABOUT, TEXT_MENU_GOTO_MAIN};
        MENU_ITEMS_INGAME_ICONS_INDEXES = new int[]{6, 3, 1, 2, 4};
        MENU_ITEMS_ENABLE_SOUND = new int[][]{TEXT_MUSIC_OFF, TEXT_MUSIC_ON};
        MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES = new int[]{8, 7};
        OPTION_TEXT_MUSIC = this.getConfString("OPTION_TEXT_MUSIC");
        OPTION_TEXT_SOUND = this.getConfString("OPTION_TEXT_SOUND");
        OPTION_TEXT_ENABLE_SOUND = this.getConfString("OPTION_TEXT_ENABLE_SOUND");
        OPTION_TEXT_OK = this.getConfString("OPTION_TEXT_OK");
        OPTION_TEXT_OFF = this.getConfString("OPTION_TEXT_OFF");
        OPTION_TEXT_YES = this.getConfString("OPTION_TEXT_YES");
        OPTION_TEXT_NO = this.getConfString("OPTION_TEXT_NO");
        OPTIONS_TEXTS = new String[]{OPTION_TEXT_OK, OPTION_TEXT_ENABLE_SOUND, OPTION_TEXT_MUSIC};
        this.optionInterline = 6;
        OPTIONS_FIELD_HEIGHT = (OPTIONS_TEXTS.length * (this.fontMenu.getHeight() + this.optionInterline) + this.optionInterline * 2) / 2;
        HELP_FIELD_HEIGHT = this.getConfInt("HELP_FIELD_HEIGHT");
        HELP_TEXT_WIDTH = this.getConfInt("HELP_TEXT_WIDTH");
        this.HELP_TEXT_LINES = this.fontHelpPlain.wrapString(this.fontMapper.mapString(this.getConfString("help.text")), 128 * HELP_TEXT_WIDTH / 100 - this.imgArrows.getWidth() / 2, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT);
        this.helpTextLinesOnScreen = HELP_FIELD_HEIGHT * 2 / (this.fontHelpPlain.getHeight() + HELP_TEXT_INTERLINE);
        HELP_FIELD_HEIGHT = ((this.fontHelpPlain.getHeight() + HELP_TEXT_INTERLINE) * this.helpTextLinesOnScreen + this.HELP_TEXT_TOP_MARGIN * 2 + 1) / 2 + 1;
        this.ABOUT_TEXT_LINES = this.fontHelpPlain.wrapString(this.fontMapper.mapString(this.getConfString("ABOUT_TEXT")), 128 * HELP_TEXT_WIDTH / 100 - this.imgArrows.getWidth() / 2, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT);
        ABOUT_FIELD_HEIGHT = this.getConfInt("ABOUT_FIELD_HEIGHT");
        ARCADE_ARROW_OFFSET_X = this.getConfInt("ARCADE_ARROW_OFFSET_X");
        ARCADE_ARROW_OFFSET_Y = this.getConfInt("ARCADE_ARROW_OFFSET_Y");
        ARCADE_ARROW_MOVEMENT_SIZE = this.getConfInt("ARCADE_ARROW_MOVEMENT_SIZE");
        ARCADE_ARROW_MOVEMENT_SPEED = this.getConfInt("ARCADE_ARROW_MOVEMENT_SPEED");
        ARCADE_ARROW_MOVEMENT_STEP = this.getConfInt("ARCADE_ARROW_MOVEMENT_STEP");
        WINNING_AREA_RADIUS = this.getConfInt("WINNING_AREA_RADIUS");
        ARCADE_PARAM_MARG_X = this.getConfInt("ARCADE_PARAM_MARG_X");
        ARCADE_PARAM_MARG_Y = this.getConfInt("ARCADE_PARAM_MARG_Y");
        ARCADE_PARAM_COLOR = this.getConfHex("ARCADE_PARAM_COLOR");
        ARCADE_PARAM_TEXT_1 = this.fontMapper.mapString(this.getConfString("ARCADE_PARAM_TEXT_1"));
        ARCADE_PARAM_TEXT_2 = this.fontMapper.mapString(this.getConfString("ARCADE_PARAM_TEXT_2"));
        int hc = this.getConfInt("HINTS_COUNT");
        HINTS_TEXTS = new int[hc][];
        for (int i = 0; i < hc; ++i) {
            GameScreen.HINTS_TEXTS[i] = this.fontMapper.mapString(this.getConfString("HINT_TEXT_" + i));
        }
        FINISH_FIELD_HEIGHT = this.getConfInt("FINISH_FIELD_HEIGHT");
        FINISH_MARGIN = this.getConfInt("FINISH_MARGIN");
        FINISH_END_TEXT = this.fontMapper.mapString(this.getConfString("FINISH_END_TEXT"));
        LOGO_TEXT_LOADING = this.fontMapper.mapString(this.getConfString("LOGO_TEXT_LOADING"));
        int[][] tmp_lines = this.fontHelpPlain.wrapString(this.fontMapper.mapString(this.getConfString("LOGO_TEXT_PRESS")), 121, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT);
        LOGO_TEXT_PRESS = tmp_lines[0];
        if (tmp_lines.length > 1) {
            LOGO_TEXT_PRESS_2 = tmp_lines[1];
        } else {
            LOGO_BAR_COLOR = this.getConfHex("LOGO_BAR_COLOR");
        }
        LOGO_BAR_WIDTH = this.getConfInt("LOGO_BAR_WIDTH");
        LOGO_BAR_HEIGHT = this.getConfInt("LOGO_BAR_HEIGHT");
        LOGO_BAR_POS = this.getConfInt("LOGO_BAR_POS");
        LOGO_TEXT_POS = this.getConfInt("LOGO_TEXT_POS");
        KEY_SOFTKEY1 = this.getConfInt("KEY_SOFTKEY1");
        KEY_SOFTKEY2 = this.getConfInt("KEY_SOFTKEY2");
        KEY_SOFTKEY3 = this.getConfInt("KEY_SOFTKEY3");
    }

    public void paint(Graphics g) {
        switch (currentScreen) {
            case 1: {
                this.paint_LogoScreen(g);
                break;
            }
            case 99: {
                this.paint_ErrorScreen(g);
                break;
            }
            case 3: {
                this.paint_Menu(g);
                break;
            }
            case 6: {
                this.paint_Options(g);
                break;
            }
            case 4: {
                this.paint_HelpAbout(g);
                break;
            }
            case 5: {
                this.paint_HelpAbout(g);
                break;
            }
            case 10: {
                this.paint_GameDialog(g);
                break;
            }
            case 89: {
                this.paint_Finish(g);
            }
        }
        this.keysBlocked = false;
    }

    protected void keyPressed(int key) {
        if (this.keysBlocked || isAnimationFieldResizeInProgress) {
            return;
        }
        this.keysBlocked = true;
        switch (currentScreen) {
            case 1: {
                this.keyPressed_LogoScreen(key);
                break;
            }
            case 99: {
                this.keyPressed_ErrorScreen(key);
                break;
            }
            case 3: {
                this.keyPressed_Menu(key);
                break;
            }
            case 6: {
                this.keyPressed_Options(key);
                break;
            }
            case 4: {
                this.keyPressed_HelpAbout(key);
                break;
            }
            case 5: {
                this.keyPressed_HelpAbout(key);
                break;
            }
            case 10: {
                this.keyPressed_GameDialog(key);
                break;
            }
            case 89: {
                this.keyPressed_Finish(key);
            }
        }
    }

    protected void keyRepeated(int key) {
        if (isAnimationIconsInProgress && this.itemSelected != this.itemDest) {
            return;
        }
        if (this.getGameAction(key) == 8) {
            return;
        }
        this.keyPressed(key);
    }

    public int getGameAction(int key) {
        if (key == KEY_SOFTKEY1) {
            return 8;
        }
        try {
            return super.getGameAction(key);
        }
        catch (IllegalArgumentException er) {
            return 0;
        }
    }

    public static void loadSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Settings", (boolean)false);
            byte[] input = rs.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(input);
            DataInputStream dis = new DataInputStream(bais);
            isEnabledMusic = dis.readBoolean();
            volumeMusic = dis.readInt();
            dis.close();
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            isEnabledMusic = true;
            isContinueIconEnabled = false;
            continueFrameId = -1;
            volumeMusic = VOLUME_MAX / 2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void writeSettings() {
        try {
            RecordStore.deleteRecordStore((String)"Settings");
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bao);
            dos.writeBoolean(isEnabledMusic);
            dos.writeInt(volumeMusic);
            dos.flush();
            rs.addRecord(bao.toByteArray(), 0, bao.toByteArray().length);
            dos.close();
            rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void startApp() {
        new OperationThread(1).start();
    }

    public Hashtable loadConfFile() {
        DataInputStream dis = null;
        Hashtable<String, String> hash = new Hashtable<String, String>();
        String[] conf_files = new String[]{"/lang.txt.JUTF", "/conf.txt.JUTF", "/about.txt.JUTF"};
        int i = -1;
        for (i = 0; i < conf_files.length; ++i) {
            try {
                dis = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(conf_files[i]));
                if (dis == null) {
                    this.showErrorScreen("Can't load conf file!");
                    return null;
                }
                String line = null;
                while ((line = dis.readUTF()) != null) {
                    if (line.length() <= 0 || line.indexOf(61) < 0) continue;
                    hash.put(line.substring(0, line.indexOf(61)), line.substring(line.indexOf(61) + 1));
                }
                dis.close();
                continue;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return hash;
    }

    public int getConfInt(Object name) {
        try {
            return Integer.parseInt((String)this.conf.get(name));
        }
        catch (Exception ex) {
            this.showErrorScreen("Can't read " + name);
            return 0;
        }
    }

    public int getConfHex(Object name) {
        try {
            return Integer.parseInt((String)this.conf.get(name), 16);
        }
        catch (Exception ex) {
            this.showErrorScreen("Can't read " + name);
            return 0;
        }
    }

    public String getConfString(Object name) {
        String val = (String)this.conf.get(name);
        if (val == null) {
            this.showErrorScreen("Can't read '" + name);
            return null;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadScenario() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("scenario.txt.JUTF");
        if (is == null) {
            this.showErrorScreen("Scenario file missing!");
            return;
        }
        DataInputStream dis = new DataInputStream(is);
        if (dis == null) {
            this.showErrorScreen("Scenario file missing!");
            return;
        }
        this.scenario = new Vector(100);
        String header = null;
        FrameOfScenario fos = null;
        try {
            while (true) {
                int i;
                int count;
                if ((header = dis.readUTF()).length() == 0) {
                    continue;
                }
                int id = Integer.parseInt(header.substring(1, 4));
                if (this.scenario.size() > id && this.scenario.elementAt(id) != null) {
                    this.showErrorScreen("Frame " + id + " already exists!");
                    return;
                }
                char imageId = header.charAt(5);
                char type = header.charAt(6);
                int paramCount = count = header.charAt(8) - 48;
                if (type == 'A') {
                    paramCount = 2 * count + 1;
                    count += 2;
                } else if (type == 'C') {
                    paramCount = count + 1;
                } else if (type == 'J') {
                    ++paramCount;
                    ++paramCount;
                    ++count;
                }
                fos = new FrameOfScenario(id, imageId, type, count, paramCount);
                for (i = 0; i < count * 2; ++i) {
                    fos.headIds[i] = header.charAt(10 + i) - 65;
                }
                for (i = 0; i < paramCount; ++i) {
                    fos.nextId[i] = Integer.parseInt(header.substring(count * 2 + 11 + i * 4, count * 2 + 14 + i * 4));
                }
                for (i = 0; i < count; ++i) {
                    int textWidthSecond;
                    String text = null;
                    text = dis.readUTF();
                    if (type == 'I') {
                        int textWidth = 112;
                        fos.textPlayer[i] = this.fontDialog.wrapString(this.fontMapper.mapString(text), textWidth, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT);
                        continue;
                    }
                    int textWidthFirst = textWidthSecond = 112;
                    if (count > 1 && (type == 'D' || type == 'C' || type == 'J' || type == 'V') || count > 3 && type == 'A') {
                        textWidthFirst = 128 - this.imgArrows.getWidth() - 12;
                    }
                    int[] textMappedFirst = this.fontMapper.mapString(text.substring(0, text.indexOf(35)));
                    int[] textMappedSecond = this.fontMapper.mapString(text.substring(text.indexOf(35) + 1));
                    fos.textPlayer[i] = this.fontDialog.wrapString(textMappedFirst, textWidthFirst, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT);
                    fos.textLady[i] = this.fontDialog.wrapString(textMappedSecond, textWidthSecond, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT);
                }
                if (this.scenario.size() < id + 1) {
                    this.scenario.setSize(id + 1);
                }
                this.scenario.setElementAt(fos, id);
                continue;
                break;
            }
        }
        catch (EOFException ex) {
            return;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            this.showErrorScreen("Can't parse some numbers at\\" + header);
            return;
        }
        catch (StringIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            this.showErrorScreen("Can't parse header at\\" + header);
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.showErrorScreen("Can't read frame at\\" + header);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.showErrorScreen("Unknown error.\\" + ex.getMessage());
            return;
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException ex) {}
            dis = null;
            is = null;
        }
    }

    public void musicStart() {
        new OperationThread(10).start();
    }

    public void musicStop() {
        new OperationThread(11).start();
    }

    public void loadMusicPlayer() {
        try {
            playerMusic = Manager.createPlayer((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/melody.mid"), (String)"audio/midi");
            if (playerMusic == null) {
                isEnabledMusic = false;
                return;
            }
            playerMusic.realize();
            playerMusic.setLoopCount(-1);
        }
        catch (Exception e0) {
            e0.printStackTrace();
            this.showErrorScreen("Can't load music file!\\" + e0.getMessage());
            return;
        }
        VolumeControl vc = (VolumeControl)playerMusic.getControl("VolumeControl");
        vc.setLevel(volumeMusic * 10);
    }

    private void paint_LogoScreen(Graphics g) {
        System.gc();
        if (this.requestSecondLogoDisplayed && this.imgLogoGame != null) {
            g.drawImage(this.imgLogoGame, 64, 80, 1 | 2);
            int width = 128;
            if (this.loadingProgress < 100) {
                g.setColor(COLOR_WHITE);
                this.drawStringOutlined(g, LOGO_TEXT_LOADING, width / 2, 80, 0x20 | 1, COLOR_BLACK, this.fontHelpPlain);
                g.setColor(COLOR_BLACK);
                g.drawRect(width / 2 - LOGO_BAR_WIDTH - 1, 80 + LOGO_BAR_HEIGHT + 1, 2 * (LOGO_BAR_WIDTH + 2) - 3, LOGO_BAR_HEIGHT + 1);
                g.setColor(COLOR_WHITE);
                g.drawRect(width / 2 - LOGO_BAR_WIDTH - 2, 80 + LOGO_BAR_HEIGHT - 1 + 1, 2 * (LOGO_BAR_WIDTH + 2) - 1, LOGO_BAR_HEIGHT + 3);
                g.fillRect(width / 2 - LOGO_BAR_WIDTH, 80 + LOGO_BAR_HEIGHT - 1 + 2 + 1, this.loadingProgress * 2 * LOGO_BAR_WIDTH / 100, LOGO_BAR_HEIGHT);
            } else if (flashState) {
                g.setColor(COLOR_WHITE);
                if (LOGO_TEXT_PRESS_2 == null || LOGO_TEXT_PRESS_2.length == 0) {
                    this.drawStringOutlined(g, LOGO_TEXT_PRESS, width / 2, 80 - this.fontDialog.getHeight() / 2 + 1, 0x10 | 1, COLOR_BLACK, this.fontHelpPlain);
                } else {
                    this.drawStringOutlined(g, LOGO_TEXT_PRESS, width / 2, 80 - this.fontDialog.getHeight() + 1, 0x10 | 1, COLOR_BLACK, this.fontHelpPlain);
                    this.drawStringOutlined(g, LOGO_TEXT_PRESS_2, width / 2, 81, 0x10 | 1, COLOR_BLACK, this.fontHelpPlain);
                }
            }
        } else if (this.imgLogoBrand != null) {
            g.setColor(COLOR_WHITE);
            g.fillRect(0, 0, 128, 160);
            g.drawImage(this.imgLogoBrand, 64, 80, 1 | 2);
        }
    }

    private void keyPressed_LogoScreen(int key) {
        if (this.loadingProgress == 100 && this.requestSecondLogoDisplayed) {
            stopFlashing = true;
            this.imgLogoBrand = null;
            this.imgCurrentBackground = this.imgLogoGame;
            this.imgCurrentImage = this.imgLogoGame;
            this.imgLogoGame = null;
            System.gc();
            this.showEnableSound();
        }
    }

    private void showMenuMain(boolean reset) {
        this.keysBlocked = true;
        if (this.imgLogoGame != null) {
            this.imgCurrentImage = this.imgLogoGame;
            this.imgLogoGame = null;
        } else {
            this.imgCurrentImage = null;
            System.gc();
            try {
                this.imgCurrentImage = Image.createImage((String)"/title.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.menuTypeRequested = 1;
        if (isContinueIconEnabled) {
            this.itemsRequested = MENU_ITEMS_MAIN_WITH_ARCADE;
            this.itemsIconIndexesRequested = MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES;
        } else {
            this.itemsRequested = MENU_ITEMS_MAIN;
            this.itemsIconIndexesRequested = MENU_ITEMS_MAIN_ICONS_INDEXES;
        }
        this.interIcon = (128 - MENU_ICONS_WIDTH * MENU_ICONS_ON_SCREEN) / MENU_ICONS_ON_SCREEN;
        this.isImageBlured = false;
        if (reset) {
            this.itemSelectedRequested = 0;
        }
        new OperationThread(4, 3).start();
        this.keysBlocked = false;
    }

    private void showInGameMain(boolean reset) {
        this.previousScreenStack.addElement(new Integer(currentScreen));
        if (reset) {
            this.itemSelectedRequested = 0;
        }
        this.menuTypeRequested = 2;
        this.itemsRequested = MENU_ITEMS_INGAME;
        this.itemsIconIndexesRequested = MENU_ITEMS_INGAME_ICONS_INDEXES;
        stopAnimateGame = true;
        new OperationThread(4, 3).start();
    }

    private void showEnableSound() {
        this.itemSelectedRequested = isEnabledMusic ? 1 : 0;
        this.menuTypeRequested = 3;
        this.itemsRequested = MENU_ITEMS_ENABLE_SOUND;
        this.itemsIconIndexesRequested = MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES;
        this.interIcon = (128 - this.imgIconsMain.getHeight() * MENU_ICONS_ON_SCREEN) / MENU_ICONS_ON_SCREEN;
        new OperationThread(4, 3).start();
    }

    private void paint_Menu(Graphics g) {
        if (!this.paint_MenuBackground(g)) {
            return;
        }
        int iconX = 64 - MENU_ICONS_WIDTH / 2;
        int cursorPosY = 80 - MENU_FIELD_HEIGHT + MENU_ICONS_POSITION;
        if (this.menuTypeCurrent == 3) {
            g.setClip(iconX - 2, Math.max(cursorPosY - 2, 80 - this.menuFieldHeightCurrentBlocked + 1), MENU_ICONS_WIDTH + 4, Math.min(this.imgIconsMain.getHeight() + 4, 2 * this.menuFieldHeightCurrentBlocked - 1));
        }
        for (int i = -(MENU_ICONS_ON_SCREEN / 2) - 1; i <= MENU_ICONS_ON_SCREEN / 2 + 1; ++i) {
            this.drawSprite(g, this.imgIconsMain, iconX + i * (MENU_ICONS_WIDTH + this.interIcon) - this.itemOffset, cursorPosY, MENU_ICONS_WIDTH, this.imgIconsMain.getHeight(), this.itemsIconIndexes[this.mod(i + this.itemSelected, this.items.length)] * MENU_ICONS_WIDTH, 0);
        }
        if (this.menuTypeCurrent == 3) {
            g.setClip(0, 80 - this.menuFieldHeightCurrentBlocked + 1, 128, 2 * this.menuFieldHeightCurrentBlocked - 1);
        }
        g.drawRect(iconX - 4, cursorPosY - 4, MENU_ICONS_WIDTH + 7, this.imgIconsMain.getHeight() + 7);
        g.drawRect(iconX - 3, cursorPosY - 3, MENU_ICONS_WIDTH + 5, this.imgIconsMain.getHeight() + 5);
        cursorPosY = 80 + MENU_FIELD_HEIGHT - MENU_TEXT_MARGIN;
        if (this.items2[this.mod(this.itemDest, this.items.length)] == null || this.items2[this.mod(this.itemDest, this.items.length)].length == 0) {
            this.fontMenu.drawString(g, this.items[this.mod(this.itemDest, this.items.length)], 64, cursorPosY, 1 | 0x20);
        } else {
            this.fontMenu.drawString(g, this.items[this.mod(this.itemDest, this.items.length)], 64, cursorPosY - this.fontMenu.getHeight() / 2, 1 | 0x20);
            this.fontMenu.drawString(g, this.items2[this.mod(this.itemDest, this.items.length)], 64, cursorPosY + this.fontMenu.getHeight() / 2, 1 | 0x20);
        }
        this.drawSprite(g, this.imgArrows, 0 + MENU_ARROW_SIDE_MARGIN + this.arrowOffset, cursorPosY -= this.fontMenu.getHeight() / 2 + this.imgArrows.getHeight() / 4, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, 0, 0);
        this.drawSprite(g, this.imgArrows, 128 - MENU_ARROW_SIDE_MARGIN - this.arrowOffset - this.imgArrows.getWidth() / 2, cursorPosY, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, this.imgArrows.getWidth() / 2, 0);
        this.drawMenuBorders(g);
    }

    public boolean paint_MenuBackground(Graphics g) {
        if (this.imgCurrentImage != null) {
            g.drawImage(this.imgCurrentImage, 0, 0, 0x10 | 4);
        }
        if (this.menuFieldHeightCurrent == 0) {
            return false;
        }
        g.setColor(MENU_FIELD_BORDER_COLOR);
        this.menuFieldHeightCurrentBlocked = this.menuFieldHeightCurrent;
        int top = 80 - this.menuFieldHeightCurrentBlocked;
        int bottom = 80 + this.menuFieldHeightCurrentBlocked;
        g.setClip(0, top, this.getWidth(), 2 * this.menuFieldHeightCurrentBlocked);
        g.drawImage(this.imgTransparent, 0, 0, 0);
        return true;
    }

    private void drawMenuBorders(Graphics g) {
        g.setClip(0, 0, this.getWidth(), this.getHeight());
        g.setColor(0);
        int top = 80 - this.menuFieldHeightCurrentBlocked;
        int bottom = 80 + this.menuFieldHeightCurrentBlocked;
        g.drawLine(0, top, this.getWidth(), top);
        g.drawLine(0, bottom - 1, this.getWidth(), bottom - 1);
    }

    private void keyPressed_Menu(int key) {
        if (isAnimationFieldResizeInProgress) {
            return;
        }
        if (Math.abs(this.itemSelected - this.itemDest) >= this.items.length) {
            return;
        }
        switch (this.getGameAction(key)) {
            case 2: {
                if (this.menuTypeCurrent == 3) {
                    this.itemDest = --this.itemSelected;
                    break;
                }
                --this.itemDest;
                break;
            }
            case 5: {
                if (this.menuTypeCurrent == 3) {
                    this.itemDest = ++this.itemSelected;
                    break;
                }
                ++this.itemDest;
                break;
            }
            case 8: {
                if (this.itemSelected != this.itemDest) break;
                this.itemDest = this.itemSelected = this.mod(this.itemSelected, this.items.length);
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_MAIN_START) {
                    this.showGameScreen(true);
                    break;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_ARCADE) {
                    this.showGameScreen(continueFrameId);
                    break;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_FOTO_DEBUG) {
                    this.showGameScreen(58);
                    break;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_CONTINUE) {
                    new OperationThread(4, (Integer)this.previousScreenStack.pop()).start();
                    new OperationThread(6).start();
                    break;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_ABOUT) {
                    this.showHelpAbout(4);
                    return;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_INSTRUCTIONS) {
                    this.showHelpAbout(5);
                    return;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_OPTIONS) {
                    this.showOptions();
                    return;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_GOTO_MAIN) {
                    stopAnimateGame = true;
                    this.currentFrame = null;
                    this.currentImageId = -1;
                    this.isArcadeModeActive = false;
                    this.whosTalking = -1;
                    this.arcadeState = -1;
                    this.currentClothes = ARCADE_CLOTHES_INITIAL;
                    this.requestedArcadeNextFrame = -1;
                    this.playerTextSelected = 0;
                    this.currentClothesVisible = false;
                    isContinueIconEnabled = false;
                    this.isImageBlured = false;
                    this.showMenuMain(true);
                    break;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MENU_EXIT) {
                    stopMenuAnimation = true;
                    this.pause(50);
                    new OperationThread(99).start();
                    return;
                }
                if (this.itemsNonWrap[this.itemSelected] == TEXT_MUSIC_OFF) {
                    isEnabledMusic = false;
                    gameStarted = true;
                    this.showMenuMain(true);
                    break;
                }
                if (this.itemsNonWrap[this.itemSelected] != TEXT_MUSIC_ON) break;
                isEnabledMusic = true;
                gameStarted = true;
                new OperationThread(10).start();
                this.showMenuMain(true);
            }
        }
    }

    private void showOptions() {
        this.optionItemSelected = 0;
        this.previousScreenStack.push(new Integer(currentScreen));
        new OperationThread(4, 6).start();
        new OperationThread(9).start();
    }

    private void paint_Options(Graphics g) {
        if (!this.paint_MenuBackground(g)) {
            return;
        }
        for (int i = 0; i < OPTIONS_TEXTS.length; ++i) {
            int top = 80 - OPTIONS_FIELD_HEIGHT + 3 * this.optionInterline / 2 - 1 + (OPTIONS_TEXTS.length - 1 - i) * (this.fontMenu.getHeight() + this.optionInterline);
            String text = OPTIONS_TEXTS[i];
            if (OPTIONS_TEXTS[i] == OPTION_TEXT_MUSIC) {
                text = text + ": " + volumeMusic;
            } else if (OPTIONS_TEXTS[i] == OPTION_TEXT_ENABLE_SOUND) {
                text = isEnabledMusic ? text + ": " + OPTION_TEXT_YES : text + ": " + OPTION_TEXT_NO;
            }
            this.fontMenu.drawString(g, this.fontMapper.mapString(text), 64, top, 1 | 0x10);
            if (this.optionItemSelected != i) continue;
            g.setColor(this.frameColor);
            g.drawRect(2, top, 123, this.fontMenu.getHeight() + 1);
            g.drawRect(1, top - 1, 125, this.fontMenu.getHeight() + 3);
            if (this.optionItemSelected > 0) {
                this.drawSprite(g, this.imgArrows, MENU_ARROW_SIDE_MARGIN + this.arrowOffset / 2, top + 1 + this.fontMenu.getHeight() / 2 - this.imgArrows.getHeight() / 4, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, 0, 0);
                this.drawSprite(g, this.imgArrows, 128 - MENU_ARROW_SIDE_MARGIN - this.arrowOffset / 2 - this.imgArrows.getWidth() / 2, top + 1 + this.fontMenu.getHeight() / 2 - this.imgArrows.getHeight() / 4, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, this.imgArrows.getWidth() / 2, 0);
            }
            g.setColor(0);
        }
        this.drawMenuBorders(g);
    }

    private void keyPressed_Options(int key) {
        if (isAnimationFieldResizeInProgress) {
            return;
        }
        switch (this.getGameAction(key)) {
            case 2: {
                if (OPTIONS_TEXTS[this.optionItemSelected] == OPTION_TEXT_MUSIC && volumeMusic > 1) {
                    --volumeMusic;
                }
                if (OPTIONS_TEXTS[this.optionItemSelected] == OPTION_TEXT_ENABLE_SOUND) {
                    boolean bl = isEnabledMusic = !isEnabledMusic;
                    if (isEnabledMusic) {
                        new OperationThread(10).start();
                    } else {
                        new OperationThread(11).start();
                    }
                }
                this.repaint();
                break;
            }
            case 5: {
                if (OPTIONS_TEXTS[this.optionItemSelected] == OPTION_TEXT_MUSIC && volumeMusic < VOLUME_MAX) {
                    ++volumeMusic;
                }
                if (OPTIONS_TEXTS[this.optionItemSelected] == OPTION_TEXT_ENABLE_SOUND) {
                    boolean bl = isEnabledMusic = !isEnabledMusic;
                    if (isEnabledMusic) {
                        new OperationThread(10).start();
                    } else {
                        new OperationThread(11).start();
                    }
                }
                this.repaint();
                break;
            }
            case 1: {
                this.optionItemSelected = this.mod(++this.optionItemSelected, OPTIONS_TEXTS.length);
                this.repaint();
                break;
            }
            case 6: {
                this.optionItemSelected = this.mod(--this.optionItemSelected, OPTIONS_TEXTS.length);
                this.repaint();
                break;
            }
            case 8: {
                if (OPTIONS_TEXTS[this.optionItemSelected] != OPTION_TEXT_OK) break;
                new OperationThread(4, (Integer)this.previousScreenStack.pop()).start();
                stopFrameColorAnimation = true;
            }
        }
        if (isEnabledMusic) {
            switch (this.getGameAction(key)) {
                case 2: 
                case 5: {
                    try {
                        VolumeControl vc = (VolumeControl)playerMusic.getControl("VolumeControl");
                        if (vc == null) break;
                        vc.setLevel(volumeMusic * 10);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void showHelpAbout(int type) {
        System.gc();
        this.previousScreenStack.addElement(new Integer(currentScreen));
        this.helpAboutTextLines = type == 5 ? this.HELP_TEXT_LINES : this.ABOUT_TEXT_LINES;
        this.helpTextFirstLine = 0;
        new OperationThread(4, 5).start();
    }

    private void paint_HelpAbout(Graphics g) {
        if (!this.paint_MenuBackground(g)) {
            return;
        }
        g.setColor(0);
        for (int i = 0; i < this.helpTextLinesOnScreen && i < this.helpAboutTextLines.length; ++i) {
            VectorFont currentLineFont;
            int[] line = this.helpAboutTextLines[i + this.helpTextFirstLine];
            if (line != null && line.length > 0 && (line[0] & 0xFF) == this.SPECIAL_CHAR_BOLD) {
                line = a.substring(line, 1);
                currentLineFont = this.fontHelpBold;
            } else {
                currentLineFont = this.fontHelpPlain;
            }
            int top = 80 - HELP_FIELD_HEIGHT + this.HELP_TEXT_TOP_MARGIN + i * (this.fontHelpPlain.getHeight() + HELP_TEXT_INTERLINE);
            if (top + this.fontHelpPlain.getHeight() <= 80 - this.menuFieldHeightCurrentBlocked || top >= 80 + this.menuFieldHeightCurrentBlocked) continue;
            currentLineFont.drawString(g, line, 64 - this.imgArrows.getWidth() / 4, top, 0x10 | 1);
        }
        if (this.helpTextFirstLine > 0) {
            this.drawSprite(g, this.imgArrows, 128 - this.imgArrows.getWidth() / 2 - 2, 80 - HELP_FIELD_HEIGHT + this.arrowOffset / 2, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, 0, this.imgArrows.getHeight() / 2);
        }
        if (this.helpTextFirstLine < this.helpAboutTextLines.length - this.helpTextLinesOnScreen) {
            this.drawSprite(g, this.imgArrows, 128 - this.imgArrows.getWidth() / 2 - 2, 80 + HELP_FIELD_HEIGHT - this.imgArrows.getHeight() / 2 - this.arrowOffset / 2, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2);
        }
        this.drawMenuBorders(g);
    }

    private void keyPressed_HelpAbout(int key) {
        if (isAnimationFieldResizeInProgress) {
            return;
        }
        switch (this.getGameAction(key)) {
            case 1: {
                if (this.helpTextFirstLine > 0) {
                    --this.helpTextFirstLine;
                }
                this.repaint();
                break;
            }
            case 6: {
                if (this.helpTextFirstLine < this.helpAboutTextLines.length - this.helpTextLinesOnScreen) {
                    ++this.helpTextFirstLine;
                }
                this.repaint();
                break;
            }
            case 8: {
                new OperationThread(4, (Integer)this.previousScreenStack.pop()).start();
            }
        }
    }

    private void showFinish() {
        new OperationThread(4, 89).start();
    }

    private void paint_Finish(Graphics g) {
        if (!this.paint_MenuBackground(g)) {
            return;
        }
        int cursorPosY = 80 - FINISH_FIELD_HEIGHT + FINISH_MARGIN;
        if (this.currentFrame != null && this.currentFrame.textLady[0][0][0] != this.fontMapper.mapString("(-)")[0]) {
            this.fontMenu.drawString(g, this.currentFrame.textLady[0][0], 64, cursorPosY, 1 | 0x10);
            cursorPosY = 80 + FINISH_FIELD_HEIGHT - FINISH_MARGIN;
        } else {
            cursorPosY = 80 + this.fontMenu.getHeight() / 2;
        }
        this.fontMenu.drawString(g, FINISH_END_TEXT, 64, cursorPosY, 1 | 0x20);
        this.drawMenuBorders(g);
    }

    private void keyPressed_Finish(int key) {
        if (isAnimationFieldResizeInProgress) {
            return;
        }
        switch (this.getGameAction(key)) {
            case 8: {
                stopAnimateGame = true;
                this.currentFrame = null;
                this.currentClothesVisible = false;
                this.currentClothes = ARCADE_CLOTHES_INITIAL;
                this.imgCurrentBackground = null;
                System.gc();
                this.showMenuMain(true);
            }
        }
    }

    protected void hideNotify() {
        gamePaused = true;
        if (gameStarted && isEnabledMusic && playerMusic != null) {
            if (playerMusic.getState() == 400) {
                this.musicStop();
            }
        }
    }

    protected void showNotify() {
        if (gameStarted && isEnabledMusic && playerMusic != null) {
            if (playerMusic.getState() != 400) {
                this.musicStart();
            }
        }
        gamePaused = false;
    }

    public void showGameScreen(boolean newGame) {
        this.colorChangeDirection = COLOR_CHANGE_STEP;
        this.colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_LIGHT;
        this.arrowDialogMovementDirection = DIALOG_ARROW_MOVEMENT_STEP;
        this.arrowDialogOffset = 0;
        this.arrowDialogMovementDirection = DIALOG_ARROW_MOVEMENT_STEP;
        this.currentClothes = ARCADE_CLOTHES_INITIAL;
        isContinueIconEnabled = false;
        new OperationThread(4, 10).start();
        if (newGame) {
            this.currentFrame = null;
            this.whosTalking = -1;
            this.currentImageId = 0;
            this.framesStates = null;
            System.gc();
            this.framesStates = new int[this.scenario.size()];
        }
        this.nextGameStep();
        new OperationThread(6).start();
    }

    public void showGameScreen(int initialFrame) {
        this.currentFrame = new FrameOfScenario(0, 0, 73, 1, 1);
        this.currentFrame.nextId[0] = initialFrame;
        this.currentImageId = -1;
        this.framesStates[70] = 0;
        this.showGameScreen(false);
    }

    public void paint_GameDialog(Graphics g) {
        if (this.enableHudArrowCapture && this.arcadeState == 2) {
            this.arrowHudOffsetHorizontal = this.arrowHudOffset;
        } else if (this.enableHudArrowCapture && this.arcadeState == 3) {
            this.arrowHudOffsetVertical = this.arrowHudOffset;
        }
        g.drawImage(this.imgCurrentImage, 0, 0, 0x10 | 4);
        int DIALOG_TEXT_INTERLINE = 0;
        int DIALOG_TEXT_OFFSET = -1;
        int DIALOG_BOX_ADDITIONAL_SPACE = 5;
        this.boxHeight = this.curentTextShownWrapped != null ? this.curentTextShownWrapped[this.playerTextSelected].length * (this.fontDialog.getHeight() + DIALOG_TEXT_INTERLINE) + DIALOG_BOX_ADDITIONAL_SPACE + 2 * DIALOG_TEXT_INTERLINE : 0;
        int upperBox = 160 - this.boxHeight;
        if (this.isArcadeModeActive && this.shownHintId < 0) {
            if (this.arcadeState == 2 || this.arcadeState == 3) {
                this.prevArrowHX = this.arrowHudOffsetHorizontal != 0 ? 64 + this.HUD_OFFSET + ARCADE_ARROW_OFFSET_X + this.arrowHudOffsetHorizontal * this.HUD_LINES_SPACE + this.arrowHudOffsetHorizontal / Math.abs(this.arrowHudOffsetHorizontal) * this.HUD_CENTER_SPACE : 64 + this.HUD_OFFSET + ARCADE_ARROW_OFFSET_X;
                this.prevArrowHH = this.HUD_LINES_HEIGHT;
                this.prevArrowHY = 80 - (this.prevArrowHH >> 1) + ARCADE_ARROW_OFFSET_Y;
                g.setColor(COLOR_HUD_ACTIVE);
                g.fillRect(this.prevArrowHX, this.prevArrowHY, this.HUD_LINES_WIDTH, this.prevArrowHH);
                this.prevArrowHudOffsetHorizontal = this.arrowHudOffsetHorizontal;
            }
            if (this.arcadeState == 3) {
                this.prevArrowVY = this.arrowHudOffsetVertical != 0 ? 80 + this.HUD_OFFSET + ARCADE_ARROW_OFFSET_Y + this.arrowHudOffsetVertical * this.HUD_LINES_SPACE + this.arrowHudOffsetVertical / Math.abs(this.arrowHudOffsetVertical) * this.HUD_CENTER_SPACE : 80 + this.HUD_OFFSET + ARCADE_ARROW_OFFSET_Y;
                this.prevArrowVW = this.HUD_LINES_HEIGHT;
                this.prevArrowVX = 64 - this.prevArrowVW / 2 + ARCADE_ARROW_OFFSET_X;
                g.setColor(COLOR_HUD_ACTIVE);
                g.fillRect(this.prevArrowVX, this.prevArrowVY, this.prevArrowVW, this.HUD_LINES_WIDTH);
                this.prevArrowHudOffsetVertical = this.arrowHudOffsetVertical;
            }
        }
        if (this.arcadeState != 2 && this.arcadeState != 3 && this.whosTalking != 0) {
            boolean blinking = false;
            if (this.whosTalking == 1 && (this.currentFrame.type == 68 || this.currentFrame.type == 67 || this.currentFrame.type == 74 || this.currentFrame.type == 86) && this.currentFrame.selectionsCount > 1 || this.whosTalking == 1 && this.arcadeState == 1 && this.currentFrame.selectionsCount > 3) {
                blinking = true;
            }
            if (this.whosTalking == 1 && (this.currentFrame.type == 74 || this.currentFrame.type == 86)) {
                blinking = false;
            }
            if (this.whosTalking == 1 || this.whosTalking == 3) {
                if (this.currentFrame.headIds[this.playerTextSelected] >= 0) {
                    this.drawSprite(g, this.imgFaces, 5, upperBox - 1 - this.imgFaces.getHeight(), this.imgFaces.getHeight(), this.imgFaces.getHeight(), this.imgFaces.getHeight() * this.currentFrame.headIds[this.playerTextSelected], 0);
                }
                if (blinking) {
                    g.setColor(this.colorDialogPlayer);
                } else if (this.currentFrame.headIds[this.playerTextSelected] >= 0) {
                    g.setColor(COLOR_DIALOG_BKG_PLAYER_DARK);
                } else {
                    g.setColor(COLOR_DIALOG_BKG_INFO);
                }
            } else if (this.whosTalking == 2 && this.currentFrame.headIds[this.playerTextSelected + this.currentFrame.selectionsCount] >= 0) {
                this.drawSprite(g, this.imgFaces, 5, upperBox - 1 - this.imgFaces.getHeight(), this.imgFaces.getHeight(), this.imgFaces.getHeight(), this.imgFaces.getHeight() * this.currentFrame.headIds[this.playerTextSelected + this.currentFrame.selectionsCount], 0);
            }
            switch (this.currentFrame.headIds[this.playerTextSelected + (this.whosTalking == 2 ? this.currentFrame.selectionsCount : 0)]) {
                case 0: {
                    if (blinking) {
                        g.setColor(this.colorDialogPlayer);
                        break;
                    }
                    g.setColor(COLOR_DIALOG_BKG_PLAYER_DARK);
                    break;
                }
                case 1: 
                case 2: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_MAN);
                    break;
                }
                default: {
                    g.setColor(COLOR_DIALOG_BKG_INFO);
                }
            }
            g.fillRoundRect(0, upperBox - 1, 127, 160 - upperBox, 12, 12);
            g.setColor(COLOR_WHITE);
            g.drawRoundRect(0, upperBox - 1, 127, 160 - upperBox, 12, 12);
            g.setColor(COLOR_BLACK);
            g.drawRoundRect(1, upperBox, 125, 160 - upperBox - 2, 12, 12);
            g.setColor(COLOR_BLACK);
            if (this.curentTextShownWrapped != null) {
                this.drawTextLines(g, this.curentTextShownWrapped[this.playerTextSelected], 64, (160 + upperBox + DIALOG_TEXT_OFFSET) / 2, this.fontDialog, true, DIALOG_TEXT_INTERLINE);
            }
            if (blinking) {
                this.drawSprite(g, this.imgArrows, DIALOG_ARROW_MARGIN + this.arrowDialogOffset / 100 + 1, (160 + upperBox) / 2 - this.imgArrows.getHeight() / 4 - 1, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, 0, 0);
                this.drawSprite(g, this.imgArrows, 128 - DIALOG_ARROW_MARGIN - this.imgArrows.getWidth() / 2 - this.arrowDialogOffset / 100, (160 + upperBox) / 2 - this.imgArrows.getHeight() / 4 - 1, this.imgArrows.getWidth() / 2, this.imgArrows.getHeight() / 2, this.imgArrows.getWidth() / 2, 0);
            }
        }
        this.drawHint(g, this.shownHintId);
    }

    public void enableShowHint(int requestedHintId) {
        this.shownHintId = requestedHintId;
    }

    public void drawHint(Graphics g, int hintId) {
        if (hintId >= 0) {
            int[][] hintLines = this.fontDialog.wrapString(HINTS_TEXTS[hintId], 115, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT);
            for (int i = 0; i < hintLines.length; ++i) {
                g.setColor(COLOR_WHITE);
                this.drawStringOutlined(g, hintLines[i], 64, 80 - hintLines.length * this.fontDialog.getHeight() / 2 + i * this.fontDialog.getHeight(), 1 | 0x10, COLOR_BLACK, this.fontHelpPlain);
            }
        }
    }

    public void keyPressed_GameDialog(int key) {
        if (this.shownHintId == 3) {
            this.arrowHudOffset = -100;
            this.shownHintId = -1;
            this.requestImageUpdate(this.currentFrame.imageId, true);
            this.enableHudArrowCapture = true;
            return;
        }
        this.shownHintId = -1;
        if (key == KEY_SOFTKEY2 || key == -KEY_SOFTKEY2) {
            this.showInGameMain(true);
            return;
        }
        if (this.getGameAction(key) == 8) {
            this.nextGameStep();
            return;
        }
        int selectionCount = -1;
        if ((this.currentFrame.type == 68 || this.currentFrame.type == 67) && this.whosTalking == 1) {
            selectionCount = this.currentFrame.selectionsCount;
        }
        if (this.currentFrame.type == 65 && this.arcadeState == 1 && this.whosTalking == 1) {
            selectionCount = this.currentFrame.selectionsCount - 2;
        }
        if (selectionCount > 0) {
            switch (this.getGameAction(key)) {
                case 5: {
                    this.playerTextSelected = this.mod(++this.playerTextSelected, selectionCount);
                    this.repaint();
                    return;
                }
                case 2: {
                    this.playerTextSelected = this.mod(--this.playerTextSelected, selectionCount);
                    this.repaint();
                    return;
                }
            }
        }
        if (this.currentFrame.type == 65) {
            return;
        }
        if (key == 1 || key == 6 || key == 2 || key == 5) {
            return;
        }
        if (this.whosTalking != 1 || this.currentFrame.textPlayer.length <= 1) {
            GameScreen.hintUsed[1] = false;
            this.enableShowHint(1);
            this.repaint();
        }
    }

    public void nextGameStep() {
        this.nextGameStepImpl();
        if (this.currentFrame.type == 69 && this.whosTalking != 1) {
            return;
        }
        if (this.curentTextShownWrapped != null && this.curentTextShownWrapped[this.playerTextSelected][0][0] == this.fontMapper.mapString("(-)")[0]) {
            this.nextGameStep();
            return;
        }
    }

    private void nextGameStepImpl() {
        if (!(this.arcadeState != 2 && this.arcadeState != 3 || this.enableHudArrowCapture)) {
            return;
        }
        if (this.whosTalking == 1) {
            this.whosTalking = 2;
            this.curentTextShownWrapped = this.currentFrame.textLady;
            this.repaint();
            return;
        }
        if (this.isArcadeModeActive) {
            if (this.arcadeState == 1) {
                this.arcadeState = 5;
                this.whosTalking = 1;
                this.curentTextShownWrapped = this.currentFrame.textPlayer;
                this.currentClothes = this.currentFrame.nextId[2 * this.playerTextSelected + 1];
                this.framesStates[this.currentFrame.id] = this.playerTextSelected + 1;
                this.playerTextSelected = this.curentTextShownWrapped.length - 2;
                this.requestImageUpdate(this.currentFrame.imageId, true);
                this.repaint();
                return;
            }
            if (this.arcadeState == 5) {
                this.playerTextSelected = this.framesStates[this.currentFrame.id] - 1;
                this.requestedArcadeNextFrame = 2 * this.playerTextSelected + 2;
                this.arcadeState = 2;
                this.enableHudArrowCapture = true;
                if (!hintUsed[3]) {
                    this.enableShowHint(3);
                    GameScreen.hintUsed[3] = true;
                    this.enableHudArrowCapture = false;
                }
                this.whosTalking = 3;
                this.requestImageUpdate(this.currentFrame.imageId, true);
                this.repaint();
                return;
            }
            if (this.arcadeState == 2) {
                this.enableHudArrowCapture = false;
                this.arrowHudOffsetHorizontal = this.arrowHudOffsetHorizontal;
                this.repaint();
                this.serviceRepaints();
                this.whosTalking = 3;
                this.pause(700);
                this.arcadeState = 3;
                this.arrowHudOffsetVertical = this.arrowHudOffset;
                this.requestImageUpdate(this.currentFrame.imageId, false);
                this.enableHudArrowCapture = true;
                return;
            }
            if (this.arcadeState == 3) {
                this.enableHudArrowCapture = false;
                this.arrowHudOffsetVertical = this.arrowHudOffsetVertical;
                this.repaint();
                this.serviceRepaints();
                this.pause(350);
                if (Math.abs(this.arrowHudOffsetHorizontal) <= WINNING_AREA_RADIUS && Math.abs(this.arrowHudOffsetVertical) <= WINNING_AREA_RADIUS) {
                    this.isArcadeGameWon = true;
                    this.isImageBlured = false;
                } else {
                    this.isArcadeGameWon = false;
                    this.isImageBlured = true;
                }
                this.arcadeState = 4;
                this.whosTalking = 2;
                this.playerTextSelected = this.currentFrame.selectionsCount - 2;
                this.curentTextShownWrapped = this.currentFrame.textLady;
                this.requestImageUpdate(this.currentFrame.imageId, true);
                this.repaint();
                return;
            }
            if (this.arcadeState == 4) {
                if (this.isArcadeGameWon) {
                    this.playerTextSelected = this.currentFrame.selectionsCount - 1;
                    this.whosTalking = 1;
                    this.curentTextShownWrapped = this.currentFrame.textPlayer;
                    this.isArcadeModeActive = false;
                    isContinueIconEnabled = false;
                    this.repaint();
                    return;
                }
                this.isArcadeModeActive = false;
                if (this.isArcadeGameWon) {
                    this.arcadeState = -1;
                }
                this.requestedArcadeNextFrame = -1;
                isContinueIconEnabled = true;
                this.playerTextSelected = 0;
                this.whosTalking = 1;
            }
        }
        if (this.currentFrame == null) {
            this.currentFrame = (FrameOfScenario)this.scenario.firstElement();
            this.whosTalking = 1;
            this.isImageBlured = false;
        } else if (!this.isArcadeModeActive) {
            if (this.currentFrame.type == 69) {
                this.curentTextShownWrapped = this.currentFrame.textLady;
                new OperationThread(4, 89).start();
                return;
            }
            if (this.currentFrame.type == 74) {
                this.requestedArcadeNextFrame = this.framesStates[this.currentFrame.nextId[0]] + 1;
            }
            if (this.requestedArcadeNextFrame > 0) {
                this.switchCurrentFrameTo(this.currentFrame.nextId[this.requestedArcadeNextFrame]);
                this.requestedArcadeNextFrame = -1;
                if (this.currentFrame.type != 65 && this.arcadeState == 4) {
                    this.arcadeState = -1;
                }
            } else {
                if (!this.isArcadeModeActive && this.currentFrame.type != 65 && this.arcadeState == 4) {
                    this.arcadeState = -1;
                }
                this.switchCurrentFrameTo(this.currentFrame.nextId[this.playerTextSelected]);
            }
            if (this.isArcadeDialogDiscard) {
                this.isArcadeDialogDiscard = false;
                if (this.currentFrame.type == 65) {
                    this.isArcadeModeActive = true;
                    this.whosTalking = 2;
                    this.arcadeState = 1;
                    if (this.framesStates[this.currentFrame.id] > 0) {
                        this.playerTextSelected = this.framesStates[this.currentFrame.id] - 1;
                    }
                    this.nextGameStep();
                    return;
                }
                this.currentFrame = (FrameOfScenario)this.scenario.elementAt(this.currentFrame.nextId[this.playerTextSelected]);
            }
        }
        if (!this.isArcadeModeActive) {
            if (this.currentFrame.type == 68 || this.currentFrame.type == 67 || this.currentFrame.type == 74 || this.currentFrame.type == 86 || this.currentFrame.type == 65 && this.arcadeState == 1) {
                this.whosTalking = 1;
                if (this.currentFrame.type != 74 && this.currentFrame.type != 86) {
                    if (!hintUsed[2] && this.currentFrame.textPlayer.length > 1) {
                        this.enableShowHint(2);
                        GameScreen.hintUsed[2] = true;
                    }
                } else if (!hintUsed[0]) {
                    this.enableShowHint(0);
                    GameScreen.hintUsed[0] = true;
                }
            } else {
                this.whosTalking = 3;
                if (!hintUsed[0]) {
                    this.enableShowHint(0);
                    GameScreen.hintUsed[0] = true;
                }
            }
            if (this.currentFrame.type == 65) {
                this.isArcadeModeActive = true;
                this.arcadeState = 1;
                this.whosTalking = 1;
                this.currentClothesVisible = true;
                if (continueFrameId < 0) {
                    continueFrameId = this.currentFrame.id;
                    isContinueIconEnabled = true;
                }
            }
            if (this.currentFrame.type == 74) {
                this.playerTextSelected = this.framesStates[this.currentFrame.nextId[0]];
            } else if (this.currentFrame.type == 86) {
                this.playerTextSelected = this.framesStates[this.currentFrame.id];
                if (this.playerTextSelected >= this.currentFrame.selectionsCount) {
                    this.playerTextSelected = this.currentFrame.selectionsCount - 1;
                }
            } else {
                this.playerTextSelected = 0;
            }
            if (this.currentFrame.type == 67) {
                this.currentClothes = this.currentFrame.nextId[this.currentFrame.selectionsCount];
                this.currentClothesVisible = true;
            }
        }
        this.curentTextShownWrapped = this.currentFrame.textPlayer;
        this.requestImageUpdate(this.currentFrame.imageId, false);
        this.repaint();
    }

    private void switchCurrentFrameTo(int nextFrameId) {
        if (this.currentFrame.type != 65) {
            this.framesStates[this.currentFrame.id] = this.playerTextSelected + 1;
        }
        if (nextFrameId == 999) {
            nextFrameId = this.previousFrameId;
            this.isArcadeDialogDiscard = true;
        }
        this.previousFrameId = this.currentFrame.id;
        this.currentFrame = (FrameOfScenario)this.scenario.elementAt(nextFrameId);
        if (this.currentFrame.imageId != this.currentImageId) {
            this.currentClothesVisible = false;
        }
    }

    public void requestImageUpdate(int requestedImageId, boolean forceUpdate) {
        System.gc();
        if (this.imgCurrentImage == null || !this.imgCurrentImage.isMutable()) {
            this.imgCurrentImage = Image.createImage((int)128, (int)160);
        }
        if (requestedImageId == 64) {
            requestedImageId = this.currentImageId;
        }
        if (this.currentImageId != requestedImageId) {
            this.imgCurrentBackground = null;
            forceUpdate = true;
            System.gc();
            try {
                this.imgCurrentBackground = Image.createImage((String)("/" + (char)requestedImageId + ".png"));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.showErrorScreen("Cant load /" + (char)requestedImageId + ".png");
                return;
            }
            this.currentImageId = this.currentFrame.imageId;
        }
        if (forceUpdate) {
            Graphics g = this.imgCurrentImage.getGraphics();
            g.drawImage(this.imgCurrentBackground, 0, 0, 0);
            if (this.arcadeState == 4 || this.arcadeState == 2 || this.arcadeState == 3 || this.arcadeState == 1 || this.arcadeState == 5 || this.currentClothesVisible) {
                for (int part = 3; part >= 0; --part) {
                    if ((this.currentClothes & POWERS[part]) <= 0) continue;
                    g.drawImage(this.imgClothesParts[part], CLOTHES_PARTS_POSITIONS_X[part], CLOTHES_PARTS_POSITIONS_Y[part], 0);
                }
            }
            if (this.arcadeState == 4) {
                if (this.isImageBlured) {
                    if (this.imgLadyBlured != null) {
                        g.drawImage(this.imgLadyBlured, 64, 80, 1 | 2);
                    }
                } else if (this.imgFilmFrame != null) {
                    g.drawImage(this.imgFilmFrame, 64, 80, 1 | 2);
                }
            }
            if (this.isArcadeModeActive && (this.arcadeState == 2 || this.arcadeState == 3) && this.imgHud != null && this.shownHintId < 0) {
                g.drawImage(this.imgHud, 0, 80 - this.imgHud.getHeight() / 2, 4 | 0x10);
            }
        }
        if ((this.arcadeState == 2 || this.arcadeState == 3) && this.shownHintId < 0) {
            int[] paintParamString = null;
            VectorFont fontDescription = this.fontHelpBold;
            if (this.arcadeState == 2) {
                paintParamString = ARCADE_PARAM_TEXT_1;
            } else if (this.arcadeState == 3) {
                paintParamString = ARCADE_PARAM_TEXT_2;
            }
            int stringWidth = fontDescription.getStringWidth(paintParamString);
            int stringHeight = fontDescription.getHeight();
            int stringPosX = 125 - stringWidth;
            int stringPosY = 2;
            Graphics g = this.imgCurrentImage.getGraphics();
            g.setClip(stringPosX - 1, stringPosY - 1, stringWidth + 2, stringHeight + 2);
            g.drawImage(this.imgCurrentBackground, 0, 0, 0);
            g.setColor(65280);
            this.drawStringOutlined(g, paintParamString, stringPosX, stringPosY, 0x10 | 4, 0, fontDescription);
            g.setColor(0);
            g.setClip(0, 0, 128, 160);
        }
    }

    private void showErrorScreen(String errorMessage) {
        currentScreen = 99;
        this.errorMessage = errorMessage;
        this.repaint();
    }

    private void paint_ErrorScreen(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 128, 160);
        g.setColor(0);
        this.drawTextLines(g, this.fontDialog.wrapString(this.fontMapper.mapString(this.errorMessage), 115, this.SPLIT_CHAR_INT, this.BREAK_LINE_CHAR_INT), 64, 80, this.fontDialog, true, 0);
    }

    private void keyPressed_ErrorScreen(int key) {
        Main.currentMidlet.destroyApp(true);
    }

    public void drawSprite(Graphics g, Image img, int posX, int posY, int width, int height, int offsetX, int offsetY) {
        int x = g.getClipX();
        int y = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        int xp = Math.max(posX, x);
        int yp = Math.max(posY, y);
        int xr = Math.min(posX + width, x + w);
        int yr = Math.min(posY + height, y + h);
        g.setClip(xp, yp, xr - xp, yr - yp);
        if (xp < 0 || yp < 0 || xr - xp <= 0 || yr - yp <= 0) {
            g.setClip(x, y, w, h);
            g.clipRect(x, y, w, h);
            return;
        }
        g.clipRect(xp, yp, xr - xp, yr - yp);
        g.drawImage(img, posX - offsetX, posY - offsetY, 0x10 | 4);
        g.setClip(x, y, w, h);
        g.clipRect(x, y, w, h);
    }

    public void drawTextLines(Graphics g, int[][] textLines, int posX, int posY, VectorFont font, boolean isCenteredVertically, int interline) {
        int topY = isCenteredVertically ? posY - textLines.length * (font.getHeight() + interline) / 2 : posY;
        for (int i = 0; i < textLines.length; ++i) {
            font.drawString(g, textLines[i], posX, topY + i * (font.getHeight() + interline), 1 | 0x10);
        }
    }

    public int mod(int a2, int b) {
        if (a2 >= 0) {
            return a2 % b;
        }
        return (a2 + (-a2 / b + 1) * b) % b;
    }

    public void drawStringOutlined(Graphics g, int[] string, int posX, int posY, int align, int colorOutline, VectorFont font) {
        int colorPrev = g.getColor();
        g.setColor(colorOutline);
        font.drawString(g, string, posX + 1, posY + 1, align);
        font.drawString(g, string, posX - 1, posY, align);
        font.drawString(g, string, posX + 1, posY, align);
        font.drawString(g, string, posX, posY - 1, align);
        font.drawString(g, string, posX, posY + 1, align);
        font.drawString(g, string, posX - 1, posY - 1, align);
        font.drawString(g, string, posX - 1, posY + 1, align);
        font.drawString(g, string, posX + 1, posY - 1, align);
        font.drawString(g, string, posX + 1, posY + 1, align);
        g.setColor(colorPrev);
        font.drawString(g, string, posX, posY, align);
    }

    public void pause(int time) {
        isSleeping = true;
        new OperationThread(8, time).start();
        while (isSleeping) {
            System.out.print("");
        }
        System.out.println("");
    }

    static /* synthetic */ int[] access$902(GameScreen x0, int[] x1) {
        x0.framesStates = x1;
        return x1;
    }

    static /* synthetic */ int[][] access$2402(GameScreen x0, int[][] x1) {
        x0.items = x1;
        return x1;
    }

    static /* synthetic */ int[][] access$2602(GameScreen x0, int[][] x1) {
        x0.items2 = x1;
        return x1;
    }

    static /* synthetic */ int[][] access$3202(GameScreen x0, int[][] x1) {
        x0.itemsNonWrap = x1;
        return x1;
    }

    static /* synthetic */ int[] access$3302(GameScreen x0, int[] x1) {
        x0.itemsIconIndexes = x1;
        return x1;
    }

    static {
        CLOTHES_PARTS_POSITIONS_X = new int[]{31, 11, 43, 45};
        CLOTHES_PARTS_POSITIONS_Y = new int[]{32, 58, 35, 109};
        COLOR_WHITE = 0xFFFFFF;
        COLOR_BLACK = 0;
        COLOR_HUD_ACTIVE = 0;
        gameStarted = false;
        gamePaused = false;
        currentScreen = -1;
        isSleeping = false;
        FLASH_INTERVAL = 750;
        flashState = false;
        isFlashing = false;
        stopFlashing = false;
        VOLUME_MAX = 10;
        volumeMusic = VOLUME_MAX / 2;
        isContinueIconEnabled = false;
        continueFrameId = -1;
        BRAND_LOGO_DISPLAY_TIME = 1500;
        isEnabledMusic = false;
        playerMusic = null;
        LOGO_TEXT_PRESS = null;
        LOGO_TEXT_PRESS_2 = null;
        MENU_ICONS_ON_SCREEN = 3;
        MENU_ICONS_ANIMATION_SPEED = 6;
        MENU_ICONS_ANIMATION_MIN_SPEED = 4;
        MENU_ARROW_SIDE_MARGIN = 3;
        isAnimationFieldResizeInProgress = false;
        isAnimationIconsInProgress = false;
        stopMenuAnimation = false;
        stopFrameColorAnimation = false;
        HELP_TEXT_INTERLINE = 0;
        COLOR_DIALOG_BKG_PLAYER_LIGHT = 0xFFFFFF;
        COLOR_DIALOG_BKG_PLAYER_DARK = 0xFFCCCC;
        COLOR_DIALOG_BKG_OTHER_MAN = 0xCCCCFF;
        COLOR_DIALOG_BKG_OTHER_WOMAN = 0xFFFFCC;
        COLOR_DIALOG_BKG_INFO = 0xFFFFFF;
        COLOR_CHANGE_STEP = 1285;
        DIALOG_ARROW_MARGIN = 1;
        DIALOG_ARROW_MOVEMENT_STEP = 50;
        DIALOG_ARROW_MOVEMENT_SIZE = 500;
        ARCADE_CLOTHES_INITIAL = 15;
        stopAnimateGame = false;
        POWERS = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        hintUsed = new boolean[10];
    }

    private class OperationThread
    extends Thread {
        public int operation = -1;
        public static final int OP_DELAYED_SECOND_LOGO = 0;
        public static final int OP_LOADING_APP = 1;
        public static final int OP_OPEN_MENU_ANIMATION = 2;
        public static final int OP_CLOSE_MENU_ANIMATION = 3;
        public static final int OP_CHANGE_SCREEN = 4;
        public static final int OP_ANIMATE_ICONS = 5;
        public static final int OP_ANIMATE_GAME = 6;
        public static final int OP_FLASH = 7;
        public static final int OP_SLEEP = 8;
        public static final int OP_ANIMATE_COLORS = 9;
        public static final int OP_START_MUSIC = 10;
        public static final int OP_STOP_MUSIC = 11;
        public static final int OP_EXIT = 99;
        public int nextScreen = -1;

        public OperationThread(int requiredOperation) {
            this.operation = requiredOperation;
        }

        public OperationThread(int requiredOperation, int requestedScreen) {
            this.operation = requiredOperation;
            this.nextScreen = requestedScreen;
            GameScreen.this.menuFieldHeightCurrentMax = GameScreen.this.menuFieldHeightCurrentBlocked;
            switch (requestedScreen) {
                case 3: {
                    GameScreen.this.menuFieldHeightRequested = MENU_FIELD_HEIGHT;
                    break;
                }
                case 4: {
                    GameScreen.this.menuFieldHeightRequested = HELP_FIELD_HEIGHT;
                    break;
                }
                case 5: {
                    GameScreen.this.menuFieldHeightRequested = HELP_FIELD_HEIGHT;
                    break;
                }
                case 6: {
                    GameScreen.this.menuFieldHeightRequested = OPTIONS_FIELD_HEIGHT;
                    break;
                }
                case 89: {
                    GameScreen.this.menuFieldHeightRequested = FINISH_FIELD_HEIGHT;
                }
            }
        }

        public synchronized void run() {
            try {
                switch (this.operation) {
                    case 1: {
                        GameScreen.this.loadMusicPlayer();
                        try {
                            GameScreen.this.imgLogoBrand = Image.createImage((String)"/brand_logo.png");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            GameScreen.this.showErrorScreen("Can't load brand logo.");
                            return;
                        }
                        GameScreen.this.repaint();
                        try {
                            GameScreen.this.imgArrows = Image.createImage((String)"/arrows.png");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        GameScreen.this.conf = GameScreen.this.loadConfFile();
                        GameScreen.this.initializeConstants();
                        GameScreen.this.conf.clear();
                        GameScreen.this.conf = null;
                        System.gc();
                        new OperationThread(0).start();
                        try {
                            GameScreen.this.imgLogoGame = Image.createImage((String)"/title.png");
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            GameScreen.this.showErrorScreen("Can't load game logo.");
                            return;
                        }
                        GameScreen.this.repaint();
                        try {
                            GameScreen.this.loadingProgress = 10;
                            GameScreen.this.repaint();
                            GameScreen.this.loadScenario();
                            GameScreen.access$902(GameScreen.this, new int[GameScreen.this.scenario.size()]);
                            GameScreen.this.loadingProgress = 35;
                            GameScreen.this.repaint();
                            GameScreen.this.imgFaces = Image.createImage((String)"/heads.png");
                            GameScreen.this.loadingProgress = 40;
                            GameScreen.this.repaint();
                            GameScreen.this.imgIconsMain = Image.createImage((String)"/icons_main.png");
                            GameScreen.this.loadingProgress = 45;
                            GameScreen.this.repaint();
                            GameScreen.this.imgTransparent = Image.createImage((String)"/transparent.png");
                            GameScreen.this.loadingProgress = 55;
                            GameScreen.this.repaint();
                            GameScreen.this.imgLadyBlured = Image.createImage((String)"/Zb.png");
                            GameScreen.this.loadingProgress = 65;
                            GameScreen.this.repaint();
                            GameScreen.this.imgHud = Image.createImage((String)"/hud.png");
                            GameScreen.this.loadingProgress = 70;
                            GameScreen.this.repaint();
                            GameScreen.this.imgFilmFrame = Image.createImage((String)"/film.png");
                            GameScreen.this.loadingProgress = 75;
                            GameScreen.this.repaint();
                            Thread.sleep(500L);
                            ((GameScreen)GameScreen.this).imgClothesParts[0] = Image.createImage((String)"/part1.png");
                            GameScreen.this.loadingProgress = 80;
                            GameScreen.this.repaint();
                            ((GameScreen)GameScreen.this).imgClothesParts[1] = Image.createImage((String)"/part2.png");
                            GameScreen.this.loadingProgress = 85;
                            GameScreen.this.repaint();
                            ((GameScreen)GameScreen.this).imgClothesParts[2] = Image.createImage((String)"/part3.png");
                            GameScreen.this.loadingProgress = 90;
                            GameScreen.this.repaint();
                            ((GameScreen)GameScreen.this).imgClothesParts[3] = Image.createImage((String)"/part4.png");
                            GameScreen.this.loadingProgress = 95;
                            GameScreen.this.repaint();
                            GameScreen.this.loadingProgress = 99;
                            GameScreen.this.repaint();
                            Thread.sleep(500L);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            GameScreen.this.showErrorScreen("error loading resources at " + GameScreen.this.loadingProgress + ".#" + ex.getMessage());
                            return;
                        }
                        GameScreen.this.loadingProgress = 100;
                        new OperationThread(7).start();
                        GameScreen.this.repaint();
                        break;
                    }
                    case 0: {
                        Thread.sleep(BRAND_LOGO_DISPLAY_TIME);
                        GameScreen.this.requestSecondLogoDisplayed = true;
                        GameScreen.this.repaint();
                        break;
                    }
                    case 7: {
                        isFlashing = true;
                        flashState = true;
                        while (!stopFlashing) {
                            flashState = !flashState;
                            Thread.sleep(FLASH_INTERVAL);
                            GameScreen.this.repaint();
                        }
                        isFlashing = false;
                        stopFlashing = false;
                        break;
                    }
                    case 8: {
                        isSleeping = true;
                        Thread.sleep(this.nextScreen);
                        isSleeping = false;
                        break;
                    }
                    case 2: {
                        this.menuOpenAnimation();
                        break;
                    }
                    case 3: {
                        this.menuCloseAnimation();
                        break;
                    }
                    case 4: {
                        if (isAnimationFieldResizeInProgress) {
                            return;
                        }
                        isAnimationFieldResizeInProgress = true;
                        if (currentScreen == 3 || currentScreen == 4 || currentScreen == 5 || currentScreen == 6 || currentScreen == 89) {
                            this.menuCloseAnimation();
                        }
                        currentScreen = this.nextScreen;
                        GameScreen.this.repaint();
                        if (GameScreen.this.itemSelectedRequested >= 0) {
                            GameScreen.this.itemSelected = (GameScreen.this.itemDest = GameScreen.this.itemSelectedRequested);
                            GameScreen.this.itemSelectedRequested = -1;
                        }
                        GameScreen.access$2402(GameScreen.this, new int[GameScreen.this.itemsRequested.length][]);
                        GameScreen.access$2602(GameScreen.this, new int[GameScreen.this.itemsRequested.length][]);
                        for (int i = 0; i < GameScreen.this.itemsRequested.length; ++i) {
                            int[][] menu_lines = GameScreen.this.fontMenu.wrapString(GameScreen.this.itemsRequested[i], 128 - MENU_ARROW_MOVEMENT_SIZE * 2 - MENU_ARROW_SIDE_MARGIN * 2 - GameScreen.this.imgArrows.getWidth() - 4, GameScreen.this.SPLIT_CHAR_INT, GameScreen.this.BREAK_LINE_CHAR_INT);
                            if (menu_lines.length == 1) {
                                ((GameScreen)GameScreen.this).items[i] = menu_lines[0];
                                ((GameScreen)GameScreen.this).items2[i] = null;
                                continue;
                            }
                            ((GameScreen)GameScreen.this).items[i] = menu_lines[0];
                            ((GameScreen)GameScreen.this).items2[i] = menu_lines[1];
                        }
                        GameScreen.access$3202(GameScreen.this, GameScreen.this.itemsRequested);
                        GameScreen.access$3302(GameScreen.this, GameScreen.this.itemsIconIndexesRequested);
                        GameScreen.this.menuTypeCurrent = GameScreen.this.menuTypeRequested;
                        if (this.nextScreen == 3 || currentScreen == 4 || currentScreen == 5 || currentScreen == 6 || currentScreen == 89) {
                            this.menuOpenAnimation();
                        }
                        if (!(this.nextScreen != 3 && this.nextScreen != 5 && this.nextScreen != 6 || isAnimationIconsInProgress)) {
                            new OperationThread(5).start();
                        }
                        isAnimationFieldResizeInProgress = false;
                        break;
                    }
                    case 5: {
                        if (isAnimationIconsInProgress) {
                            return;
                        }
                        isAnimationIconsInProgress = true;
                        GameScreen.this.arrowMovementDirection = MENU_ARROW_MOVEMENT_STEP;
                        GameScreen.this.arrowOffset = 0;
                        stopMenuAnimation = false;
                        while (!stopMenuAnimation) {
                            if (currentScreen == 3 && (GameScreen.this.itemDest != GameScreen.this.itemSelected || GameScreen.this.itemOffset != 0)) {
                                int direction = 1;
                                if (GameScreen.this.itemDest != GameScreen.this.itemSelected) {
                                    direction = (GameScreen.this.itemDest - GameScreen.this.itemSelected) / Math.abs(GameScreen.this.itemDest - GameScreen.this.itemSelected);
                                } else if (GameScreen.this.itemOffset != 0) {
                                    direction = -GameScreen.this.itemOffset / Math.abs(GameScreen.this.itemOffset);
                                }
                                int distance = (GameScreen.this.itemDest - GameScreen.this.itemSelected) * (MENU_ICONS_WIDTH + GameScreen.this.interIcon) - GameScreen.this.itemOffset;
                                int step = direction * Math.max(Math.abs(distance / MENU_ICONS_ANIMATION_SPEED), MENU_ICONS_ANIMATION_MIN_SPEED);
                                GameScreen.this.itemOffset += step;
                                if (Math.abs(GameScreen.this.itemOffset) >= Math.abs(MENU_ICONS_WIDTH + GameScreen.this.interIcon)) {
                                    GameScreen.this.itemSelected += GameScreen.this.itemOffset / (MENU_ICONS_WIDTH + GameScreen.this.interIcon);
                                    GameScreen.this.itemOffset -= GameScreen.this.itemOffset / (MENU_ICONS_WIDTH + GameScreen.this.interIcon) * (MENU_ICONS_WIDTH + GameScreen.this.interIcon);
                                    if (GameScreen.this.itemSelected == GameScreen.this.itemDest) {
                                        GameScreen.this.itemSelected = GameScreen.this.mod(GameScreen.this.itemSelected, GameScreen.this.items.length);
                                        GameScreen.this.itemDest = GameScreen.this.itemSelected;
                                        GameScreen.this.itemOffset = 0;
                                    }
                                } else if (GameScreen.this.itemSelected == GameScreen.this.itemDest && GameScreen.this.itemOffset * direction > 0) {
                                    GameScreen.this.itemOffset = 0;
                                }
                            }
                            GameScreen.this.arrowOffset += GameScreen.this.arrowMovementDirection;
                            GameScreen.this.frameColor += GameScreen.this.frameColorChangeDirection;
                            if (GameScreen.this.arrowOffset <= 0 || GameScreen.this.arrowOffset >= MENU_ARROW_MOVEMENT_SIZE) {
                                GameScreen.this.arrowMovementDirection = -GameScreen.this.arrowMovementDirection;
                                GameScreen.this.frameColorChangeDirection = -GameScreen.this.frameColorChangeDirection;
                            }
                            GameScreen.this.repaint();
                            Thread.sleep(MENU_ANIMATION_BASE_INTERVAL);
                        }
                        isAnimationIconsInProgress = false;
                        stopMenuAnimation = false;
                        break;
                    }
                    case 6: {
                        System.out.println("OP_GAME started");
                        stopAnimateGame = false;
                        while (!stopAnimateGame) {
                            if (GameScreen.this.arcadeState == 2 || GameScreen.this.arcadeState == 3) {
                                this.doAnimateArcade();
                                continue;
                            }
                            this.doAnimateDialog();
                        }
                        stopAnimateGame = false;
                        System.out.println("    OP_GAME stopped");
                        break;
                    }
                    case 10: {
                        try {
                            playerMusic.start();
                            try {
                                VolumeControl vc = (VolumeControl)playerMusic.getControl("VolumeControl");
                                if (vc != null) {
                                    vc.setLevel(volumeMusic * 10);
                                }
                            }
                            catch (Exception ex) {
                            }
                        }
                        catch (Exception ex) {
                            playerMusic.close();
                            System.gc();
                            GameScreen.this.loadMusicPlayer();
                            try {
                                playerMusic.start();
                                VolumeControl vc = (VolumeControl)playerMusic.getControl("VolumeControl");
                                if (vc != null) {
                                    vc.setLevel(volumeMusic * 10);
                                }
                            }
                            catch (MediaException mediaException) {}
                        }
                        break;
                    }
                    case 11: {
                        try {
                            playerMusic.stop();
                        }
                        catch (Exception ex) {}
                        break;
                    }
                    case 99: {
                        this.menuCloseAnimation();
                        Thread.sleep(200L);
                        currentScreen = -1;
                        Main.currentMidlet.destroyApp(false);
                    }
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }

        private void menuOpenAnimation() throws InterruptedException {
            while (GameScreen.this.menuFieldHeightCurrent < GameScreen.this.menuFieldHeightRequested) {
                int step = Math.max(GameScreen.this.menuFieldHeightRequested / MENU_ANIMATION_OPENING_SPEED, MENU_ANIMATION_OPENING_MIN_SPEED);
                GameScreen.this.menuFieldHeightCurrent += step;
                GameScreen.this.menuFieldHeightCurrent = Math.min(GameScreen.this.menuFieldHeightCurrent, GameScreen.this.menuFieldHeightRequested);
                GameScreen.this.repaint();
                Thread.sleep(MENU_ANIMATION_BASE_INTERVAL);
            }
        }

        private void menuCloseAnimation() throws InterruptedException {
            if (GameScreen.this.menuFieldHeightRequested < 0) {
                GameScreen.this.menuFieldHeightRequested = GameScreen.this.menuFieldHeightCurrent;
            }
            while (GameScreen.this.menuFieldHeightCurrent > 0) {
                int step = GameScreen.this.menuFieldHeightCurrentMax / MENU_ANIMATION_CLOSING_SPEED;
                GameScreen.this.menuFieldHeightCurrent -= step;
                GameScreen.this.menuFieldHeightCurrent = Math.max(GameScreen.this.menuFieldHeightCurrent, 0);
                GameScreen.this.repaint();
                Thread.sleep(MENU_ANIMATION_BASE_INTERVAL);
            }
        }

        private void doAnimateDialog() throws InterruptedException {
            if (GameScreen.this.whosTalking == 1) {
                GameScreen.this.colorDialogPlayer += GameScreen.this.colorChangeDirection;
                if (GameScreen.this.colorDialogPlayer <= COLOR_DIALOG_BKG_PLAYER_DARK) {
                    GameScreen.this.colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_DARK;
                    GameScreen.this.colorChangeDirection = -GameScreen.this.colorChangeDirection;
                }
                if (GameScreen.this.colorDialogPlayer >= COLOR_DIALOG_BKG_PLAYER_LIGHT) {
                    GameScreen.this.colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_LIGHT;
                    GameScreen.this.colorChangeDirection = -GameScreen.this.colorChangeDirection;
                }
                GameScreen.this.arrowDialogOffset += GameScreen.this.arrowDialogMovementDirection;
                if (GameScreen.this.arrowDialogOffset < 0) {
                    GameScreen.this.arrowDialogOffset = 0;
                    GameScreen.this.arrowDialogMovementDirection = -GameScreen.this.arrowDialogMovementDirection;
                }
                if (GameScreen.this.arrowDialogOffset > DIALOG_ARROW_MOVEMENT_SIZE) {
                    GameScreen.this.arrowDialogOffset = DIALOG_ARROW_MOVEMENT_SIZE;
                    GameScreen.this.arrowDialogMovementDirection = -GameScreen.this.arrowDialogMovementDirection;
                }
                GameScreen.this.repaint();
                Thread.sleep(MENU_ANIMATION_BASE_INTERVAL);
            } else if (GameScreen.this.arcadeState != 2 && GameScreen.this.arcadeState != 3) {
                Thread.sleep(MENU_ANIMATION_BASE_INTERVAL);
            }
        }

        private void doAnimateArcade() throws InterruptedException {
            int position = (int)(System.currentTimeMillis() % (long)ARCADE_ARROW_MOVEMENT_STEP * (long)(ARCADE_ARROW_MOVEMENT_SIZE << 1 << 1) / (long)ARCADE_ARROW_MOVEMENT_STEP);
            if (position > ARCADE_ARROW_MOVEMENT_SIZE << 1) {
                position = (ARCADE_ARROW_MOVEMENT_SIZE << 1 << 1) - position;
            }
            GameScreen.this.arrowHudOffset = position - ARCADE_ARROW_MOVEMENT_SIZE;
            GameScreen.this.repaint();
            Thread.sleep(ARCADE_ARROW_MOVEMENT_SPEED);
            Thread.yield();
        }
    }
}

