/*
 * Decompiled with CFR 0.152.
 */
package midp.shopper;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import midp.shopper.Category;
import midp.shopper.Locale;
import midp.shopper.NewCategoryBox;
import midp.shopper.ProductList;
import midp.shopper.RenameCategoryBox;
import midp.shopper.Shopper;

public class CategoryList
extends List
implements CommandListener {
    public CategoryList() {
        super(Locale.current.groups, 3);
        Vector vector = Shopper.getInstance().getCategories();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Category category = (Category)vector.elementAt(i);
            this.append(category.name, category.icon);
        }
        this.setCommandListener(this);
        this.addCommand(Shopper.SELECT_CMD);
        this.addCommand(Shopper.ADD_CMD);
        this.addCommand(Shopper.REMOVE_CMD);
        this.addCommand(Shopper.RENAME_CMD);
        this.addCommand(Shopper.BACK_CMD);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == Shopper.BACK_CMD) {
            Shopper.goBack();
        } else if (command == Shopper.REMOVE_CMD) {
            int n = this.getSelectedIndex();
            if (n >= 0 && Shopper.getInstance().removeCategory(n)) {
                this.delete(n);
            }
        } else if (command == Shopper.RENAME_CMD) {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                Category category = (Category)Shopper.getInstance().getCategories().elementAt(n);
                if (category.isPredefined()) {
                    Shopper.getInstance().error(Locale.current.predefinedCategory);
                } else {
                    new RenameCategoryBox(this, n, this.getString(n));
                }
            }
        } else if (command == Shopper.ADD_CMD) {
            new NewCategoryBox(this);
        } else {
            int n = this.getSelectedIndex();
            if (n >= 0) {
                Category category = (Category)Shopper.getInstance().getCategories().elementAt(n);
                new ProductList(category, (Displayable)this);
            }
        }
    }
}

